/*
 * Decompiled with CFR 0.152.
 */
package helliker.id3;

import helliker.id3.ID3FieldDataException;
import helliker.id3.ID3Tag;
import helliker.id3.NullsoftID3GenreTable;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;

public class ID3v1Tag
implements ID3Tag,
Serializable {
    private final int ALBUM_SIZE = 30;
    private final int ARTIST_SIZE = 30;
    private final int COMMENT_SIZE = 28;
    private final int GENRE_LOCATION = 127;
    private final int MAX_GENRE = 255;
    private final int MAX_TRACK = 255;
    private final int TAG_SIZE = 128;
    private final String TAG_START = "TAG";
    private final int TITLE_SIZE = 30;
    private final int TRACK_LOCATION = 126;
    private final int YEAR_SIZE = 4;
    private String album = null;
    private String artist = null;
    private String comment = null;
    private int genre;
    private boolean headerExists = false;
    private File mp3 = null;
    private String title = null;
    private int track;
    private String year = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public ID3v1Tag(File mp3) throws FileNotFoundException, IOException {
        this.mp3 = mp3;
        this.title = new String();
        this.artist = new String();
        this.album = new String();
        this.year = new String();
        this.comment = new String();
        this.genre = -1;
        this.track = -1;
        RandomAccessFile in = null;
        try {
            in = new RandomAccessFile(mp3, "r");
            this.headerExists = this.checkHeader(in);
            if (this.headerExists) {
                this.readTag(in);
            }
            Object var4_3 = null;
            if (in == null) return;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            if (in == null) throw throwable;
            in.close();
            throw throwable;
        }
        in.close();
    }

    private boolean checkHeader(RandomAccessFile raf) throws FileNotFoundException, IOException {
        boolean retval = false;
        if (raf.length() > 128L) {
            raf.seek(raf.length() - 128L);
            byte[] buf = new byte[3];
            if (raf.read(buf) != 3) {
                throw new IOException("Error encountered reading ID3 header");
            }
            String result = new String(buf, 0, 3);
            retval = result.equals("TAG");
        }
        return retval;
    }

    private String chopSubstring(String s, int start, int end) {
        String str = s.substring(start, end);
        int loc = str.indexOf(0);
        if (loc != -1) {
            str = str.substring(0, loc);
        }
        return str;
    }

    public void copyFrom(ID3Tag tag) {
    }

    public String getAlbum() {
        return this.album.trim();
    }

    public String getArtist() {
        return this.artist.trim();
    }

    public byte[] getBytes() {
        byte[] tag = new byte[128];
        int bytesCopied = 0;
        System.arraycopy("TAG".getBytes(), 0, tag, bytesCopied, "TAG".length());
        System.arraycopy(this.title.getBytes(), 0, tag, bytesCopied += "TAG".length(), this.title.length());
        System.arraycopy(this.artist.getBytes(), 0, tag, bytesCopied += 30, this.artist.length());
        System.arraycopy(this.album.getBytes(), 0, tag, bytesCopied += 30, this.album.length());
        System.arraycopy(this.year.getBytes(), 0, tag, bytesCopied += 30, this.year.length());
        System.arraycopy(this.comment.getBytes(), 0, tag, bytesCopied += 4, this.comment.length());
        tag[126] = (byte)this.track;
        tag[127] = (byte)this.genre;
        return tag;
    }

    public String getComment() {
        return this.comment.trim();
    }

    private byte[] getFieldBytes(String str, int length) throws UnsupportedEncodingException {
        StringBuffer buf = new StringBuffer(str);
        int i = str.length();
        while (i < length) {
            buf.append('\u0000');
            ++i;
        }
        return buf.toString().getBytes();
    }

    public int getGenre() {
        return this.genre;
    }

    public String getGenreString() {
        return NullsoftID3GenreTable.getGenre(this.genre);
    }

    public int getSize() {
        int retval = 0;
        if (this.headerExists) {
            retval = 128;
        }
        return retval;
    }

    public String getTitle() {
        return this.title.trim();
    }

    public int getTrack() {
        return this.track;
    }

    public String getYear() {
        return this.year.trim();
    }

    private void readTag(RandomAccessFile raf) throws FileNotFoundException, IOException {
        raf.seek(raf.length() - 128L);
        byte[] buf = new byte[128];
        raf.read(buf, 0, 128);
        String tag = new String(buf, 0, 128);
        int start = "TAG".length();
        this.title = this.chopSubstring(tag, start, start += 30);
        this.artist = this.chopSubstring(tag, start, start += 30);
        this.album = this.chopSubstring(tag, start, start += 30);
        this.year = this.chopSubstring(tag, start, start += 4);
        this.comment = this.chopSubstring(tag, start, start += 28);
        this.track = buf[126] & 0xFF;
        this.genre = buf[127] & 0xFF;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void removeTag() throws FileNotFoundException, IOException {
        if (this.headerExists) {
            block5: {
                RandomAccessFile raf = null;
                try {
                    raf = new RandomAccessFile(this.mp3, "rw");
                    Long bufSize = new Long(raf.length() - 128L);
                    byte[] buf = new byte[bufSize.intValue()];
                    if (raf.read(buf) != bufSize.intValue()) {
                        throw new IOException("Error encountered while removing tag");
                    }
                    raf.setLength(bufSize);
                    raf.seek(0L);
                    raf.write(buf);
                    Object var5_4 = null;
                    if (raf == null) break block5;
                }
                catch (Throwable throwable) {
                    Object var5_5 = null;
                    if (raf != null) {
                        raf.close();
                    }
                    throw throwable;
                }
                raf.close();
            }
            this.headerExists = false;
        }
    }

    public void setAlbum(String newAlbum) {
        this.album = newAlbum.length() > 30 ? newAlbum.substring(0, 30) : newAlbum;
    }

    public void setArtist(String newArtist) {
        this.artist = newArtist.length() > 30 ? newArtist.substring(0, 30) : newArtist;
    }

    public void setComment(String newComment) {
        this.comment = newComment.length() > 28 ? newComment.substring(0, 28) : newComment;
    }

    public void setGenre(int newGenre) throws ID3FieldDataException {
        if (newGenre > 255 || newGenre < 0) {
            throw new ID3FieldDataException("Invalid genre value.  Must be between 0 and 255.");
        }
        this.genre = newGenre;
    }

    public boolean setGenreString(String str) {
        int result = NullsoftID3GenreTable.getGenre(str);
        boolean retval = false;
        if (result != -1) {
            this.genre = result;
            retval = true;
        }
        return retval;
    }

    public void setTitle(String newTitle) {
        this.title = newTitle.length() > 30 ? newTitle.substring(0, 30) : newTitle;
    }

    public void setTrack(int newTrack) {
        if (newTrack <= 255 && newTrack >= 0) {
            this.track = newTrack;
        }
    }

    public void setYear(String newYear) {
        this.year = newYear.length() > 4 ? newYear.substring(0, 4) : newYear;
    }

    public boolean tagExists() {
        return this.headerExists;
    }

    public String toString() {
        return "ID3v1.1\nTagSize:\t\t\t" + this.getSize() + " bytes\nTitle:\t\t\t\t" + this.getTitle() + "\nArtist:\t\t\t\t" + this.getArtist() + "\nAlbum:\t\t\t\t" + this.getAlbum() + "\nYear:\t\t\t\t" + this.getYear() + "\nComment:\t\t\t" + this.getComment() + "\nTrack:\t\t\t\t" + this.getTrack() + "\nGenre:\t\t\t\t" + this.getGenreString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void writeTag() throws FileNotFoundException, IOException {
        block5: {
            RandomAccessFile raf = null;
            try {
                raf = new RandomAccessFile(this.mp3, "rw");
                if (this.headerExists) {
                    raf.seek(raf.length() - 128L);
                } else {
                    raf.seek(raf.length());
                }
                raf.write(this.getBytes());
                Object var3_2 = null;
                if (raf == null) break block5;
            }
            catch (Throwable throwable) {
                Object var3_3 = null;
                if (raf != null) {
                    raf.close();
                }
                throw throwable;
            }
            raf.close();
        }
        this.headerExists = true;
    }
}

