/*
 * Decompiled with CFR 0.152.
 */
package helliker.id3;

import helliker.id3.BinaryParser;
import helliker.id3.ID3v2FormatException;
import helliker.id3.ID3v2Frames;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;

public class ID3v2Frame
implements Serializable {
    private final String[] ENC_TYPES = new String[]{"ISO-8859-1", "UTF16", "UTF-16BE", "UTF-8"};
    private final int FRAME_FLAGS_SIZE = 2;
    private final int FRAME_HEAD_SIZE = 10;
    private final int MAX_EXTRA_DATA = 5;
    private boolean compressed;
    private int dataLength;
    private byte encrType;
    private boolean encrypted;
    private boolean fileAlterDiscard;
    private byte[] frameData;
    private byte group;
    private boolean grouped;
    private String id = null;
    private boolean lengthIndicator;
    private boolean readOnly;
    private boolean tagAlterDiscard;
    private boolean unsynchronised;

    public ID3v2Frame(String id, byte[] data, boolean tagAlterDiscard, boolean fileAlterDiscard, boolean readOnly, boolean grouped, boolean compressed, boolean encrypted, boolean unsynchronised, boolean lengthIndicator) {
        this.id = id;
        this.tagAlterDiscard = tagAlterDiscard;
        this.fileAlterDiscard = fileAlterDiscard;
        this.readOnly = readOnly;
        this.grouped = grouped;
        this.compressed = compressed;
        this.encrypted = encrypted;
        this.unsynchronised = unsynchronised;
        this.lengthIndicator = lengthIndicator;
        this.group = 0;
        this.encrType = 0;
        this.dataLength = -1;
        this.parseData(data);
    }

    public ID3v2Frame(String id, byte[] data) {
        this.id = id;
        this.tagAlterDiscard = false;
        this.fileAlterDiscard = this.checkDefaultFileAlterDiscard();
        this.readOnly = false;
        this.grouped = false;
        this.compressed = false;
        this.encrypted = false;
        this.unsynchronised = false;
        this.lengthIndicator = false;
        this.group = 0;
        this.encrType = 0;
        this.dataLength = -1;
        this.parseData(data);
    }

    public ID3v2Frame(String id, byte[] flags, byte[] data) throws ID3v2FormatException {
        this(id, data);
        this.parseFlags(flags);
    }

    private boolean checkDefaultFileAlterDiscard() {
        return this.id.equals(ID3v2Frames.AUDIO_SEEK_POINT_INDEX) || this.id.equals(ID3v2Frames.AUDIO_ENCRYPTION) || this.id.equals(ID3v2Frames.EVENT_TIMING_CODES) || this.id.equals(ID3v2Frames.EQUALISATION) || this.id.equals(ID3v2Frames.MPEG_LOCATION_LOOKUP_TABLE) || this.id.equals(ID3v2Frames.POSITION_SYNCHRONISATION_FRAME) || this.id.equals(ID3v2Frames.SEEK_FRAME) || this.id.equals(ID3v2Frames.SYNCHRONISED_LYRIC) || this.id.equals(ID3v2Frames.SYNCHRONISED_TEMPO_CODES) || this.id.equals(ID3v2Frames.RELATIVE_VOLUME_ADJUSTMENT) || this.id.equals(ID3v2Frames.ENCODED_BY) || this.id.equals(ID3v2Frames.LENGTH);
    }

    public boolean getCompressed() {
        return this.compressed;
    }

    public int getDataLength() {
        return this.dataLength;
    }

    public String getDataString() throws ID3v2FormatException {
        String str = new String();
        if (this.frameData.length > 1) {
            try {
                if (this.id.charAt(0) == 'T' || this.id.equals(ID3v2Frames.OWNERSHIP_FRAME)) {
                    str = this.getDecodedString(this.frameData, 0, 1);
                } else if (this.id.charAt(0) == 'W') {
                    str = new String(this.frameData);
                } else if (this.id.equals(ID3v2Frames.USER_DEFINED_URL)) {
                    byte encType = this.frameData[0];
                    byte[] desc = new byte[this.frameData.length];
                    boolean done = false;
                    int i = 0;
                    while (!done && i < desc.length) {
                        boolean bl = done = this.frameData[i + 1] == 0;
                        if (done) continue;
                        desc[i] = this.frameData[i + 1];
                        ++i;
                    }
                    if (encType >= 0 && encType < this.ENC_TYPES.length) {
                        str = new String(desc, 0, i, this.ENC_TYPES[encType]);
                    }
                    str = str + "\n";
                    str = str.concat(new String(this.frameData, i, this.frameData.length - i));
                } else if (this.id.equals(ID3v2Frames.UNSYNCHRONISED_LYRIC_TRANSCRIPTION) || this.id.equals(ID3v2Frames.COMMENTS) || this.id.equals(ID3v2Frames.TERMS_OF_USE)) {
                    str = this.getDecodedString(this.frameData, 0, 4);
                }
            }
            catch (UnsupportedEncodingException e) {
                throw new ID3v2FormatException("Frame: " + this.id + " has " + " not specified a valid encoding type.");
            }
        }
        return str;
    }

    private String getDecodedString(byte[] b, int eIndex, int offset) throws UnsupportedEncodingException {
        String str = new String();
        byte encType = b[eIndex];
        if (encType >= 0 && encType < this.ENC_TYPES.length) {
            str = new String(b, offset, b.length - offset, this.ENC_TYPES[encType]);
        }
        return str;
    }

    public boolean getEncrypted() {
        return this.encrypted;
    }

    public byte getEncryptionType() {
        return this.encrType;
    }

    private byte[] getExtraDataBytes() {
        byte[] buf = new byte[5];
        int bytesCopied = 0;
        if (this.grouped) {
            buf[bytesCopied] = this.group;
            ++bytesCopied;
        }
        if (this.encrypted) {
            buf[bytesCopied] = this.encrType;
            ++bytesCopied;
        }
        if (this.lengthIndicator) {
            byte[] num = BinaryParser.convertToBytes(this.dataLength);
            System.arraycopy(num, 0, buf, bytesCopied, num.length);
            bytesCopied += num.length;
        }
        byte[] ret = new byte[bytesCopied];
        System.arraycopy(buf, 0, ret, 0, bytesCopied);
        return ret;
    }

    public boolean getFileAlterDiscard() {
        return this.fileAlterDiscard;
    }

    private byte[] getFlagBytes() {
        byte[] flags = new byte[]{0, 0};
        if (this.tagAlterDiscard) {
            flags[0] = BinaryParser.setBit(flags[0], 6);
        }
        if (this.fileAlterDiscard) {
            flags[0] = BinaryParser.setBit(flags[0], 5);
        }
        if (this.readOnly) {
            flags[0] = BinaryParser.setBit(flags[0], 4);
        }
        if (this.grouped) {
            flags[1] = BinaryParser.setBit(flags[1], 6);
        }
        if (this.compressed) {
            flags[1] = BinaryParser.setBit(flags[1], 3);
        }
        if (this.encrypted) {
            flags[1] = BinaryParser.setBit(flags[1], 2);
        }
        if (this.unsynchronised) {
            flags[1] = BinaryParser.setBit(flags[1], 1);
        }
        if (this.lengthIndicator) {
            flags[1] = BinaryParser.setBit(flags[1], 0);
        }
        return flags;
    }

    public byte[] getFrameBytes() {
        int length = this.frameData.length;
        int bytesWritten = 0;
        byte[] flags = this.getFlagBytes();
        byte[] extra = this.getExtraDataBytes();
        if (this.grouped) {
            ++length;
        }
        if (this.encrypted) {
            ++length;
        }
        if (this.lengthIndicator) {
            length += 4;
        }
        byte[] b = new byte[length + 10];
        System.arraycopy(this.id.getBytes(), 0, b, 0, this.id.length());
        System.arraycopy(BinaryParser.convertToBytes(length), 0, b, bytesWritten += this.id.length(), 4);
        System.arraycopy(flags, 0, b, bytesWritten += 4, flags.length);
        System.arraycopy(extra, 0, b, bytesWritten += flags.length, extra.length);
        System.arraycopy(this.frameData, 0, b, bytesWritten += extra.length, this.frameData.length);
        bytesWritten += this.frameData.length;
        return b;
    }

    public byte[] getFrameData() {
        return this.frameData;
    }

    public int getFrameLength() {
        int length = this.frameData.length + 10;
        if (this.grouped) {
            ++length;
        }
        if (this.encrypted) {
            ++length;
        }
        if (this.lengthIndicator) {
            length += 4;
        }
        return length;
    }

    public byte getGroup() {
        return this.group;
    }

    public boolean getGrouped() {
        return this.grouped;
    }

    public boolean getLengthIndicator() {
        return this.lengthIndicator;
    }

    public boolean getReadOnly() {
        return this.readOnly;
    }

    public boolean getTagAlterDiscard() {
        return this.tagAlterDiscard;
    }

    public boolean getUnsynchronised() {
        return this.unsynchronised;
    }

    public boolean isEmpty() {
        return this.frameData.length <= 1;
    }

    private void parseData(byte[] data) {
        int bytesRead = 0;
        if (this.grouped) {
            this.group = data[bytesRead];
            ++bytesRead;
        }
        if (this.encrypted) {
            this.encrType = data[bytesRead];
            ++bytesRead;
        }
        if (this.lengthIndicator) {
            byte[] num = new byte[4];
            System.arraycopy(data, bytesRead, num, 0, num.length);
            this.dataLength = BinaryParser.convertToInt(num);
            bytesRead += num.length;
        }
        this.frameData = new byte[data.length - bytesRead];
        System.arraycopy(data, bytesRead, this.frameData, 0, this.frameData.length);
    }

    private void parseFlags(byte[] flags) throws ID3v2FormatException {
        if (flags.length != 2) {
            throw new ID3v2FormatException("Error parsing flags of frame: " + this.id + ".  Expected 2 bytes.");
        }
        this.tagAlterDiscard = BinaryParser.bitSet(flags[0], 6);
        this.fileAlterDiscard = BinaryParser.bitSet(flags[0], 5);
        this.readOnly = BinaryParser.bitSet(flags[0], 4);
        this.grouped = BinaryParser.bitSet(flags[1], 6);
        this.compressed = BinaryParser.bitSet(flags[1], 3);
        this.encrypted = BinaryParser.bitSet(flags[1], 2);
        this.unsynchronised = BinaryParser.bitSet(flags[1], 1);
        this.lengthIndicator = BinaryParser.bitSet(flags[1], 0);
        if (this.compressed && !this.lengthIndicator) {
            throw new ID3v2FormatException("Error parsing flags of frame: " + this.id + ".  Compressed bit set  " + "without data length bit set.");
        }
    }

    public void setFrameData(byte[] newData) {
        if (!this.readOnly) {
            this.frameData = newData;
        }
    }

    public String toString() {
        String str = null;
        try {
            str = this.id + "\nTagAlterDiscard:\t\t" + this.tagAlterDiscard + "\nFileAlterDiscard:\t\t" + this.fileAlterDiscard + "\nReadOnly:\t\t\t" + this.readOnly + "\nGrouped:\t\t\t" + this.grouped + "\nCompressed:\t\t\t" + this.compressed + "\nEncrypted:\t\t\t" + this.encrypted + "\nUnsynchronised:\t\t\t" + this.unsynchronised + "\nLengthIndicator:\t\t" + this.lengthIndicator + "\nData:\t\t\t\t" + this.getDataString().toString();
        }
        catch (Exception e) {}
        return str;
    }
}

