/*
 * Decompiled with CFR 0.152.
 */
package helliker.id3;

import helliker.id3.BinaryParser;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.io.Serializable;

public class ID3v2Header
implements Serializable {
    private final int HEAD_LOCATION = 0;
    private final int HEAD_SIZE = 10;
    private final int NEW_MAJOR_VERSION = 3;
    private final int NEW_MINOR_VERSION = 0;
    private final String TAG_START = "ID3";
    private boolean experimental;
    private boolean extended;
    private boolean footer;
    private boolean headerExists;
    private int majorVersion;
    private int minorVersion;
    private File mp3 = null;
    private int tagSize;
    private boolean unsynchronisation;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public ID3v2Header(File mp3) throws FileNotFoundException, IOException {
        this.mp3 = mp3;
        this.majorVersion = 3;
        this.minorVersion = 0;
        this.unsynchronisation = false;
        this.extended = false;
        this.experimental = false;
        this.footer = false;
        this.tagSize = 0;
        RandomAccessFile in = null;
        try {
            in = new RandomAccessFile(mp3, "r");
            this.headerExists = this.checkHeader(in);
            if (this.headerExists) {
                this.readHeader(in);
            }
            Object var4_3 = null;
            if (in == null) return;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            if (in == null) throw throwable;
            in.close();
            throw throwable;
        }
        in.close();
    }

    private boolean checkHeader(RandomAccessFile raf) throws FileNotFoundException, IOException {
        boolean exists = false;
        raf.seek(0L);
        byte[] buf = new byte[10];
        if (raf.read(buf) != 10) {
            throw new IOException("Error encountered finding id3v2 header");
        }
        String result = new String(buf);
        if (result.substring(0, "ID3".length()).equals("ID3") && buf[3] < 255 && buf[4] < 255 && buf[6] < 128 && buf[7] < 128 && buf[8] < 128 && buf[9] < 128) {
            exists = true;
        }
        return exists;
    }

    public byte[] getBytes() {
        byte[] b = new byte[10];
        int bytesCopied = 0;
        if (this.majorVersion < 3) {
            this.majorVersion = 3;
        }
        System.arraycopy("ID3".getBytes(), 0, b, bytesCopied, "ID3".length());
        bytesCopied += "ID3".length();
        b[bytesCopied++] = (byte)this.majorVersion;
        b[bytesCopied++] = (byte)this.minorVersion;
        b[bytesCopied++] = this.getFlagByte();
        System.arraycopy(BinaryParser.convertToSynchsafeBytes(this.tagSize), 0, b, bytesCopied, 4);
        bytesCopied += 4;
        return b;
    }

    public boolean getExperimental() {
        return this.experimental;
    }

    public boolean getExtendedHeader() {
        return this.extended;
    }

    private byte getFlagByte() {
        byte ret = 0;
        if (this.unsynchronisation) {
            ret = BinaryParser.setBit(ret, 7);
        }
        if (this.extended) {
            ret = BinaryParser.setBit(ret, 6);
        }
        if (this.experimental) {
            ret = BinaryParser.setBit(ret, 5);
        }
        if (this.footer) {
            ret = BinaryParser.setBit(ret, 4);
        }
        return ret;
    }

    public boolean getFooter() {
        return this.footer;
    }

    public int getHeaderSize() {
        return 10;
    }

    public int getMajorVersion() {
        return this.majorVersion;
    }

    public int getMinorVersion() {
        return this.minorVersion;
    }

    public int getTagSize() {
        return this.tagSize;
    }

    public boolean getUnsynchronisation() {
        return this.unsynchronisation;
    }

    public boolean headerExists() {
        return this.headerExists;
    }

    private void readHeader(RandomAccessFile raf) throws FileNotFoundException, IOException {
        raf.seek(0L);
        byte[] head = new byte[10];
        if (raf.read(head) != 10) {
            throw new IOException("Error encountered reading id3v2 header");
        }
        this.majorVersion = head[3];
        if (this.majorVersion <= 3) {
            this.minorVersion = head[4];
            this.unsynchronisation = BinaryParser.bitSet(head[5], 7);
            this.extended = BinaryParser.bitSet(head[5], 6);
            this.experimental = BinaryParser.bitSet(head[5], 5);
            this.footer = BinaryParser.bitSet(head[5], 4);
            byte[] size = new byte[]{head[6], head[7], head[8], head[9]};
            this.tagSize = BinaryParser.convertToSynchsafeInt(size);
        }
    }

    public void setExperimental(boolean experiment) {
        this.experimental = experiment;
    }

    public void setExtendedHeader(boolean extend) {
        this.extended = extend;
    }

    public void setFooter(boolean foot) {
        this.footer = foot;
    }

    public void setTagSize(int size) {
        if (size > 0) {
            this.tagSize = size;
            this.headerExists = true;
        }
    }

    public void setUnsynchronisation(boolean unsynch) {
        this.unsynchronisation = unsynch;
    }

    public String toString() {
        return "ID3v2." + this.getMajorVersion() + "." + this.getMinorVersion() + "\n" + "TagSize:\t\t\t" + this.getTagSize() + " bytes\nUnsynchronisation:\t\t" + this.getUnsynchronisation() + "\nExtended Header:\t\t" + this.getExtendedHeader() + "\nExperimental:\t\t\t" + this.getExperimental() + "\nFooter:\t\t\t\t" + this.getFooter();
    }
}

