/*
 * Decompiled with CFR 0.152.
 */
package helliker.id3;

import helliker.id3.CorruptHeaderException;
import helliker.id3.ID3v1Tag;
import helliker.id3.ID3v2FormatException;
import helliker.id3.ID3v2Frames;
import helliker.id3.ID3v2Tag;
import helliker.id3.MPEGAudioFrameHeader;
import helliker.id3.NoMPEGFramesException;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.Serializable;

public class MP3File
implements Comparable,
Serializable {
    public static final int BOTH_TAGS = 0;
    public static final int EXISTING_TAGS_ONLY = 4;
    private final int ID3V1 = 5;
    public static final int ID3V1_ONLY = 2;
    private final int ID3V2 = 6;
    public static final int ID3V2_ONLY = 1;
    public static final int NO_TAGS = 3;
    private MPEGAudioFrameHeader head = null;
    private ID3v1Tag id3v1 = null;
    private ID3v2Tag id3v2 = null;
    private File mp3 = null;
    private int tagType = 0;

    public MP3File(File mp3, int tagType) throws FileNotFoundException, NoMPEGFramesException, IOException, ID3v2FormatException, CorruptHeaderException {
        this.mp3 = mp3;
        this.tagType = tagType;
        this.head = new MPEGAudioFrameHeader(mp3, 0);
        this.id3v1 = new ID3v1Tag(mp3);
        this.id3v2 = new ID3v2Tag(mp3, this.head.getLocation());
    }

    public MP3File(String fn, int tagType) throws FileNotFoundException, NoMPEGFramesException, IOException, ID3v2FormatException, CorruptHeaderException {
        this(new File(fn), tagType);
    }

    public MP3File(File mp3) throws FileNotFoundException, NoMPEGFramesException, IOException, ID3v2FormatException, CorruptHeaderException {
        this(mp3, 4);
    }

    public MP3File(String fn) throws FileNotFoundException, NoMPEGFramesException, IOException, ID3v2FormatException, CorruptHeaderException {
        this(new File(fn));
    }

    private boolean allow(int tagVersion, int type) {
        boolean retval = false;
        if (tagVersion == 5) {
            retval = type == 4 && this.id3v1.tagExists() || type == 2 || type == 0;
        } else if (tagVersion == 6) {
            retval = type == 4 && this.id3v2.tagExists() || type == 1 || type == 0;
        }
        return retval;
    }

    private boolean allow(int tagVersion) {
        return this.allow(tagVersion, this.tagType);
    }

    public int compareTo(Object o) {
        int cmp = 1;
        if (o instanceof MP3File) {
            cmp = this.getPath().compareTo(((MP3File)o).getPath());
        }
        return cmp;
    }

    public boolean equals(Object o) {
        boolean equal = false;
        if (o instanceof MP3File) {
            equal = this.getPath().equals(((MP3File)o).getPath());
        }
        return equal;
    }

    public String getAlbum() throws ID3v2FormatException {
        String str = new String();
        if (this.allow(6)) {
            str = this.id3v2.getFrameDataString(ID3v2Frames.ALBUM);
        } else if (this.allow(5)) {
            str = this.id3v1.getAlbum();
        }
        return str;
    }

    public String getArtist() throws ID3v2FormatException {
        String str = new String();
        if (this.allow(6)) {
            str = this.id3v2.getFrameDataString(ID3v2Frames.LEAD_PERFORMERS);
        } else if (this.allow(5)) {
            str = this.id3v1.getArtist();
        }
        return str;
    }

    public int getBitRate() {
        return this.head.getBitRate();
    }

    public String getComment() throws ID3v2FormatException {
        String str = new String();
        if (this.allow(6)) {
            str = this.id3v2.getFrameDataString(ID3v2Frames.COMMENTS);
        } else if (this.allow(5)) {
            str = this.id3v1.getComment();
        }
        return str;
    }

    public String getComposer() throws ID3v2FormatException {
        String str = new String();
        if (this.allow(6)) {
            str = this.id3v2.getFrameDataString(ID3v2Frames.COMPOSER);
        }
        return str;
    }

    public String getCopyrightInfo() throws ID3v2FormatException {
        String str = new String();
        if (this.allow(6)) {
            str = this.id3v2.getFrameDataString(ID3v2Frames.COPYRIGHT_MESSAGE);
        }
        return str;
    }

    public String getEncodedBy() throws ID3v2FormatException {
        String str = new String();
        if (this.allow(6)) {
            str = this.id3v2.getFrameDataString(ID3v2Frames.ENCODED_BY);
        }
        return str;
    }

    public String getFileName() {
        return this.mp3.getName();
    }

    public long getFileSize() {
        return this.mp3.length();
    }

    public byte[] getFrameDataBytes(String id) {
        byte[] b = new byte[]{};
        if (this.allow(6)) {
            b = this.id3v2.getFrameData(id);
        }
        return b;
    }

    public String getFrameDataString(String id) throws ID3v2FormatException {
        String str = new String();
        if (this.allow(6)) {
            str = this.id3v2.getFrameDataString(id);
        }
        return str;
    }

    public String getGenre() throws ID3v2FormatException {
        String str = new String();
        if (this.allow(6)) {
            str = this.id3v2.getFrameDataString(ID3v2Frames.CONTENT_TYPE);
        } else if (this.allow(5)) {
            str = this.id3v1.getGenreString();
        }
        return str;
    }

    public String getMPEGChannelMode() {
        return this.head.getChannelMode();
    }

    public String getMPEGEmphasis() {
        return this.head.getEmphasis();
    }

    public String getMPEGLayer() {
        return this.head.getLayer();
    }

    public String getMPEGVersion() {
        return this.head.getVersion();
    }

    public int getNumTracks() throws ID3v2FormatException {
        String str = this.getTrackString();
        int track = -1;
        int loc = str.indexOf("/");
        try {
            if (loc != -1) {
                str = str.substring(loc + 1, str.length());
                track = Integer.parseInt(str);
            }
        }
        catch (NumberFormatException e) {}
        return track;
    }

    public String getOriginalArtist() throws ID3v2FormatException {
        String str = new String();
        if (this.allow(6)) {
            str = this.id3v2.getFrameDataString(ID3v2Frames.ORIGINAL_ARTIST);
        }
        return str;
    }

    public String getParent() {
        return this.mp3.getParent();
    }

    public String getPath() {
        return this.mp3.getAbsolutePath();
    }

    public long getPlayingTime() {
        long time = 0L;
        if (this.head.isVBR()) {
            time = this.head.getVBRPlayingTime();
        } else {
            long datasize = this.mp3.length() * 8L - (long)this.id3v2.getSize() - (long)this.id3v1.getSize();
            long bps = this.head.getBitRate() * 1000;
            time = bps == 0L ? 0L : datasize / bps;
        }
        return time;
    }

    public String getPlayingTimeString() {
        long time = this.getPlayingTime();
        long mins = time / 60L;
        long secs = Math.round(((double)time / 60.0 - (double)(time / 60L)) * 60.0);
        String str = mins + ":";
        str = secs < 10L ? str + "0" + secs : str + "" + secs;
        return str;
    }

    public int getSampleRate() {
        return this.head.getSampleRate();
    }

    public int getTagSize(int type) {
        int size = 0;
        if (this.allow(5, type)) {
            size += this.id3v1.getSize();
        }
        if (this.allow(6, type) && this.id3v2.tagExists()) {
            size += this.id3v2.getSize();
        }
        return size;
    }

    public int getTagSize() {
        return this.getTagSize(this.tagType);
    }

    public int getTaggingType() {
        return this.tagType;
    }

    public String getTitle() throws ID3v2FormatException {
        String str = new String();
        if (this.allow(6)) {
            str = this.id3v2.getFrameDataString(ID3v2Frames.TITLE);
        } else if (this.allow(5)) {
            str = this.id3v1.getTitle();
        }
        return str;
    }

    public int getTrack() throws ID3v2FormatException {
        String str = this.getTrackString();
        int track = -1;
        int loc = str.indexOf("/");
        try {
            if (loc != -1) {
                str = str.substring(0, loc);
            }
            track = Integer.parseInt(str);
        }
        catch (NumberFormatException e) {}
        return track;
    }

    public String getTrackString() throws ID3v2FormatException {
        String str = new String();
        if (this.allow(6)) {
            str = this.id3v2.getFrameDataString(ID3v2Frames.TRACK_NUMBER);
        } else if (this.allow(5)) {
            str = String.valueOf(this.id3v1.getTrack());
        }
        return str;
    }

    public String getUserDefinedURL() throws ID3v2FormatException {
        String str = new String();
        if (this.allow(6)) {
            str = this.id3v2.getFrameDataString(ID3v2Frames.USER_DEFINED_URL);
        }
        return str;
    }

    public String getYear() throws ID3v2FormatException {
        String str = new String();
        if (this.allow(6)) {
            str = this.id3v2.getFrameDataString(ID3v2Frames.YEAR);
        } else if (this.allow(5)) {
            str = this.id3v1.getYear();
        }
        return str;
    }

    public boolean id3v1Exists() {
        return this.id3v1.tagExists();
    }

    public boolean id3v2Exists() {
        return this.id3v2.tagExists();
    }

    public boolean isMP3() {
        return this.head.isMP3();
    }

    public boolean isMPEGCopyrighted() {
        return this.head.isCopyrighted();
    }

    public boolean isMPEGOriginal() {
        return this.head.isOriginal();
    }

    public boolean isMPEGPrivate() {
        return this.head.privateBitSet();
    }

    public boolean isMPEGProtected() {
        return this.head.isProtected();
    }

    public boolean isVBR() {
        return this.head.isVBR();
    }

    public void removeTags(int type) throws FileNotFoundException, IOException {
        if (this.allow(5, type)) {
            this.id3v1.removeTag();
        }
        if (this.allow(6, type)) {
            this.id3v2.removeTag();
        }
    }

    public void setAlbum(String album) {
        if (this.allow(5)) {
            this.id3v1.setAlbum(album);
        }
        if (this.allow(6)) {
            this.id3v2.setTextFrame(ID3v2Frames.ALBUM, album);
        }
    }

    public void setArtist(String artist) {
        if (this.allow(5)) {
            this.id3v1.setArtist(artist);
        }
        if (this.allow(6)) {
            this.id3v2.setTextFrame(ID3v2Frames.LEAD_PERFORMERS, artist);
        }
    }

    public void setComment(String comment) {
        if (this.allow(5)) {
            this.id3v1.setComment(comment);
        }
        if (this.allow(6)) {
            this.id3v2.setCommentFrame("", comment);
        }
    }

    public void setComposer(String composer) {
        if (this.allow(6)) {
            this.id3v2.setTextFrame(ID3v2Frames.COMPOSER, composer);
        }
    }

    public void setCopyrightInfo(String copyright) {
        if (this.allow(6)) {
            this.id3v2.setTextFrame(ID3v2Frames.COPYRIGHT_MESSAGE, copyright);
        }
    }

    public void setEncodedBy(String encBy) {
        if (this.allow(6)) {
            this.id3v2.setTextFrame(ID3v2Frames.ENCODED_BY, encBy);
        }
    }

    public void setFrameData(String id, byte[] data) {
        if (this.allow(6)) {
            this.id3v2.updateFrameData(id, data);
        }
    }

    public void setGenre(String genre) {
        if (this.allow(5)) {
            this.id3v1.setGenreString(genre);
        }
        if (this.allow(6)) {
            this.id3v2.setTextFrame(ID3v2Frames.CONTENT_TYPE, genre);
        }
    }

    public void setOriginalArtist(String artist) {
        if (this.allow(6)) {
            this.id3v2.setTextFrame(ID3v2Frames.ORIGINAL_ARTIST, artist);
        }
    }

    public void setTaggingType(int newType) {
        this.tagType = newType;
    }

    public void setTextFrame(String id, String data) {
        if (this.allow(6)) {
            this.id3v2.setTextFrame(id, data);
        }
    }

    public void setTitle(String title) {
        if (this.allow(5)) {
            this.id3v1.setTitle(title);
        }
        if (this.allow(6)) {
            this.id3v2.setTextFrame(ID3v2Frames.TITLE, title);
        }
    }

    public void setTrack(String track) throws NumberFormatException {
        if (this.allow(5)) {
            this.id3v1.setTrack(Integer.parseInt(track));
        }
        if (this.allow(6)) {
            this.id3v2.setTextFrame(ID3v2Frames.TRACK_NUMBER, track);
        }
    }

    public void setTrack(int track) {
        if (this.allow(5)) {
            this.id3v1.setTrack(track);
        }
        if (this.allow(6)) {
            this.id3v2.setTextFrame(ID3v2Frames.TRACK_NUMBER, String.valueOf(track));
        }
    }

    public void setUserDefinedText(String desc, String text) {
        if (this.allow(6)) {
            this.id3v2.setUserDefinedTextFrame(desc, text);
        }
    }

    public void setUserDefinedURL(String desc, String url) {
        if (this.allow(6)) {
            this.id3v2.setUserDefinedURLFrame(desc, url);
        }
    }

    public void setYear(String year) {
        if (this.allow(5)) {
            this.id3v1.setYear(year);
        }
        if (this.allow(6)) {
            this.id3v2.setTextFrame(ID3v2Frames.YEAR, year);
        }
    }

    public String toString() {
        return "MP3File\nPath:\t\t\t\t" + this.mp3.getAbsolutePath() + "\nFileSize:\t\t\t" + this.mp3.length() + " bytes\nPlayingTime:\t\t\t" + this.getPlayingTimeString() + "\n" + this.head + "\n" + this.id3v1 + "\n" + this.id3v2;
    }

    public void writeTags() throws FileNotFoundException, IOException {
        if (this.allow(6)) {
            this.id3v2.writeTag();
        }
        if (this.allow(5)) {
            this.id3v1.writeTag();
        }
    }
}

