/*
 * Decompiled with CFR 0.152.
 */
package com.Trendy.swing.plaf;

import com.Trendy.swing.plaf.BumpBuffer;
import com.Trendy.swing.plaf.TrendyLookAndFeel;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.util.Enumeration;
import java.util.Vector;
import javax.swing.Icon;

class TrendyBumps
implements Icon {
    protected int xBumps;
    protected int yBumps;
    protected Color topColor;
    protected Color shadowColor;
    protected static Vector buffers = new Vector();
    protected BumpBuffer buffer;

    public TrendyBumps(Dimension bumpArea) {
        this(bumpArea.width, bumpArea.height);
    }

    public TrendyBumps(int width, int height) {
        this(width, height, TrendyLookAndFeel.getPrimaryControlHighlight(), TrendyLookAndFeel.getPrimaryControlDarkShadow());
    }

    public TrendyBumps(int width, int height, Color newTopColor, Color newShadowColor) {
        this.setBumpArea(width, height);
        this.setBumpColors(newTopColor, newShadowColor);
    }

    private BumpBuffer _$10236(GraphicsConfiguration gc, Color aTopColor, Color aShadowColor) {
        if (this.buffer != null && this.buffer.hasSameConfiguration(gc, aTopColor, aShadowColor)) {
            return this.buffer;
        }
        BumpBuffer result = null;
        Enumeration elements = buffers.elements();
        while (elements.hasMoreElements()) {
            BumpBuffer aBuffer = (BumpBuffer)elements.nextElement();
            if (!aBuffer.hasSameConfiguration(gc, aTopColor, aShadowColor)) continue;
            result = aBuffer;
            break;
        }
        if (result == null) {
            result = new BumpBuffer(gc, this.topColor, this.shadowColor);
            buffers.addElement(result);
        }
        return result;
    }

    public void setBumpArea(Dimension bumpArea) {
        this.setBumpArea(bumpArea.width, bumpArea.height);
    }

    public void setBumpArea(int width, int height) {
        this.xBumps = width / 2;
        this.yBumps = height / 2;
    }

    public void setBumpColors(Color newTopColor, Color newShadowColor) {
        this.topColor = newTopColor;
        this.shadowColor = newShadowColor;
    }

    public void paintIcon(Component c, Graphics g, int x, int y) {
        GraphicsConfiguration gc = g instanceof Graphics2D ? ((Graphics2D)g).getDeviceConfiguration() : null;
        this.buffer = this._$10236(gc, this.topColor, this.shadowColor);
        int bufferWidth = this.buffer.getImageSize().width;
        int bufferHeight = this.buffer.getImageSize().height;
        int iconWidth = this.getIconWidth();
        int iconHeight = this.getIconHeight();
        int x2 = x + iconWidth;
        int y2 = y + iconHeight;
        int savex = x;
        while (y < y2) {
            int h = Math.min(y2 - y, bufferHeight);
            for (x = savex; x < x2; x += bufferWidth) {
                int w = Math.min(x2 - x, bufferWidth);
                g.drawImage(this.buffer.getImage(), x, y, x + w, y + h, 0, 0, w, h, null);
            }
            y += bufferHeight;
        }
    }

    public int getIconWidth() {
        return this.xBumps * 2;
    }

    public int getIconHeight() {
        return this.yBumps * 2;
    }
}

