/*
 * Decompiled with CFR 0.152.
 */
package com.Trendy.swing.plaf;

import com.Trendy.swing.plaf.TrendyToggleButtonListener;
import com.Trendy.swing.plaf.TrendyUtils;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Rectangle;
import javax.swing.AbstractButton;
import javax.swing.ButtonModel;
import javax.swing.JComponent;
import javax.swing.JToolBar;
import javax.swing.SwingUtilities;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicButtonListener;
import javax.swing.plaf.basic.BasicToggleButtonUI;
import javax.swing.text.View;

public class TrendyToggleButtonUI
extends BasicToggleButtonUI {
    private static final TrendyToggleButtonUI _$13437 = new TrendyToggleButtonUI();

    public static ComponentUI createUI(JComponent c) {
        return _$13437;
    }

    protected void installDefaults(AbstractButton b) {
        super.installDefaults(b);
        b.setRolloverEnabled(true);
    }

    protected void uninstallDefaults(AbstractButton b) {
        super.uninstallDefaults(b);
    }

    public void installUI(JComponent c) {
        super.installUI(c);
    }

    public void uninstallUI(JComponent c) {
        super.uninstallUI(c);
    }

    public void paint(Graphics g, JComponent c) {
        AbstractButton b = (AbstractButton)c;
        ButtonModel model = b.getModel();
        boolean down = model.isArmed() && model.isPressed() || model.isSelected();
        Dimension size = b.getSize();
        FontMetrics fm = g.getFontMetrics();
        Insets i = c.getInsets();
        Rectangle viewRect = new Rectangle(size);
        viewRect.x += i.left;
        viewRect.y += i.top;
        viewRect.width -= i.right + viewRect.x;
        viewRect.height -= i.bottom + viewRect.y;
        Rectangle iconRect = new Rectangle();
        Rectangle textRect = new Rectangle();
        Font f = c.getFont();
        g.setFont(f);
        String text = SwingUtilities.layoutCompoundLabel(c, fm, b.getText(), b.getIcon(), b.getVerticalAlignment(), b.getHorizontalAlignment(), b.getVerticalTextPosition(), b.getHorizontalTextPosition(), viewRect, iconRect, textRect, b.getText() == null ? 0 : b.getIconTextGap());
        g.setColor(b.getBackground());
        if (down) {
            this.paintButtonPressed(g, b);
        } else if (b.isOpaque()) {
            Insets insets = b.getInsets();
            Insets margin = b.getMargin();
            if (b.getParent() instanceof JToolBar) {
                TrendyUtils.drawToolbarButtonSkin(g, c);
            } else if (TrendyUtils.isTooSmall(c)) {
                TrendyUtils.drawButtonSkinSmall(g, c);
            } else {
                TrendyUtils.drawButtonSkin(g, c);
            }
        }
        if (b.getIcon() != null) {
            this.paintIcon(g, b, iconRect);
        }
        if (text != null && !text.equals("")) {
            View v = (View)c.getClientProperty("html");
            if (v != null) {
                v.paint(g, textRect);
            } else {
                this.paintText(g, b, textRect, text);
            }
        }
        if (b.isFocusPainted() && b.hasFocus()) {
            this.paintFocus(g, b, viewRect, textRect, iconRect);
        }
        TrendyUtils.drawButtonBorder(g, b);
    }

    protected void paintFocus(Graphics g, AbstractButton b, Rectangle viewRect, Rectangle textRect, Rectangle iconRect) {
        TrendyUtils.drawButtonBorder(g, b);
    }

    protected void paintButtonPressed(Graphics g, AbstractButton b) {
        if (b.isContentAreaFilled()) {
            if (b.getParent() instanceof JToolBar) {
                TrendyUtils.drawToolbarButtonSkin(g, b);
            } else if (TrendyUtils.isTooSmall(b)) {
                TrendyUtils.drawButtonSkinSmall(g, b);
            } else {
                TrendyUtils.drawButtonSkin(g, b);
            }
        }
        TrendyUtils.drawButtonBorder(g, b);
        this.setTextShiftOffset();
    }

    protected BasicButtonListener createButtonListener(AbstractButton b) {
        return new TrendyToggleButtonListener(b);
    }

    public Dimension getPreferredSize(JComponent c) {
        if (c.getParent() instanceof JToolBar) {
            return new Dimension((int)super.getPreferredSize(c).getWidth() + 6, (int)super.getPreferredSize(c).getHeight() + 6);
        }
        return new Dimension((int)super.getPreferredSize(c).getWidth() + 10, (int)super.getPreferredSize(c).getHeight() + 6);
    }
}

