/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.asn1.ess;

import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1EncodableVector;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.DERObject;
import org.bouncycastle.asn1.DERSequence;
import org.bouncycastle.asn1.ess.ESSCertID;
import org.bouncycastle.asn1.x509.PolicyInformation;

public class SigningCertificate
extends ASN1Encodable {
    ASN1Sequence certs;
    ASN1Sequence policies;

    public SigningCertificate(ESSCertID essCertID) {
        this.certs = new DERSequence(essCertID);
    }

    public SigningCertificate(ASN1Sequence seq) {
        this.certs = (ASN1Sequence)seq.getObjectAt(0);
        if (seq.size() > 1) {
            this.policies = (ASN1Sequence)seq.getObjectAt(1);
        }
    }

    public ESSCertID[] getCerts() {
        ESSCertID[] cs = new ESSCertID[this.certs.size()];
        int i = 0;
        while (i != this.certs.size()) {
            cs[i] = ESSCertID.getInstance(this.certs.getObjectAt(i));
            ++i;
        }
        return cs;
    }

    public static SigningCertificate getInstance(Object o) {
        if (o == null || o instanceof SigningCertificate) {
            return (SigningCertificate)o;
        }
        if (o instanceof ASN1Sequence) {
            return new SigningCertificate((ASN1Sequence)o);
        }
        throw new IllegalArgumentException("unknown object in 'SigningCertificate' factory : " + o.getClass().getName() + ".");
    }

    public PolicyInformation[] getPolicies() {
        if (this.policies == null) {
            return null;
        }
        PolicyInformation[] ps = new PolicyInformation[this.policies.size()];
        int i = 0;
        while (i != this.policies.size()) {
            ps[i] = PolicyInformation.getInstance(this.policies.getObjectAt(i));
            ++i;
        }
        return ps;
    }

    public DERObject toASN1Object() {
        ASN1EncodableVector v = new ASN1EncodableVector();
        v.add(this.certs);
        if (this.policies != null) {
            v.add(this.policies);
        }
        return new DERSequence(v);
    }
}

