/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.asn1.oiw;

import java.math.BigInteger;
import java.util.Enumeration;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1EncodableVector;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.DERInteger;
import org.bouncycastle.asn1.DERObject;
import org.bouncycastle.asn1.DERSequence;

public class ElGamalParameter
extends ASN1Encodable {
    DERInteger g;
    DERInteger p;

    public ElGamalParameter(ASN1Sequence seq) {
        Enumeration e = seq.getObjects();
        this.p = (DERInteger)e.nextElement();
        this.g = (DERInteger)e.nextElement();
    }

    public ElGamalParameter(BigInteger p, BigInteger g) {
        this.p = new DERInteger(p);
        this.g = new DERInteger(g);
    }

    public BigInteger getG() {
        return this.g.getPositiveValue();
    }

    public BigInteger getP() {
        return this.p.getPositiveValue();
    }

    public DERObject toASN1Object() {
        ASN1EncodableVector v = new ASN1EncodableVector();
        v.add(this.p);
        v.add(this.g);
        return new DERSequence(v);
    }
}

