/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.asn1.x509;

import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1OctetString;
import org.bouncycastle.asn1.ASN1TaggedObject;
import org.bouncycastle.asn1.DEREncodable;
import org.bouncycastle.asn1.DERIA5String;
import org.bouncycastle.asn1.DERObject;
import org.bouncycastle.asn1.DERObjectIdentifier;
import org.bouncycastle.asn1.DERTaggedObject;
import org.bouncycastle.asn1.x509.X509Name;

public class GeneralName
extends ASN1Encodable {
    public static final int dNSName = 2;
    public static final int directoryName = 4;
    public static final int ediPartyName = 5;
    public static final int iPAddress = 7;
    DEREncodable obj;
    public static final int otherName = 0;
    public static final int registeredID = 8;
    public static final int rfc822Name = 1;
    int tag;
    public static final int uniformResourceIdentifier = 6;
    public static final int x400Address = 3;

    public GeneralName(int tag, String name) {
        if (tag == 1 || tag == 2 || tag == 6) {
            this.tag = tag;
            this.obj = new DERIA5String(name);
        } else if (tag == 8) {
            this.tag = tag;
            this.obj = new DERObjectIdentifier(name);
        } else {
            throw new IllegalArgumentException("can't process String for tag: " + tag);
        }
    }

    public GeneralName(int tag, ASN1Encodable name) {
        this.obj = name;
        this.tag = tag;
    }

    public GeneralName(DERObject name, int tag) {
        this.obj = name;
        this.tag = tag;
    }

    public GeneralName(X509Name directoryName) {
        this.obj = directoryName;
        this.tag = 4;
    }

    public static GeneralName getInstance(ASN1TaggedObject tagObj, boolean explicit) {
        return GeneralName.getInstance(ASN1TaggedObject.getInstance(tagObj, explicit));
    }

    public static GeneralName getInstance(Object obj) {
        if (obj == null || obj instanceof GeneralName) {
            return (GeneralName)obj;
        }
        if (obj instanceof ASN1TaggedObject) {
            ASN1TaggedObject tagObj = (ASN1TaggedObject)obj;
            int tag = tagObj.getTagNo();
            switch (tag) {
                case 0: {
                    return new GeneralName(tagObj.getObject(), tag);
                }
                case 1: {
                    return new GeneralName(DERIA5String.getInstance(tagObj, false), tag);
                }
                case 2: {
                    return new GeneralName(DERIA5String.getInstance(tagObj, false), tag);
                }
                case 3: {
                    throw new IllegalArgumentException("unknown tag: " + tag);
                }
                case 4: {
                    return new GeneralName(tagObj.getObject(), tag);
                }
                case 5: {
                    return new GeneralName(tagObj.getObject(), tag);
                }
                case 6: {
                    return new GeneralName(DERIA5String.getInstance(tagObj, false), tag);
                }
                case 7: {
                    return new GeneralName(ASN1OctetString.getInstance(tagObj, false), tag);
                }
                case 8: {
                    return new GeneralName(DERObjectIdentifier.getInstance(tagObj, false), tag);
                }
            }
        }
        throw new IllegalArgumentException("unknown object in getInstance");
    }

    public DEREncodable getName() {
        return this.obj;
    }

    public int getTagNo() {
        return this.tag;
    }

    public DERObject toASN1Object() {
        if (this.tag == 4) {
            return new DERTaggedObject(true, this.tag, this.obj);
        }
        return new DERTaggedObject(false, this.tag, this.obj);
    }
}

