/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.crypto.test;

import org.bouncycastle.crypto.digests.SHA1Digest;
import org.bouncycastle.util.encoders.Hex;
import org.bouncycastle.util.test.SimpleTestResult;
import org.bouncycastle.util.test.Test;
import org.bouncycastle.util.test.TestResult;

public class SHA1DigestTest
implements Test {
    private static String resVec1;
    private static String resVec2;
    private static String resVec3;
    private static String resVec4;
    private static String testVec1;
    private static String testVec2;
    private static String testVec3;
    private static String testVec4;

    static {
        testVec1 = "";
        resVec1 = "da39a3ee5e6b4b0d3255bfef95601890afd80709";
        testVec2 = "61";
        resVec2 = "86f7e437faa5a7fce15d1ddcb9eaeaea377667b8";
        testVec3 = "616263";
        resVec3 = "a9993e364706816aba3e25717850c26c9cd0d89d";
        testVec4 = "6162636465666768696a6b6c6d6e6f707172737475767778797a";
        resVec4 = "32d10c7b8cf96570ca04ce37f2a19d84240d3a89";
    }

    public String getName() {
        return "SHA1";
    }

    public static void main(String[] args) {
        SHA1DigestTest test = new SHA1DigestTest();
        TestResult result = test.perform();
        System.out.println(result);
    }

    public TestResult perform() {
        SHA1Digest digest = new SHA1Digest();
        byte[] resBuf = new byte[digest.getDigestSize()];
        digest.doFinal(resBuf, 0);
        String resStr = new String(Hex.encode(resBuf));
        if (!resVec1.equals(resStr)) {
            return new SimpleTestResult(false, "SHA-1 failing standard vector test 1" + System.getProperty("line.separator") + "    expected: " + resVec1 + System.getProperty("line.separator") + "    got     : " + resStr);
        }
        byte[] bytes = Hex.decode(testVec2);
        digest.update(bytes, 0, bytes.length);
        digest.doFinal(resBuf, 0);
        resStr = new String(Hex.encode(resBuf));
        if (!resVec2.equals(resStr)) {
            return new SimpleTestResult(false, "SHA-1 failing standard vector test 2" + System.getProperty("line.separator") + "    expected: " + resVec2 + System.getProperty("line.separator") + "    got     : " + resStr);
        }
        bytes = Hex.decode(testVec3);
        digest.update(bytes, 0, bytes.length);
        digest.doFinal(resBuf, 0);
        resStr = new String(Hex.encode(resBuf));
        if (!resVec3.equals(resStr)) {
            return new SimpleTestResult(false, "SHA-1 failing standard vector test 3" + System.getProperty("line.separator") + "    expected: " + resVec3 + System.getProperty("line.separator") + "    got     : " + resStr);
        }
        bytes = Hex.decode(testVec4);
        digest.update(bytes, 0, bytes.length);
        digest.doFinal(resBuf, 0);
        resStr = new String(Hex.encode(resBuf));
        if (!resVec4.equals(resStr)) {
            return new SimpleTestResult(false, "SHA-1 failing standard vector test 4" + System.getProperty("line.separator") + "    expected: " + resVec4 + System.getProperty("line.separator") + "    got     : " + resStr);
        }
        bytes = Hex.decode(testVec4);
        digest.update(bytes, 0, bytes.length / 2);
        SHA1Digest d = new SHA1Digest(digest);
        digest.update(bytes, bytes.length / 2, bytes.length - bytes.length / 2);
        digest.doFinal(resBuf, 0);
        resStr = new String(Hex.encode(resBuf));
        if (!resVec4.equals(resStr)) {
            return new SimpleTestResult(false, "SHA1 failing standard vector test 5" + System.getProperty("line.separator") + "    expected: " + resVec4 + System.getProperty("line.separator") + "    got     : " + resStr);
        }
        d.update(bytes, bytes.length / 2, bytes.length - bytes.length / 2);
        d.doFinal(resBuf, 0);
        resStr = new String(Hex.encode(resBuf));
        if (!resVec4.equals(resStr)) {
            return new SimpleTestResult(false, "SHA1 failing standard vector test 5" + System.getProperty("line.separator") + "    expected: " + resVec4 + System.getProperty("line.separator") + "    got     : " + resStr);
        }
        return new SimpleTestResult(true, this.getName() + ": Okay");
    }
}

