/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.crypto.test;

import org.bouncycastle.crypto.digests.SHA224Digest;
import org.bouncycastle.util.encoders.Hex;
import org.bouncycastle.util.test.SimpleTestResult;
import org.bouncycastle.util.test.Test;
import org.bouncycastle.util.test.TestResult;

public class SHA224DigestTest
implements Test {
    private static String resVec1;
    private static String resVec2;
    private static String resVec3;
    private static String resVec4;
    private static String resVec5;
    private static String testVec1;
    private static String testVec2;
    private static String testVec3;
    private static String testVec4;
    private static String testVec5;

    static {
        testVec1 = "";
        resVec1 = "d14a028c2a3a2bc9476102bb288234c415a2b01f828ea62ac5b3e42f";
        testVec2 = "61";
        resVec2 = "abd37534c7d9a2efb9465de931cd7055ffdb8879563ae98078d6d6d5";
        testVec3 = "616263";
        resVec3 = "23097d223405d8228642a477bda255b32aadbce4bda0b3f7e36c9da7";
        testVec4 = "6162636462636465636465666465666765666768666768696768696a68696a6b696a6b6c6a6b6c6d6b6c6d6e6c6d6e6f6d6e6f706e6f7071";
        resVec4 = "75388b16512776cc5dba5da1fd890150b0c6455cb4f58b1952522525";
        testVec5 = "61616161616161616161";
        resVec5 = "20794655980c91d8bbb4c1ea97618a4bf03f42581948b2ee4ee7ad67";
    }

    public String getName() {
        return "SHA224";
    }

    public static void main(String[] args) {
        SHA224DigestTest test = new SHA224DigestTest();
        TestResult result = test.perform();
        System.out.println(result);
    }

    public TestResult perform() {
        SHA224Digest digest = new SHA224Digest();
        byte[] resBuf = new byte[digest.getDigestSize()];
        digest.doFinal(resBuf, 0);
        String resStr = new String(Hex.encode(resBuf));
        if (!resVec1.equals(resStr)) {
            return new SimpleTestResult(false, "SHA-256 failing standard vector test 1" + System.getProperty("line.separator") + "    expected: " + resVec1 + System.getProperty("line.separator") + "    got     : " + resStr);
        }
        byte[] bytes = Hex.decode(testVec2);
        digest.update(bytes, 0, bytes.length);
        digest.doFinal(resBuf, 0);
        resStr = new String(Hex.encode(resBuf));
        if (!resVec2.equals(resStr)) {
            return new SimpleTestResult(false, "SHA-256 failing standard vector test 2" + System.getProperty("line.separator") + "    expected: " + resVec2 + System.getProperty("line.separator") + "    got     : " + resStr);
        }
        bytes = Hex.decode(testVec3);
        digest.update(bytes, 0, bytes.length);
        digest.doFinal(resBuf, 0);
        resStr = new String(Hex.encode(resBuf));
        if (!resVec3.equals(resStr)) {
            return new SimpleTestResult(false, "SHA-256 failing standard vector test 3" + System.getProperty("line.separator") + "    expected: " + resVec3 + System.getProperty("line.separator") + "    got     : " + resStr);
        }
        bytes = Hex.decode(testVec4);
        digest.update(bytes, 0, bytes.length);
        digest.doFinal(resBuf, 0);
        resStr = new String(Hex.encode(resBuf));
        if (!resVec4.equals(resStr)) {
            return new SimpleTestResult(false, "SHA-256 failing standard vector test 4" + System.getProperty("line.separator") + "    expected: " + resVec4 + System.getProperty("line.separator") + "    got     : " + resStr);
        }
        bytes = Hex.decode(testVec4);
        digest.update(bytes, 0, bytes.length / 2);
        SHA224Digest d = new SHA224Digest(digest);
        digest.update(bytes, bytes.length / 2, bytes.length - bytes.length / 2);
        digest.doFinal(resBuf, 0);
        resStr = new String(Hex.encode(resBuf));
        if (!resVec4.equals(resStr)) {
            return new SimpleTestResult(false, "SHA224 failing standard vector test 5" + System.getProperty("line.separator") + "    expected: " + resVec4 + System.getProperty("line.separator") + "    got     : " + resStr);
        }
        d.update(bytes, bytes.length / 2, bytes.length - bytes.length / 2);
        d.doFinal(resBuf, 0);
        resStr = new String(Hex.encode(resBuf));
        if (!resVec4.equals(resStr)) {
            return new SimpleTestResult(false, "SHA224 failing standard vector test 5" + System.getProperty("line.separator") + "    expected: " + resVec4 + System.getProperty("line.separator") + "    got     : " + resStr);
        }
        bytes = Hex.decode(testVec5);
        int i = 0;
        while (i < 100000) {
            digest.update(bytes, 0, bytes.length);
            ++i;
        }
        digest.doFinal(resBuf, 0);
        resStr = new String(Hex.encode(resBuf));
        if (!resVec5.equals(resStr)) {
            return new SimpleTestResult(false, "SHA-256 failing standard vector test 5" + System.getProperty("line.separator") + "    expected: " + resVec5 + System.getProperty("line.separator") + "    got     : " + resStr);
        }
        return new SimpleTestResult(true, this.getName() + ": Okay");
    }
}

