/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mina.core.service;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.mina.core.future.IoFuture;
import org.apache.mina.core.future.IoFutureListener;
import org.apache.mina.core.service.IoAcceptor;
import org.apache.mina.core.service.IoConnector;
import org.apache.mina.core.service.IoService;
import org.apache.mina.core.service.IoServiceListener;
import org.apache.mina.core.session.IoSession;
import org.apache.mina.util.ExceptionMonitor;

public class IoServiceListenerSupport {
    private final IoService service;
    private final List<IoServiceListener> listeners = new CopyOnWriteArrayList<IoServiceListener>();
    private final ConcurrentMap<Long, IoSession> managedSessions = new ConcurrentHashMap<Long, IoSession>();
    private final Map<Long, IoSession> readOnlyManagedSessions = Collections.unmodifiableMap(this.managedSessions);
    private final AtomicBoolean activated = new AtomicBoolean();
    private volatile long activationTime;
    private volatile int largestManagedSessionCount = 0;
    private volatile long cumulativeManagedSessionCount = 0L;

    public IoServiceListenerSupport(IoService ioService) {
        if (ioService == null) {
            throw new IllegalArgumentException("service");
        }
        this.service = ioService;
    }

    public void add(IoServiceListener ioServiceListener) {
        if (ioServiceListener != null) {
            this.listeners.add(ioServiceListener);
        }
    }

    public long getActivationTime() {
        return this.activationTime;
    }

    public int getManagedSessionCount() {
        return this.managedSessions.size();
    }

    public boolean isActive() {
        return this.activated.get();
    }

    public void fireServiceActivated() {
        if (!this.activated.compareAndSet(false, true)) {
            return;
        }
        this.activationTime = System.currentTimeMillis();
        for (IoServiceListener ioServiceListener : this.listeners) {
            try {
                ioServiceListener.serviceActivated(this.service);
            }
            catch (Throwable throwable) {
                ExceptionMonitor.getInstance().exceptionCaught(throwable);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fireServiceDeactivated() {
        if (!this.activated.compareAndSet(true, false)) {
            return;
        }
        try {
            for (IoServiceListener ioServiceListener : this.listeners) {
                try {
                    ioServiceListener.serviceDeactivated(this.service);
                }
                catch (Throwable throwable) {
                    ExceptionMonitor.getInstance().exceptionCaught(throwable);
                }
            }
        }
        finally {
            this.disconnectSessions();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fireSessionCreated(IoSession ioSession) {
        Object object;
        boolean bl = false;
        if (ioSession.getService() instanceof IoConnector) {
            object = this.managedSessions;
            synchronized (object) {
                bl = this.managedSessions.isEmpty();
            }
        }
        if (this.managedSessions.putIfAbsent(ioSession.getId(), ioSession) != null) {
            return;
        }
        if (bl) {
            this.fireServiceActivated();
        }
        object = ioSession.getFilterChain();
        object.fireSessionCreated();
        object.fireSessionOpened();
        int n = this.managedSessions.size();
        if (n > this.largestManagedSessionCount) {
            this.largestManagedSessionCount = n;
        }
        ++this.cumulativeManagedSessionCount;
        for (IoServiceListener ioServiceListener : this.listeners) {
            try {
                ioServiceListener.sessionCreated(ioSession);
            }
            catch (Throwable throwable) {
                ExceptionMonitor.getInstance().exceptionCaught(throwable);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fireSessionDestroyed(IoSession ioSession) {
        if (this.managedSessions.remove(ioSession.getId()) == null) {
            return;
        }
        ioSession.getFilterChain().fireSessionClosed();
        try {
            for (IoServiceListener object : this.listeners) {
                try {
                    object.sessionDestroyed(ioSession);
                }
                catch (Throwable throwable) {
                    ExceptionMonitor.getInstance().exceptionCaught(throwable);
                }
            }
        }
        finally {
            if (ioSession.getService() instanceof IoConnector) {
                boolean bl = false;
                ConcurrentMap<Long, IoSession> concurrentMap = this.managedSessions;
                synchronized (concurrentMap) {
                    bl = this.managedSessions.isEmpty();
                }
                if (bl) {
                    this.fireServiceDeactivated();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void disconnectSessions() {
        if (!(this.service instanceof IoAcceptor)) {
            return;
        }
        if (!((IoAcceptor)this.service).isCloseOnDeactivation()) {
            return;
        }
        Object object = new Object();
        LockNotifyingListener lockNotifyingListener = new LockNotifyingListener(object);
        for (IoSession ioSession : this.managedSessions.values()) {
            ioSession.close(true).addListener(lockNotifyingListener);
        }
        try {
            Object object2 = object;
            synchronized (object2) {
                while (!this.managedSessions.isEmpty()) {
                    object.wait(500L);
                }
            }
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class LockNotifyingListener
    implements IoFutureListener<IoFuture> {
        private final Object lock;

        public LockNotifyingListener(Object object) {
            this.lock = object;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void operationComplete(IoFuture ioFuture) {
            Object object = this.lock;
            synchronized (object) {
                this.lock.notifyAll();
            }
        }
    }
}

