/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mina.transport.socket.nio;

import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.nio.channels.SocketChannel;
import java.util.Collection;
import java.util.Iterator;
import org.apache.mina.core.polling.AbstractPollingIoConnector;
import org.apache.mina.core.service.IoProcessor;
import org.apache.mina.core.service.TransportMetadata;
import org.apache.mina.core.session.IoSessionConfig;
import org.apache.mina.transport.socket.DefaultSocketSessionConfig;
import org.apache.mina.transport.socket.SocketConnector;
import org.apache.mina.transport.socket.SocketSessionConfig;
import org.apache.mina.transport.socket.nio.NioProcessor;
import org.apache.mina.transport.socket.nio.NioSession;
import org.apache.mina.transport.socket.nio.NioSocketSession;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class NioSocketConnector
extends AbstractPollingIoConnector<NioSession, SocketChannel>
implements SocketConnector {
    private volatile Selector selector;

    public NioSocketConnector() {
        super((IoSessionConfig)new DefaultSocketSessionConfig(), NioProcessor.class);
        ((DefaultSocketSessionConfig)this.getSessionConfig()).init(this);
    }

    @Override
    protected void init() throws Exception {
        this.selector = Selector.open();
    }

    @Override
    protected void destroy() throws Exception {
        if (this.selector != null) {
            this.selector.close();
        }
    }

    @Override
    public TransportMetadata getTransportMetadata() {
        return NioSocketSession.METADATA;
    }

    @Override
    public SocketSessionConfig getSessionConfig() {
        return (SocketSessionConfig)super.getSessionConfig();
    }

    @Override
    public InetSocketAddress getDefaultRemoteAddress() {
        return (InetSocketAddress)super.getDefaultRemoteAddress();
    }

    @Override
    public void setDefaultRemoteAddress(InetSocketAddress inetSocketAddress) {
        super.setDefaultRemoteAddress(inetSocketAddress);
    }

    @Override
    protected Iterator<SocketChannel> allHandles() {
        return new SocketChannelIterator(this.selector.keys());
    }

    @Override
    protected boolean connect(SocketChannel socketChannel, SocketAddress socketAddress) throws Exception {
        return socketChannel.connect(socketAddress);
    }

    @Override
    protected AbstractPollingIoConnector.ConnectionRequest getConnectionRequest(SocketChannel socketChannel) {
        SelectionKey selectionKey = socketChannel.keyFor(this.selector);
        if (selectionKey == null || !selectionKey.isValid()) {
            return null;
        }
        return (AbstractPollingIoConnector.ConnectionRequest)selectionKey.attachment();
    }

    @Override
    protected void close(SocketChannel socketChannel) throws Exception {
        SelectionKey selectionKey = socketChannel.keyFor(this.selector);
        if (selectionKey != null) {
            selectionKey.cancel();
        }
        socketChannel.close();
    }

    @Override
    protected boolean finishConnect(SocketChannel socketChannel) throws Exception {
        if (socketChannel.finishConnect()) {
            SelectionKey selectionKey = socketChannel.keyFor(this.selector);
            if (selectionKey != null) {
                selectionKey.cancel();
            }
            return true;
        }
        return false;
    }

    @Override
    protected SocketChannel newHandle(SocketAddress socketAddress) throws Exception {
        SocketChannel socketChannel = SocketChannel.open();
        int n = this.getSessionConfig().getReceiveBufferSize();
        if (n > 65535) {
            socketChannel.socket().setReceiveBufferSize(n);
        }
        if (socketAddress != null) {
            socketChannel.socket().bind(socketAddress);
        }
        socketChannel.configureBlocking(false);
        return socketChannel;
    }

    @Override
    protected NioSession newSession(IoProcessor<NioSession> ioProcessor, SocketChannel socketChannel) {
        return new NioSocketSession(this, ioProcessor, socketChannel);
    }

    @Override
    protected void register(SocketChannel socketChannel, AbstractPollingIoConnector.ConnectionRequest connectionRequest) throws Exception {
        socketChannel.register(this.selector, 8, connectionRequest);
    }

    @Override
    protected int select(int n) throws Exception {
        return this.selector.select(n);
    }

    @Override
    protected Iterator<SocketChannel> selectedHandles() {
        return new SocketChannelIterator(this.selector.selectedKeys());
    }

    @Override
    protected void wakeup() {
        this.selector.wakeup();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class SocketChannelIterator
    implements Iterator<SocketChannel> {
        private final Iterator<SelectionKey> i;

        private SocketChannelIterator(Collection<SelectionKey> collection) {
            this.i = collection.iterator();
        }

        @Override
        public boolean hasNext() {
            return this.i.hasNext();
        }

        @Override
        public SocketChannel next() {
            SelectionKey selectionKey = this.i.next();
            return (SocketChannel)selectionKey.channel();
        }

        @Override
        public void remove() {
            this.i.remove();
        }
    }
}

