/*
 * Decompiled with CFR 0.152.
 */
package nl.ikarus.nxt.priv.imageio.icoreader.obj;

import java.io.DataInputStream;
import java.io.IOException;

public class MyReader {
    private DataInputStream reader;
    private int offset = 0;
    private int offsetAtMark = 0;

    public MyReader(DataInputStream in) {
        this.reader = in;
    }

    public void skip(int byteCount) throws IOException {
        this.reader.skipBytes(byteCount);
    }

    public void mark() {
        if (!this.reader.markSupported()) {
            System.err.println("Error, mark not supported for this stream");
        }
        this.offsetAtMark = this.offset;
        this.reader.mark(Integer.MAX_VALUE);
    }

    public void reset() throws IOException {
        this.reader.reset();
        this.offset = this.offsetAtMark;
    }

    public byte[] readBytes(int amount) throws IOException {
        byte[] res = new byte[amount];
        this.reader.readFully(res);
        this.offset += amount;
        return res;
    }

    public int getOffset() {
        return this.offset;
    }

    public int readLONG() throws IOException {
        return this.readLONG(this.reader);
    }

    public int readLONG(DataInputStream reader) throws IOException {
        return this.readDWORD(reader);
    }

    public int readDWORD() throws IOException {
        return this.readDWORD(this.reader);
    }

    public int readDWORD(DataInputStream reader) throws IOException {
        byte[] tmp = new byte[4];
        reader.readFully(tmp);
        int res = 0;
        for (int i = tmp.length - 1; i >= 0; --i) {
            res <<= 8;
            res += tmp[i] & 0xFF;
        }
        this.offset += 4;
        return res;
    }

    public int readWORD() throws IOException {
        return this.readWORD(this.reader);
    }

    public int readWORD(DataInputStream reader) throws IOException {
        byte[] tmp = new byte[2];
        reader.readFully(tmp);
        int res = 0;
        for (int i = tmp.length - 1; i >= 0; --i) {
            res <<= 8;
            res += tmp[i] & 0xFF;
        }
        this.offset += 2;
        return res;
    }

    public int readBYTE() throws IOException {
        return this.readBYTE(this.reader);
    }

    public int readBYTE(DataInputStream reader) throws IOException {
        int res = reader.readByte() & 0xFF;
        ++this.offset;
        return res;
    }
}

