/*
 * Decompiled with CFR 0.152.
 */
package cz.vity.freerapid.core.tasks;

import cz.vity.freerapid.core.AppPrefs;
import cz.vity.freerapid.core.MainApp;
import cz.vity.freerapid.core.tasks.CoreTask;
import cz.vity.freerapid.core.tasks.ScreenInputBlocker;
import cz.vity.freerapid.gui.managers.DataManager;
import cz.vity.freerapid.swing.Swinger;
import cz.vity.freerapid.utilities.LogUtils;
import cz.vity.freerapid.utilities.os.OSCommand;
import cz.vity.freerapid.utilities.os.SystemCommander;
import cz.vity.freerapid.utilities.os.SystemCommanderFactory;
import java.util.logging.Logger;
import org.jdesktop.application.Application;
import org.jdesktop.application.Task;

public final class CloseInTimeTask
extends CoreTask<Void, Void> {
    private static final Logger logger = Logger.getLogger(CloseInTimeTask.class.getName());
    private DataManager dataManager;

    public CloseInTimeTask(Application application) {
        super(application);
        MainApp app = (MainApp)application;
        this.setUserCanCancel(true);
        this.setInputBlocker(new ScreenInputBlocker(this, Task.BlockingScope.APPLICATION, app.getMainFrame(), null));
        Swinger.bringToFront(app.getMainFrame(), true);
        this.dataManager = app.getManagerDirector().getDataManager();
    }

    @Override
    protected Void doInBackground() throws Exception {
        int seconds;
        for (int i = seconds = AppPrefs.getProperty("closeApplicationConfirmTime", 30); i > 0 && !this.isCancelled(); --i) {
            this.message(i > 1 ? "closeAppMessageN" : "closeAppMessage1", i);
            Thread.sleep(1000L);
            if (this.dataManager.checkAllComplete()) continue;
            throw new InterruptedException();
        }
        return null;
    }

    @Override
    protected void succeeded(Void taskResult) {
        int property = AppPrefs.getProperty("autoshutdown", 0);
        if (property == 1) {
            this.getApplication().exit();
            return;
        }
        if (property == 0) {
            return;
        }
        SystemCommander utils = SystemCommanderFactory.getInstance().getSystemCommanderInstance(this.getContext());
        boolean force = AppPrefs.getProperty("autoshutdownForce", true);
        boolean renew = AppPrefs.getProperty("autoshutdownDisabledWhenExecuted", true);
        if (renew) {
            AppPrefs.storeProperty("autoshutdown", 0);
        }
        boolean result = true;
        switch (property) {
            case 5: {
                result = utils.shutDown(OSCommand.HIBERNATE, force);
                break;
            }
            case 3: {
                result = utils.shutDown(OSCommand.REBOOT, force);
                break;
            }
            case 4: {
                result = utils.shutDown(OSCommand.SHUTDOWN, force);
                break;
            }
            case 2: {
                result = utils.shutDown(OSCommand.STANDBY, force);
                break;
            }
        }
        if (!result) {
            Swinger.showErrorMessage(this.getResourceMap(), "shutdownActionFailed", new Object[0]);
        } else if (property == 4) {
            this.getApplication().exit();
        }
    }

    @Override
    protected void failed(Throwable cause) {
        if (!(cause instanceof InterruptedException)) {
            super.failed(cause);
            LogUtils.processException(logger, cause);
        }
    }

    @Override
    protected void cancelled() {
        super.cancelled();
        AppPrefs.storeProperty("autoshutdown", 0);
    }

    public void sleep(int seconds) throws InterruptedException {
        logger.info("Going to sleep on " + seconds + " seconds");
    }
}

