/*
 * Decompiled with CFR 0.152.
 */
package cz.vity.freerapid.core.tasks;

import cz.vity.freerapid.core.tasks.CoreTask;
import cz.vity.freerapid.model.DownloadFile;
import cz.vity.freerapid.utilities.LogUtils;
import cz.vity.freerapid.utilities.Utils;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.List;
import java.util.logging.Logger;
import org.jdesktop.application.ApplicationContext;
import org.jdesktop.application.LocalStorage;

public final class LinksAddedTask
extends CoreTask<Void, Void> {
    private final List<DownloadFile> list;
    private static final String ALL_LINKS_FILENAME = "links.txt";
    private static final Logger logger = Logger.getLogger(LinksAddedTask.class.getName());

    public LinksAddedTask(ApplicationContext context, List<DownloadFile> list) {
        super(context.getApplication());
        this.list = list;
        this.message("", new Object[0]);
        this.setUserCanCancel(false);
        this.setDescription("");
        this.setMessage("");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected Void doInBackground() throws Exception {
        String s = this.getStringRepresentation();
        byte[] bytes = s.getBytes();
        if (bytes.length <= 0) {
            return null;
        }
        OutputStream os = null;
        LocalStorage ls = this.getContext().getLocalStorage();
        File dir = ls.getDirectory();
        if (!dir.isDirectory() && !dir.mkdirs()) {
            return null;
        }
        File path = new File(dir, ALL_LINKS_FILENAME);
        try {
            os = new BufferedOutputStream(new FileOutputStream(path, true));
            os.write(bytes);
        }
        catch (IOException e) {
            LogUtils.processException(logger, e);
        }
        finally {
            if (os != null) {
                os.close();
            }
        }
        return null;
    }

    public String getStringRepresentation() {
        StringBuilder builder = new StringBuilder();
        String time = new SimpleDateFormat("yyyy-MM-dd HH:mm ").format(Calendar.getInstance().getTime());
        String lineSeparator = Utils.getSystemLineSeparator();
        for (DownloadFile downloadFile : this.list) {
            String desc = downloadFile.getDescription();
            if (desc != null && !downloadFile.getDescription().isEmpty()) {
                builder.append(" [").append(desc).append("]");
            }
            builder.append(time).append(downloadFile.getFileUrl().toExternalForm());
            builder.append(lineSeparator);
        }
        return builder.toString();
    }
}

