/*
 * Decompiled with CFR 0.152.
 */
package cz.vity.freerapid.gui.content;

import cz.vity.freerapid.core.AppPrefs;
import cz.vity.freerapid.model.DownloadFile;
import java.awt.Component;
import java.util.Date;
import javax.swing.JTable;
import javax.swing.table.DefaultTableCellRenderer;

class DateCellRenderer
extends DefaultTableCellRenderer {
    private final String dateFormat = AppPrefs.getProperty("contentTableDateFormat", "%1$tB %1$te");

    DateCellRenderer() {
    }

    @Override
    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        if (value == null) {
            value = table.getValueAt(row, column);
        } else {
            DownloadFile downloadFile = (DownloadFile)value;
            Date dateInserted = downloadFile.getDateInserted();
            if (dateInserted == null) {
                value = "";
                this.setToolTipText(null);
            } else {
                value = this.millisToString(dateInserted);
                long time = dateInserted.getTime();
                this.setToolTipText(String.format(this.dateFormat + " %tH:%tM", time, time));
            }
        }
        this.setHorizontalAlignment(0);
        return super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
    }

    private String millisToString(Date value) {
        return String.format(this.dateFormat, value.getTime());
    }
}

