/*
 * Decompiled with CFR 0.152.
 */
package cz.vity.freerapid.gui.dialogs;

import cz.vity.freerapid.core.MainApp;
import cz.vity.freerapid.swing.SwingUtils;
import cz.vity.freerapid.swing.Swinger;
import cz.vity.freerapid.utilities.LogUtils;
import java.awt.Component;
import java.awt.ComponentOrientation;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.HeadlessException;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.Locale;
import java.util.logging.Logger;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.JFrame;
import javax.swing.JRootPane;
import javax.swing.JTextField;
import javax.swing.JToggleButton;
import javax.swing.KeyStroke;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import org.jdesktop.application.Application;
import org.jdesktop.application.ApplicationContext;
import org.jdesktop.application.ResourceMap;

abstract class AppFrame
extends JFrame {
    private static final Logger logger = Logger.getLogger(AppFrame.class.getName());
    private ActionMap actionMap = null;
    protected final Frame owner;
    public static final int RESULT_OK = 0;
    static final int RESULT_CANCEL = 1;
    protected int result = 1;

    public AppFrame(Frame owner) throws HeadlessException {
        this.setIconImage(owner.getIconImage());
        this.owner = owner;
    }

    public void doClose() {
        this.dispose();
    }

    public final int getModalResult() {
        return this.result;
    }

    protected AbstractButton getBtnCancel() {
        return null;
    }

    protected AbstractButton getBtnOK() {
        return null;
    }

    public MainApp getApp() {
        return MainApp.getInstance(MainApp.class);
    }

    protected void inject() {
        Application application = Application.getInstance(Application.class);
        ApplicationContext context = application.getContext();
        context.getResourceMap(this.getClass()).injectComponents(this);
        this.getContentPane().applyComponentOrientation(ComponentOrientation.getOrientation(Locale.getDefault()));
    }

    void setResult(int result) {
        this.result = result;
    }

    @Override
    protected final JRootPane createRootPane() {
        ActionListener escapeActionListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                AppFrame.this.doCancel(actionEvent);
            }
        };
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                AppFrame.this.windowIsClosing();
            }
        });
        ActionListener okButtonListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                AbstractButton button;
                if (AppFrame.this.getFocusOwner() instanceof AbstractButton) {
                    button = (AbstractButton)AppFrame.this.getFocusOwner();
                    if (button instanceof JToggleButton) {
                        JToggleButton toggleButton = (JToggleButton)button;
                        if (!toggleButton.isSelected()) {
                            AppFrame.doButtonAction(button, actionEvent);
                            return;
                        }
                    } else {
                        AppFrame.doButtonAction(button, actionEvent);
                        return;
                    }
                }
                if ((button = AppFrame.this.getBtnOK()) != null) {
                    actionEvent.setSource(button);
                    AppFrame.doButtonAction(button, actionEvent);
                }
            }
        };
        JRootPane rootPane = new JRootPane();
        KeyStroke stroke = KeyStroke.getKeyStroke(27, 0);
        rootPane.registerKeyboardAction(escapeActionListener, stroke, 2);
        stroke = KeyStroke.getKeyStroke(10, 0);
        rootPane.registerKeyboardAction(okButtonListener, stroke, 2);
        stroke = KeyStroke.getKeyStroke(10, 2);
        rootPane.registerKeyboardAction(okButtonListener, stroke, 2);
        return rootPane;
    }

    protected void windowIsClosing() {
    }

    private void doCancel(ActionEvent actionEvent) {
        AbstractButton button = this.getBtnCancel();
        if (button != null) {
            AppFrame.doButtonAction(button, actionEvent);
        }
    }

    private static void doButtonAction(AbstractButton button, ActionEvent actionEvent) {
        Action action = button.getAction();
        if (action != null && action.isEnabled()) {
            button.doClick();
        }
    }

    protected ResourceMap getResourceMap() {
        return Swinger.getResourceMap(this.getClass(), AppFrame.class);
    }

    static void locateOnOpticalScreenCenter(Component component) {
        Dimension paneSize = component.getSize();
        Dimension screenSize = component.getToolkit().getScreenSize();
        component.setLocation((screenSize.width - paneSize.width) / 2, (int)((double)(screenSize.height - paneSize.height) * 0.45));
    }

    protected String[] getList(String key, int valueCount) {
        ResourceMap resourceMap = this.getResourceMap();
        return Swinger.getList(resourceMap, key, valueCount);
    }

    protected boolean validateNonEmpty(JTextComponent component) {
        String text;
        Document doc = component.getDocument();
        try {
            text = doc.getText(0, doc.getLength());
        }
        catch (BadLocationException e) {
            LogUtils.processException(logger, e);
            return false;
        }
        return this.validateNonEmpty(text);
    }

    protected boolean validateNonEmpty(JTextField field, String value) {
        if (!this.validateNonEmpty(value)) {
            Swinger.inputFocus(field);
            return false;
        }
        return true;
    }

    protected boolean validateNonEmpty(String text) {
        return text.trim().length() > 0;
    }

    protected Action setAction(AbstractButton button, String actionCode) {
        Action action = this.getActionMap().get(actionCode);
        button.setAction(action);
        Object keystroke = action.getValue("AcceleratorKey");
        if (keystroke != null) {
            this.registerKeyboardAction(action);
            Object desc = action.getValue("ShortDescription");
            if (desc != null) {
                action.putValue("ShortDescription", desc.toString() + " (" + SwingUtils.keyStroke2String((KeyStroke)keystroke) + ")");
            }
        }
        return action;
    }

    protected ActionMap getActionMap() {
        if (this.actionMap == null) {
            this.actionMap = Swinger.getActionMap(this.getClass(), this);
            return this.actionMap;
        }
        return this.actionMap;
    }

    protected void setContextHelp(AbstractButton btnHelp, String contextHelp) {
        Action helpAction = this.getActionMap().get("contextDialogHelpAction");
        btnHelp.setAction(helpAction);
        btnHelp.setActionCommand(contextHelp);
        btnHelp.putClientProperty("contextDialogHelp", contextHelp);
        this.rootPane.registerKeyboardAction(helpAction, contextHelp, (KeyStroke)helpAction.getValue("AcceleratorKey"), 2);
    }

    protected void registerKeyboardAction(String action) {
        this.registerKeyboardAction(this.getActionMap().get(action));
    }

    protected void registerKeyboardAction(Action action) {
        this.registerKeyboardAction(action, (KeyStroke)action.getValue("AcceleratorKey"));
    }

    protected void registerKeyboardAction(Action action, KeyStroke keystroke) {
        this.rootPane.registerKeyboardAction(action, keystroke, 2);
    }
}

