/*
 * Decompiled with CFR 0.152.
 */
package cz.vity.freerapid.utilities.os;

import com.sun.jna.Function;
import com.sun.jna.Pointer;
import com.sun.jna.Structure;
import com.sun.jna.WString;
import com.sun.jna.platform.win32.Ole32;
import com.sun.jna.platform.win32.Ole32Util;
import com.sun.jna.platform.win32.W32Errors;
import com.sun.jna.platform.win32.WinNT;
import com.sun.jna.ptr.PointerByReference;
import java.util.logging.Logger;

class WindowsShellLink {
    private static final Logger logger = Logger.getLogger(WindowsShellLink.class.getName());
    private static final String CLSID_ShellLink = "{00021401-0000-0000-C000-000000000046}";
    private static final String IID_IShellLinkW = "{000214F9-0000-0000-C000-000000000046}";
    private static final String IID_IPersistFile = "{0000010b-0000-0000-C000-000000000046}";
    private static final int COINIT_APARTMENTTHREADED = 2;
    private static final int CLSCTX_INPROC_SERVER = 1;
    private String file;
    private String target;
    private String workingDirectory;
    private String iconLocation;
    private String arguments;

    public WindowsShellLink(String file) {
        this.file = file;
    }

    public String getFile() {
        return this.file;
    }

    public void setFile(String file) {
        this.file = file;
    }

    public String getTarget() {
        return this.target;
    }

    public void setTarget(String target) {
        this.target = target;
    }

    public String getWorkingDirectory() {
        return this.workingDirectory;
    }

    public void setWorkingDirectory(String workingDirectory) {
        this.workingDirectory = workingDirectory;
    }

    public String getIconLocation() {
        return this.iconLocation;
    }

    public void setIconLocation(String iconLocation) {
        this.iconLocation = iconLocation;
    }

    public String getArguments() {
        return this.arguments;
    }

    public void setArguments(String arguments) {
        this.arguments = arguments;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean save() {
        IPersistFile persistFile;
        IShellLinkW shellLink;
        block33: {
            boolean bl;
            block34: {
                WinNT.HRESULT h;
                String file;
                block31: {
                    boolean bl2;
                    block32: {
                        block29: {
                            boolean bl3;
                            block30: {
                                block27: {
                                    boolean bl4;
                                    block28: {
                                        block25: {
                                            boolean bl5;
                                            block26: {
                                                PointerByReference persistFileRef;
                                                block23: {
                                                    boolean bl6;
                                                    block24: {
                                                        PointerByReference shellLinkRef;
                                                        block21: {
                                                            boolean bl7;
                                                            block22: {
                                                                file = this.file;
                                                                if (file == null) {
                                                                    throw new NullPointerException("file cannot be null");
                                                                }
                                                                h = Ole32.INSTANCE.CoInitializeEx(null, 2);
                                                                if (!W32Errors.S_OK.equals(h)) {
                                                                    logger.warning("CoInitializeEx failed (" + h + ")");
                                                                    return false;
                                                                }
                                                                shellLink = null;
                                                                persistFile = null;
                                                                try {
                                                                    shellLinkRef = new PointerByReference();
                                                                    persistFileRef = new PointerByReference();
                                                                    h = Ole32.INSTANCE.CoCreateInstance(Ole32Util.getGUIDFromString(CLSID_ShellLink), null, 1, Ole32Util.getGUIDFromString(IID_IShellLinkW), shellLinkRef);
                                                                    if (W32Errors.S_OK.equals(h)) break block21;
                                                                    logger.warning("CoCreateInstance failed (" + h + ")");
                                                                    bl7 = false;
                                                                    if (shellLink == null) break block22;
                                                                }
                                                                catch (Throwable throwable) {
                                                                    if (shellLink != null) {
                                                                        WindowsShellLink.invoke(shellLink.vtbl.Release, shellLink);
                                                                    }
                                                                    if (persistFile != null) {
                                                                        WindowsShellLink.invoke(persistFile.vtbl.Release, persistFile);
                                                                    }
                                                                    Ole32.INSTANCE.CoUninitialize();
                                                                    throw throwable;
                                                                }
                                                                WindowsShellLink.invoke(shellLink.vtbl.Release, shellLink);
                                                            }
                                                            if (persistFile != null) {
                                                                WindowsShellLink.invoke(persistFile.vtbl.Release, persistFile);
                                                            }
                                                            Ole32.INSTANCE.CoUninitialize();
                                                            return bl7;
                                                        }
                                                        shellLink = new IShellLinkW(shellLinkRef.getValue());
                                                        shellLink.autoRead();
                                                        shellLink.setAutoWrite(false);
                                                        h = WindowsShellLink.invoke(shellLink.vtbl.QueryInterface, shellLink, Ole32Util.getGUIDFromString(IID_IPersistFile), persistFileRef);
                                                        if (W32Errors.S_OK.equals(h)) break block23;
                                                        logger.warning("IShellLinkW_QueryInterface failed (" + h + ")");
                                                        bl6 = false;
                                                        if (shellLink == null) break block24;
                                                        WindowsShellLink.invoke(shellLink.vtbl.Release, shellLink);
                                                    }
                                                    if (persistFile != null) {
                                                        WindowsShellLink.invoke(persistFile.vtbl.Release, persistFile);
                                                    }
                                                    Ole32.INSTANCE.CoUninitialize();
                                                    return bl6;
                                                }
                                                persistFile = new IPersistFile(persistFileRef.getValue());
                                                persistFile.autoRead();
                                                persistFile.setAutoWrite(false);
                                                if (this.target == null || W32Errors.S_OK.equals(h = WindowsShellLink.invoke(shellLink.vtbl.SetPath, shellLink, new WString(this.target)))) break block25;
                                                logger.warning("IShellLinkW_SetPath failed (" + h + ")");
                                                bl5 = false;
                                                if (shellLink == null) break block26;
                                                WindowsShellLink.invoke(shellLink.vtbl.Release, shellLink);
                                            }
                                            if (persistFile != null) {
                                                WindowsShellLink.invoke(persistFile.vtbl.Release, persistFile);
                                            }
                                            Ole32.INSTANCE.CoUninitialize();
                                            return bl5;
                                        }
                                        if (this.workingDirectory == null || W32Errors.S_OK.equals(h = WindowsShellLink.invoke(shellLink.vtbl.SetWorkingDirectory, shellLink, new WString(this.workingDirectory)))) break block27;
                                        logger.warning("IShellLinkW_SetWorkingDirectory failed (" + h + ")");
                                        bl4 = false;
                                        if (shellLink == null) break block28;
                                        WindowsShellLink.invoke(shellLink.vtbl.Release, shellLink);
                                    }
                                    if (persistFile != null) {
                                        WindowsShellLink.invoke(persistFile.vtbl.Release, persistFile);
                                    }
                                    Ole32.INSTANCE.CoUninitialize();
                                    return bl4;
                                }
                                if (this.iconLocation == null || W32Errors.S_OK.equals(h = WindowsShellLink.invoke(shellLink.vtbl.SetIconLocation, shellLink, new WString(this.iconLocation), 0))) break block29;
                                logger.warning("IShellLinkW_SetIconLocation failed (" + h + ")");
                                bl3 = false;
                                if (shellLink == null) break block30;
                                WindowsShellLink.invoke(shellLink.vtbl.Release, shellLink);
                            }
                            if (persistFile != null) {
                                WindowsShellLink.invoke(persistFile.vtbl.Release, persistFile);
                            }
                            Ole32.INSTANCE.CoUninitialize();
                            return bl3;
                        }
                        if (this.arguments == null || W32Errors.S_OK.equals(h = WindowsShellLink.invoke(shellLink.vtbl.SetArguments, shellLink, new WString(this.arguments)))) break block31;
                        logger.warning("IShellLinkW_SetArguments failed (" + h + ")");
                        bl2 = false;
                        if (shellLink == null) break block32;
                        WindowsShellLink.invoke(shellLink.vtbl.Release, shellLink);
                    }
                    if (persistFile != null) {
                        WindowsShellLink.invoke(persistFile.vtbl.Release, persistFile);
                    }
                    Ole32.INSTANCE.CoUninitialize();
                    return bl2;
                }
                h = WindowsShellLink.invoke(persistFile.vtbl.Save, persistFile, new WString(file), 1);
                if (W32Errors.S_OK.equals(h)) break block33;
                logger.warning("IPersistFile_Save failed (" + h + ")");
                bl = false;
                if (shellLink == null) break block34;
                WindowsShellLink.invoke(shellLink.vtbl.Release, shellLink);
            }
            if (persistFile != null) {
                WindowsShellLink.invoke(persistFile.vtbl.Release, persistFile);
            }
            Ole32.INSTANCE.CoUninitialize();
            return bl;
        }
        if (shellLink != null) {
            WindowsShellLink.invoke(shellLink.vtbl.Release, shellLink);
        }
        if (persistFile != null) {
            WindowsShellLink.invoke(persistFile.vtbl.Release, persistFile);
        }
        Ole32.INSTANCE.CoUninitialize();
        return true;
    }

    private static WinNT.HRESULT invoke(Pointer pointer, Object ... args) {
        return (WinNT.HRESULT)Function.getFunction(pointer).invoke(WinNT.HRESULT.class, args);
    }

    public static class IPersistFileVtbl
    extends Structure {
        public Pointer QueryInterface;
        public Pointer AddRef;
        public Pointer Release;
        public Pointer GetClassID;
        public Pointer IsDirty;
        public Pointer Load;
        public Pointer Save;
        public Pointer SaveCompleted;
        public Pointer GetCurFile;

        public static class ByReference
        extends IPersistFileVtbl
        implements Structure.ByReference {
        }
    }

    public static class IPersistFile
    extends Structure {
        public IPersistFileVtbl.ByReference vtbl;

        public IPersistFile(Pointer p) {
            super(p);
        }
    }

    public static class IShellLinkWVtbl
    extends Structure {
        public Pointer QueryInterface;
        public Pointer AddRef;
        public Pointer Release;
        public Pointer GetPath;
        public Pointer GetIDList;
        public Pointer SetIDList;
        public Pointer GetDescription;
        public Pointer SetDescription;
        public Pointer GetWorkingDirectory;
        public Pointer SetWorkingDirectory;
        public Pointer GetArguments;
        public Pointer SetArguments;
        public Pointer GetHotkey;
        public Pointer SetHotkey;
        public Pointer GetShowCmd;
        public Pointer SetShowCmd;
        public Pointer GetIconLocation;
        public Pointer SetIconLocation;
        public Pointer SetRelativePath;
        public Pointer Resolve;
        public Pointer SetPath;

        public static class ByReference
        extends IShellLinkWVtbl
        implements Structure.ByReference {
        }
    }

    public static class IShellLinkW
    extends Structure {
        public IShellLinkWVtbl.ByReference vtbl;

        public IShellLinkW(Pointer p) {
            super(p);
        }
    }
}

