/*
 * Decompiled with CFR 0.152.
 */
package chrriis.dj.sweet.components;

import chrriis.common.Utils;
import chrriis.common.WebServer;
import chrriis.dj.sweet.NSOption;
import chrriis.dj.sweet.SweetSystemProperty;
import chrriis.dj.sweet.components.BorderUtils;
import chrriis.dj.sweet.components.FlashPlayerCommandEvent;
import chrriis.dj.sweet.components.FlashPlayerListener;
import chrriis.dj.sweet.components.FlashPluginOptions;
import chrriis.dj.sweet.components.JWebBrowser;
import chrriis.dj.sweet.components.WebBrowserAdapter;
import chrriis.dj.sweet.components.WebBrowserCommandEvent;
import chrriis.dj.sweet.components.WebBrowserObject;
import java.io.File;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JFlashPlayer
extends Composite {
    private static final String SET_CUSTOM_JAVASCRIPT_DEFINITIONS_OPTION_KEY = "Flash Player Custom Javascript definitions";
    private final ResourceBundle RESOURCES;
    private Composite webBrowserPanel;
    private JWebBrowser webBrowser;
    private Composite controlBarPane;
    private Button playButton;
    private Button pauseButton;
    private Button stopButton;
    private WebBrowserObject webBrowserObject;
    private volatile String customJavascriptDefinitions;
    private volatile FlashPluginOptions options;
    protected List<FlashPlayerListener> listenerList;
    private List<ClassLoader> referenceClassLoaderList;

    static {
        WebServer.getDefaultWebServer().addContentProvider(new WebServer.WebServerContentProvider(){

            public WebServer.WebServerContent getWebServerContent(WebServer.HTTPRequest httpRequest) {
                if ("/crossdomain.xml".equals(httpRequest.getResourcePath())) {
                    return new WebServer.WebServerContent(){

                        public InputStream getInputStream() {
                            return 1.getInputStream("<?xml version=\"1.0\"?>" + Utils.LINE_SEPARATOR + "<!DOCTYPE cross-domain-policy SYSTEM \"http://www.adobe.com/xml/dtds/cross-domain-policy.dtd\">" + Utils.LINE_SEPARATOR + "<cross-domain-policy>" + Utils.LINE_SEPARATOR + "  <site-control permitted-cross-domain-policies=\"all\"/>" + Utils.LINE_SEPARATOR + "  <allow-access-from domain=\"*\" secure=\"false\"/>" + Utils.LINE_SEPARATOR + "  <allow-http-request-headers-from domain=\"*\" headers=\"*\" secure=\"false\"/>" + Utils.LINE_SEPARATOR + "</cross-domain-policy>");
                        }
                    };
                }
                return null;
            }
        });
    }

    public static NSOption setCustomJavascriptDefinitions(final String javascript) {
        return new NSOption(SET_CUSTOM_JAVASCRIPT_DEFINITIONS_OPTION_KEY){

            public Object getOptionValue() {
                return javascript;
            }
        };
    }

    public JFlashPlayer(Composite parent, NSOption ... options) {
        super(parent, 0);
        String className = JFlashPlayer.class.getName();
        this.RESOURCES = ResourceBundle.getBundle(String.valueOf(className.substring(0, className.lastIndexOf(46)).replace('.', '/')) + "/resource/FlashPlayer");
        this.listenerList = new ArrayList<FlashPlayerListener>();
        this.referenceClassLoaderList = new ArrayList<ClassLoader>(1);
        GridLayout gridLayout = new GridLayout();
        gridLayout.marginWidth = 0;
        gridLayout.marginHeight = 0;
        this.setLayout(gridLayout);
        Map<Object, Object> optionMap = NSOption.createOptionMap(options);
        this.customJavascriptDefinitions = (String)optionMap.get(SET_CUSTOM_JAVASCRIPT_DEFINITIONS_OPTION_KEY);
        this.webBrowserPanel = new Composite(this, 0);
        BorderUtils.addLoweredBevelBorderPaintListener(this.webBrowserPanel);
        this.webBrowserPanel.setLayout(new FillLayout());
        this.webBrowserPanel.setLayoutData(new GridData(4, 4, true, true));
        this.webBrowser = new JWebBrowser(this.webBrowserPanel, options);
        this.webBrowserObject = new NWebBrowserObject(this);
        this.webBrowser.addWebBrowserListener(new WebBrowserAdapter(){

            public void commandReceived(WebBrowserCommandEvent e) {
                String command = e.getCommand();
                Object[] parameters = e.getParameters();
                boolean isInternal = command.startsWith("[Chrriis]");
                FlashPlayerCommandEvent ev = null;
                FlashPlayerListener[] flashPlayerListenerArray = JFlashPlayer.this.getFlashPlayerListeners();
                int n = flashPlayerListenerArray.length;
                int n2 = 0;
                while (n2 < n) {
                    FlashPlayerListener listener = flashPlayerListenerArray[n2];
                    if (!isInternal || listener.getClass().getName().startsWith("chrriis.")) {
                        if (ev == null) {
                            ev = new FlashPlayerCommandEvent(JFlashPlayer.this, command, parameters);
                        }
                        listener.commandReceived(ev);
                    }
                    ++n2;
                }
            }
        });
        this.controlBarPane = new Composite(this, 0);
        RowLayout rowLayout = new RowLayout();
        this.controlBarPane.setLayout(rowLayout);
        this.controlBarPane.setLayoutData(new GridData(0x1000000, 4, true, false));
        this.playButton = new Button(this.controlBarPane, 8);
        this.playButton.setImage(this.createImage("PlayIcon"));
        this.playButton.setEnabled(false);
        this.playButton.setToolTipText(this.RESOURCES.getString("PlayText"));
        this.playButton.addSelectionListener(new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                JFlashPlayer.this.play();
            }
        });
        this.pauseButton = new Button(this.controlBarPane, 8);
        this.pauseButton.setImage(this.createImage("PauseIcon"));
        this.pauseButton.setEnabled(false);
        this.pauseButton.setToolTipText(this.RESOURCES.getString("PauseText"));
        this.pauseButton.addSelectionListener(new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                JFlashPlayer.this.pause();
            }
        });
        this.stopButton = new Button(this.controlBarPane, 8);
        this.stopButton.setImage(this.createImage("StopIcon"));
        this.stopButton.setEnabled(false);
        this.stopButton.setToolTipText(this.RESOURCES.getString("StopText"));
        this.stopButton.addSelectionListener(new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                JFlashPlayer.this.stop();
            }
        });
        this.adjustBorder();
        this.setControlBarVisible(false);
        this.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                JFlashPlayer.this.webBrowserObject.load(null);
            }
        });
    }

    private void adjustBorder() {
        FillLayout layout = (FillLayout)this.webBrowserPanel.getLayout();
        if (this.isControlBarVisible()) {
            layout.marginWidth = 2;
            layout.marginHeight = 2;
        } else {
            layout.marginWidth = 0;
            layout.marginHeight = 0;
        }
        this.webBrowserPanel.layout();
    }

    private Image createImage(String resourceKey) {
        String value = this.RESOURCES.getString(resourceKey);
        return value.length() == 0 ? null : new Image((Device)this.getDisplay(), JWebBrowser.class.getResourceAsStream(value));
    }

    public void load(Class<?> clazz, String resourcePath) {
        this.load(clazz, resourcePath, null);
    }

    public void load(Class<?> clazz, String resourcePath, FlashPluginOptions options) {
        this.addReferenceClassLoader(clazz.getClassLoader());
        this.load(WebServer.getDefaultWebServer().getClassPathResourceURL(clazz.getName(), resourcePath), options);
    }

    public void load(String resourceLocation) {
        this.load(resourceLocation, null);
    }

    public void load(String resourceLocation, FlashPluginOptions options) {
        if ("".equals(resourceLocation)) {
            resourceLocation = null;
        }
        if (options == null) {
            options = new FlashPluginOptions();
        }
        this.options = options;
        this.webBrowserObject.load(resourceLocation);
        boolean isEnabled = resourceLocation != null;
        this.playButton.setEnabled(isEnabled);
        this.pauseButton.setEnabled(isEnabled);
        this.stopButton.setEnabled(isEnabled);
    }

    public void play() {
        if (!this.webBrowserObject.hasContent()) {
            return;
        }
        this.webBrowserObject.invokeObjectFunction("Play", new Object[0]);
    }

    public void pause() {
        if (!this.webBrowserObject.hasContent()) {
            return;
        }
        this.webBrowserObject.invokeObjectFunction("StopPlay", new Object[0]);
    }

    public void stop() {
        if (!this.webBrowserObject.hasContent()) {
            return;
        }
        this.webBrowserObject.invokeObjectFunction("Rewind", new Object[0]);
    }

    public void setVariable(String name, String value) {
        if (!this.webBrowserObject.hasContent()) {
            return;
        }
        this.webBrowserObject.invokeObjectFunction("SetVariable", name, value);
    }

    public Object getVariable(String name) {
        if (!this.webBrowserObject.hasContent()) {
            return null;
        }
        return this.webBrowserObject.invokeObjectFunctionWithResult("GetVariable", name);
    }

    public void invokeFlashFunction(String functionName, Object ... args) {
        this.webBrowserObject.invokeObjectFunction(functionName, args);
    }

    public Object invokeFlashFunctionWithResult(String functionName, Object ... args) {
        return this.webBrowserObject.invokeObjectFunctionWithResult(functionName, args);
    }

    public JWebBrowser getWebBrowser() {
        return this.webBrowser;
    }

    public boolean isControlBarVisible() {
        return this.controlBarPane.getVisible();
    }

    public void setControlBarVisible(boolean isControlBarVisible) {
        this.controlBarPane.setVisible(isControlBarVisible);
        ((GridData)this.controlBarPane.getLayoutData()).exclude = !isControlBarVisible;
        this.adjustBorder();
        this.layout();
    }

    public void addFlashPlayerListener(FlashPlayerListener listener) {
        this.listenerList.add(listener);
    }

    public void removeFlashPlayerListener(FlashPlayerListener listener) {
        this.listenerList.remove(listener);
    }

    public FlashPlayerListener[] getFlashPlayerListeners() {
        return this.listenerList.toArray(new FlashPlayerListener[0]);
    }

    private void addReferenceClassLoader(ClassLoader referenceClassLoader) {
        if (referenceClassLoader == null || referenceClassLoader == this.getClass().getClassLoader() || this.referenceClassLoaderList.contains(referenceClassLoader)) {
            return;
        }
        this.referenceClassLoaderList.add(referenceClassLoader);
        WebServer.getDefaultWebServer().addReferenceClassLoader(referenceClassLoader);
    }

    protected void finalize() throws Throwable {
        for (ClassLoader referenceClassLoader : this.referenceClassLoaderList) {
            WebServer.getDefaultWebServer().removeReferenceClassLoader(referenceClassLoader);
        }
        this.referenceClassLoaderList.clear();
        super.finalize();
    }

    private static class NWebBrowserObject
    extends WebBrowserObject {
        private final JFlashPlayer flashPlayer;
        private final String LS = Utils.LINE_SEPARATOR;

        NWebBrowserObject(JFlashPlayer flashPlayer) {
            super(flashPlayer.webBrowser);
            this.flashPlayer = flashPlayer;
        }

        protected WebBrowserObject.ObjectHTMLConfiguration getObjectHtmlConfiguration() {
            WebBrowserObject.ObjectHTMLConfiguration objectHTMLConfiguration = new WebBrowserObject.ObjectHTMLConfiguration();
            if (this.flashPlayer.options != null) {
                String loadedResource;
                Map<String, String> htmlParameters = this.flashPlayer.options.getHTMLParameters();
                if (!htmlParameters.containsKey("base") && (loadedResource = this.flashPlayer.webBrowserObject.getLoadedResource()) != null) {
                    int lastIndex = loadedResource.lastIndexOf(47);
                    htmlParameters.put("base", loadedResource.substring(0, lastIndex + 1));
                }
                objectHTMLConfiguration.setHTMLParameters(htmlParameters);
            }
            objectHTMLConfiguration.setWindowsClassID("D27CDB6E-AE6D-11cf-96B8-444553540000");
            objectHTMLConfiguration.setWindowsInstallationURL("http://fpdownload.macromedia.com/pub/shockwave/cabs/flash/swflash.cab#version=9,0,0,0");
            objectHTMLConfiguration.setMimeType("application/x-shockwave-flash");
            objectHTMLConfiguration.setInstallationURL("http://www.adobe.com/go/getflashplayer");
            objectHTMLConfiguration.setWindowsParamName("movie");
            objectHTMLConfiguration.setParamName("src");
            return objectHTMLConfiguration;
        }

        protected String getJavascriptDefinitions() {
            String javascriptDefinitions = this.flashPlayer.customJavascriptDefinitions;
            return "      function " + NWebBrowserObject.getEmbeddedObjectJavascriptName() + "_DoFScommand(command, args) {" + this.LS + "        sendCommand(command, args);" + this.LS + "      }" + (javascriptDefinitions == null ? "" : String.valueOf(this.LS) + javascriptDefinitions);
        }

        protected String getAdditionalHeadDefinitions() {
            return "    <script language=\"VBScript\">" + this.LS + "    <!-- " + this.LS + "    Sub " + NWebBrowserObject.getEmbeddedObjectJavascriptName() + "_FSCommand(ByVal command, ByVal args)" + this.LS + "      call " + NWebBrowserObject.getEmbeddedObjectJavascriptName() + "_DoFSCommand(command, args)" + this.LS + "    end sub" + this.LS + "    //-->" + this.LS + "    </script>";
        }

        public String getLocalFileURL(File localFile) {
            if (Boolean.parseBoolean(SweetSystemProperty.WEBSERVER_ACTIVATEOLDRESOURCEMETHOD.get())) {
                return WebServer.getDefaultWebServer().getResourcePathURL(this.encodeSpecialCharacters(localFile.getParent()), this.encodeSpecialCharacters(localFile.getName()));
            }
            return WebServer.getDefaultWebServer().getResourcePathURL(localFile.getParent(), localFile.getName());
        }

        private String encodeSpecialCharacters(String s) {
            StringBuilder sb = new StringBuilder();
            int i = 0;
            while (i < s.length()) {
                int c = s.charAt(i);
                boolean isToEncode = false;
                if (!(c >= 97 && c <= 122 || c >= 65 && c <= 90 || c >= 48 && c <= 57)) {
                    switch (c) {
                        case 37: 
                        case 42: 
                        case 43: 
                        case 45: 
                        case 46: 
                        case 47: 
                        case 58: 
                        case 95: {
                            break;
                        }
                        case 92: {
                            if (!Utils.IS_WINDOWS) break;
                            c = 47;
                            break;
                        }
                        default: {
                            isToEncode = true;
                        }
                    }
                }
                if (isToEncode) {
                    sb.append(Utils.encodeURL(String.valueOf((char)c)));
                } else {
                    sb.append((char)c);
                }
                ++i;
            }
            return sb.toString();
        }
    }
}

