/*
 * Decompiled with CFR 0.152.
 */
package chrriis.dj.sweet.components;

import chrriis.common.Utils;
import chrriis.dj.sweet.EventDispatchUtils;
import chrriis.dj.sweet.NSOption;
import chrriis.dj.sweet.SweetSystemProperty;
import chrriis.dj.sweet.components.BorderUtils;
import chrriis.dj.sweet.components.JSBrowserDetection;
import chrriis.dj.sweet.components.JWebBrowserWindow;
import chrriis.dj.sweet.components.WebBrowserAdapter;
import chrriis.dj.sweet.components.WebBrowserCommandEvent;
import chrriis.dj.sweet.components.WebBrowserEvent;
import chrriis.dj.sweet.components.WebBrowserListener;
import chrriis.dj.sweet.components.WebBrowserNavigationEvent;
import chrriis.dj.sweet.components.WebBrowserWindowOpeningEvent;
import chrriis.dj.sweet.components.WebBrowserWindowWillOpenEvent;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.StringTokenizer;
import java.util.concurrent.atomic.AtomicReference;
import java.util.regex.Pattern;
import org.eclipse.swt.browser.Browser;
import org.eclipse.swt.browser.BrowserFunction;
import org.eclipse.swt.browser.CloseWindowListener;
import org.eclipse.swt.browser.LocationEvent;
import org.eclipse.swt.browser.LocationListener;
import org.eclipse.swt.browser.OpenWindowListener;
import org.eclipse.swt.browser.ProgressEvent;
import org.eclipse.swt.browser.ProgressListener;
import org.eclipse.swt.browser.StatusTextEvent;
import org.eclipse.swt.browser.StatusTextListener;
import org.eclipse.swt.browser.TitleEvent;
import org.eclipse.swt.browser.TitleListener;
import org.eclipse.swt.browser.VisibilityWindowAdapter;
import org.eclipse.swt.browser.WindowEvent;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.MenuAdapter;
import org.eclipse.swt.events.MenuEvent;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.ProgressBar;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;

public class JWebBrowser
extends Composite {
    private static final boolean IS_DEBUGGING_OPTIONS = Boolean.parseBoolean(SweetSystemProperty.COMPONENTS_DEBUG_PRINTOPTIONS.get());
    public static final String COMMAND_FUNCTION = "sendSCommand";
    public static final String COMMAND_LOCATION_PREFIX = "command://";
    public static final String COMMAND_STATUS_PREFIX = "scommand://";
    private static final String USE_XULRUNNER_RUNTIME_OPTION_KEY = "XULRunner Runtime";
    private static final NSOption XUL_RUNNER_RUNTIME_OPTION = new NSOption("XULRunner Runtime");
    private final ResourceBundle RESOURCES = ResourceBundle.getBundle(String.valueOf(JWebBrowser.class.getPackage().getName().replace('.', '/')) + "/resource/WebBrowser");
    private Composite browserContainer;
    private Browser browser;
    private Composite statusBarPane;
    private Menu menuBar;
    private Menu fileMenu;
    private MenuItem buttonBarCheckBoxMenuItem;
    private MenuItem locationBarCheckBoxMenuItem;
    private MenuItem statusBarCheckBoxMenuItem;
    private Composite buttonBarPane;
    private Composite locationBarPane;
    private Label statusLabel;
    private ProgressBar progressBar;
    private Text locationField;
    private ToolItem backButton;
    private ToolItem forwardButton;
    private ToolItem reloadButton;
    private ToolItem stopButton;
    private boolean isXULRunnerRuntime;
    private String title;
    private String status = "";
    private static Pattern JAVASCRIPT_LINE_COMMENT_PATTERN = Pattern.compile("^\\s*//.*$", 8);
    private static volatile Boolean isFixedJS;
    private int loadingProgress = 100;
    private boolean isLoading;
    private MenuItem backMenuItem;
    private MenuItem forwardMenuItem;
    private MenuItem reloadMenuItem;
    private MenuItem stopMenuItem;
    protected List<WebBrowserListener> listenerList = new ArrayList<WebBrowserListener>();

    public static NSOption useXULRunnerRuntime() {
        return XUL_RUNNER_RUNTIME_OPTION;
    }

    private void configureBrowserFunction(Browser browser) {
        new NSCommandBrowserFunction(browser);
    }

    public static void clearSessionCookies() {
        Browser.clearSessions();
    }

    public static String getCookie(String url, String name) {
        return Browser.getCookie(name, url);
    }

    public static void setCookie(String url, String value) {
        Browser.setCookie(value, url);
    }

    public static void copyAppearance(JWebBrowser fromWebBrowser, JWebBrowser toWebBrowser) {
        toWebBrowser.setLocationBarVisible(fromWebBrowser.isLocationBarVisible());
        toWebBrowser.setButtonBarVisible(fromWebBrowser.isButtonBarVisible());
        toWebBrowser.setMenuBarVisible(fromWebBrowser.isMenuBarVisible());
        toWebBrowser.setStatusBarVisible(fromWebBrowser.isStatusBarVisible());
    }

    public static void copyContent(JWebBrowser fromWebBrowser, JWebBrowser toWebBrowser) {
        String location = fromWebBrowser.getResourceLocation();
        if ("about:blank".equals(location)) {
            toWebBrowser.setHTMLContent(fromWebBrowser.getHTMLContent());
        } else {
            toWebBrowser.navigate(location);
        }
    }

    private boolean isXULRunnerRuntime() {
        return this.isXULRunnerRuntime;
    }

    public JWebBrowser(Composite parent, NSOption ... options) {
        super(parent, 0);
        String xulRunnerPath = SweetSystemProperty.WEBBROWSER_XULRUNNER_HOME.get();
        if (xulRunnerPath != null) {
            System.setProperty("org.eclipse.swt.browser.XULRunnerPath", xulRunnerPath);
        } else {
            xulRunnerPath = System.getProperty("org.eclipse.swt.browser.XULRunnerPath");
            if (xulRunnerPath == null && (xulRunnerPath = System.getenv("XULRUNNER_HOME")) != null) {
                System.setProperty("org.eclipse.swt.browser.XULRunnerPath", xulRunnerPath);
            }
        }
        int style = 0;
        Map<Object, Object> optionMap = NSOption.createOptionMap(options);
        if (IS_DEBUGGING_OPTIONS) {
            StringBuilder sb = new StringBuilder();
            sb.append("Component ").append(this.getClass().getName()).append("[").append(this.hashCode()).append("] options: ");
            boolean isFirst = true;
            for (Object key : optionMap.keySet()) {
                if (isFirst) {
                    isFirst = false;
                } else {
                    sb.append(", ");
                }
                Object value = optionMap.get(key);
                if (value instanceof NSOption) {
                    sb.append(value);
                    continue;
                }
                sb.append(key).append('=').append(value);
            }
            if (isFirst) {
                sb.append("<none>");
            }
            System.err.println(sb);
        }
        if (optionMap.get(USE_XULRUNNER_RUNTIME_OPTION_KEY) != null || "xulrunner".equals(SweetSystemProperty.WEBBROWSER_RUNTIME.get())) {
            this.isXULRunnerRuntime = true;
            style |= 0x8000;
        }
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 2;
        gridLayout.marginHeight = 0;
        gridLayout.marginWidth = 0;
        gridLayout.horizontalSpacing = 0;
        gridLayout.verticalSpacing = 0;
        this.setLayout(gridLayout);
        GridData gridData = new GridData();
        this.buttonBarPane = new Composite(this, 0);
        this.createButtonBarContent();
        this.buttonBarPane.setLayoutData(gridData);
        gridData = new GridData();
        gridData.grabExcessHorizontalSpace = true;
        gridData.horizontalAlignment = 4;
        this.locationBarPane = new Composite(this, 0);
        this.createLocationBarContent();
        this.locationBarPane.setLayoutData(gridData);
        gridData = new GridData();
        gridData.grabExcessHorizontalSpace = true;
        gridData.grabExcessVerticalSpace = true;
        gridData.horizontalSpan = 2;
        gridData.verticalAlignment = 4;
        gridData.horizontalAlignment = 4;
        this.browserContainer = new Composite(this, 0);
        BorderUtils.addLoweredBevelBorderPaintListener(this.browserContainer);
        this.browserContainer.setLayout(new FillLayout());
        this.browser = new Browser(this.browserContainer, style);
        this.configureBrowserFunction(this.browser);
        this.browserContainer.setLayoutData(gridData);
        gridData = new GridData();
        gridData.grabExcessHorizontalSpace = true;
        gridData.horizontalSpan = 2;
        gridData.horizontalAlignment = 4;
        this.statusBarPane = new Composite(this, 2048);
        this.createStatusBarContent();
        this.statusBarPane.setLayoutData(gridData);
        JWebBrowserWindow webBrowserWindow = this.getWebBrowserWindow();
        if (webBrowserWindow != null) {
            this.menuBar = new Menu(webBrowserWindow, 2);
            this.createMenuBarContent();
            webBrowserWindow.setMenuBar(this.menuBar);
        }
        this.adjustBorder();
        this.browser.addCloseWindowListener(new CloseWindowListener(){

            public void close(WindowEvent e) {
                WebBrowserEvent ev = null;
                int i = JWebBrowser.this.listenerList.size() - 1;
                while (i >= 0) {
                    if (ev == null) {
                        ev = new WebBrowserEvent(JWebBrowser.this);
                    }
                    JWebBrowser.this.listenerList.get(i).windowClosing(ev);
                    --i;
                }
                JWebBrowserWindow browserWindow = JWebBrowser.this.getWebBrowserWindow();
                if (browserWindow != null) {
                    browserWindow.dispose();
                }
            }
        });
        this.browser.addTitleListener(new TitleListener(){

            public void changed(TitleEvent e) {
                JWebBrowser.this.title = e.title;
                WebBrowserEvent ev = null;
                int i = JWebBrowser.this.listenerList.size() - 1;
                while (i >= 0) {
                    if (ev == null) {
                        ev = new WebBrowserEvent(JWebBrowser.this);
                    }
                    JWebBrowser.this.listenerList.get(i).titleChanged(ev);
                    --i;
                }
            }
        });
        this.browser.addStatusTextListener(new StatusTextListener(){

            public void changed(StatusTextEvent e) {
                String newStatus = e.text;
                if (newStatus.startsWith(JWebBrowser.COMMAND_STATUS_PREFIX)) {
                    JWebBrowser.this.browser.execute(JWebBrowser.fixJavascript(JWebBrowser.this.browser, "window.status = decodeURIComponent('" + Utils.encodeURL(JWebBrowser.this.status == null ? "" : JWebBrowser.this.status) + "');"));
                    String query = newStatus.substring(JWebBrowser.COMMAND_STATUS_PREFIX.length());
                    if (query.endsWith("/")) {
                        query = query.substring(0, query.length() - 1);
                    }
                    ArrayList<String> queryElementList = new ArrayList<String>();
                    StringTokenizer st = new StringTokenizer(query, "&", true);
                    String lastToken = null;
                    while (st.hasMoreTokens()) {
                        String token = st.nextToken();
                        if ("&".equals(token)) {
                            if (lastToken == null) {
                                queryElementList.add("");
                            }
                            lastToken = null;
                            continue;
                        }
                        lastToken = token;
                        queryElementList.add(Utils.decodeURL(token));
                    }
                    if (lastToken == null) {
                        queryElementList.add("");
                    }
                    String command = queryElementList.isEmpty() ? "" : (String)queryElementList.remove(0);
                    Object[] args = queryElementList.toArray(new String[0]);
                    WebBrowserCommandEvent ev = null;
                    int i = JWebBrowser.this.listenerList.size() - 1;
                    while (i >= 0) {
                        if (ev == null) {
                            ev = new WebBrowserCommandEvent(JWebBrowser.this, command, args);
                        }
                        JWebBrowser.this.listenerList.get(i).commandReceived(ev);
                        --i;
                    }
                    return;
                }
                if (newStatus.equals(JWebBrowser.this.status)) {
                    return;
                }
                JWebBrowser.this.status = e.text;
                WebBrowserEvent ev = null;
                int i = JWebBrowser.this.listenerList.size() - 1;
                while (i >= 0) {
                    if (ev == null) {
                        ev = new WebBrowserEvent(JWebBrowser.this);
                    }
                    JWebBrowser.this.listenerList.get(i).statusChanged(ev);
                    --i;
                }
            }
        });
        this.browser.addProgressListener(new ProgressListener(){

            private void updateProgress(int loadingProgress) {
                if (JWebBrowser.this.loadingProgress != loadingProgress) {
                    JWebBrowser.this.loadingProgress = loadingProgress;
                    WebBrowserEvent e = null;
                    int i = JWebBrowser.this.listenerList.size() - 1;
                    while (i >= 0) {
                        if (e == null) {
                            e = new WebBrowserEvent(JWebBrowser.this);
                        }
                        JWebBrowser.this.listenerList.get(i).loadingProgressChanged(e);
                        --i;
                    }
                }
            }

            public void changed(ProgressEvent e) {
                if (e.total <= 0 || e.total < e.current) {
                    return;
                }
                JWebBrowser.this.isLoading = true;
                this.updateProgress(e.current == e.total ? 100 : Math.min(e.current * 100 / e.total, 99));
            }

            public void completed(ProgressEvent progressevent) {
                JWebBrowser.this.isLoading = false;
                this.updateProgress(100);
            }
        });
        this.browser.addLocationListener(new LocationListener(){

            public void changed(LocationEvent e) {
                JWebBrowser.this.isLoading = false;
                WebBrowserNavigationEvent ev = null;
                int i = JWebBrowser.this.listenerList.size() - 1;
                while (i >= 0) {
                    if (ev == null) {
                        ev = new WebBrowserNavigationEvent(JWebBrowser.this, e.location, e.top);
                    }
                    JWebBrowser.this.listenerList.get(i).locationChanged(ev);
                    --i;
                }
            }

            public void changing(LocationEvent e) {
                String location = e.location;
                if (location.startsWith(JWebBrowser.COMMAND_LOCATION_PREFIX)) {
                    e.doit = false;
                    String query = location.substring(JWebBrowser.COMMAND_LOCATION_PREFIX.length());
                    if (query.endsWith("/")) {
                        query = query.substring(0, query.length() - 1);
                    }
                    ArrayList<String> queryElementList = new ArrayList<String>();
                    StringTokenizer st = new StringTokenizer(query, "&", true);
                    String lastToken = null;
                    while (st.hasMoreTokens()) {
                        String token = st.nextToken();
                        if ("&".equals(token)) {
                            if (lastToken == null) {
                                queryElementList.add("");
                            }
                            lastToken = null;
                            continue;
                        }
                        lastToken = token;
                        queryElementList.add(Utils.decodeURL(token));
                    }
                    if (lastToken == null) {
                        queryElementList.add("");
                    }
                    String command = queryElementList.isEmpty() ? "" : (String)queryElementList.remove(0);
                    Object[] args = queryElementList.toArray(new String[0]);
                    WebBrowserCommandEvent ev = null;
                    int i = JWebBrowser.this.listenerList.size() - 1;
                    while (i >= 0) {
                        if (ev == null) {
                            ev = new WebBrowserCommandEvent(JWebBrowser.this, command, args);
                        }
                        JWebBrowser.this.listenerList.get(i).commandReceived(ev);
                        --i;
                    }
                    return;
                }
                if (location.startsWith("javascript:")) {
                    return;
                }
                JWebBrowser.this.isLoading = true;
                boolean isNavigating = true;
                WebBrowserNavigationEvent ev = null;
                int i = JWebBrowser.this.listenerList.size() - 1;
                while (i >= 0) {
                    if (ev == null) {
                        ev = new WebBrowserNavigationEvent(JWebBrowser.this, location, e.top);
                    }
                    JWebBrowser.this.listenerList.get(i).locationChanging(ev);
                    isNavigating &= !ev.isConsumed();
                    --i;
                }
                e.doit = isNavigating;
                if (!e.doit) {
                    JWebBrowser.this.isLoading = false;
                    WebBrowserNavigationEvent ev2 = null;
                    int i2 = JWebBrowser.this.listenerList.size() - 1;
                    while (i2 >= 0) {
                        if (ev2 == null) {
                            ev2 = new WebBrowserNavigationEvent(JWebBrowser.this, e.location, e.top);
                        }
                        JWebBrowser.this.listenerList.get(i2).locationChangeCanceled(ev2);
                        --i2;
                    }
                }
            }
        });
        this.browser.addOpenWindowListener(new OpenWindowListener(){

            public void open(WindowEvent e) {
                JWebBrowser newWebBrowser;
                boolean isDisposed;
                JWebBrowser jWebBrowser;
                JWebBrowserWindow webBrowserWindow;
                if (JWebBrowser.this.isXULRunnerRuntime()) {
                    webBrowserWindow = new JWebBrowserWindow(JWebBrowser.useXULRunnerRuntime());
                    jWebBrowser = webBrowserWindow.getWebBrowser();
                } else {
                    webBrowserWindow = new JWebBrowserWindow(new NSOption[0]);
                    jWebBrowser = webBrowserWindow.getWebBrowser();
                }
                WebBrowserWindowWillOpenEvent ev = null;
                int i = JWebBrowser.this.listenerList.size() - 1;
                while (i >= 0) {
                    if (ev == null) {
                        ev = new WebBrowserWindowWillOpenEvent(JWebBrowser.this, jWebBrowser);
                    }
                    JWebBrowser.this.listenerList.get(i).windowWillOpen(ev);
                    jWebBrowser = ev.isConsumed() ? null : ev.getNewWebBrowser();
                    --i;
                }
                if (jWebBrowser == null) {
                    isDisposed = true;
                    newWebBrowser = webBrowserWindow.getWebBrowser();
                } else {
                    isDisposed = false;
                    newWebBrowser = jWebBrowser;
                }
                e.browser = newWebBrowser.getNativeComponent();
                e.browser.addVisibilityWindowListener(new VisibilityWindowAdapter(){

                    public void show(final WindowEvent e) {
                        Browser browser = (Browser)e.widget;
                        if (isDisposed) {
                            final Shell shell = browser.getShell();
                            e.display.asyncExec(new Runnable(){

                                public void run() {
                                    shell.close();
                                }
                            });
                        } else {
                            browser.removeVisibilityWindowListener(this);
                            newWebBrowser.setMenuBarVisible(e.menuBar);
                            newWebBrowser.setButtonBarVisible(e.toolBar);
                            newWebBrowser.setLocationBarVisible(e.addressBar);
                            newWebBrowser.setStatusBarVisible(e.statusBar);
                            JWebBrowserWindow browserWindow = newWebBrowser.getWebBrowserWindow();
                            if (browserWindow != null) {
                                if (e.size != null) {
                                    Point windowSize = browserWindow.getSize();
                                    Point webBrowserSize = browserWindow.getWebBrowser().getNativeComponent().getSize();
                                    if (e.size.x > 0) {
                                        windowSize.x -= webBrowserSize.x;
                                        windowSize.x += e.size.x;
                                    }
                                    if (e.size.y > 0) {
                                        windowSize.y -= webBrowserSize.y;
                                        windowSize.y += e.size.y;
                                    }
                                    browserWindow.setSize(windowSize);
                                }
                                if (e.location != null) {
                                    browserWindow.setLocation(e.location);
                                }
                            }
                            WebBrowserWindowOpeningEvent ev = null;
                            int i = (this).JWebBrowser.this.listenerList.size() - 1;
                            while (i >= 0) {
                                if (ev == null) {
                                    ev = new WebBrowserWindowOpeningEvent(JWebBrowser.this, newWebBrowser, e.location, e.size);
                                }
                                (this).JWebBrowser.this.listenerList.get(i).windowOpening(ev);
                                --i;
                            }
                            new Thread(){

                                public void run() {
                                    try {
                                        2.sleep(600L);
                                    }
                                    catch (Exception exception) {
                                        // empty catch block
                                    }
                                    e.display.asyncExec(new Runnable(){

                                        public void run() {
                                            JWebBrowserWindow webBrowserWindow;
                                            if (!newWebBrowser.isDisposed() && (webBrowserWindow = newWebBrowser.getWebBrowserWindow()) != null && !webBrowserWindow.isDisposed()) {
                                                webBrowserWindow.setVisible(true);
                                            }
                                        }
                                    });
                                }
                            }.start();
                        }
                    }
                });
            }
        });
        this.addWebBrowserListener(new WebBrowserAdapter(){

            public void statusChanged(WebBrowserEvent e) {
                JWebBrowser.this.updateStatus();
            }

            public void loadingProgressChanged(WebBrowserEvent e) {
                JWebBrowser.this.updateProgressValue();
                JWebBrowser.this.updateStopButton(false);
            }

            public void locationChanged(WebBrowserNavigationEvent e) {
                JWebBrowser.this.updateStopButton(false);
                if (e.isTopFrame()) {
                    JWebBrowser.this.updateLocationField(null);
                }
                JWebBrowser.this.updateNavigationButtons();
            }

            public void locationChanging(WebBrowserNavigationEvent e) {
                if (e.isTopFrame()) {
                    JWebBrowser.this.updateLocationField(e.getNewResourceLocation());
                }
                JWebBrowser.this.updateStopButton(true);
            }

            public void locationChangeCanceled(WebBrowserNavigationEvent e) {
                JWebBrowser.this.updateStopButton(false);
                if (e.isTopFrame()) {
                    JWebBrowser.this.updateLocationField(null);
                }
                JWebBrowser.this.updateNavigationButtons();
            }
        });
    }

    private void createMenuBarContent() {
        JWebBrowserWindow webBrowserWindow = this.getWebBrowserWindow();
        MenuItem fileMenuItem = new MenuItem(this.menuBar, 64);
        fileMenuItem.setText(this.RESOURCES.getString("FileMenu"));
        this.fileMenu = new Menu(webBrowserWindow, 4);
        fileMenuItem.setMenu(this.fileMenu);
        MenuItem fileNewWindowMenuItem = new MenuItem(this.fileMenu, 8);
        fileNewWindowMenuItem.setText(this.RESOURCES.getString("FileNewWindowMenu"));
        fileNewWindowMenuItem.addSelectionListener(new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                JWebBrowserWindow webBrowserWindow = JWebBrowser.this.isXULRunnerRuntime() ? new JWebBrowserWindow(JWebBrowser.useXULRunnerRuntime()) : new JWebBrowserWindow(new NSOption[0]);
                JWebBrowser webBrowser = webBrowserWindow.getWebBrowser();
                JWebBrowser.copyAppearance(JWebBrowser.this, webBrowser);
                JWebBrowser.copyContent(JWebBrowser.this, webBrowser);
                webBrowserWindow.setVisible(true);
            }
        });
        MenuItem fileOpenLocationMenuItem = new MenuItem(this.fileMenu, 8);
        fileOpenLocationMenuItem.setText(this.RESOURCES.getString("FileOpenLocationMenu"));
        fileOpenLocationMenuItem.addSelectionListener(new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
            }
        });
        MenuItem fileOpenFileMenuItem = new MenuItem(this.fileMenu, 8);
        fileOpenFileMenuItem.setText(this.RESOURCES.getString("FileOpenFileMenu"));
        fileOpenFileMenuItem.addSelectionListener(new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                FileDialog fileDialog = new FileDialog(JWebBrowser.this.getShell(), 4096);
                String fileName = fileDialog.open();
                if (fileName != null) {
                    JWebBrowser.this.navigate(fileName);
                }
            }
        });
        MenuItem viewMenuItem = new MenuItem(this.menuBar, 64);
        viewMenuItem.setText(this.RESOURCES.getString("ViewMenu"));
        Menu viewMenu = new Menu(webBrowserWindow, 4);
        viewMenuItem.setMenu(viewMenu);
        MenuItem viewToolbarsMenuItem = new MenuItem(viewMenu, 64);
        viewToolbarsMenuItem.setText(this.RESOURCES.getString("ViewToolbarsMenu"));
        Menu viewToolbarsMenu = new Menu(webBrowserWindow, 4);
        viewToolbarsMenuItem.setMenu(viewToolbarsMenu);
        this.buttonBarCheckBoxMenuItem = new MenuItem(viewToolbarsMenu, 32);
        this.buttonBarCheckBoxMenuItem.setText(this.RESOURCES.getString("ViewToolbarsButtonBarMenu"));
        this.buttonBarCheckBoxMenuItem.setSelection(this.isButtonBarVisible());
        this.buttonBarCheckBoxMenuItem.addSelectionListener(new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                JWebBrowser.this.setButtonBarVisible(JWebBrowser.this.buttonBarCheckBoxMenuItem.getSelection());
            }
        });
        this.locationBarCheckBoxMenuItem = new MenuItem(viewToolbarsMenu, 32);
        this.locationBarCheckBoxMenuItem.setText(this.RESOURCES.getString("ViewToolbarsLocationBarMenu"));
        this.locationBarCheckBoxMenuItem.setSelection(this.isLocationBarVisible());
        this.locationBarCheckBoxMenuItem.addSelectionListener(new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                JWebBrowser.this.setLocationBarVisible(JWebBrowser.this.locationBarCheckBoxMenuItem.getSelection());
            }
        });
        this.statusBarCheckBoxMenuItem = new MenuItem(viewMenu, 32);
        this.statusBarCheckBoxMenuItem.setText(this.RESOURCES.getString("ViewStatusBarMenu"));
        this.statusBarCheckBoxMenuItem.setSelection(this.isStatusBarVisible());
        this.statusBarCheckBoxMenuItem.addSelectionListener(new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                JWebBrowser.this.setStatusBarVisible(JWebBrowser.this.statusBarCheckBoxMenuItem.getSelection());
            }
        });
    }

    private void createStatusBarContent() {
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 2;
        gridLayout.marginHeight = 2;
        gridLayout.marginWidth = 2;
        gridLayout.horizontalSpacing = 0;
        gridLayout.verticalSpacing = 0;
        this.statusBarPane.setLayout(gridLayout);
        GridData gridData = new GridData();
        gridData.grabExcessHorizontalSpace = true;
        gridData.horizontalAlignment = 4;
        this.statusLabel = new Label(this.statusBarPane, 0);
        this.statusLabel.setLayoutData(gridData);
        gridData = new GridData();
        gridData.widthHint = 50;
        gridData.heightHint = 0;
        gridData.verticalAlignment = 4;
        this.progressBar = new ProgressBar(this.statusBarPane, 256);
        this.progressBar.setMinimum(0);
        this.progressBar.setMaximum(100);
        this.progressBar.setLayoutData(gridData);
        this.progressBar.setVisible(false);
    }

    private void createButtonBarContent() {
        this.buttonBarPane.setLayout(new FillLayout());
        ToolBar buttonToolBar = new ToolBar(this.buttonBarPane, 0x800100);
        this.backButton = new ToolItem(buttonToolBar, 8);
        this.backButton.setImage(this.createIcon("BackIcon"));
        this.backButton.setToolTipText(this.RESOURCES.getString("BackText"));
        this.backButton.setEnabled(false);
        this.backButton.addSelectionListener(new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                JWebBrowser.this.navigateBack();
            }
        });
        this.forwardButton = new ToolItem(buttonToolBar, 8);
        this.forwardButton.setImage(this.createIcon("ForwardIcon"));
        this.forwardButton.setToolTipText(this.RESOURCES.getString("ForwardText"));
        this.forwardButton.setEnabled(false);
        this.forwardButton.addSelectionListener(new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                JWebBrowser.this.navigateForward();
            }
        });
        this.reloadButton = new ToolItem(buttonToolBar, 8);
        this.reloadButton.setImage(this.createIcon("ReloadIcon"));
        this.reloadButton.setToolTipText(this.RESOURCES.getString("ReloadText"));
        this.reloadButton.addSelectionListener(new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                JWebBrowser.this.reloadPage();
            }
        });
        this.stopButton = new ToolItem(buttonToolBar, 8);
        this.stopButton.setImage(this.createIcon("StopIcon"));
        this.stopButton.setToolTipText(this.RESOURCES.getString("StopText"));
        this.stopButton.setEnabled(false);
        this.stopButton.addSelectionListener(new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                JWebBrowser.this.stopLoading();
            }
        });
    }

    private void updateNavigationButtons() {
        this.backButton.setEnabled(this.isBackNavigationEnabled());
        if (this.backMenuItem != null) {
            this.backMenuItem.setEnabled(this.isBackNavigationEnabled());
        }
        this.forwardButton.setEnabled(this.isForwardNavigationEnabled());
        if (this.forwardMenuItem != null) {
            this.forwardMenuItem.setEnabled(this.isForwardNavigationEnabled());
        }
    }

    private void updateStopButton(boolean isForcedOn) {
        boolean isStopEnabled = isForcedOn || this.getLoadingProgress() != 100;
        this.stopButton.setEnabled(isStopEnabled);
        if (this.stopMenuItem != null) {
            this.stopMenuItem.setEnabled(isStopEnabled);
        }
    }

    private void updateLocationField(String location) {
        String string = location = location == null ? this.getResourceLocation() : location;
        if (!this.locationField.getText().equals(location)) {
            this.locationField.setText(location);
            this.locationField.setSelection(location.length(), location.length());
        }
    }

    private void updateStatus() {
        this.statusLabel.setText(this.status);
        this.statusBarPane.layout();
    }

    private void updateProgressValue() {
        this.progressBar.setSelection(this.loadingProgress);
        boolean isProgressBarVisible = this.loadingProgress < 100;
        this.progressBar.setVisible(isProgressBarVisible);
        ((GridData)this.progressBar.getLayoutData()).exclude = !isProgressBarVisible;
        this.statusBarPane.layout();
    }

    private void createLocationBarContent() {
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 2;
        gridLayout.marginHeight = 2;
        gridLayout.marginWidth = 2;
        gridLayout.horizontalSpacing = 0;
        gridLayout.verticalSpacing = 0;
        this.locationBarPane.setLayout(gridLayout);
        GridData gridData = new GridData();
        gridData.grabExcessHorizontalSpace = true;
        gridData.horizontalAlignment = 4;
        gridData.verticalAlignment = 4;
        this.locationField = new Text(this.locationBarPane, 2048);
        this.locationField.setLayoutData(gridData);
        this.locationField.addKeyListener(new KeyAdapter(){

            public void keyPressed(KeyEvent e) {
                if (e.keyCode == 27) {
                    JWebBrowser.this.updateLocationField(null);
                    JWebBrowser.this.locationField.setSelection(0, JWebBrowser.this.locationField.getText().length());
                }
            }
        });
        this.locationField.addSelectionListener(new SelectionAdapter(){

            public void widgetDefaultSelected(SelectionEvent e) {
                JWebBrowser.this.navigate(JWebBrowser.this.locationField.getText());
            }
        });
        gridData = new GridData();
        gridData.verticalAlignment = 4;
        ToolBar goToolBar = new ToolBar(this.locationBarPane, 0x800000);
        goToolBar.setLayoutData(gridData);
        ToolItem goButton = new ToolItem(goToolBar, 8);
        goButton.setImage(this.createIcon("GoIcon"));
        goButton.setToolTipText(this.RESOURCES.getString("GoText"));
        goButton.addSelectionListener(new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                JWebBrowser.this.navigate(JWebBrowser.this.locationField.getText());
            }
        });
    }

    public void setStatusBarVisible(boolean isStatusBarVisible) {
        if (isStatusBarVisible == this.isStatusBarVisible()) {
            return;
        }
        this.statusBarPane.setVisible(isStatusBarVisible);
        boolean bl = ((GridData)this.statusBarPane.getLayoutData()).exclude = !isStatusBarVisible;
        if (this.statusBarCheckBoxMenuItem != null) {
            this.statusBarCheckBoxMenuItem.setSelection(isStatusBarVisible);
        }
        this.adjustBorder();
        this.layout();
    }

    public boolean isStatusBarVisible() {
        return this.statusBarPane.getVisible();
    }

    void setMenuBarVisible(boolean isMenuBarVisible) {
        if (isMenuBarVisible == this.isMenuBarVisible()) {
            return;
        }
        JWebBrowserWindow webBrowserWindow = this.getWebBrowserWindow();
        if (webBrowserWindow != null) {
            webBrowserWindow.setMenuBar(isMenuBarVisible ? this.menuBar : null);
        }
        this.adjustBorder();
    }

    boolean isMenuBarVisible() {
        return this.menuBar != null && this.menuBar.getVisible();
    }

    public void setButtonBarVisible(boolean isButtonBarVisible) {
        if (isButtonBarVisible == this.isButtonBarVisible()) {
            return;
        }
        this.buttonBarPane.setVisible(isButtonBarVisible);
        boolean bl = ((GridData)this.buttonBarPane.getLayoutData()).exclude = !isButtonBarVisible;
        if (this.buttonBarCheckBoxMenuItem != null) {
            this.buttonBarCheckBoxMenuItem.setSelection(isButtonBarVisible);
        }
        this.adjustBorder();
        this.layout();
    }

    public boolean isButtonBarVisible() {
        return this.buttonBarPane.getVisible();
    }

    public void setLocationBarVisible(boolean isLocationBarVisible) {
        if (isLocationBarVisible == this.isLocationBarVisible()) {
            return;
        }
        this.locationBarPane.setVisible(isLocationBarVisible);
        boolean bl = ((GridData)this.locationBarPane.getLayoutData()).exclude = !isLocationBarVisible;
        if (this.locationBarCheckBoxMenuItem != null) {
            this.locationBarCheckBoxMenuItem.setSelection(isLocationBarVisible);
        }
        this.adjustBorder();
        this.layout();
    }

    public boolean isLocationBarVisible() {
        return this.locationBarPane.getVisible();
    }

    public String getPageTitle() {
        return this.title == null ? "" : this.title;
    }

    public String getStatusText() {
        return this.status == null ? "" : this.status;
    }

    public String getHTMLContent() {
        return this.browser.getText();
    }

    public boolean setHTMLContent(String html) {
        return this.browser.setText(html);
    }

    public String getResourceLocation() {
        return this.browser.getUrl();
    }

    public boolean navigate(String resourceLocation) {
        return this.browser.setUrl(resourceLocation);
    }

    public boolean isBackNavigationEnabled() {
        return this.browser.isBackEnabled();
    }

    public void navigateBack() {
        this.browser.back();
    }

    public boolean isForwardNavigationEnabled() {
        return this.browser.isForwardEnabled();
    }

    public void navigateForward() {
        this.browser.forward();
    }

    public void reloadPage() {
        this.browser.refresh();
    }

    public void stopLoading() {
        this.browser.stop();
    }

    public boolean isJavascriptEnabled() {
        return this.browser.getJavascriptEnabled();
    }

    public void setJavascriptEnabled(boolean isJavascriptEnabled) {
        this.browser.setJavascriptEnabled(isJavascriptEnabled);
    }

    private static String fixJavascript(Browser browser, String script) {
        if ("mozilla".equals(browser.getBrowserType())) {
            if (isFixedJS == null) {
                isFixedJS = "%25".equals(browser.evaluate("return '%25'"));
            }
            if (!isFixedJS.booleanValue()) {
                script = JAVASCRIPT_LINE_COMMENT_PATTERN.matcher(script).replaceAll("");
                script = Utils.encodeURL(script);
            }
        }
        return script;
    }

    private boolean executeJavascriptAndWait(String javascript) {
        return this.browser.execute(JWebBrowser.fixJavascript(this.browser, javascript));
    }

    public void executeJavascript(String javascript) {
        this.executeJavascriptAndWait(javascript);
    }

    public Object executeJavascriptWithResult(String javascript) {
        Object[] result;
        if (!javascript.endsWith(";")) {
            javascript = String.valueOf(javascript) + ";";
        }
        if ((result = this.executeJavascriptWithCommandResult("[[getScriptResult]]", "try {  sendSCommand('[[getScriptResult]]', (function() {" + javascript + "})());" + "} catch(exxxxx) {" + "  " + COMMAND_FUNCTION + "('[[getScriptResult]]');" + "}")) == null) {
            return null;
        }
        return result.length == 0 ? null : result[0];
    }

    public static String createJavascriptFunctionCall(String functionName, Object ... args) {
        StringBuilder sb = new StringBuilder();
        sb.append(functionName).append('(');
        int i = 0;
        while (i < args.length) {
            if (i > 0) {
                sb.append(", ");
            }
            sb.append(JWebBrowser.convertJavaObjectToJavascript(args[i]));
            ++i;
        }
        sb.append(")");
        return sb.toString();
    }

    public static String convertJavaObjectToJavascript(Object o) {
        String encodedArg;
        if (o == null) {
            return "null";
        }
        if (o instanceof Boolean || o instanceof Number) {
            return o.toString();
        }
        if (o.getClass().isArray()) {
            StringBuilder sb = new StringBuilder();
            sb.append('[');
            int length = Array.getLength(o);
            int i = 0;
            while (i < length) {
                if (i > 0) {
                    sb.append(", ");
                }
                sb.append(JWebBrowser.convertJavaObjectToJavascript(Array.get(o, i)));
                ++i;
            }
            sb.append(']');
            return sb.toString();
        }
        if ((o = o.toString()).equals(encodedArg = Utils.encodeURL((String)o))) {
            return String.valueOf('\'') + (String)o + '\'';
        }
        return "decodeURIComponent('" + encodedArg + "')";
    }

    private Object[] executeJavascriptWithCommandResult(final String command, String script) {
        final AtomicReference result = new AtomicReference();
        WebBrowserAdapter webBrowserListener = new WebBrowserAdapter(){

            public void commandReceived(WebBrowserCommandEvent e) {
                if (command.equals(e.getCommand())) {
                    result.set(e.getParameters());
                    JWebBrowser.this.removeWebBrowserListener(this);
                }
            }
        };
        this.addWebBrowserListener(webBrowserListener);
        if (this.executeJavascriptAndWait(script)) {
            int i = 0;
            while (i < 20) {
                EventDispatchUtils.sleepWithEventDispatch(new EventDispatchUtils.Condition(){

                    public boolean getValue() {
                        return result.get() != null;
                    }
                }, 50);
                ++i;
            }
        }
        this.removeWebBrowserListener(webBrowserListener);
        return (Object[])result.get();
    }

    public int getLoadingProgress() {
        return this.loadingProgress;
    }

    public void setBarsVisible(boolean areBarsVisible) {
        this.setMenuBarVisible(areBarsVisible);
        this.setButtonBarVisible(areBarsVisible);
        this.setLocationBarVisible(areBarsVisible);
        this.setStatusBarVisible(areBarsVisible);
    }

    private void adjustBorder() {
        FillLayout layout = (FillLayout)this.browserContainer.getLayout();
        if (this.isMenuBarVisible() || this.isButtonBarVisible() || this.isLocationBarVisible() || this.isStatusBarVisible()) {
            layout.marginWidth = 2;
            layout.marginHeight = 2;
        } else {
            layout.marginWidth = 0;
            layout.marginHeight = 0;
        }
        this.browserContainer.layout();
    }

    Menu getMenuBar() {
        return this.menuBar;
    }

    Menu getFileMenu() {
        return this.fileMenu;
    }

    private Image createIcon(String resourceKey) {
        String value = this.RESOURCES.getString(resourceKey);
        return value.length() == 0 ? null : new Image((Device)this.getDisplay(), new ImageData(JWebBrowser.class.getResourceAsStream(value)));
    }

    public JWebBrowserWindow getWebBrowserWindow() {
        Shell shell = this.getShell();
        if (shell instanceof JWebBrowserWindow) {
            return (JWebBrowserWindow)shell;
        }
        return null;
    }

    private void registerDefaultPopupMenu(final Browser browser) {
        Menu oldMenu = browser.getMenu();
        if (oldMenu != null) {
            oldMenu.dispose();
        }
        if ("ie".equals(browser.getBrowserType())) {
            browser.setMenu(null);
            return;
        }
        Menu menu = new Menu(browser.getShell(), 8);
        this.backMenuItem = new MenuItem(menu, 8);
        this.backMenuItem.setText(this.RESOURCES.getString("SystemMenuBack"));
        this.backMenuItem.setImage(new Image((Device)browser.getDisplay(), this.getClass().getResourceAsStream(this.RESOURCES.getString("SystemMenuBackIcon"))));
        this.backMenuItem.addSelectionListener(new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                JWebBrowser.this.navigateBack();
            }
        });
        this.forwardMenuItem = new MenuItem(menu, 8);
        this.forwardMenuItem.setText(this.RESOURCES.getString("SystemMenuForward"));
        this.forwardMenuItem.setImage(new Image((Device)browser.getDisplay(), this.getClass().getResourceAsStream(this.RESOURCES.getString("SystemMenuForwardIcon"))));
        this.forwardMenuItem.addSelectionListener(new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                JWebBrowser.this.navigateForward();
            }
        });
        this.reloadMenuItem = new MenuItem(menu, 8);
        this.reloadMenuItem.setText(this.RESOURCES.getString("SystemMenuReload"));
        this.reloadMenuItem.setImage(new Image((Device)browser.getDisplay(), this.getClass().getResourceAsStream(this.RESOURCES.getString("SystemMenuReloadIcon"))));
        this.reloadMenuItem.addSelectionListener(new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                JWebBrowser.this.reloadPage();
            }
        });
        this.stopMenuItem = new MenuItem(menu, 8);
        this.stopMenuItem.setText(this.RESOURCES.getString("SystemMenuStop"));
        this.stopMenuItem.setImage(new Image((Device)browser.getDisplay(), this.getClass().getResourceAsStream(this.RESOURCES.getString("SystemMenuStopIcon"))));
        this.stopMenuItem.addSelectionListener(new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                JWebBrowser.this.stopLoading();
            }
        });
        menu.addMenuListener(new MenuAdapter(){

            public void menuShown(MenuEvent e) {
                JWebBrowser.this.backMenuItem.setEnabled(browser.isBackEnabled());
                JWebBrowser.this.forwardMenuItem.setEnabled(browser.isForwardEnabled());
                JWebBrowser.this.stopMenuItem.setEnabled(JWebBrowser.this.isLoading);
            }
        });
        browser.setMenu(menu);
    }

    public void setDefaultPopupMenuRegistered(boolean isDefaultPopupMenuRegistered) {
        this.backMenuItem = null;
        this.forwardMenuItem = null;
        this.reloadMenuItem = null;
        this.stopMenuItem = null;
        if (isDefaultPopupMenuRegistered) {
            this.registerDefaultPopupMenu(this.browser);
        } else {
            Menu oldMenu = this.browser.getMenu();
            if (oldMenu != null) {
                oldMenu.dispose();
            }
            final Menu menu = new Menu(this.browser.getShell(), 8);
            menu.addMenuListener(new MenuAdapter(){

                public void menuShown(MenuEvent e) {
                    menu.setVisible(false);
                }
            });
            this.browser.setMenu(menu);
        }
    }

    public String getBrowserType() {
        return this.browser.getBrowserType();
    }

    public String getBrowserVersion() {
        return new JSBrowserDetection((Browser)this.browser).browserVersion;
    }

    public void addWebBrowserListener(WebBrowserListener listener) {
        this.listenerList.add(listener);
    }

    public void removeWebBrowserListener(WebBrowserListener listener) {
        this.listenerList.remove(listener);
    }

    public WebBrowserListener[] getWebBrowserListeners() {
        return this.listenerList.toArray(new WebBrowserListener[0]);
    }

    public Browser getNativeComponent() {
        return this.browser;
    }

    private class NSCommandBrowserFunction
    extends BrowserFunction {
        public NSCommandBrowserFunction(Browser browser) {
            super(browser, JWebBrowser.COMMAND_FUNCTION);
        }

        public Object function(Object[] args) {
            Object[] commandArgs;
            String command;
            String string = args.length >= 1 ? (args[0] instanceof String ? (String)args[0] : "") : (command = "");
            if (args.length > 1) {
                commandArgs = new Object[args.length - 1];
                System.arraycopy(args, 1, commandArgs, 0, commandArgs.length);
                args = commandArgs;
            } else {
                commandArgs = new Object[]{};
            }
            WebBrowserCommandEvent e = null;
            boolean isInternal = command.startsWith("[Chrriis]");
            int i = JWebBrowser.this.listenerList.size() - 1;
            while (i >= 0) {
                if (e == null) {
                    e = new WebBrowserCommandEvent(JWebBrowser.this, command, commandArgs);
                }
                WebBrowserListener webBrowserListener = JWebBrowser.this.listenerList.get(i);
                if (!isInternal || webBrowserListener.getClass().getName().startsWith("chrriis.")) {
                    webBrowserListener.commandReceived(e);
                }
                --i;
            }
            return null;
        }
    }
}

