/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.guess;

import com.limegroup.gnutella.ByteOrder;
import java.io.IOException;
import java.io.OutputStream;
import java.math.BigInteger;
import java.net.InetAddress;
import java.util.Arrays;
import java.util.Random;
import org.logi.crypto.Crypto;
import org.logi.crypto.keys.DESKey;

public final class QueryKey {
    private static SecretKey SECRET_KEY = null;
    private static SecretPad SECRET_PAD = null;
    public static final int MIN_QK_SIZE_IN_BYTES = 4;
    public static final int MAX_QK_SIZE_IN_BYTES = 16;
    private byte[] _queryKey;

    private QueryKey(byte[] key) throws IllegalArgumentException {
        if (!QueryKey.isValidQueryKeyBytes(key)) {
            throw new IllegalArgumentException();
        }
        this._queryKey = new byte[key.length];
        System.arraycopy(key, 0, this._queryKey, 0, key.length);
    }

    public void prepareForNetwork() {
        for (int i = 0; i < this._queryKey.length; ++i) {
            if (this._queryKey[i] != 28) continue;
            this._queryKey[i] = -6;
        }
    }

    public static SecretKey generateSecretKey() {
        return new SecretKey();
    }

    public static SecretPad generateSecretPad() {
        return new SecretPad();
    }

    public boolean equals(Object o) {
        if (!(o instanceof QueryKey)) {
            return false;
        }
        QueryKey other = (QueryKey)o;
        return Arrays.equals(this._queryKey, other._queryKey);
    }

    public int hashCode() {
        int retInt = 0;
        for (int i = 0; i < 4; ++i) {
            int index = this._queryKey[i] % this._queryKey.length;
            if (index < 0) {
                index *= -1;
            }
            retInt += this._queryKey[index] * 7;
        }
        return retInt;
    }

    public void write(OutputStream out) throws IOException {
        out.write(this._queryKey);
    }

    public String toString() {
        return "{Query Key: " + new BigInteger(this._queryKey) + "}";
    }

    public static boolean isValidQueryKeyBytes(byte[] key) {
        return key != null && key.length >= 4 && key.length <= 16;
    }

    public static QueryKey getQueryKey(byte[] networkQK, boolean prepareForNet) throws IllegalArgumentException {
        QueryKey retQK = new QueryKey(networkQK);
        if (prepareForNet) {
            retQK.prepareForNetwork();
        }
        return retQK;
    }

    public static QueryKey getQueryKey(InetAddress ip, int port) {
        return QueryKey.getQueryKey(ip, port, SECRET_KEY, SECRET_PAD);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static QueryKey getQueryKey(InetAddress ip, int port, SecretKey secretKey, SecretPad secretPad) {
        int i;
        int second;
        byte[] toEncrypt = new byte[8];
        byte[] ipBytes = ip.getAddress();
        short shortPort = (short)port;
        byte[] portBytes = new byte[2];
        ByteOrder.short2leb(shortPort, portBytes, 0);
        int first = secretPad._pad[0] % 8;
        if (first < 0) {
            first *= -1;
        }
        if ((second = secretPad._pad[1] % 8) < 0) {
            second *= -1;
        }
        if (second == first) {
            second = first == 0 ? 1 : first - 1;
        }
        toEncrypt[first] = secretPad._pad[0];
        toEncrypt[second] = secretPad._pad[1];
        int j = 0;
        for (i = 0; i < 4; ++i) {
            while (j == first || j == second) {
                ++j;
            }
            toEncrypt[j++] = ipBytes[i];
        }
        for (i = 0; i < 2; ++i) {
            while (j == first || j == second) {
                ++j;
            }
            toEncrypt[j++] = portBytes[i];
        }
        byte[] encrypted = new byte[8];
        SecretKey secretKey2 = secretKey;
        synchronized (secretKey2) {
            secretKey._DESKey.encrypt(toEncrypt, 0, encrypted, 0);
        }
        return QueryKey.getQueryKey(encrypted, true);
    }

    static {
        Crypto.initRandom();
        SECRET_KEY = new SecretKey();
        SECRET_PAD = new SecretPad();
    }

    public static class SecretPad {
        private byte[] _pad = new byte[2];

        private SecretPad() {
            new Random().nextBytes(this._pad);
        }
    }

    public static class SecretKey {
        private DESKey _DESKey = new DESKey();

        private SecretKey() {
        }
    }
}

