/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.gui;

import com.limegroup.gnutella.gui.GUIMediator;
import com.limegroup.gnutella.gui.Initializer;
import com.limegroup.gnutella.gui.PackagedMediaFileLauncher;
import com.limegroup.gnutella.util.CommonUtils;
import com.limegroup.gnutella.util.ManagedThread;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import net.roydesign.event.ApplicationEvent;
import net.roydesign.mac.MRJAdapter;

public class MacEventHandler {
    private static final MacEventHandler instance = new MacEventHandler();

    public static MacEventHandler instance() {
        return instance;
    }

    private MacEventHandler() {
        MRJAdapter.addAboutListener((ActionListener)new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                MacEventHandler.this.handleAbout();
            }
        });
        MRJAdapter.addQuitApplicationListener((ActionListener)new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                MacEventHandler.this.handleQuit();
            }
        });
        MRJAdapter.addOpenDocumentListener((ActionListener)new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                File file = ((ApplicationEvent)evt).getFile();
                MacEventHandler.this.handleOpenFile(file);
            }
        });
        MRJAdapter.addReopenApplicationListener((ActionListener)new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                MacEventHandler.this.handleReopen();
            }
        });
    }

    public void enablePreferences() {
        MRJAdapter.setPreferencesEnabled((boolean)true);
        MRJAdapter.addPreferencesListener((ActionListener)new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                MacEventHandler.this.handlePreferences();
            }
        });
    }

    private void handleAbout() {
        if (CommonUtils.isJaguarOrAbove() || CommonUtils.isJava14OrLater()) {
            GUIMediator.showAboutWindow();
        } else {
            new ManagedThread("Mac about menu thread"){

                public void managedRun() {
                    GUIMediator.showAboutWindow();
                }
            }.start();
        }
    }

    private void handleQuit() {
        if (CommonUtils.isJaguarOrAbove() || CommonUtils.isJava14OrLater()) {
            GUIMediator.applyWindowSettings();
            GUIMediator.close(false);
        } else {
            new ManagedThread("Mac quit thread"){

                public void managedRun() {
                    GUIMediator.applyWindowSettings();
                    GUIMediator.close(false);
                }
            }.start();
        }
    }

    private void handleOpenFile(File file) {
        String filename = file.toString();
        if (CommonUtils.isJava14OrLater() && filename.endsWith("limestart")) {
            Initializer.setStartup();
        } else if (CommonUtils.isJaguarOrAbove() || CommonUtils.isJava14OrLater()) {
            PackagedMediaFileLauncher.launchFile(filename, false);
        } else {
            new HandleOpenFile(file).start();
        }
    }

    private void handleReopen() {
        GUIMediator.handleReopen();
    }

    private void handlePreferences() {
        GUIMediator.instance().setOptionsVisible(true);
    }

    class HandleOpenFile
    extends ManagedThread {
        File requestedFile;

        public HandleOpenFile(File file) {
            super("handleOpenFile");
            this.requestedFile = file;
        }

        public void managedRun() {
            PackagedMediaFileLauncher.launchFile(this.requestedFile.toString(), false);
        }
    }
}

