/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.gui;

import com.limegroup.gnutella.gui.GUIMediator;
import com.limegroup.gnutella.gui.GUIUtils;
import com.limegroup.gnutella.gui.themes.LimeLookAndFeel;
import com.limegroup.gnutella.gui.themes.LimePlasticTheme;
import com.limegroup.gnutella.gui.themes.ThemeFileHandler;
import com.limegroup.gnutella.gui.themes.ThemeSettings;
import com.limegroup.gnutella.settings.ApplicationSettings;
import com.limegroup.gnutella.settings.SharingSettings;
import com.limegroup.gnutella.updates.UpdateManager;
import com.limegroup.gnutella.util.CommonUtils;
import com.limegroup.gnutella.util.Expand;
import java.awt.Color;
import java.awt.Font;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.LookAndFeel;
import javax.swing.UIDefaults;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.FontUIResource;

public final class ResourceManager {
    private static ResourceManager _instance;
    private static final String WINDOWS_LIBRARY_NAME = "LimeWire20";
    private static final String GUI_PATH = "com/limegroup/gnutella/gui/";
    private static final String RESOURCES_PATH = "com/limegroup/gnutella/gui/resources/";
    private static final String IMAGES_PATH = "com/limegroup/gnutella/gui/images/";
    private static boolean _localeOptionsSet;
    private static Locale _locale;
    private static ResourceBundle _resourceBundle;
    private static boolean _useBold;
    private static boolean _useLeftToRight;
    private static boolean _installerShared;
    private static boolean _fontReduced;
    private final boolean BRUSHED_METAL;
    private final boolean LOADED_WINDOWS_LIBRARY;
    private static final HashMap THEME_IMAGES;
    static /* synthetic */ Class class$com$limegroup$gnutella$gui$ResourceManager;

    static void resetLocaleOptions() {
        _localeOptionsSet = false;
        ResourceManager.setLocaleOptions();
    }

    static void setLocaleOptions() {
        if (!_localeOptionsSet) {
            if (ApplicationSettings.LANGUAGE.getValue().equals("")) {
                ApplicationSettings.LANGUAGE.setValue("en");
            }
            _locale = new Locale(ApplicationSettings.LANGUAGE.getValue(), ApplicationSettings.COUNTRY.getValue(), ApplicationSettings.LOCALE_VARIANT.getValue());
            _resourceBundle = ResourceBundle.getBundle("MessagesBundle", _locale);
            _useBold = Boolean.valueOf(ResourceManager.getStringResource("DISABLE_BOLD_CHARACTERS")) == false;
            _useLeftToRight = Boolean.valueOf(ResourceManager.getStringResource("LAYOUT_RIGHT_TO_LEFT")) == false;
            _localeOptionsSet = true;
        }
    }

    static Locale getLocale() {
        return _locale;
    }

    static boolean hasLocalizedTipsOfTheDay() {
        return Boolean.valueOf(ResourceManager.getStringResource("HAS_TIPS_OF_THE_DAY"));
    }

    static ResourceBundle getTOTDResourceBundle() {
        return ResourceBundle.getBundle("totd/TOTD", _locale);
    }

    static ResourceBundle getXMLResourceBundle(String name) {
        return ResourceBundle.getBundle("xml.display." + name, _locale);
    }

    static final boolean useBold() {
        ResourceManager.setLocaleOptions();
        return _useBold;
    }

    static final boolean isLeftToRight() {
        ResourceManager.setLocaleOptions();
        return _useLeftToRight;
    }

    static final String getStringResource(String resourceKey) {
        return _resourceBundle.getString(resourceKey);
    }

    static final ImageIcon getThemeImage(String name) {
        if (name == null) {
            throw new NullPointerException("null image name");
        }
        ImageIcon icon = null;
        icon = (ImageIcon)THEME_IMAGES.get(name);
        if (icon != null) {
            return icon;
        }
        File themeDir = ThemeSettings.THEME_DIR.getValue();
        icon = ResourceManager.getImageFromURL(new File(themeDir, name).getPath(), true);
        if (icon.getImage() != null) {
            THEME_IMAGES.put(name, icon);
            return icon;
        }
        icon = ResourceManager.getImageFromURL(IMAGES_PATH + name, false);
        if (icon.getImage() != null) {
            THEME_IMAGES.put(name, icon);
            return icon;
        }
        throw new MissingResourceException("image: " + name + " doesn't exist.", null, null);
    }

    static final ImageIcon getImageFromPath(String loc) {
        return ResourceManager.getImageFromURL(loc, true);
    }

    private static final ImageIcon getImageFromURL(String location, boolean file) {
        URL img = ResourceManager.toURL(location, file);
        if (img != null) {
            return new ImageIcon(img);
        }
        img = ResourceManager.toURL(location + ".png", file);
        if (img != null) {
            return new ImageIcon(img);
        }
        img = ResourceManager.toURL(location + ".gif", file);
        if (img != null) {
            return new ImageIcon(img);
        }
        return new ImageIcon();
    }

    private static final URL toURL(String location, boolean file) {
        if (file) {
            File f = new File(location);
            if (f.exists()) {
                try {
                    return f.toURL();
                }
                catch (MalformedURLException murl) {
                    return null;
                }
            }
            return null;
        }
        return ResourceManager.getURL(location);
    }

    static URL getURLResource(String FILE_NAME) {
        return ResourceManager.getURL(RESOURCES_PATH + FILE_NAME);
    }

    private static URL getURL(String PATH) {
        ClassLoader cl = (class$com$limegroup$gnutella$gui$ResourceManager == null ? (class$com$limegroup$gnutella$gui$ResourceManager = ResourceManager.class$("com.limegroup.gnutella.gui.ResourceManager")) : class$com$limegroup$gnutella$gui$ResourceManager).getClassLoader();
        if (cl == null) {
            return ClassLoader.getSystemResource(PATH);
        }
        URL url = cl.getResource(PATH);
        if (url == null) {
            return ClassLoader.getSystemResource(PATH);
        }
        return url;
    }

    public static final ResourceManager instance() {
        if (_instance == null) {
            _instance = new ResourceManager();
        }
        return _instance;
    }

    private ResourceManager() {
        String bMetal;
        GUIMediator.setSplashScreenString(GUIMediator.getStringResource("SPLASH_STATUS_RESOURCE_MANAGER"));
        if (!ThemeFileHandler.isCurrent()) {
            ThemeSettings.THEME_FILE.revertToDefault();
            ThemeSettings.THEME_DIR.revertToDefault();
            ThemeFileHandler.reload();
        }
        this.BRUSHED_METAL = (bMetal = System.getProperty("apple.awt.brushMetalLook")) != null && bMetal.equalsIgnoreCase("true");
        this.themeChanged();
        try {
            this.validateLocaleAndFonts();
        }
        catch (NullPointerException npe) {
            // empty catch block
        }
        if (CommonUtils.isWindows()) {
            boolean loaded = false;
            try {
                System.loadLibrary(WINDOWS_LIBRARY_NAME);
                loaded = true;
            }
            catch (UnsatisfiedLinkError unsatisfiedLinkError) {
                // empty catch block
            }
            this.LOADED_WINDOWS_LIBRARY = loaded;
        } else {
            this.LOADED_WINDOWS_LIBRARY = false;
        }
        try {
            ResourceManager.unpackWarFiles();
        }
        catch (IOException e) {
            GUIMediator.showInternalError(e);
        }
        this.unpackVersionFile();
        this.shareInstaller();
    }

    public void validateLocaleAndFonts() {
        if (CommonUtils.isMacOSX()) {
            return;
        }
        String s = ResourceManager.getStringResource("LOCALE_LANGUAGE_NAME");
        if (!this.checkUIFonts("dialog", s)) {
            ApplicationSettings.LANGUAGE.setValue("en");
            ApplicationSettings.COUNTRY.setValue("");
            ApplicationSettings.LOCALE_VARIANT.setValue("");
            ResourceManager.resetLocaleOptions();
        }
        String i18n = "\u4e2d\u56fd";
        this.checkFont("TextField.font", "dialog", i18n, true);
        this.checkFont("Table.font", "dialog", i18n, true);
        this.checkFont("ProgressBar.font", "dialog", i18n, true);
        this.checkFont("TabbedPane.font", "dialog", i18n, true);
    }

    private boolean checkUIFonts(String newFont, String testString) {
        String[] comps = new String[]{"TextField.font", "PasswordField.font", "TextArea.font", "TextPane.font", "EditorPane.font", "FormattedTextField.font", "Button.font", "CheckBox.font", "RadioButton.font", "ToggleButton.font", "ProgressBar.font", "ComboBox.font", "InternalFrame.titleFont", "DesktopIcon.font", "TitledBorder.font", "Label.font", "List.font", "TabbedPane.font", "Table.font", "TableHeader.font", "MenuBar.font", "Menu.font", "Menu.acceleratorFont", "MenuItem.font", "MenuItem.acceleratorFont", "PopupMenu.font", "CheckBoxMenuItem.font", "CheckBoxMenuItem.acceleratorFont", "RadioButtonMenuItem.font", "RadioButtonMenuItem.acceleratorFont", "Spinner.font", "Tree.font", "ToolBar.font", "OptionPane.messageFont", "OptionPane.buttonFont", "ToolTip.font"};
        boolean displayable = false;
        for (int i = 0; i < comps.length; ++i) {
            displayable |= this.checkFont(comps[i], newFont, testString, false);
        }
        Iterator i = UIManager.getDefaults().entrySet().iterator();
        while (i.hasNext()) {
            Font f;
            Map.Entry next = i.next();
            if (!(next.getValue() instanceof Font) || (f = (Font)next.getValue()) == null || newFont.equalsIgnoreCase(f.getName()) || GUIUtils.canDisplay(f, testString) || !GUIUtils.canDisplay(f = new Font(newFont, f.getStyle(), f.getSize()), testString)) continue;
            next.setValue(f);
            displayable = true;
        }
        return displayable;
    }

    private boolean checkFont(String fontName, String newName, String testString, boolean force) {
        boolean displayable = true;
        Font f = UIManager.getFont(fontName);
        if (f != null && !newName.equalsIgnoreCase(f.getName())) {
            if (!GUIUtils.canDisplay(f, testString) || force) {
                if (GUIUtils.canDisplay(f = new Font(newName, f.getStyle(), f.getSize()), testString)) {
                    UIManager.put(fontName, f);
                } else {
                    displayable = false;
                }
            }
        } else {
            displayable = f != null ? GUIUtils.canDisplay(f, testString) : false;
        }
        return displayable;
    }

    public boolean isTrayLibraryLoaded() {
        return this.LOADED_WINDOWS_LIBRARY;
    }

    private void shareInstaller() {
        if (CommonUtils.isPro()) {
            return;
        }
        if (_installerShared) {
            return;
        }
        String installerName = "";
        if (CommonUtils.isWindows()) {
            installerName = "LimeWireWin.exe";
        } else if (CommonUtils.isMacOSX()) {
            installerName = "LimeWireOSX.zip";
        } else if (CommonUtils.isLinux()) {
            installerName = "LimeWireLinux.bin";
        } else if (CommonUtils.isSolaris()) {
            installerName = "LimeWireSolaris.bin";
        } else {
            _installerShared = true;
            return;
        }
        File javaHome = new File(System.getProperty("java.home"));
        File installer = new File(javaHome, installerName);
        if (!installer.isFile()) {
            return;
        }
        File[] sharedDirs = SharingSettings.DIRECTORIES_TO_SHARE.getValue();
        if (sharedDirs.length == 0) {
            return;
        }
        File sharedDir = sharedDirs[0];
        File newFile = new File(sharedDir, installerName);
        if (newFile.isFile() && installer.lastModified() <= newFile.lastModified()) {
            _installerShared = true;
            return;
        }
        installer.renameTo(new File(sharedDir, installerName));
        _installerShared = true;
    }

    public boolean isBrushedMetalSet() {
        return this.BRUSHED_METAL;
    }

    public void themeChanged() {
        THEME_IMAGES.clear();
        try {
            if (ThemeSettings.isNativeTheme()) {
                if (CommonUtils.isWindows() && this.isPlasticWindowsAvailable()) {
                    UIManager.setLookAndFeel("com.jgoodies.plaf.windows.ExtWindowsLookAndFeel");
                } else {
                    String lafName = UIManager.getSystemLookAndFeelClassName();
                    UIManager.setLookAndFeel(lafName);
                }
                if (CommonUtils.isMacOSX()) {
                    if (!_fontReduced) {
                        _fontReduced = true;
                        ResourceManager.reduceFont("Label.font");
                        ResourceManager.reduceFont("Table.font");
                    }
                    if (CommonUtils.isJava14OrLater() && !CommonUtils.isJava15OrLater()) {
                        UIManager.put("List.focusCellHighlightBorder", BorderFactory.createEmptyBorder(1, 1, 1, 1));
                        UIManager.put("ScrollPane.border", BorderFactory.createMatteBorder(1, 1, 1, 1, Color.lightGray));
                    }
                }
            } else if (this.isPlasticAvailable()) {
                LimePlasticTheme.installThisTheme();
                UIManager.setLookAndFeel("com.jgoodies.plaf.plastic.PlasticXPLookAndFeel");
                LimeLookAndFeel.installUIManagerDefaults();
            } else {
                UIManager.setLookAndFeel(new LimeLookAndFeel());
            }
            UIManager.put("Tree.leafIcon", UIManager.getIcon("Tree.closedIcon"));
            UIManager.put("SplitPane.border", BorderFactory.createEmptyBorder());
            if (!CommonUtils.isMacOSX()) {
                UIManager.put("Table.focusRowHighlightBorder", UIManager.get("Table.focusCellHighlightBorder"));
            }
            UIManager.put("Table.focusCellHighlightBorder", BorderFactory.createEmptyBorder(1, 1, 1, 1));
            Font normal = UIManager.getFont("Table.font");
            FontUIResource bold = new FontUIResource(normal.getName(), 1, normal.getSize());
            UIManager.put("Table.font.bold", bold);
        }
        catch (UnsupportedLookAndFeelException e) {
            GUIMediator.showInternalError(e);
        }
        catch (ClassNotFoundException e) {
            GUIMediator.showInternalError(e);
        }
        catch (InstantiationException e) {
            GUIMediator.showInternalError(e);
        }
        catch (IllegalAccessException e) {
            GUIMediator.showInternalError(e);
        }
    }

    private boolean isPlasticAvailable() {
        if (!CommonUtils.isJava14OrLater()) {
            return false;
        }
        try {
            Class<?> plastic = Class.forName("com.jgoodies.plaf.plastic.PlasticXPLookAndFeel");
            return plastic != null;
        }
        catch (ClassNotFoundException cnfe) {
            return false;
        }
    }

    private boolean isPlasticWindowsAvailable() {
        if (!CommonUtils.isJava14OrLater()) {
            return false;
        }
        try {
            Class<?> plastic = Class.forName("com.jgoodies.plaf.windows.ExtWindowsLookAndFeel");
            return plastic != null;
        }
        catch (ClassNotFoundException cnfe) {
            return false;
        }
    }

    static ComponentUI getNativeUI(JComponent c) {
        ComponentUI ret = null;
        String name = UIManager.getSystemLookAndFeelClassName();
        if (name != null) {
            try {
                Class<?> clazz = Class.forName(name);
                LookAndFeel lf = (LookAndFeel)clazz.newInstance();
                lf.initialize();
                UIDefaults def = lf.getDefaults();
                ret = def.getUI(c);
            }
            catch (ExceptionInInitializerError e) {
            }
            catch (ClassNotFoundException e) {
            }
            catch (LinkageError e) {
            }
            catch (IllegalAccessException e) {
            }
            catch (InstantiationException e) {
            }
            catch (SecurityException e) {
            }
            catch (ClassCastException classCastException) {
                // empty catch block
            }
        }
        if (ret == null) {
            ret = UIManager.getUI(c);
        }
        return ret;
    }

    private static void reduceFont(String name) {
        Font oldFont = UIManager.getFont(name);
        FontUIResource newFont = new FontUIResource(oldFont.getName(), oldFont.getStyle(), oldFont.getSize() - 2);
        UIManager.put(name, newFont);
    }

    private static void unpackWarFiles() throws IOException {
        File currDir = CommonUtils.getCurrentDirectory();
        String[] warFiles = currDir.list(new FilenameFilter(){

            public boolean accept(File dir, String name) {
                return name.endsWith(".war");
            }
        });
        if (warFiles == null) {
            return;
        }
        File destDir = CommonUtils.getUserSettingsDir();
        if (!destDir.isDirectory()) {
            throw new IOException("settings dir not a directory: " + destDir);
        }
        if (!destDir.canWrite()) {
            throw new IOException("cannot write to the settings dir: " + destDir);
        }
        for (int i = 0; i < warFiles.length; ++i) {
            if (warFiles[i].equals("xml.war")) {
                Expand.expandFile(new File(warFiles[i]), destDir, false, new String[]{"xml/schemas/"});
                continue;
            }
            Expand.expandFile(new File(warFiles[i]), destDir);
        }
    }

    private void unpackVersionFile() {
        String latestVersion;
        File userHome = CommonUtils.getUserSettingsDir();
        File updateFile = new File(userHome, "update.xml");
        File verFile = new File("update.ver");
        if (!updateFile.exists()) {
            try {
                Expand.expandFile(verFile, userHome);
            }
            catch (IOException iox) {
                return;
            }
        }
        String myVersion = CommonUtils.getLimeWireVersion();
        if (UpdateManager.isGreaterVersion(myVersion, latestVersion = ResourceManager.parseVersion(updateFile)) || latestVersion.equals("@version@") && !myVersion.equals("@version@")) {
            try {
                Expand.expandFile(verFile, userHome);
            }
            catch (IOException iox) {
                return;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private static String parseVersion(File file) {
        String string;
        RandomAccessFile raf;
        block12: {
            String tempVersion;
            int b;
            int a;
            String tempString;
            block10: {
                String string2;
                block11: {
                    raf = null;
                    raf = new RandomAccessFile(file, "r");
                    byte[] bytes = new byte[(int)raf.length()];
                    raf.read(bytes);
                    raf.close();
                    tempString = new String(bytes, "UTF8");
                    a = tempString.indexOf("<version>");
                    b = tempString.indexOf("</version>");
                    if (a >= 0 && b >= 0 && b > a) break block10;
                    file.delete();
                    string2 = null;
                    Object var9_9 = null;
                    if (raf == null) break block11;
                    try {
                        raf.close();
                    }
                    catch (IOException ignored) {
                        // empty catch block
                    }
                }
                return string2;
            }
            string = tempVersion = tempString.substring(a + 9, b);
            Object var9_10 = null;
            if (raf == null) break block12;
            try {
                raf.close();
            }
            catch (IOException ignored) {
                // empty catch block
            }
        }
        return string;
        catch (IOException e) {
            String string3;
            block13: {
                try {
                    string3 = null;
                    Object var9_11 = null;
                    if (raf == null) break block13;
                }
                catch (Throwable throwable) {
                    block14: {
                        Object var9_12 = null;
                        if (raf == null) break block14;
                        try {
                            raf.close();
                        }
                        catch (IOException ignored) {}
                    }
                    throw throwable;
                }
                try {
                    raf.close();
                }
                catch (IOException ignored) {
                    // empty catch block
                }
            }
            return string3;
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        _installerShared = false;
        _fontReduced = false;
        THEME_IMAGES = new HashMap();
        ResourceManager.resetLocaleOptions();
    }
}

