/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.gui.init;

import com.limegroup.gnutella.gui.BoxPanel;
import com.limegroup.gnutella.gui.ButtonRow;
import com.limegroup.gnutella.gui.FileChooserHandler;
import com.limegroup.gnutella.gui.GUIMediator;
import com.limegroup.gnutella.gui.LabeledTextField;
import com.limegroup.gnutella.gui.init.ApplySettingsException;
import com.limegroup.gnutella.gui.init.SetupManager;
import com.limegroup.gnutella.gui.init.SetupWindow;
import com.limegroup.gnutella.settings.SharingSettings;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;

class SaveWindow
extends SetupWindow {
    private final LabeledTextField SAVE_FIELD = new LabeledTextField(GUIMediator.getStringResource("INIT_SAVE_DIRECTORY_FIELD_LABEL"), 20);
    private String _defaultSaveDir;

    SaveWindow(SetupManager manager) {
        super(manager, "SETUP_SAVE_TITLE", "SETUP_SAVE_LABEL");
    }

    protected void createWindow() {
        super.createWindow();
        File saveDir = SharingSettings.getSaveDirectory();
        try {
            this._defaultSaveDir = saveDir.getCanonicalPath();
        }
        catch (IOException e) {
            this._defaultSaveDir = saveDir.getAbsolutePath();
        }
        BoxPanel mainPanel = new BoxPanel(1);
        String[] labels = new String[]{"INIT_SAVE_BROWSE_BUTTON_LABEL", "INIT_SAVE_DEFAULT_BUTTON_LABEL"};
        String[] toolTips = new String[]{"INIT_SAVE_BROWSE_BUTTON_TIP", "INIT_SAVE_DEFAULT_BUTTON_TIP"};
        ActionListener[] listeners = new ActionListener[]{new SaveListener(), new DefaultListener()};
        ButtonRow buttons = new ButtonRow(labels, toolTips, listeners, 0, 12);
        try {
            this.SAVE_FIELD.setText(this._defaultSaveDir);
        }
        catch (NullPointerException npe) {
            // empty catch block
        }
        mainPanel.add(this.SAVE_FIELD);
        mainPanel.add(buttons);
        super.addSetupComponent(mainPanel);
    }

    public void applySettings() throws ApplySettingsException {
        try {
            String saveDirString = this.SAVE_FIELD.getText();
            File saveDir = new File(saveDirString);
            if (!saveDir.isDirectory() && !saveDir.mkdirs()) {
                throw new IOException();
            }
            File[] sharedDirs = new File[]{saveDir};
            SharingSettings.setSaveDirectory(saveDir);
            SharingSettings.DIRECTORIES_TO_SHARE.setValue(sharedDirs);
        }
        catch (IOException ioe) {
            String msgKey = "MESSAGE_INVALID_SAVE_DIRECTORY";
            throw new ApplySettingsException(msgKey);
        }
    }

    private class SaveListener
    implements ActionListener {
        private SaveListener() {
        }

        public void actionPerformed(ActionEvent e) {
            File saveDir = FileChooserHandler.getInputDirectory(SaveWindow.this);
            if (saveDir == null || !saveDir.isDirectory()) {
                return;
            }
            SaveWindow.this.SAVE_FIELD.setText(saveDir.getAbsolutePath());
        }
    }

    private class DefaultListener
    implements ActionListener {
        private DefaultListener() {
        }

        public void actionPerformed(ActionEvent e) {
            SaveWindow.this.SAVE_FIELD.setText(SaveWindow.this._defaultSaveDir);
        }
    }
}

