/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.gui.options.panes;

import com.limegroup.gnutella.downloader.HTTPDownloader;
import com.limegroup.gnutella.gui.LabeledComponent;
import com.limegroup.gnutella.gui.options.panes.AbstractPaneItem;
import com.limegroup.gnutella.settings.ConnectionSettings;
import com.limegroup.gnutella.settings.DownloadSettings;
import java.awt.Font;
import java.io.IOException;
import java.text.NumberFormat;
import java.util.Hashtable;
import javax.swing.JLabel;
import javax.swing.JSlider;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public final class DownloadBandwidthPaneItem
extends AbstractPaneItem {
    private final String LABEL_LABEL = "OPTIONS_DOWNLOAD_BANDWIDTH_SLIDER_LABEL_LABEL";
    private final String SLIDER_MAX_LABEL = "OPTIONS_DOWNLOAD_BANDWIDTH_SLIDER_MAX_LABEL";
    private final JSlider DOWNLOAD_SLIDER = new JSlider(5, 100);
    private final JLabel SLIDER_LABEL = new JLabel();
    private int _downloadThrottle;

    public DownloadBandwidthPaneItem(String key) {
        super(key);
        this.DOWNLOAD_SLIDER.setMajorTickSpacing(10);
        this.DOWNLOAD_SLIDER.setPaintTicks(true);
        Hashtable<Integer, JLabel> labelTable = new Hashtable<Integer, JLabel>();
        JLabel label2 = new JLabel("1%");
        JLabel label3 = new JLabel("100%");
        Font font = new Font("Helvetica", 1, 10);
        label2.setFont(font);
        label3.setFont(font);
        labelTable.put(new Integer(1), label2);
        labelTable.put(new Integer(100), label3);
        this.DOWNLOAD_SLIDER.setLabelTable(labelTable);
        this.DOWNLOAD_SLIDER.setPaintLabels(true);
        this.DOWNLOAD_SLIDER.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent e) {
                DownloadBandwidthPaneItem.this.handleThrottleLabel();
            }
        });
        LabeledComponent comp = new LabeledComponent("OPTIONS_DOWNLOAD_BANDWIDTH_SLIDER_LABEL_LABEL", this.SLIDER_LABEL, 120);
        this.add(this.DOWNLOAD_SLIDER);
        this.add(this.getVerticalSeparator());
        this.add(comp.getComponent());
    }

    private void handleThrottleLabel() {
        float value = this.DOWNLOAD_SLIDER.getValue();
        String labelText = "";
        if (value == 100.0f) {
            labelText = MEDIATOR.getString("OPTIONS_DOWNLOAD_BANDWIDTH_SLIDER_MAX_LABEL");
        } else {
            Float f = new Float((double)this.DOWNLOAD_SLIDER.getValue() / 100.0 * (double)ConnectionSettings.CONNECTION_SPEED.getValue() / 8.0);
            NumberFormat formatter = NumberFormat.getInstance();
            formatter.setMaximumFractionDigits(2);
            labelText = String.valueOf(formatter.format(f)) + " KB/s";
        }
        this.SLIDER_LABEL.setText(labelText);
    }

    public void initOptions() {
        this._downloadThrottle = DownloadSettings.DOWNLOAD_SPEED.getValue();
        this.DOWNLOAD_SLIDER.setValue(this._downloadThrottle);
        this.handleThrottleLabel();
    }

    public boolean applyOptions() throws IOException {
        int downloadThrottle = this.DOWNLOAD_SLIDER.getValue();
        if (downloadThrottle != this._downloadThrottle) {
            DownloadSettings.DOWNLOAD_SPEED.setValue(downloadThrottle);
            this._downloadThrottle = downloadThrottle;
            HTTPDownloader.applyRate();
        }
        return false;
    }

    public boolean isDirty() {
        return DownloadSettings.DOWNLOAD_SPEED.getValue() != this.DOWNLOAD_SLIDER.getValue();
    }
}

