/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.udpconnect;

import com.limegroup.gnutella.udpconnect.Chunk;
import com.limegroup.gnutella.udpconnect.UDPConnectionProcessor;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class UDPBufferedOutputStream
extends OutputStream {
    private static final Log LOG = LogFactory.getLog(class$com$limegroup$gnutella$udpconnect$UDPBufferedOutputStream == null ? (class$com$limegroup$gnutella$udpconnect$UDPBufferedOutputStream = UDPBufferedOutputStream.class$("com.limegroup.gnutella.udpconnect.UDPBufferedOutputStream")) : class$com$limegroup$gnutella$udpconnect$UDPBufferedOutputStream);
    private static final int FOREVER = 36000000;
    private ArrayList chunks;
    private byte[] activeChunk;
    private int activeCount;
    private UDPConnectionProcessor _processor;
    private boolean _connectionActive;
    static /* synthetic */ Class class$com$limegroup$gnutella$udpconnect$UDPBufferedOutputStream;

    public UDPBufferedOutputStream(UDPConnectionProcessor p) {
        this._processor = p;
        this._connectionActive = true;
        this.chunks = new ArrayList(5);
        this.allocateNewChunk();
    }

    public synchronized void write(int b) throws IOException {
        if (this._connectionActive && this.getPendingChunks() == 0) {
            this._processor.wakeupWriteEvent();
        }
        while (true) {
            if (!this._connectionActive) {
                throw new IOException("Connection Closed");
            }
            if (this.activeCount < 512) {
                this.activeChunk[this.activeCount] = (byte)b;
                ++this.activeCount;
                return;
            }
            if (this.chunks.size() < this._processor.getChunkLimit()) {
                this.chunks.add(this.activeChunk);
                this.allocateNewChunk();
                continue;
            }
            this.waitOnReader();
            if (this.getPendingChunks() != 0) continue;
            this._processor.wakeupWriteEvent();
        }
    }

    public synchronized void write(byte[] b, int off, int len) throws IOException {
        if (LOG.isDebugEnabled()) {
            LOG.debug("writing len: " + len + " bytes");
        }
        if (this._connectionActive && this.getPendingChunks() == 0) {
            this._processor.wakeupWriteEvent();
        }
        while (true) {
            if (!this._connectionActive) {
                throw new IOException("Connection Closed");
            }
            if (this.activeCount < this.activeChunk.length) {
                int space = this.activeChunk.length - this.activeCount;
                int wlength = Math.min(space, len);
                System.arraycopy(b, off, this.activeChunk, this.activeCount, wlength);
                this.activeCount += wlength;
                if ((space -= wlength) > 0) {
                    return;
                }
                off += wlength;
                if ((len -= wlength) > 0) continue;
                return;
            }
            if (this.chunks.size() < this._processor.getChunkLimit()) {
                this.chunks.add(this.activeChunk);
                this.allocateNewChunk();
                continue;
            }
            this.waitOnReader();
            if (this.getPendingChunks() != 0) continue;
            this._processor.wakeupWriteEvent();
        }
    }

    public synchronized void close() throws IOException {
        if (!this._connectionActive) {
            throw new IOException("already closed");
        }
        this._processor.close();
    }

    public void flush() throws IOException {
    }

    private void allocateNewChunk() {
        this.activeChunk = new byte[512];
        this.activeCount = 0;
    }

    /*
     * WARNING - void declaration
     */
    synchronized Chunk getChunk() {
        void var1_1;
        Chunk rChunk;
        if (this.chunks.size() > 0) {
            rChunk = new Chunk();
            rChunk.data = (byte[])this.chunks.remove(0);
            rChunk.start = 0;
            rChunk.length = rChunk.data.length;
        } else if (this.activeCount > 0) {
            rChunk = new Chunk();
            rChunk.data = this.activeChunk;
            rChunk.start = 0;
            rChunk.length = this.activeCount;
            this.allocateNewChunk();
        } else {
            return null;
        }
        this.notify();
        return var1_1;
    }

    private void waitOnReader() throws IOException {
        try {
            this.wait(36000000L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        if (!this._connectionActive) {
            throw new IOException("Connection Closed");
        }
    }

    synchronized void connectionClosed() {
        LOG.debug("connection closed");
        this._connectionActive = false;
        this.notify();
    }

    synchronized int getPendingChunks() {
        int count = this.chunks.size();
        if (this.activeCount > 0) {
            ++count;
        }
        return count;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

