/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.xml;

import com.limegroup.gnutella.licenses.License;
import com.limegroup.gnutella.licenses.LicenseFactory;
import com.limegroup.gnutella.util.NameValue;
import com.limegroup.gnutella.xml.LimeXMLDocumentHelper;
import com.limegroup.gnutella.xml.LimeXMLSchema;
import com.limegroup.gnutella.xml.LimeXMLSchemaRepository;
import com.limegroup.gnutella.xml.LimeXMLUtils;
import com.limegroup.gnutella.xml.SchemaNotFoundException;
import com.limegroup.gnutella.xml.XMLParsingUtils;
import com.limegroup.gnutella.xml.XMLStringUtils;
import java.io.File;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class LimeXMLDocument
implements Serializable {
    private static final Log LOG = LogFactory.getLog(class$com$limegroup$gnutella$xml$LimeXMLDocument == null ? (class$com$limegroup$gnutella$xml$LimeXMLDocument = LimeXMLDocument.class$("com.limegroup.gnutella.xml.LimeXMLDocument")) : class$com$limegroup$gnutella$xml$LimeXMLDocument);
    public static final String XML_ID_ATTRIBUTE = "identifier__";
    public static final String XML_ACTION_ATTRIBUTE = "action__";
    public static final String XML_INDEX_ATTRIBUTE = "index__";
    public static final String XML_LICENSE_ATTRIBUTE = "license__";
    public static final String XML_LICENSE_TYPE_ATTRIBUTE = "licensetype__";
    private static final int CURRENT_VERSION = 1;
    private volatile transient int hashCode = 0;
    private static final long serialVersionUID = 7396170507085078485L;
    private Map fieldToValue = new HashMap();
    private String schemaUri;
    private transient String attributeString;
    private transient File fileId;
    private transient String action;
    private int version = 1;
    private transient List CACHED_KEYWORDS = null;
    private static final List INDIVISIBLE_LIST;
    private transient boolean hasCCLicense = false;
    static /* synthetic */ Class class$com$limegroup$gnutella$xml$LimeXMLDocument;

    boolean isCurrent() {
        return this.version == 1;
    }

    void setCurrent() {
        this.version = 1;
    }

    public LimeXMLDocument(String xml) throws SAXException, SchemaNotFoundException, IOException {
        if (xml == null || xml.equals("")) {
            throw new SAXException("null or empty string");
        }
        InputSource doc = new InputSource(new StringReader(xml));
        XMLParsingUtils.ParseResult result = XMLParsingUtils.parse(doc);
        if (result.isEmpty()) {
            throw new IOException("No element present");
        }
        if (result.schemaURI == null) {
            throw new SchemaNotFoundException("no schema");
        }
        this.fieldToValue = (Map)result.get(0);
        this.schemaUri = result.schemaURI;
        this.setFields(result.canonicalKeyPrefix);
        if (!this.isValid()) {
            throw new IOException("Invalid XML: " + xml);
        }
    }

    LimeXMLDocument(Map map, String schemaURI, String keyPrefix) throws IOException {
        if (map.isEmpty()) {
            throw new IllegalArgumentException("empty map");
        }
        this.schemaUri = schemaURI;
        this.fieldToValue = map;
        this.fieldToValue.remove(keyPrefix + XML_ID_ATTRIBUTE);
        this.setFields(keyPrefix);
        if (!this.isValid()) {
            throw new IOException("invalid doc! " + map + " \nschema uri: " + schemaURI);
        }
    }

    public LimeXMLDocument(Collection nameValueList, String schemaURI) {
        if (nameValueList.isEmpty()) {
            throw new IllegalArgumentException("empty list");
        }
        this.schemaUri = schemaURI;
        Iterator i = nameValueList.iterator();
        while (i.hasNext()) {
            Map.Entry next = (Map.Entry)i.next();
            String name = (String)next.getKey();
            Object value = next.getValue();
            this.fieldToValue.put(name.trim(), value);
        }
        this.scanFields();
        if (!this.isValid()) {
            throw new IllegalArgumentException("Invalid Doc!");
        }
    }

    boolean isValid() {
        if (this.schemaUri == null || this.getSchema() == null) {
            return false;
        }
        return this.getAttributeString().length() != 0;
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        this.scanFields();
    }

    public int getNumFields() {
        return this.fieldToValue.size();
    }

    public List getKeyWords() {
        if (this.CACHED_KEYWORDS != null) {
            return this.CACHED_KEYWORDS;
        }
        ArrayList<String> retList = new ArrayList<String>();
        Iterator iter = this.fieldToValue.keySet().iterator();
        while (iter.hasNext()) {
            String currKey = (String)iter.next();
            String val = (String)this.fieldToValue.get(currKey);
            if (val == null || val.equals("") || this.isIndivisible(currKey, val)) continue;
            try {
                Double.parseDouble(val);
            }
            catch (NumberFormatException ignored) {
                retList.add(val);
            }
        }
        this.CACHED_KEYWORDS = retList;
        return retList;
    }

    public List getKeyWordsIndivisible() {
        if (this.hasCCLicense) {
            return INDIVISIBLE_LIST;
        }
        return Collections.EMPTY_LIST;
    }

    public boolean isIndivisible(String currKey, String val) {
        return currKey.endsWith(XML_LICENSE_TYPE_ATTRIBUTE);
    }

    public String getSchemaURI() {
        return this.schemaUri;
    }

    public LimeXMLSchema getSchema() {
        return LimeXMLSchemaRepository.instance().getSchema(this.schemaUri);
    }

    public String getSchemaDescription() {
        LimeXMLSchema schema = this.getSchema();
        if (schema != null) {
            return schema.getDescription();
        }
        return LimeXMLSchema.getDisplayString(this.schemaUri);
    }

    public File getIdentifier() {
        return this.fileId;
    }

    public void setIdentifier(File id) {
        this.fileId = id;
    }

    public String getAction() {
        if (this.action == null) {
            return "";
        }
        return this.action;
    }

    public Set getNameValueSet() {
        return this.fieldToValue.entrySet();
    }

    public Set getNameSet() {
        return this.fieldToValue.keySet();
    }

    public Collection getValueList() {
        return this.fieldToValue.values();
    }

    public boolean isLicenseAvailable() {
        return this.hasCCLicense;
    }

    public String getLicenseString() {
        if (this.hasCCLicense) {
            Iterator i = this.fieldToValue.entrySet().iterator();
            while (i.hasNext()) {
                Map.Entry next = i.next();
                if (!((String)next.getKey()).endsWith(XML_LICENSE_ATTRIBUTE)) continue;
                return (String)next.getValue();
            }
        }
        return null;
    }

    public License getLicense() {
        String license = this.getLicenseString();
        if (license != null) {
            return LicenseFactory.create(license);
        }
        return null;
    }

    public List getOrderedNameValueList() {
        String[] fNames = this.getSchema().getCanonicalizedFieldNames();
        ArrayList<NameValue> retList = new ArrayList<NameValue>(fNames.length);
        for (int i = 0; i < fNames.length; ++i) {
            String name = fNames[i].trim();
            Object value = this.fieldToValue.get(name);
            if (value == null) continue;
            retList.add(new NameValue(name, value));
        }
        return retList;
    }

    public String getValue(String fieldName) {
        return (String)this.fieldToValue.get(fieldName);
    }

    public String getXMLString() {
        StringBuffer fullXML = new StringBuffer();
        LimeXMLDocumentHelper.buildXML(fullXML, this.getSchema(), this.getAttributeString() + "/>");
        return fullXML.toString();
    }

    public String getAttributeStringWithIndex(int i) {
        String attributes = this.getAttributeString();
        return attributes + " index=\"" + i + "\"/>";
    }

    private String getAttributeString() {
        if (this.attributeString == null) {
            this.attributeString = this.constructAttributeString();
        }
        return this.attributeString;
    }

    private String constructAttributeString() {
        List attributes = this.getOrderedNameValueList();
        if (attributes.isEmpty()) {
            return "";
        }
        StringBuffer tag = new StringBuffer();
        String root = this.getSchema().getRootXMLName();
        String type = this.getSchema().getInnerXMLName();
        String canonicalKey = root + "__" + type + "__";
        tag.append("<");
        tag.append(type);
        Iterator i = attributes.iterator();
        while (i.hasNext()) {
            NameValue nv = (NameValue)i.next();
            String name = XMLStringUtils.getLastField(canonicalKey, nv.getName());
            if (name == null) continue;
            tag.append(" ");
            tag.append(name);
            tag.append("=\"");
            tag.append(LimeXMLUtils.encodeXML((String)nv.getValue()));
            tag.append("\"");
        }
        return tag.toString();
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o == null) {
            return false;
        }
        if (!(o instanceof LimeXMLDocument)) {
            return false;
        }
        LimeXMLDocument xmlDoc = (LimeXMLDocument)o;
        return (this.schemaUri == null ? xmlDoc.schemaUri == null : this.schemaUri.equals(xmlDoc.schemaUri)) && (this.fileId == null ? xmlDoc.fileId == null : this.fileId.equals(xmlDoc.fileId)) && (this.action == null ? xmlDoc.action == null : this.action.equals(xmlDoc.action)) && (this.fieldToValue == null ? xmlDoc.fieldToValue == null : ((Object)this.fieldToValue).equals(xmlDoc.fieldToValue));
    }

    public int hashCode() {
        if (this.hashCode == 0) {
            int result = 17;
            if (this.fieldToValue != null) {
                result = 37 * result + ((Object)this.fieldToValue).hashCode();
            }
            if (this.schemaUri != null) {
                result = 37 * result + this.schemaUri.hashCode();
            }
            if (this.fileId != null) {
                result = 37 * result + this.fileId.hashCode();
            }
            if (this.action != null) {
                result = 37 * result + this.action.hashCode();
            }
            this.hashCode = result;
        }
        return this.hashCode;
    }

    public String toString() {
        return this.getXMLString();
    }

    private void scanFields() {
        String canonicalKey = this.getCanonicalKey(this.getNameValueSet());
        if (canonicalKey == null) {
            return;
        }
        this.setFields(canonicalKey);
        this.fieldToValue.remove(canonicalKey + XML_INDEX_ATTRIBUTE);
        this.fieldToValue.remove(canonicalKey + XML_ID_ATTRIBUTE);
    }

    private void setFields(String prefix) {
        this.action = (String)this.fieldToValue.get(prefix + XML_ACTION_ATTRIBUTE);
        String license = (String)this.fieldToValue.get(prefix + XML_LICENSE_ATTRIBUTE);
        String licenseType = (String)this.fieldToValue.get(prefix + XML_LICENSE_TYPE_ATTRIBUTE);
        if (license != null && license.indexOf("creativecommons.org/licenses/") != -1 && license.indexOf("verify at") != -1) {
            this.fieldToValue.put(prefix + XML_LICENSE_TYPE_ATTRIBUTE, "creativecommons.org/licenses/");
            this.hasCCLicense = true;
        } else if (licenseType != null && licenseType.equals("creativecommons.org/licenses/")) {
            this.hasCCLicense = true;
        } else {
            this.fieldToValue.remove(prefix + XML_LICENSE_TYPE_ATTRIBUTE);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("Fields after setting: " + this.fieldToValue);
        }
    }

    private String getCanonicalKey(Collection entries) {
        if (entries.isEmpty()) {
            return null;
        }
        Map.Entry firstEntry = (Map.Entry)entries.iterator().next();
        String firstKey = (String)firstEntry.getKey();
        int idx = firstKey.indexOf("__");
        if ((idx = firstKey.indexOf("__", idx + 1)) == -1) {
            return null;
        }
        return firstKey.substring(0, idx + 2);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        ArrayList<String> l = new ArrayList<String>(1);
        l.add("creativecommons.org/licenses/");
        INDIVISIBLE_LIST = Collections.unmodifiableList(l);
    }
}

