/*
 * Decompiled with CFR 0.152.
 */
package phex.common;

import java.net.URL;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;
import java.util.TreeMap;
import javax.xml.bind.JAXBException;
import phex.common.AlternateLocation;
import phex.common.URN;
import phex.host.HostAddress;
import phex.http.HTTPHeader;
import phex.http.HTTPHeaders;
import phex.utils.Logger;
import phex.xml.ObjectFactory;
import phex.xml.XJBAlternateLocation;

public class AlternateLocationContainer {
    private static final Object PRESENT = new Object();
    private URN urn;
    private TreeMap altLocationMap;

    public AlternateLocationContainer(URN uRN) {
        if (uRN == null) {
            throw new NullPointerException("URN must be provided");
        }
        this.urn = uRN;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addContainer(AlternateLocationContainer alternateLocationContainer) {
        if (alternateLocationContainer.urn == null || !alternateLocationContainer.urn.equals(this.urn)) {
            throw new IllegalArgumentException("Trying to add container with not matching urns");
        }
        if (alternateLocationContainer.altLocationMap == null) {
            return;
        }
        this.initMap();
        TreeMap treeMap = alternateLocationContainer.altLocationMap;
        synchronized (treeMap) {
            Iterator iterator = alternateLocationContainer.altLocationMap.keySet().iterator();
            while (iterator.hasNext()) {
                AlternateLocation alternateLocation = (AlternateLocation)iterator.next();
                this.addAlternateLocation(alternateLocation);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addAlternateLocation(AlternateLocation alternateLocation) {
        URN uRN = alternateLocation.getURN();
        if (uRN == null || !uRN.equals(this.urn)) {
            Logger.logMessage(Logger.WARNING, (short)2, "Cant add alt-location with not matching URN to container ");
            return;
        }
        this.initMap();
        TreeMap treeMap = this.altLocationMap;
        synchronized (treeMap) {
            Iterator iterator = this.altLocationMap.keySet().iterator();
            URL uRL = alternateLocation.getURL();
            AlternateLocation alternateLocation2 = null;
            while (iterator.hasNext()) {
                AlternateLocation alternateLocation3 = (AlternateLocation)iterator.next();
                if (!alternateLocation3.getURL().equals(uRL)) continue;
                if (alternateLocation.getTimestamp() > alternateLocation3.getTimestamp()) {
                    alternateLocation2 = alternateLocation3;
                    break;
                }
                return;
            }
            if (alternateLocation2 != null) {
                this.altLocationMap.remove(alternateLocation2);
            }
            this.altLocationMap.put(alternateLocation, PRESENT);
            if (this.altLocationMap.size() > 100) {
                Object k = this.altLocationMap.lastKey();
                this.altLocationMap.remove(k);
            }
        }
    }

    public void addFromHTTPHeaders(HTTPHeader[] hTTPHeaderArray) {
        if (hTTPHeaderArray.length == 0) {
            return;
        }
        int n = 0;
        while (n < hTTPHeaderArray.length) {
            HTTPHeader hTTPHeader = hTTPHeaderArray[n];
            StringTokenizer stringTokenizer = new StringTokenizer(hTTPHeader.getValue(), ",");
            while (stringTokenizer.hasMoreTokens()) {
                try {
                    String string = stringTokenizer.nextToken().trim();
                    AlternateLocation alternateLocation = AlternateLocation.parse(string);
                    if (alternateLocation == null) continue;
                    this.addAlternateLocation(alternateLocation);
                }
                catch (Exception exception) {
                    Logger.logError(exception);
                }
            }
            ++n;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HTTPHeader[] getAltLocHTTPHeadersForAddress(HostAddress hostAddress) {
        HTTPHeader[] hTTPHeaderArray;
        if (this.isEmpty()) {
            return HTTPHeaders.EMPTY_HTTPHEADER_ARRAY;
        }
        ArrayList<HTTPHeader> arrayList = new ArrayList<HTTPHeader>(10);
        TreeMap treeMap = this.altLocationMap;
        synchronized (treeMap) {
            hTTPHeaderArray = this.altLocationMap.keySet().iterator();
            while (hTTPHeaderArray.hasNext()) {
                AlternateLocation alternateLocation = (AlternateLocation)hTTPHeaderArray.next();
                if (hostAddress.getHostName().equals(alternateLocation.getURL().getHost())) continue;
                arrayList.add(new HTTPHeader("X-Gnutella-Alternate-Location", alternateLocation.getHTTPString()));
                if (arrayList.size() == 10) break;
            }
        }
        hTTPHeaderArray = new HTTPHeader[arrayList.size()];
        arrayList.toArray(hTTPHeaderArray);
        return hTTPHeaderArray;
    }

    public synchronized int getSize() {
        if (this.altLocationMap == null) {
            return 0;
        }
        return this.altLocationMap.size();
    }

    public synchronized boolean isEmpty() {
        if (this.altLocationMap == null) {
            return true;
        }
        return this.altLocationMap.isEmpty();
    }

    public synchronized void createXJBAlternateLocationList(List list) throws JAXBException {
        if (this.altLocationMap == null) {
            return;
        }
        Iterator iterator = this.altLocationMap.keySet().iterator();
        while (iterator.hasNext()) {
            AlternateLocation alternateLocation = (AlternateLocation)iterator.next();
            XJBAlternateLocation xJBAlternateLocation = ObjectFactory.createXJBAlternateLocation();
            xJBAlternateLocation.setURL(alternateLocation.getURL().toExternalForm());
            xJBAlternateLocation.setURN(alternateLocation.getURN().getAsString());
            xJBAlternateLocation.setTimestamp(alternateLocation.getTimestamp());
            list.add(xJBAlternateLocation);
        }
    }

    public synchronized String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("Alt-Locations(SHA1: ");
        stringBuffer.append(this.urn.getAsString());
        stringBuffer.append(")=[ ");
        if (this.altLocationMap != null) {
            Iterator iterator = this.altLocationMap.keySet().iterator();
            while (iterator.hasNext()) {
                AlternateLocation alternateLocation = (AlternateLocation)iterator.next();
                stringBuffer.append(alternateLocation.toString());
                stringBuffer.append(", ");
            }
        }
        stringBuffer.append(" ]");
        return stringBuffer.toString();
    }

    private void initMap() {
        if (this.altLocationMap == null) {
            this.altLocationMap = new TreeMap(new AltLocComparator());
        }
    }

    private class AltLocComparator
    implements Comparator {
        private AltLocComparator() {
        }

        public int compare(Object object, Object object2) {
            if (object == object2 || object.equals(object2)) {
                return 0;
            }
            if (!(object instanceof AlternateLocation)) {
                return -1;
            }
            if (!(object2 instanceof AlternateLocation)) {
                return 1;
            }
            AlternateLocation alternateLocation = (AlternateLocation)object;
            AlternateLocation alternateLocation2 = (AlternateLocation)object2;
            if (alternateLocation.getURL().equals(alternateLocation2.getURL())) {
                if (alternateLocation.getTimestamp() > alternateLocation2.getTimestamp()) {
                    return -1;
                }
                return 1;
            }
            if (alternateLocation.getTimestamp() > alternateLocation2.getTimestamp()) {
                return -1;
            }
            return 1;
        }
    }
}

