/*
 * Decompiled with CFR 0.152.
 */
package phex.common.bandwidth;

import java.util.Iterator;
import java.util.LinkedList;

final class SlidingWindow {
    private final LinkedList windowPanes = new LinkedList();
    private WindowPane currentPane;

    public SlidingWindow(int n) {
        int n2 = 0;
        while (n2 < n) {
            this.windowPanes.add(new WindowPane());
            ++n2;
        }
        this.currentPane = (WindowPane)this.windowPanes.getFirst();
    }

    public void slideWindow(long l) {
        long l2 = this.currentPane.maxBytesTransfered - this.currentPane.bytesTransfered;
        if (l2 > 0L) {
            l2 = (long)((float)l2 * 0.1f);
        }
        this.currentPane = (WindowPane)this.windowPanes.removeLast();
        this.windowPanes.addFirst(this.currentPane);
        this.currentPane.setNewContents(0L, l + l2);
    }

    public boolean addBytesTransfered(long l) {
        this.currentPane.bytesTransfered += l;
        return this.currentPane.bytesTransfered >= this.currentPane.maxBytesTransfered;
    }

    public long getBytesTransfered() {
        return this.currentPane.bytesTransfered;
    }

    public long getCurrentBytesTransfered() {
        return ((WindowPane)this.windowPanes.get((int)2)).bytesTransfered;
    }

    public double getAvgBytesTransfered() {
        Iterator iterator = this.windowPanes.iterator();
        iterator.next();
        int n = 0;
        long l = 0L;
        while (iterator.hasNext()) {
            l += ((WindowPane)iterator.next()).bytesTransfered;
            ++n;
        }
        return l / (long)n;
    }

    public long getMaxTransferAllowed() {
        return this.currentPane.maxBytesTransfered;
    }

    static final class WindowPane {
        public long bytesTransfered;
        public long maxBytesTransfered;

        public WindowPane() {
            this.setNewContents(0L, 0L);
        }

        public void setNewContents(long l, long l2) {
            this.bytesTransfered = l;
            this.maxBytesTransfered = l2;
        }
    }
}

