/*
 * Decompiled with CFR 0.152.
 */
package phex.connection;

import java.io.IOException;
import phex.connection.ConnectionEngine;
import phex.host.Host;
import phex.host.HostManager;
import phex.utils.Logger;

public class OutgoingConnectionDispatcher
implements Runnable {
    public Host outgoingHost;

    public OutgoingConnectionDispatcher(Host host) {
        this.outgoingHost = host;
    }

    public void run() {
        try {
            ConnectionEngine connectionEngine = new ConnectionEngine(this.outgoingHost);
            connectionEngine.initializeOutgoingConnection();
            connectionEngine.processIncomingData();
        }
        catch (IOException iOException) {
            this.outgoingHost.setStatus(1, iOException.getMessage());
            HostManager.getInstance().disconnectHost(this.outgoingHost);
            Logger.logMessage(Logger.FINEST, (short)16, iOException.toString());
        }
        catch (Exception exception) {
            this.outgoingHost.setStatus(1, exception.getMessage());
            HostManager.getInstance().disconnectHost(this.outgoingHost);
            Logger.logWarning(exception);
        }
    }
}

