/*
 * Decompiled with CFR 0.152.
 */
package phex.connection.handshake;

import phex.connection.ConnectionConstants;
import phex.connection.NetworkManager;
import phex.connection.handshake.HandshakeHandler;
import phex.connection.handshake.HandshakeStatus;
import phex.host.Host;
import phex.host.HostManager;
import phex.host.NetworkHostsContainer;
import phex.http.HTTPHeader;
import phex.http.HTTPHeaders;

public class LeafHandshakeHandler
extends HandshakeHandler
implements ConnectionConstants {
    private HostManager hostMgr = HostManager.getInstance();
    private NetworkHostsContainer hostContainer = this.hostMgr.getNetworkHostsContainer();

    public LeafHandshakeHandler(Host host) {
        super(host);
    }

    public HTTPHeaders createAcceptHandshakeHeaders() {
        HTTPHeaders hTTPHeaders = super.createAcceptHandshakeHeaders();
        hTTPHeaders.addHeader(new HTTPHeader("X-Ultrapeer", "false"));
        hTTPHeaders.addHeader(new HTTPHeader("X-Query-Routing", "0.1"));
        hTTPHeaders.addHeader(new HTTPHeader("X-Ultrapeer-Query-Routing", "0.1"));
        return hTTPHeaders;
    }

    public HandshakeStatus createHandshakeResponse(HandshakeStatus handshakeStatus, boolean bl) {
        boolean bl2;
        HTTPHeaders hTTPHeaders = handshakeStatus.getResponseHeaders();
        HTTPHeader hTTPHeader = hTTPHeaders.getHeader("X-Ultrapeer");
        boolean bl3 = bl2 = hTTPHeader != null && Boolean.valueOf(hTTPHeader.getValue()) != false;
        if (bl2) {
            this.connectedHost.setConnectionType((byte)1);
        } else {
            this.connectedHost.setConnectionType((byte)0);
            if (!NetworkManager.getInstance().areNoneUPConnectionsAllowed()) {
                if (bl) {
                    return new HandshakeStatus(503, "I accept only Ultrapeers");
                }
                return new HandshakeStatus(503, "I accept only Ultrapeers", this.createRejectHandshakeHeaders());
            }
            if (!this.hostContainer.hasPeerSlotsAvailable()) {
                return new HandshakeStatus(503, "I am busy.", this.createRejectHandshakeHeaders());
            }
        }
        if (bl) {
            return new HandshakeStatus(200, "OK");
        }
        if (this.hostContainer.isShieldedLeafNode()) {
            return new HandshakeStatus(503, "I am a shielded leaf node", this.createRejectHandshakeHeaders());
        }
        return new HandshakeStatus(200, "OK", this.createAcceptHandshakeHeaders());
    }
}

