/*
 * Decompiled with CFR 0.152.
 */
package phex.download.swarming;

import javax.xml.bind.JAXBException;
import phex.common.ServiceManager;
import phex.common.URN;
import phex.download.IDownloadCandidate;
import phex.download.RemoteFile;
import phex.download.swarming.SWDownloadConstants;
import phex.download.swarming.SWDownloadFile;
import phex.download.swarming.SWDownloadSegment;
import phex.download.swarming.SWDownloadWorker;
import phex.download.swarming.SwarmingManager;
import phex.host.HostAddress;
import phex.host.MalformedHostAddressException;
import phex.http.HTTPRangeSet;
import phex.http.XQueueParameters;
import phex.msg.GUID;
import phex.query.QueryHitHost;
import phex.utils.Logger;
import phex.xml.ObjectFactory;
import phex.xml.XJBSWDownloadCandidate;

public class SWDownloadCandidate
implements IDownloadCandidate,
SWDownloadConstants {
    private GUID guid;
    private long fileIndex;
    private String fileName;
    private URN resourceURN;
    private HostAddress hostAddress;
    private short status;
    private short errorStatus;
    private long statusTimeout;
    private int errorStatusRepetition;
    private String vendor;
    private boolean isPushNeeded;
    private boolean isChatSupported;
    private Short hostRating;
    private HTTPRangeSet availableRangeSet;
    private long availableRangeSetTime;
    private SWDownloadFile downloadFile;
    private SWDownloadWorker worker;
    private SWDownloadSegment downloadSegment;
    private XQueueParameters xQueueParameters;

    public SWDownloadCandidate(RemoteFile remoteFile, SWDownloadFile sWDownloadFile) {
        this.downloadFile = sWDownloadFile;
        this.fileIndex = remoteFile.getFileIndex();
        this.fileName = remoteFile.getFilename();
        this.resourceURN = remoteFile.getURN();
        this.guid = remoteFile.getRemoteClientID();
        QueryHitHost queryHitHost = remoteFile.getQueryHitHost();
        this.vendor = queryHitHost.getVendor();
        this.isPushNeeded = queryHitHost.isPushNeeded();
        this.hostRating = queryHitHost.getHostRatingObject();
        this.hostAddress = remoteFile.getHostAddress();
        this.isChatSupported = queryHitHost.isChatSupported();
        this.status = (short)10;
    }

    public SWDownloadCandidate(HostAddress hostAddress, long l, String string, Short s, URN uRN, SWDownloadFile sWDownloadFile) {
        this.downloadFile = sWDownloadFile;
        this.fileIndex = l;
        this.fileName = string;
        this.resourceURN = uRN;
        this.guid = null;
        this.vendor = null;
        this.isPushNeeded = false;
        this.isChatSupported = true;
        this.hostRating = s;
        this.hostAddress = hostAddress;
        this.status = (short)10;
    }

    public SWDownloadCandidate(XJBSWDownloadCandidate xJBSWDownloadCandidate, SWDownloadFile sWDownloadFile) {
        this.downloadFile = sWDownloadFile;
        this.fileIndex = xJBSWDownloadCandidate.getFileIndex();
        this.fileName = xJBSWDownloadCandidate.getFileName();
        String string = xJBSWDownloadCandidate.getGUID();
        if (string != null) {
            this.guid = new GUID(string);
        }
        this.vendor = xJBSWDownloadCandidate.getVendor();
        this.isPushNeeded = xJBSWDownloadCandidate.isPushNeeded();
        this.isChatSupported = xJBSWDownloadCandidate.isChatSupported();
        this.hostRating = new Short(xJBSWDownloadCandidate.getRating());
        try {
            this.hostAddress = new HostAddress(xJBSWDownloadCandidate.getRemoteHost());
        }
        catch (MalformedHostAddressException malformedHostAddressException) {
            Logger.logWarning((short)2, malformedHostAddressException);
        }
        this.resourceURN = sWDownloadFile.getFileURN();
        this.status = (short)10;
    }

    public HostAddress getHostAddress() {
        return this.hostAddress;
    }

    public String getFileName() {
        return this.fileName;
    }

    public URN getResourceURN() {
        return this.resourceURN;
    }

    public GUID getGUID() {
        return this.guid;
    }

    public long getFileIndex() {
        return this.fileIndex;
    }

    public long getStatusTimeLeft() {
        long l = this.statusTimeout - System.currentTimeMillis();
        if (l < 0L) {
            l = 0L;
        }
        return l;
    }

    public int getStatus() {
        return this.status;
    }

    public String getVendor() {
        return this.vendor;
    }

    public void setVendor(String string) {
        if (this.vendor == null || !this.vendor.equals(string)) {
            int n = 0;
            while (n < string.length()) {
                if (!Character.isLetterOrDigit(string.charAt(n))) {
                    return;
                }
                ++n;
            }
            this.vendor = string;
            this.downloadFile.fireDownloadCandidateChanged(this);
        }
    }

    public void updateXQueueParameters(XQueueParameters xQueueParameters) {
        if (this.xQueueParameters == null) {
            this.xQueueParameters = xQueueParameters;
        } else {
            this.xQueueParameters.update(xQueueParameters);
        }
    }

    public XQueueParameters getXQueueParameters() {
        return this.xQueueParameters;
    }

    public boolean isPushNeeded() {
        return this.isPushNeeded;
    }

    public boolean isChatSupported() {
        return this.isChatSupported;
    }

    public void setChatSupported(boolean bl) {
        this.isChatSupported = bl;
    }

    public short getHostRating() {
        return this.hostRating;
    }

    public Short getHostRatingObject() {
        return this.hostRating;
    }

    public void setAvailableRangeSet(HTTPRangeSet hTTPRangeSet) {
        this.availableRangeSet = hTTPRangeSet;
        this.availableRangeSetTime = System.currentTimeMillis();
    }

    public HTTPRangeSet getAvailableRangeSet() {
        if (System.currentTimeMillis() > this.availableRangeSetTime + 600000L) {
            this.availableRangeSet = null;
        }
        return this.availableRangeSet;
    }

    public boolean equals(Object object) {
        if (object instanceof SWDownloadCandidate) {
            return this.equals((SWDownloadCandidate)object);
        }
        return false;
    }

    public boolean equals(SWDownloadCandidate sWDownloadCandidate) {
        return this.hostAddress.equals(sWDownloadCandidate.hostAddress);
    }

    public void setStatus(short s) {
        if (this.status == s) {
            return;
        }
        this.status = s;
        this.statusTimeout = System.currentTimeMillis();
        this.log("Set status to " + this.status + " and raise timeout from: " + this.statusTimeout);
        switch (this.status) {
            case 13: 
            case 15: 
            case 16: 
            case 17: {
                this.statusTimeout += this.determineErrorStatusTimeout(this.status);
                break;
            }
            case 14: {
                this.statusTimeout += (long)ServiceManager.sCfg.mPushTransferTimeout;
                break;
            }
            case 12: {
                this.errorStatus = 0;
            }
        }
        this.log("to time: " + this.statusTimeout);
        this.downloadFile.fireDownloadCandidateChanged(this);
    }

    public boolean isRemotelyQueued() {
        return this.status == 17;
    }

    private long determineErrorStatusTimeout(short s) {
        if (this.errorStatus == s) {
            ++this.errorStatusRepetition;
        } else {
            this.errorStatus = s;
            this.errorStatusRepetition = 0;
        }
        switch (this.errorStatus) {
            case 13: {
                return 60000L;
            }
            case 15: {
                if (this.errorStatusRepetition + 1 >= ServiceManager.sCfg.maxFailedConnectionsInARow) {
                    this.downloadFile.removeDownloadCandidate(this);
                }
                return 120000L * (long)Math.pow(2.0, this.errorStatusRepetition);
            }
            case 16: {
                return 60000L * (long)Math.pow(2.0, this.errorStatusRepetition);
            }
            case 17: {
                if (this.xQueueParameters == null) {
                    return 0L;
                }
                return this.xQueueParameters.getRequestSleepTime();
            }
        }
        Logger.logWarning((short)2, "Unknown error status: " + this.errorStatus);
        return 0L;
    }

    public void manualConnectionRetry() {
        if (this.status != 13 && this.status != 15 && this.status != 16) {
            return;
        }
        this.setStatus((short)10);
        --this.errorStatusRepetition;
        SwarmingManager.getInstance().notifyWaitingWorkers();
    }

    public boolean isAbleToBeAllocated() {
        long l = System.currentTimeMillis();
        return this.worker == null && this.statusTimeout <= l;
    }

    public void setAllocatedByWorker(SWDownloadWorker sWDownloadWorker) {
        this.log("Allocated from " + sWDownloadWorker);
        this.worker = sWDownloadWorker;
    }

    public void associateDownloadSegment(SWDownloadSegment sWDownloadSegment) {
        this.downloadSegment = sWDownloadSegment;
        this.downloadSegment.associateDownloadCandidate(this);
    }

    public void releaseDownloadSegment() {
        if (this.downloadSegment != null) {
            this.downloadSegment.associateDownloadCandidate(null);
            this.downloadSegment = null;
        }
    }

    public SWDownloadSegment getDownloadSegment() {
        return this.downloadSegment;
    }

    public void stopDownload() {
        if (this.worker != null) {
            this.worker.stopDownload();
        }
    }

    public XJBSWDownloadCandidate createXJBSWDownloadCandidate() throws JAXBException {
        XJBSWDownloadCandidate xJBSWDownloadCandidate = ObjectFactory.createXJBSWDownloadCandidate();
        xJBSWDownloadCandidate.setFileIndex(this.fileIndex);
        xJBSWDownloadCandidate.setFileName(this.fileName);
        if (this.guid != null) {
            xJBSWDownloadCandidate.setGUID(this.guid.toHexString());
        }
        xJBSWDownloadCandidate.setPushNeeded(this.isPushNeeded);
        xJBSWDownloadCandidate.setChatSupported(this.isChatSupported);
        xJBSWDownloadCandidate.setRating(this.hostRating);
        xJBSWDownloadCandidate.setRemoteHost(this.hostAddress.getFullHostName());
        xJBSWDownloadCandidate.setVendor(this.vendor);
        return xJBSWDownloadCandidate;
    }

    public void log(String string) {
        Logger.logMessage(Logger.FINE, (short)2, "Candidate " + this.hostAddress.getHostName() + ":" + this.hostAddress.getPort() + ": " + string);
    }

    public String toString() {
        return "[Candidate: " + this.hostAddress.getFullHostName() + " -> " + super.toString() + "]";
    }
}

