/*
 * Decompiled with CFR 0.152.
 */
package phex.download.swarming;

import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.EventListener;
import java.util.Iterator;
import javax.xml.bind.JAXBException;
import phex.common.AlternateLocation;
import phex.common.AlternateLocationContainer;
import phex.common.FileHandlingException;
import phex.common.ServiceManager;
import phex.common.URN;
import phex.download.IDownloadFile;
import phex.download.RemoteFile;
import phex.download.swarming.SWDownloadCandidate;
import phex.download.swarming.SWDownloadConstants;
import phex.download.swarming.SWDownloadSegment;
import phex.download.swarming.SWDownloadWorker;
import phex.download.swarming.SwarmingManager;
import phex.event.AsynchronousDispatcher;
import phex.event.DownloadCandidatesChangeListener;
import phex.event.DownloadSegmentsChangeListener;
import phex.event.EventListenerList;
import phex.host.HostAddress;
import phex.http.HTTPRangeSet;
import phex.msg.GETRequest;
import phex.query.ResearchSetting;
import phex.utils.FileUtils;
import phex.utils.Logger;
import phex.utils.URLUtil;
import phex.xml.ObjectFactory;
import phex.xml.XJBSWDownloadCandidate;
import phex.xml.XJBSWDownloadFile;
import phex.xml.XJBSWDownloadSegment;

public class SWDownloadFile
implements IDownloadFile,
SWDownloadConstants {
    private static Comparator candidatesComparator = new SWDownloadCandidateComparator();
    private int indexOfAttemptedCandidate = -1;
    private ArrayList downloadSegments;
    private ArrayList downloadCandidates;
    private Integer candidateCountObj;
    private AlternateLocationContainer altLocContainer;
    private long fileSize;
    private int nextSegmentNumber;
    private File destinationFile;
    private Date createdDate;
    private Date modifiedDate;
    private short status;
    private long transferRateTimestamp;
    private int transferRateBytes;
    private long sessionTransferRateBytes;
    private int transferRate;
    private long transferStartTime;
    private long transferStopTime;
    private long transferDataSize;
    private long transferredDataSize;
    private long transferDataUpdateTime;
    private Integer currentProgress;
    private short workerCount;
    private URN fileURN;
    private ResearchSetting researchSetting;
    private EventListenerList listenerList = new EventListenerList();
    static /* synthetic */ Class class$phex$event$DownloadCandidatesChangeListener;
    static /* synthetic */ Class class$phex$event$DownloadSegmentsChangeListener;

    public SWDownloadFile(String string, String string2, long l, URN uRN) {
        this(string, string2, l, true);
        if (uRN != null) {
            this.fileURN = uRN;
            this.altLocContainer = new AlternateLocationContainer(uRN);
        }
    }

    public SWDownloadFile(XJBSWDownloadFile xJBSWDownloadFile) {
        this(ServiceManager.sCfg.mDownloadDir + File.separator + xJBSWDownloadFile.getLocalFileName(), xJBSWDownloadFile.getSearchTerm(), xJBSWDownloadFile.getFileSize(), false);
        this.createdDate = new Date(xJBSWDownloadFile.getCreatedTime());
        this.modifiedDate = new Date(xJBSWDownloadFile.getModifiedTime());
        this.status = xJBSWDownloadFile.getStatus();
        if (xJBSWDownloadFile.getFileURN() != null) {
            URN uRN;
            this.fileURN = uRN = new URN(xJBSWDownloadFile.getFileURN());
            this.altLocContainer = new AlternateLocationContainer(this.fileURN);
        }
        this.createDownloadCandidates(xJBSWDownloadFile);
        this.createDownloadSegments(xJBSWDownloadFile);
        this.forceCollectionOfTransferData();
        this.transferRateBytes = 0;
        this.sessionTransferRateBytes = 0L;
        this.verifyStatus();
        if (this.status == 3) {
            this.transferDataSize = this.transferredDataSize = this.fileSize;
        }
    }

    private SWDownloadFile(String string, String string2, long l, boolean bl) {
        this.destinationFile = new File(string);
        this.fileSize = l;
        this.downloadCandidates = new ArrayList();
        this.candidateCountObj = new Integer(0);
        this.currentProgress = new Integer(0);
        this.createdDate = this.modifiedDate = new Date(System.currentTimeMillis());
        this.status = 1;
        if (bl) {
            this.createDownloadSegments();
        } else {
            this.downloadSegments = new ArrayList();
        }
        this.researchSetting = new ResearchSetting(this);
        this.researchSetting.setSearchTerm(string2);
        ServiceManager.getTransferRateService().registerTransferDataProvider(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isDownloadSegmentAllocateable(HTTPRangeSet hTTPRangeSet) {
        if (hTTPRangeSet != null) {
            Iterator iterator = hTTPRangeSet.getIterator();
            SWDownloadSegment sWDownloadSegment = null;
            while (iterator.hasNext()) {
                HTTPRangeSet.Range range = (HTTPRangeSet.Range)iterator.next();
                long l = range.getStartOffset(this.fileSize);
                long l2 = range.getEndOffset(this.fileSize);
                ArrayList arrayList = this.downloadSegments;
                synchronized (arrayList) {
                    Iterator iterator2 = this.downloadSegments.iterator();
                    while (iterator2.hasNext()) {
                        long l3;
                        sWDownloadSegment = (SWDownloadSegment)iterator2.next();
                        long l4 = sWDownloadSegment.getTransferDataSize();
                        long l5 = sWDownloadSegment.getTransferStartPosition();
                        if (l5 == (l3 = sWDownloadSegment.getEndOffset()) || l2 <= l5 || l >= l3) continue;
                        if (sWDownloadSegment.isAbleToBeAllocated()) {
                            return true;
                        }
                        if (!this.isSplitAllowed(sWDownloadSegment, l, l2)) continue;
                        return true;
                    }
                }
            }
            return false;
        }
        ArrayList arrayList = this.downloadSegments;
        synchronized (arrayList) {
            SWDownloadSegment sWDownloadSegment = null;
            Iterator iterator = this.downloadSegments.iterator();
            while (iterator.hasNext()) {
                sWDownloadSegment = (SWDownloadSegment)iterator.next();
                if (sWDownloadSegment.isAbleToBeAllocated()) {
                    return true;
                }
                if (!this.isSplitAllowed(sWDownloadSegment)) continue;
                return true;
            }
            return false;
        }
    }

    public SWDownloadSegment allocateDownloadSegment(SWDownloadWorker sWDownloadWorker, HTTPRangeSet hTTPRangeSet) {
        if (hTTPRangeSet != null) {
            return this.allocateSegmentForRangeSet(sWDownloadWorker, hTTPRangeSet);
        }
        return this.allocateSegment(sWDownloadWorker);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SWDownloadCandidate allocateDownloadCandidate(SWDownloadWorker sWDownloadWorker) {
        SWDownloadCandidate sWDownloadCandidate = null;
        ArrayList arrayList = this.downloadCandidates;
        synchronized (arrayList) {
            int n = this.downloadCandidates.size();
            if (this.downloadCandidates.size() == 0) {
                return null;
            }
            if (++this.indexOfAttemptedCandidate >= n) {
                this.indexOfAttemptedCandidate = 0;
            }
            int n2 = 0;
            while (n2 < n) {
                int n3 = n2 + this.indexOfAttemptedCandidate;
                if (n3 >= n) {
                    n3 -= n;
                }
                if ((sWDownloadCandidate = (SWDownloadCandidate)this.downloadCandidates.get(n3)).isAbleToBeAllocated()) {
                    sWDownloadCandidate.setAllocatedByWorker(sWDownloadWorker);
                    this.indexOfAttemptedCandidate = n3;
                    return sWDownloadCandidate;
                }
                ++n2;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void releaseDownloadCandidate(SWDownloadCandidate sWDownloadCandidate) {
        ArrayList arrayList = this.downloadCandidates;
        synchronized (arrayList) {
            SwarmingManager.getInstance().releaseCandidateIP(sWDownloadCandidate);
            sWDownloadCandidate.setAllocatedByWorker(null);
        }
    }

    public boolean addDownloadCandidate(RemoteFile remoteFile) {
        SWDownloadCandidate sWDownloadCandidate = new SWDownloadCandidate(remoteFile, this);
        return this.addDownloadCandidate(sWDownloadCandidate);
    }

    public boolean addDownloadCandidate(AlternateLocation alternateLocation) {
        URN uRN = alternateLocation.getURN();
        if (this.fileURN != null && !uRN.equals(this.fileURN)) {
            Logger.logMessage(Logger.FINE, (short)2, "AlternateLocation URN does not match!");
            return false;
        }
        URL uRL = alternateLocation.getURL();
        GETRequest gETRequest = new GETRequest(uRL.getFile());
        if (!gETRequest.isFileRequest()) {
            return false;
        }
        HostAddress hostAddress = new HostAddress(uRL.getHost(), uRL.getPort());
        if (hostAddress.isLocalHost()) {
            return false;
        }
        SWDownloadCandidate sWDownloadCandidate = new SWDownloadCandidate(hostAddress, gETRequest.getFileIndex(), gETRequest.getFileName(), AlternateLocation.DEFAULT_HOST_RATING, gETRequest.getURN(), this);
        return this.addDownloadCandidate(sWDownloadCandidate);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean addDownloadCandidate(SWDownloadCandidate sWDownloadCandidate) {
        Logger.logMessage(Logger.FINE, (short)2, "Adding download candidate " + sWDownloadCandidate);
        URN uRN = sWDownloadCandidate.getResourceURN();
        if (this.fileURN == null && uRN != null) {
            this.fileURN = uRN;
            this.altLocContainer = new AlternateLocationContainer(this.fileURN);
        }
        if (this.fileURN != null && uRN != null && !this.fileURN.equals(uRN)) {
            Logger.logMessage(Logger.FINE, (short)2, "Candidate URN does not match!");
            return false;
        }
        ArrayList arrayList = this.downloadCandidates;
        synchronized (arrayList) {
            if (this.downloadCandidates.contains(sWDownloadCandidate)) {
                Logger.logMessage(Logger.FINE, (short)2, "Duplicate download candidate");
                return false;
            }
            int n = this.downloadCandidates.size();
            this.downloadCandidates.add(n, sWDownloadCandidate);
            this.fireDownloadCandidateAdded(n);
            Collections.sort(this.downloadCandidates, candidatesComparator);
            if (uRN != null && this.altLocContainer != null) {
                try {
                    AlternateLocation alternateLocation = new AlternateLocation(new URL(URLUtil.buildFullName2ResourceURL(sWDownloadCandidate.getHostAddress(), uRN)), uRN, System.currentTimeMillis());
                    this.altLocContainer.addAlternateLocation(alternateLocation);
                }
                catch (MalformedURLException malformedURLException) {
                    Logger.logError(malformedURLException);
                }
            }
        }
        SwarmingManager.getInstance().notifyWaitingWorkers();
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeDownloadCandidate(SWDownloadCandidate sWDownloadCandidate) {
        sWDownloadCandidate.stopDownload();
        ArrayList arrayList = this.downloadCandidates;
        synchronized (arrayList) {
            int n = this.downloadCandidates.indexOf(sWDownloadCandidate);
            if (n >= 0) {
                this.downloadCandidates.remove(n);
                this.fireDownloadCandidateRemoved(n);
            }
        }
        Logger.logMessage(Logger.FINE, (short)2, "Removing Candidate: " + sWDownloadCandidate.getHostAddress());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void releaseDownloadSegment(SWDownloadSegment sWDownloadSegment) {
        ArrayList arrayList = this.downloadSegments;
        synchronized (arrayList) {
            sWDownloadSegment.setAllocatedByWorker(null);
        }
    }

    public int getCandidateCount() {
        return this.downloadCandidates.size();
    }

    public Integer getCandidateCountObject() {
        if (this.candidateCountObj.intValue() != this.downloadCandidates.size()) {
            this.candidateCountObj = new Integer(this.downloadCandidates.size());
        }
        return this.candidateCountObj;
    }

    public SWDownloadCandidate getCandidate(int n) {
        if (n >= this.downloadCandidates.size()) {
            return null;
        }
        return (SWDownloadCandidate)this.downloadCandidates.get(n);
    }

    public AlternateLocationContainer getAltLocContainer() {
        return this.altLocContainer;
    }

    public URN getFileURN() {
        return this.fileURN;
    }

    public Date getCreatedDate() {
        return this.createdDate;
    }

    public Date getDownloadedDate() {
        return this.modifiedDate;
    }

    public int getSegmentCount() {
        return this.downloadSegments.size();
    }

    public SWDownloadSegment getSegment(int n) {
        if (n >= this.downloadSegments.size()) {
            return null;
        }
        return (SWDownloadSegment)this.downloadSegments.get(n);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SWDownloadSegment getSegmentForRange(HTTPRangeSet.Range range) {
        long l = range.getStartOffset(this.fileSize);
        long l2 = range.getEndOffset(this.fileSize);
        ArrayList arrayList = this.downloadSegments;
        synchronized (arrayList) {
            int n = this.downloadSegments.size();
            int n2 = 0;
            while (n2 < n) {
                SWDownloadSegment sWDownloadSegment = (SWDownloadSegment)this.downloadSegments.get(n2);
                if (sWDownloadSegment.getStartOffset() <= l && sWDownloadSegment.getEndOffset() >= l) {
                    return sWDownloadSegment;
                }
                ++n2;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HTTPRangeSet createAvailableRangeSet() {
        HTTPRangeSet hTTPRangeSet = new HTTPRangeSet();
        ArrayList arrayList = this.downloadSegments;
        synchronized (arrayList) {
            int n = this.downloadSegments.size();
            int n2 = 0;
            while (n2 < n) {
                SWDownloadSegment sWDownloadSegment = (SWDownloadSegment)this.downloadSegments.get(n2);
                if (sWDownloadSegment.getTransferredDataSize() > 0L) {
                    hTTPRangeSet.addRange(sWDownloadSegment.getStartOffset(), sWDownloadSegment.getTransferStartPosition());
                }
                ++n2;
            }
        }
        return hTTPRangeSet;
    }

    public ResearchSetting getResearchSetting() {
        return this.researchSetting;
    }

    public void startSearchForCandidates() {
        if (this.isDownloadCompleted()) {
            return;
        }
        this.researchSetting.stopSearch();
        this.researchSetting.startSearch(300000L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean mergeSegmentWithNext(SWDownloadSegment sWDownloadSegment) {
        ArrayList arrayList = this.downloadSegments;
        synchronized (arrayList) {
            SWDownloadSegment sWDownloadSegment2 = sWDownloadSegment.getNextDownloadSegment();
            Logger.logMessage(Logger.FINE, (short)2, "Segment to merge: " + sWDownloadSegment);
            if (sWDownloadSegment.isFixedSizeSegment() || sWDownloadSegment2 == null || !sWDownloadSegment2.isAbleToBeAllocated() || sWDownloadSegment2.getTransferredDataSize() > 0L) {
                return false;
            }
            sWDownloadSegment.mergeWithNextSegment();
            int n = this.downloadSegments.indexOf(sWDownloadSegment2);
            if (n >= 0) {
                this.downloadSegments.remove(n);
                this.fireDownloadSegmentRemoved(n);
            }
            this.logDownloadSegments();
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void mergeCompletedSegments(SWDownloadWorker sWDownloadWorker) {
        ArrayList arrayList = this.downloadSegments;
        synchronized (arrayList) {
            int n = this.downloadSegments.size() - 1;
            while (n >= 0) {
                SWDownloadSegment sWDownloadSegment = (SWDownloadSegment)this.downloadSegments.get(n);
                Logger.logMessage(Logger.FINE, (short)2, "Trying to merge completed segment: " + sWDownloadSegment);
                SWDownloadSegment sWDownloadSegment2 = sWDownloadSegment.getNextDownloadSegment();
                if (sWDownloadSegment2 != null && sWDownloadSegment.getTransferredDataSize() >= sWDownloadSegment.getTransferDataSize() && sWDownloadSegment2.getTransferredDataSize() != 0L && (sWDownloadSegment2.getAllocatedByWorker() == null || sWDownloadSegment2.getAllocatedByWorker() == sWDownloadWorker)) {
                    try {
                        FileUtils.truncateFile(sWDownloadSegment.getIncompleteFile(), sWDownloadSegment.getTransferDataSize());
                        FileUtils.appendFile(sWDownloadSegment.getIncompleteFile(), sWDownloadSegment2.getIncompleteFile());
                    }
                    catch (IOException iOException) {
                        Logger.logWarning(iOException);
                    }
                    sWDownloadSegment.mergeWithNextSegment();
                    int n2 = this.downloadSegments.indexOf(sWDownloadSegment2);
                    if (n2 >= 0) {
                        this.downloadSegments.remove(n2);
                        this.fireDownloadSegmentRemoved(n2);
                    }
                    Logger.logMessage(Logger.FINE, (short)2, "Merged completed segment: " + sWDownloadSegment);
                }
                --n;
            }
            this.logDownloadSegments();
        }
        SwarmingManager.getInstance().triggerSaveDownloadList();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setStatus(short s) {
        if (this.status == s) {
            return;
        }
        Logger.logMessage(Logger.FINE, (short)2, "DownloadFile Status " + s);
        ArrayList arrayList = this.downloadCandidates;
        synchronized (arrayList) {
            switch (s) {
                case 1: 
                case 3: 
                case 4: {
                    this.downloadStopNotify();
                    break;
                }
                case 2: {
                    this.downloadStartNotify();
                }
            }
            this.status = s;
            SwarmingManager.getInstance().fireDownloadFileChanged(this);
        }
    }

    public short getStatus() {
        return this.status;
    }

    public boolean isAbleToBeAllocated() {
        return this.status != 4 && this.status != 3 && this.workerCount <= ServiceManager.sCfg.maxWorkerPerDownload;
    }

    public void incrementWorkerCount() {
        this.workerCount = (short)(this.workerCount + 1);
    }

    public void decrementWorkerCount() {
        this.workerCount = (short)(this.workerCount - 1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void verifyStatus() {
        this.forceCollectionOfTransferData();
        if (this.getTransferDataSize() == this.getTransferredDataSize()) {
            this.setStatus((short)3);
            this.researchSetting.stopSearch();
            return;
        }
        ArrayList arrayList = this.downloadCandidates;
        synchronized (arrayList) {
            int n = this.downloadCandidates.size();
            int n2 = n - 1;
            while (n2 >= 0) {
                SWDownloadCandidate sWDownloadCandidate = (SWDownloadCandidate)this.downloadCandidates.get(n2);
                if (sWDownloadCandidate.getStatus() == 12) {
                    this.setStatus((short)2);
                    return;
                }
                --n2;
            }
            if (this.status != 1 && this.status != 4 && this.status != 3) {
                this.setStatus((short)1);
            }
        }
    }

    public boolean isDownloadCompleted() {
        return this.status == 3;
    }

    public boolean isDownloadInProgress() {
        return this.status == 2;
    }

    public boolean isDownloadStopped() {
        return this.status == 4;
    }

    public File getDestinationFile() {
        return this.destinationFile;
    }

    public String getDestinationFileName() {
        return this.destinationFile.getName();
    }

    public void setDestinationFile(File file, boolean bl) throws FileHandlingException {
        if (file.compareTo(this.destinationFile) == 0) {
            return;
        }
        if (bl) {
            if (SwarmingManager.getInstance().isNewLocalFilenameUsed(this, file)) {
                throw new FileHandlingException(1);
            }
            this.renameSegmentsToDestinationRoot(file);
            FileUtils.renameLocalFile(this.destinationFile, file);
        }
        this.destinationFile = file;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void moveToDestinationFile() {
        if (this.downloadSegments.size() != 1 && this.status == 3) {
            throw new RuntimeException("There must be exactly one download segment and the download must be completed to move to destination file");
        }
        ArrayList arrayList = this.downloadSegments;
        synchronized (arrayList) {
            SWDownloadSegment sWDownloadSegment = (SWDownloadSegment)this.downloadSegments.get(0);
            File file = sWDownloadSegment.getIncompleteFile();
            File file2 = this.destinationFile;
            if (!file2.isAbsolute()) {
                file2 = new File(ServiceManager.sCfg.mDownloadDir, this.destinationFile.getName());
            }
            int n = 0;
            while (file2.exists()) {
                ++n;
                StringBuffer stringBuffer = new StringBuffer();
                stringBuffer.append(this.destinationFile.getParent());
                stringBuffer.append(File.separatorChar);
                stringBuffer.append('(');
                stringBuffer.append(n);
                stringBuffer.append(") ");
                stringBuffer.append(this.destinationFile.getName());
                file2 = new File(stringBuffer.toString());
            }
            Logger.logMessage(Logger.FINE, (short)2, "Renameing final segment from " + file.getAbsolutePath() + " to " + file2.getAbsoluteFile() + ".");
            boolean bl = file.renameTo(file2);
            if (bl) {
                int n2 = this.downloadSegments.indexOf(sWDownloadSegment);
                if (n2 >= 0) {
                    this.downloadSegments.remove(n2);
                    this.fireDownloadSegmentRemoved(n2);
                    this.logDownloadSegments();
                }
            } else {
                Logger.logMessage(Logger.FINE, (short)2, "Renaming from " + file.getAbsolutePath() + " to " + file2.getAbsolutePath() + " failed.");
            }
        }
        if (ServiceManager.sCfg.mDownloadAutoRemoveCompleted) {
            SwarmingManager.getInstance().removeDownloadFile(this);
        } else {
            SwarmingManager.getInstance().triggerSaveDownloadList();
        }
    }

    public void setTransferRateTimestamp(long l) {
        this.transferRateTimestamp = l;
        this.transferRateBytes = 0;
    }

    public int getShortTermTransferRate() {
        if (this.status == 3) {
            this.transferRate = 0;
        } else if (this.transferRateTimestamp != 0L) {
            double d = (System.currentTimeMillis() - this.transferRateTimestamp) / 1000L;
            if ((this.transferRateBytes > 0 || d > 1.0) && d != 0.0) {
                this.transferRate = (int)((double)this.transferRateBytes / d);
            }
        }
        return this.transferRate;
    }

    public short getDataTransferStatus() {
        switch (this.status) {
            case 2: {
                return 10;
            }
            case 3: {
                return 12;
            }
        }
        return 11;
    }

    public long getTransferDataSize() {
        this.lazyCollectTransferData();
        return this.transferDataSize;
    }

    public long getTotalDataSize() {
        return this.fileSize;
    }

    public long getTransferredDataSize() {
        this.lazyCollectTransferData();
        return this.transferredDataSize;
    }

    public int getLongTermTransferRate() {
        long l = this.transferStopTime != 0L ? (this.transferStopTime - this.transferStartTime) / 1000L : (System.currentTimeMillis() - this.transferStartTime) / 1000L;
        return (int)(this.sessionTransferRateBytes / (l + 1L));
    }

    public Integer getProgress() {
        int n;
        if (this.status == 3) {
            n = 100;
        } else {
            long l = this.transferDataSize;
            if (l == 0L) {
                l = 1L;
            }
            n = (int)(this.transferredDataSize * 100L / l);
        }
        if (this.currentProgress != n) {
            this.currentProgress = new Integer(n);
        }
        return this.currentProgress;
    }

    public void startDownload() {
        this.setStatus((short)1);
        SwarmingManager.getInstance().notifyWaitingWorkers();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stopDownload() {
        this.setStatus((short)4);
        ArrayList arrayList = this.downloadCandidates;
        synchronized (arrayList) {
            Iterator iterator = this.downloadCandidates.iterator();
            while (iterator.hasNext()) {
                SWDownloadCandidate sWDownloadCandidate = (SWDownloadCandidate)iterator.next();
                sWDownloadCandidate.stopDownload();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeDownloadSegmentFiles() {
        if (this.status != 4) {
            Logger.logMessage(Logger.WARNING, (short)2, "Can't clean temp files of not stopped download file.");
            return;
        }
        ArrayList arrayList = this.downloadSegments;
        synchronized (arrayList) {
            Iterator iterator = this.downloadSegments.iterator();
            while (iterator.hasNext()) {
                SWDownloadSegment sWDownloadSegment = (SWDownloadSegment)iterator.next();
                sWDownloadSegment.removeDownloadDestinationFile();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private SWDownloadSegment allocateSegmentForRangeSet(SWDownloadWorker sWDownloadWorker, HTTPRangeSet hTTPRangeSet) {
        Iterator iterator = hTTPRangeSet.getIterator();
        SWDownloadSegment sWDownloadSegment = null;
        while (iterator.hasNext()) {
            HTTPRangeSet.Range range = (HTTPRangeSet.Range)iterator.next();
            long l = range.getStartOffset(this.fileSize);
            long l2 = range.getEndOffset(this.fileSize);
            ArrayList arrayList = this.downloadSegments;
            synchronized (arrayList) {
                Iterator iterator2 = this.downloadSegments.iterator();
                while (iterator2.hasNext()) {
                    SWDownloadSegment sWDownloadSegment2;
                    sWDownloadSegment = (SWDownloadSegment)iterator2.next();
                    long l3 = sWDownloadSegment.getTransferDataSize();
                    long l4 = sWDownloadSegment.getTransferStartPosition();
                    long l5 = sWDownloadSegment.getEndOffset();
                    if (l5 == l4 || l2 <= l4 || l >= l5) continue;
                    long l6 = Math.max(l, l4);
                    long l7 = Math.min(l2, l5);
                    if (sWDownloadSegment.isAbleToBeAllocated() && l6 == l4 && l7 == l5) {
                        return sWDownloadSegment;
                    }
                    if (l7 - l6 < 131072L || (sWDownloadSegment2 = this.splitDownloadSegment(sWDownloadSegment, l6, l7)) == null) continue;
                    Logger.logMessage(Logger.FINE, (short)2, "Allocating segment: " + sWDownloadSegment);
                    sWDownloadSegment2.setFixedSizeSegment(true);
                    sWDownloadSegment2.setAllocatedByWorker(sWDownloadWorker);
                    return sWDownloadSegment2;
                }
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private SWDownloadSegment allocateSegment(SWDownloadWorker sWDownloadWorker) {
        long l = 0L;
        SWDownloadSegment sWDownloadSegment = null;
        ArrayList arrayList = this.downloadSegments;
        synchronized (arrayList) {
            SWDownloadSegment sWDownloadSegment2 = null;
            Iterator iterator = this.downloadSegments.iterator();
            while (iterator.hasNext()) {
                sWDownloadSegment2 = (SWDownloadSegment)iterator.next();
                if (sWDownloadSegment2.isAbleToBeAllocated()) {
                    Logger.logMessage(Logger.FINE, (short)2, "Allocating segment: " + sWDownloadSegment2);
                    sWDownloadSegment2.setAllocatedByWorker(sWDownloadWorker);
                    return sWDownloadSegment2;
                }
                if (sWDownloadSegment2.getTransferDataSizeLeft() <= l) continue;
                l = sWDownloadSegment2.getTransferDataSizeLeft();
                sWDownloadSegment = sWDownloadSegment2;
            }
            if (sWDownloadSegment == null) {
                return null;
            }
            Logger.logMessage(Logger.FINE, (short)2, "No free segment found... try to split segment: " + sWDownloadSegment);
            sWDownloadSegment2 = this.splitDownloadSegment(sWDownloadSegment);
            if (sWDownloadSegment2 == null) {
                return null;
            }
            Logger.logMessage(Logger.FINE, (short)2, "Allocating segment: " + sWDownloadSegment2);
            sWDownloadSegment2.setAllocatedByWorker(sWDownloadWorker);
            return sWDownloadSegment2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void renameSegmentsToDestinationRoot(File file) throws FileHandlingException {
        ArrayList arrayList = this.downloadSegments;
        synchronized (arrayList) {
            Iterator iterator = this.downloadSegments.iterator();
            while (iterator.hasNext()) {
                SWDownloadSegment sWDownloadSegment = (SWDownloadSegment)iterator.next();
                sWDownloadSegment.renameToDestinationRoot(file);
            }
        }
    }

    private void downloadStartNotify() {
        this.transferStartTime = System.currentTimeMillis();
        this.modifiedDate = new Date(this.transferStartTime);
        this.transferRateTimestamp = this.transferStartTime;
        this.transferStopTime = 0L;
        this.sessionTransferRateBytes = 0L;
    }

    private void downloadStopNotify() {
        if (this.transferStopTime == 0L) {
            this.transferStopTime = System.currentTimeMillis();
            this.modifiedDate = new Date(this.transferStopTime);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void forceCollectionOfTransferData() {
        long l = 0L;
        long l2 = 0L;
        ArrayList arrayList = this.downloadSegments;
        synchronized (arrayList) {
            Iterator iterator = this.downloadSegments.iterator();
            while (iterator.hasNext()) {
                SWDownloadSegment sWDownloadSegment = (SWDownloadSegment)iterator.next();
                l += sWDownloadSegment.getTransferredDataSize();
                l2 += sWDownloadSegment.getTransferDataSize();
            }
        }
        this.transferRateBytes = (int)((long)this.transferRateBytes + (l - this.transferredDataSize));
        this.sessionTransferRateBytes += l - this.transferredDataSize;
        this.transferDataSize = l2;
        this.transferredDataSize = l;
        this.transferDataUpdateTime = System.currentTimeMillis() + 1000L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public XJBSWDownloadFile createXJBSWDownloadFile() throws JAXBException {
        Object object;
        Object object2;
        Object object3;
        Object object4;
        XJBSWDownloadFile xJBSWDownloadFile = ObjectFactory.createXJBSWDownloadFile();
        xJBSWDownloadFile.setLocalFileName(this.destinationFile.getName());
        xJBSWDownloadFile.setFileSize(this.fileSize);
        xJBSWDownloadFile.setSearchTerm(this.researchSetting.getSearchTerm());
        xJBSWDownloadFile.setCreatedTime(this.createdDate.getTime());
        xJBSWDownloadFile.setModifiedTime(this.modifiedDate.getTime());
        if (this.fileURN != null) {
            xJBSWDownloadFile.setFileURN(this.fileURN.getAsString());
        }
        xJBSWDownloadFile.setStatus(this.status);
        ArrayList arrayList = this.downloadCandidates;
        synchronized (arrayList) {
            object4 = this.downloadCandidates.iterator();
            object3 = xJBSWDownloadFile.getCandidateList();
            while (object4.hasNext()) {
                object2 = (SWDownloadCandidate)object4.next();
                object = ((SWDownloadCandidate)object2).createXJBSWDownloadCandidate();
                object3.add(object);
            }
        }
        object4 = this.downloadSegments;
        synchronized (object4) {
            object3 = this.downloadSegments.iterator();
            object2 = xJBSWDownloadFile.getSegmentList();
            while (object3.hasNext()) {
                object = (SWDownloadSegment)object3.next();
                XJBSWDownloadSegment xJBSWDownloadSegment = ((SWDownloadSegment)object).createXJBSWDownloadSegment();
                object2.add(xJBSWDownloadSegment);
            }
        }
        return xJBSWDownloadFile;
    }

    private void lazyCollectTransferData() {
        if (this.status == 3 || this.transferDataUpdateTime > System.currentTimeMillis()) {
            return;
        }
        this.forceCollectionOfTransferData();
    }

    private boolean isSplitAllowed(SWDownloadSegment sWDownloadSegment) {
        long l = sWDownloadSegment.getTransferDataSizeLeft();
        return l >= 131072L;
    }

    private boolean isSplitAllowed(SWDownloadSegment sWDownloadSegment, long l, long l2) {
        long l3 = sWDownloadSegment.getTransferStartPosition();
        long l4 = sWDownloadSegment.getEndOffset();
        if (l < l3) {
            l = l3;
            l2 = Math.min(l2, l4 - 131072L);
        } else if (l2 > l4) {
            l2 = l4;
            l = Math.max(l, l3 + 131072L);
        } else {
            l = Math.max(l, l3 + 131072L);
            l2 = Math.min(l2, l4 - 131072L);
        }
        return l2 - l >= 131072L;
    }

    private SWDownloadSegment splitDownloadSegment(SWDownloadSegment sWDownloadSegment) {
        if (!this.isSplitAllowed(sWDownloadSegment)) {
            return null;
        }
        long l = sWDownloadSegment.getTransferredDataSize();
        long l2 = sWDownloadSegment.getTransferDataSizeLeft();
        long l3 = sWDownloadSegment.getStartOffset();
        long l4 = (long)Math.ceil((double)l + (double)l2 / 2.0);
        sWDownloadSegment.setTransferDataSize(l4);
        long l5 = l3 + l4;
        SWDownloadSegment sWDownloadSegment2 = new SWDownloadSegment(this, this.nextSegmentNumber, l5, (long)Math.floor((double)l2 / 2.0));
        ++this.nextSegmentNumber;
        SWDownloadSegment sWDownloadSegment3 = sWDownloadSegment.getNextDownloadSegment();
        sWDownloadSegment2.setNextDownloadSegment(sWDownloadSegment3);
        sWDownloadSegment.setNextDownloadSegment(sWDownloadSegment2);
        int n = this.downloadSegments.size();
        this.downloadSegments.add(n, sWDownloadSegment2);
        this.fireDownloadSegmentAdded(n);
        this.logDownloadSegments();
        Logger.logMessage(Logger.FINE, (short)2, "Splitted segment: " + sWDownloadSegment + " - New Segment: " + sWDownloadSegment2);
        SwarmingManager.getInstance().triggerSaveDownloadList();
        return sWDownloadSegment2;
    }

    private SWDownloadSegment splitDownloadSegment(SWDownloadSegment sWDownloadSegment, long l, long l2) {
        if (!this.isSplitAllowed(sWDownloadSegment, l, l2)) {
            return null;
        }
        long l3 = sWDownloadSegment.getTransferStartPosition() + 131072L;
        long l4 = sWDownloadSegment.getEndOffset();
        if (l < l3) {
            l = l3;
            l2 = Math.min(l2, l4 - 131072L);
        } else if (l2 > l4) {
            l2 = l4;
            l = Math.max(l, l3);
        } else {
            l = Math.max(l, l3);
            l2 = Math.min(l2, l4 - 131072L);
        }
        long l5 = l - sWDownloadSegment.getStartOffset();
        sWDownloadSegment.setTransferDataSize(l5);
        SWDownloadSegment sWDownloadSegment2 = new SWDownloadSegment(this, this.nextSegmentNumber, l, l2 - l);
        ++this.nextSegmentNumber;
        SWDownloadSegment sWDownloadSegment3 = sWDownloadSegment.getNextDownloadSegment();
        sWDownloadSegment2.setNextDownloadSegment(sWDownloadSegment3);
        sWDownloadSegment.setNextDownloadSegment(sWDownloadSegment2);
        int n = this.downloadSegments.size();
        this.downloadSegments.add(n, sWDownloadSegment2);
        this.fireDownloadSegmentAdded(n);
        SWDownloadSegment sWDownloadSegment4 = null;
        if (l2 < l4) {
            sWDownloadSegment4 = new SWDownloadSegment(this, this.nextSegmentNumber, l2, l4 - l2);
            ++this.nextSegmentNumber;
            sWDownloadSegment3 = sWDownloadSegment2.getNextDownloadSegment();
            sWDownloadSegment4.setNextDownloadSegment(sWDownloadSegment3);
            sWDownloadSegment2.setNextDownloadSegment(sWDownloadSegment4);
            n = this.downloadSegments.size();
            this.downloadSegments.add(n, sWDownloadSegment4);
            this.fireDownloadSegmentAdded(n);
        }
        this.logDownloadSegments();
        Logger.logMessage(Logger.FINE, (short)2, "Splitted segment: " + sWDownloadSegment + " - New Segment: " + sWDownloadSegment2 + " - End Segment: " + sWDownloadSegment4);
        SwarmingManager.getInstance().triggerSaveDownloadList();
        return sWDownloadSegment2;
    }

    private void createDownloadSegments() {
        this.nextSegmentNumber = 0;
        if (ServiceManager.sCfg.downloadSplitType == 0) {
            this.downloadSegments = new ArrayList();
            SWDownloadSegment sWDownloadSegment = new SWDownloadSegment(this, this.nextSegmentNumber, 0L, this.fileSize);
            this.downloadSegments.add(sWDownloadSegment);
            ++this.nextSegmentNumber;
        } else if (ServiceManager.sCfg.downloadSplitType == 2) {
            int n = ServiceManager.sCfg.downloadSplitValue;
            long l = (long)Math.ceil((double)this.fileSize / (double)n);
            this.downloadSegments = new ArrayList(n);
            this.splitDownloadSegments(l);
        } else if (ServiceManager.sCfg.downloadSplitType == 1) {
            long l = (long)ServiceManager.sCfg.downloadSplitValue * 0x100000L;
            int n = (int)Math.ceil(this.fileSize / l);
            this.downloadSegments = new ArrayList(n);
            this.splitDownloadSegments(l);
        } else {
            throw new RuntimeException("Unknown Download split type: " + ServiceManager.sCfg.downloadSplitType);
        }
        this.logDownloadSegments();
    }

    private void splitDownloadSegments(long l) {
        long l2 = 0L;
        int n = 0;
        SWDownloadSegment sWDownloadSegment = null;
        SWDownloadSegment sWDownloadSegment2 = null;
        while (l2 < this.fileSize) {
            n = (int)Math.min(l, this.fileSize - l2);
            sWDownloadSegment = new SWDownloadSegment(this, this.nextSegmentNumber, l2, n);
            this.downloadSegments.add(sWDownloadSegment);
            if (sWDownloadSegment2 != null) {
                sWDownloadSegment2.setNextDownloadSegment(sWDownloadSegment);
            }
            sWDownloadSegment2 = sWDownloadSegment;
            l2 += (long)n;
            ++this.nextSegmentNumber;
        }
    }

    private void createDownloadSegments(XJBSWDownloadFile xJBSWDownloadFile) {
        this.downloadSegments = new ArrayList();
        SWDownloadSegment sWDownloadSegment = null;
        this.nextSegmentNumber = 0;
        ArrayList arrayList = new ArrayList();
        Iterator iterator = xJBSWDownloadFile.getSegmentList().iterator();
        while (iterator.hasNext()) {
            arrayList.add(iterator.next());
        }
        Collections.sort(arrayList, new SWDownloadSegmentComparator());
        iterator = arrayList.iterator();
        while (iterator.hasNext()) {
            XJBSWDownloadSegment xJBSWDownloadSegment = (XJBSWDownloadSegment)iterator.next();
            SWDownloadSegment sWDownloadSegment2 = new SWDownloadSegment(this, xJBSWDownloadSegment);
            this.downloadSegments.add(sWDownloadSegment2);
            if (sWDownloadSegment != null) {
                sWDownloadSegment.setNextDownloadSegment(sWDownloadSegment2);
            }
            this.nextSegmentNumber = Math.max(xJBSWDownloadSegment.getSegmentNumber() + 1, this.nextSegmentNumber);
            sWDownloadSegment = sWDownloadSegment2;
        }
        ++this.nextSegmentNumber;
        this.logDownloadSegments();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createDownloadCandidates(XJBSWDownloadFile xJBSWDownloadFile) {
        ArrayList arrayList = this.downloadCandidates;
        synchronized (arrayList) {
            this.downloadCandidates.clear();
            Iterator iterator = xJBSWDownloadFile.getCandidateList().iterator();
            while (iterator.hasNext()) {
                try {
                    XJBSWDownloadCandidate xJBSWDownloadCandidate = (XJBSWDownloadCandidate)iterator.next();
                    SWDownloadCandidate sWDownloadCandidate = new SWDownloadCandidate(xJBSWDownloadCandidate, this);
                    Logger.logMessage(Logger.FINE, (short)2, "Adding download candidate " + sWDownloadCandidate);
                    int n = this.downloadCandidates.size();
                    this.downloadCandidates.add(n, sWDownloadCandidate);
                    this.fireDownloadCandidateAdded(n);
                }
                catch (Exception exception) {
                    Logger.logError(exception, "Error loading a download candidate from XML.");
                }
            }
            Collections.sort(this.downloadCandidates, candidatesComparator);
        }
        SwarmingManager.getInstance().notifyWaitingWorkers();
    }

    private void logDownloadSegments() {
    }

    public void addDownloadCandidatesChangeListener(DownloadCandidatesChangeListener downloadCandidatesChangeListener) {
        this.listenerList.add(class$phex$event$DownloadCandidatesChangeListener == null ? (class$phex$event$DownloadCandidatesChangeListener = SWDownloadFile.class$("phex.event.DownloadCandidatesChangeListener")) : class$phex$event$DownloadCandidatesChangeListener, downloadCandidatesChangeListener);
    }

    public void removeDownloadCandidatesChangeListener(DownloadCandidatesChangeListener downloadCandidatesChangeListener) {
        this.listenerList.remove(class$phex$event$DownloadCandidatesChangeListener == null ? (class$phex$event$DownloadCandidatesChangeListener = SWDownloadFile.class$("phex.event.DownloadCandidatesChangeListener")) : class$phex$event$DownloadCandidatesChangeListener, downloadCandidatesChangeListener);
    }

    private void fireDownloadCandidateChanged(final int n) {
        AsynchronousDispatcher.invokeLater(new Runnable(){

            public void run() {
                EventListener[] eventListenerArray = SWDownloadFile.this.listenerList.getListeners(class$phex$event$DownloadCandidatesChangeListener == null ? (class$phex$event$DownloadCandidatesChangeListener = SWDownloadFile.class$("phex.event.DownloadCandidatesChangeListener")) : class$phex$event$DownloadCandidatesChangeListener);
                int n2 = eventListenerArray.length - 1;
                while (n2 >= 0) {
                    DownloadCandidatesChangeListener downloadCandidatesChangeListener = (DownloadCandidatesChangeListener)eventListenerArray[n2];
                    downloadCandidatesChangeListener.downloadCandidateChanged(n);
                    --n2;
                }
            }
        });
    }

    private void fireDownloadCandidateAdded(final int n) {
        AsynchronousDispatcher.invokeLater(new Runnable(){

            public void run() {
                EventListener[] eventListenerArray = SWDownloadFile.this.listenerList.getListeners(class$phex$event$DownloadCandidatesChangeListener == null ? (class$phex$event$DownloadCandidatesChangeListener = SWDownloadFile.class$("phex.event.DownloadCandidatesChangeListener")) : class$phex$event$DownloadCandidatesChangeListener);
                int n2 = eventListenerArray.length - 1;
                while (n2 >= 0) {
                    DownloadCandidatesChangeListener downloadCandidatesChangeListener = (DownloadCandidatesChangeListener)eventListenerArray[n2];
                    downloadCandidatesChangeListener.downloadCandidateAdded(n);
                    --n2;
                }
            }
        });
    }

    private void fireDownloadCandidateRemoved(final int n) {
        AsynchronousDispatcher.invokeLater(new Runnable(){

            public void run() {
                EventListener[] eventListenerArray = SWDownloadFile.this.listenerList.getListeners(class$phex$event$DownloadCandidatesChangeListener == null ? (class$phex$event$DownloadCandidatesChangeListener = SWDownloadFile.class$("phex.event.DownloadCandidatesChangeListener")) : class$phex$event$DownloadCandidatesChangeListener);
                int n2 = eventListenerArray.length - 1;
                while (n2 >= 0) {
                    DownloadCandidatesChangeListener downloadCandidatesChangeListener = (DownloadCandidatesChangeListener)eventListenerArray[n2];
                    downloadCandidatesChangeListener.downloadCandidateRemoved(n);
                    --n2;
                }
            }
        });
    }

    public void fireDownloadCandidateChanged(SWDownloadCandidate sWDownloadCandidate) {
        int n = this.downloadCandidates.indexOf(sWDownloadCandidate);
        if (n >= 0) {
            this.fireDownloadCandidateChanged(n);
        }
    }

    public void addDownloadSegmentChangeListener(DownloadSegmentsChangeListener downloadSegmentsChangeListener) {
        this.listenerList.add(class$phex$event$DownloadSegmentsChangeListener == null ? (class$phex$event$DownloadSegmentsChangeListener = SWDownloadFile.class$("phex.event.DownloadSegmentsChangeListener")) : class$phex$event$DownloadSegmentsChangeListener, downloadSegmentsChangeListener);
    }

    public void removeDownloadSegmentChangeListener(DownloadSegmentsChangeListener downloadSegmentsChangeListener) {
        this.listenerList.remove(class$phex$event$DownloadSegmentsChangeListener == null ? (class$phex$event$DownloadSegmentsChangeListener = SWDownloadFile.class$("phex.event.DownloadSegmentsChangeListener")) : class$phex$event$DownloadSegmentsChangeListener, downloadSegmentsChangeListener);
    }

    private void fireDownloadSegmentChanged(final int n) {
        AsynchronousDispatcher.invokeLater(new Runnable(){

            public void run() {
                EventListener[] eventListenerArray = SWDownloadFile.this.listenerList.getListeners(class$phex$event$DownloadSegmentsChangeListener == null ? (class$phex$event$DownloadSegmentsChangeListener = SWDownloadFile.class$("phex.event.DownloadSegmentsChangeListener")) : class$phex$event$DownloadSegmentsChangeListener);
                int n2 = eventListenerArray.length - 1;
                while (n2 >= 0) {
                    DownloadSegmentsChangeListener downloadSegmentsChangeListener = (DownloadSegmentsChangeListener)eventListenerArray[n2];
                    downloadSegmentsChangeListener.downloadSegmentChanged(n);
                    --n2;
                }
            }
        });
    }

    private void fireDownloadSegmentAdded(final int n) {
        AsynchronousDispatcher.invokeLater(new Runnable(){

            public void run() {
                EventListener[] eventListenerArray = SWDownloadFile.this.listenerList.getListeners(class$phex$event$DownloadSegmentsChangeListener == null ? (class$phex$event$DownloadSegmentsChangeListener = SWDownloadFile.class$("phex.event.DownloadSegmentsChangeListener")) : class$phex$event$DownloadSegmentsChangeListener);
                int n2 = eventListenerArray.length - 1;
                while (n2 >= 0) {
                    DownloadSegmentsChangeListener downloadSegmentsChangeListener = (DownloadSegmentsChangeListener)eventListenerArray[n2];
                    downloadSegmentsChangeListener.downloadSegmentAdded(n);
                    --n2;
                }
            }
        });
    }

    private void fireDownloadSegmentRemoved(final int n) {
        AsynchronousDispatcher.invokeLater(new Runnable(){

            public void run() {
                EventListener[] eventListenerArray = SWDownloadFile.this.listenerList.getListeners(class$phex$event$DownloadSegmentsChangeListener == null ? (class$phex$event$DownloadSegmentsChangeListener = SWDownloadFile.class$("phex.event.DownloadSegmentsChangeListener")) : class$phex$event$DownloadSegmentsChangeListener);
                int n2 = eventListenerArray.length - 1;
                while (n2 >= 0) {
                    DownloadSegmentsChangeListener downloadSegmentsChangeListener = (DownloadSegmentsChangeListener)eventListenerArray[n2];
                    downloadSegmentsChangeListener.downloadSegmentRemoved(n);
                    --n2;
                }
            }
        });
    }

    public void fireDownloadSegmentChanged(SWDownloadSegment sWDownloadSegment) {
        int n = this.downloadSegments.indexOf(sWDownloadSegment);
        if (n >= 0) {
            this.fireDownloadSegmentChanged(n);
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private static class SWDownloadSegmentComparator
    implements Comparator {
        private SWDownloadSegmentComparator() {
        }

        public int compare(Object object, Object object2) {
            XJBSWDownloadSegment xJBSWDownloadSegment = (XJBSWDownloadSegment)object;
            XJBSWDownloadSegment xJBSWDownloadSegment2 = (XJBSWDownloadSegment)object2;
            long l = xJBSWDownloadSegment.getStartPosition() - xJBSWDownloadSegment2.getStartPosition();
            if (l < 0L) {
                return -1;
            }
            if (l > 0L) {
                return 1;
            }
            return 0;
        }
    }

    private static class SWDownloadCandidateComparator
    implements Comparator {
        private SWDownloadCandidateComparator() {
        }

        public int compare(Object object, Object object2) {
            SWDownloadCandidate sWDownloadCandidate = (SWDownloadCandidate)object;
            SWDownloadCandidate sWDownloadCandidate2 = (SWDownloadCandidate)object2;
            return sWDownloadCandidate2.getHostRating() - sWDownloadCandidate.getHostRating();
        }
    }
}

