/*
 * Decompiled with CFR 0.152.
 */
package phex.gui.actions;

import java.awt.event.ActionEvent;
import javax.swing.KeyStroke;
import phex.common.Environment;
import phex.common.ServiceManager;
import phex.gui.actions.FWAction;
import phex.gui.common.DesktopIndicator;
import phex.gui.common.GUIRegistry;
import phex.gui.common.MainFrame;
import phex.gui.dialogs.CloseOptionsDialog;
import phex.utils.Localizer;
import phex.utils.Logger;

public class ExitPhexAction
extends FWAction {
    public ExitPhexAction() {
        super(Localizer.getString("Exit"), GUIRegistry.getInstance().getIconFactory().getIcon("Close"), Localizer.getString("TTTExitPhex"), new Integer(Localizer.getChar("ExitMnemonic")), KeyStroke.getKeyStroke(Localizer.getString("ExitAccelerator")));
    }

    public void actionPerformed(ActionEvent actionEvent) {
        ExitPhexAction.performCloseGUIAction();
    }

    public static void performCloseGUIAction() {
        if (ServiceManager.sCfg.showCloseOptionsDialog) {
            CloseOptionsDialog closeOptionsDialog = new CloseOptionsDialog();
            closeOptionsDialog.show();
            if (!closeOptionsDialog.isOkActivated()) {
                return;
            }
        }
        if (ServiceManager.sCfg.minimizeToBackground) {
            ExitPhexAction.minimizeToBackground();
        } else {
            ExitPhexAction.shutdown();
        }
    }

    private static void minimizeToBackground() {
        GUIRegistry gUIRegistry = GUIRegistry.getInstance();
        DesktopIndicator desktopIndicator = gUIRegistry.getDesktopIndicator();
        MainFrame mainFrame = gUIRegistry.getMainFrame();
        if (mainFrame.getState() != 1) {
            mainFrame.setState(1);
        }
        if (desktopIndicator != null) {
            desktopIndicator.showIndicator();
            mainFrame.hide();
        }
    }

    public static void shutdown() {
        try {
            Environment.getInstance().shutdownManagers();
        }
        catch (Exception exception) {
            Logger.logError(exception);
        }
        GUIRegistry gUIRegistry = GUIRegistry.getInstance();
        try {
            DesktopIndicator desktopIndicator = gUIRegistry.getDesktopIndicator();
            if (desktopIndicator != null) {
                desktopIndicator.hideIndicator();
                desktopIndicator.removeIndicator();
            }
        }
        catch (Exception exception) {
            Logger.logError(exception);
        }
        try {
            gUIRegistry.saveGUISettings();
        }
        catch (Exception exception) {
            Logger.logError(exception);
        }
        gUIRegistry.getMainFrame().dispose();
        System.exit(0);
    }

    public void refreshActionState() {
    }
}

