/*
 * Decompiled with CFR 0.152.
 */
package phex.gui.dialogs.options;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.HashMap;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import phex.common.ServiceManager;
import phex.connection.IncomingListener;
import phex.connection.NetworkManager;
import phex.gui.common.GUIUtils;
import phex.gui.common.IntegerTextField;
import phex.gui.dialogs.options.OptionsSettingsPane;
import phex.utils.Localizer;

public class NetworkPane
extends OptionsSettingsPane {
    private static final String LISTENING_PORT_KEY = "ListeningPort";
    private static final String CONNECTION_TIMEOUT_KEY = "ConnectionTimeout";
    private static final String ERROR_DISPLAY_TIME_KEY = "ErrorDisplayTime";
    private static final String UP_2_UP_CONNECTIONS_KEY = "UP2UPConnections";
    private static final String UP_2_LEAF_CONNECTIONS_KEY = "UP2LeafConnections";
    private static final String UP_2_PEER_CONNECTIONS_KEY = "UP2PeerConnections";
    private static final String LEAF_2_UP_CONNECTIONS_KEY = "Leaf2UPConnections";
    private static final String LEAF_2_PEER_CONNECTIONS_KEY = "Leaf2PeerConnections";
    private static final String PEER_CONNECTIONS_KEY = "PeerConnections";
    private IntegerTextField listeningPortTF;
    private IntegerTextField connectionTimeoutTF;
    private IntegerTextField errorDisplayTimeTF;
    private JCheckBox autoConnectChkbx;
    private JCheckBox connectedToLANChkbx;
    private JCheckBox allowToBeUPChkbx;
    private JCheckBox forceToBeUPChkbx;
    private JLabel connectionAsUPLabel;
    private JLabel up2upConnectionsLabel;
    private IntegerTextField up2upConnectionsTF;
    private JLabel up2LeafConnectionsLabel;
    private IntegerTextField up2LeafConnectionsTF;
    private JLabel up2PeerConnectionsLabel;
    private IntegerTextField up2PeerConnectionsTF;
    private JCheckBox allowToBeLeafChkbx;
    private JCheckBox forceUPConnectionsChkbx;
    private JLabel connectionAsLeafLabel;
    private JLabel leaf2upConnectionsLabel;
    private IntegerTextField leaf2upConnectionsTF;
    private JLabel leaf2PeerConnectionsLabel;
    private IntegerTextField leaf2PeerConnectionsTF;
    private IntegerTextField peerConnectionsTF;

    public NetworkPane() {
        super("Network");
    }

    protected void prepareComponent() {
        this.setLayout(new GridBagLayout());
        JPanel jPanel = new JPanel(new GridBagLayout());
        jPanel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), Localizer.getString("NetworkSettings")));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        this.add((Component)jPanel, gridBagConstraints);
        JPanel jPanel2 = new JPanel(new GridBagLayout());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = new Insets(3, 0, 5, 0);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        jPanel.add((Component)jPanel2, gridBagConstraints);
        JLabel jLabel = new JLabel(Localizer.getString(LISTENING_PORT_KEY) + ": ");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = new Insets(0, 0, 3, 0);
        jPanel2.add((Component)jLabel, gridBagConstraints);
        this.listeningPortTF = new IntegerTextField(String.valueOf(ServiceManager.sCfg.mListeningPort), 5, 5);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = new Insets(0, 0, 3, 5);
        jPanel2.add((Component)this.listeningPortTF, gridBagConstraints);
        jLabel = new JLabel(Localizer.getString(CONNECTION_TIMEOUT_KEY) + ": ");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = new Insets(0, 0, 3, 0);
        jPanel2.add((Component)jLabel, gridBagConstraints);
        this.connectionTimeoutTF = new IntegerTextField(String.valueOf(ServiceManager.sCfg.mNetConnectionTimeout / 1000), 3, 3);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = new Insets(0, 0, 3, 5);
        jPanel2.add((Component)this.connectionTimeoutTF, gridBagConstraints);
        jLabel = new JLabel(Localizer.getString(ERROR_DISPLAY_TIME_KEY) + ": ");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = new Insets(0, 0, 3, 0);
        jPanel2.add((Component)jLabel, gridBagConstraints);
        this.errorDisplayTimeTF = new IntegerTextField(String.valueOf(ServiceManager.sCfg.hostErrorDisplayTime / 1000), 2, 2);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = new Insets(0, 0, 3, 0);
        jPanel2.add((Component)this.errorDisplayTimeTF, gridBagConstraints);
        this.autoConnectChkbx = new JCheckBox(Localizer.getString("AutoConnectOnStartup"), ServiceManager.sCfg.mAutoConnect);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.gridwidth = 4;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = new Insets(0, 0, 0, 0);
        jPanel2.add((Component)this.autoConnectChkbx, gridBagConstraints);
        this.connectedToLANChkbx = new JCheckBox(Localizer.getString("ConnectedToLAN"), ServiceManager.sCfg.connectedToLAN);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.gridwidth = 4;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = new Insets(0, 0, 0, 0);
        jPanel2.add((Component)this.connectedToLANChkbx, gridBagConstraints);
        JPanel jPanel3 = new JPanel(new GridBagLayout());
        jPanel3.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), Localizer.getString("ConnectionSettings")));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.add((Component)jPanel3, gridBagConstraints);
        JPanel jPanel4 = new JPanel(new GridBagLayout());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 7;
        gridBagConstraints.gridwidth = 4;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 0, 3, 0);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        jPanel3.add((Component)jPanel4, gridBagConstraints);
        JPanel jPanel5 = new JPanel(new GridBagLayout());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 0, 0, 0);
        gridBagConstraints.weightx = 1.0;
        jPanel4.add((Component)jPanel5, gridBagConstraints);
        this.allowToBeUPChkbx = new JCheckBox(Localizer.getString("AllowToBecomeUltrapeer"), ServiceManager.sCfg.allowToBecomeUP);
        this.allowToBeUPChkbx.setToolTipText(Localizer.getString("TTTAllowToBecomeUltrapeer"));
        this.allowToBeUPChkbx.addActionListener(new CheckboxActionListener());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = new Insets(0, 0, 0, 0);
        jPanel5.add((Component)this.allowToBeUPChkbx, gridBagConstraints);
        this.forceToBeUPChkbx = new JCheckBox(Localizer.getString("ForceToBeUltrapeer"), ServiceManager.sCfg.forceToBeUltrapeer);
        this.forceToBeUPChkbx.setToolTipText(Localizer.getString("TTTForceToBeUltrapeer"));
        this.forceToBeUPChkbx.addActionListener(new CheckboxActionListener());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(0, 15, 0, 0);
        gridBagConstraints.weightx = 1.0;
        jPanel5.add((Component)this.forceToBeUPChkbx, gridBagConstraints);
        JPanel jPanel6 = new JPanel(new GridBagLayout());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 3, 8, 0);
        gridBagConstraints.weightx = 1.0;
        jPanel4.add((Component)jPanel6, gridBagConstraints);
        this.connectionAsUPLabel = new JLabel(Localizer.getString("ConnectionsAsUltrapeer") + ": ");
        this.connectionAsUPLabel.setToolTipText(Localizer.getString("TTTConnectionsAsUltrapeer"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = new Insets(0, 0, 0, 2);
        jPanel6.add((Component)this.connectionAsUPLabel, gridBagConstraints);
        this.up2upConnectionsLabel = new JLabel(Localizer.getString("ToUltrapeers") + ": ");
        this.up2upConnectionsLabel.setToolTipText(Localizer.getString("TTTToUltrapeers"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = new Insets(0, 0, 0, 0);
        jPanel6.add((Component)this.up2upConnectionsLabel, gridBagConstraints);
        this.up2upConnectionsTF = new IntegerTextField(String.valueOf(ServiceManager.sCfg.up2upConnections), 2, 2);
        this.up2upConnectionsTF.setToolTipText(Localizer.getString("TTTToUltrapeers"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = new Insets(0, 0, 0, 5);
        jPanel6.add((Component)this.up2upConnectionsTF, gridBagConstraints);
        this.up2LeafConnectionsLabel = new JLabel(Localizer.getString("ToLeafs") + ": ");
        this.up2LeafConnectionsLabel.setToolTipText(Localizer.getString("TTTToLeafs"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = new Insets(0, 0, 0, 0);
        jPanel6.add((Component)this.up2LeafConnectionsLabel, gridBagConstraints);
        this.up2LeafConnectionsTF = new IntegerTextField(String.valueOf(ServiceManager.sCfg.up2leafConnections), 2, 2);
        this.up2LeafConnectionsTF.setToolTipText(Localizer.getString("TTTToLeafs"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = new Insets(0, 0, 0, 5);
        jPanel6.add((Component)this.up2LeafConnectionsTF, gridBagConstraints);
        this.up2PeerConnectionsLabel = new JLabel(Localizer.getString("ToPeers") + ": ");
        this.up2PeerConnectionsLabel.setToolTipText(Localizer.getString("TTTToPeers"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 5;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = new Insets(0, 0, 0, 0);
        jPanel6.add((Component)this.up2PeerConnectionsLabel, gridBagConstraints);
        this.up2PeerConnectionsTF = new IntegerTextField(String.valueOf(ServiceManager.sCfg.up2peerConnections), 2, 2);
        this.up2PeerConnectionsTF.setToolTipText(Localizer.getString("TTTToPeers"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 6;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = new Insets(0, 0, 0, 0);
        gridBagConstraints.weightx = 1.0;
        jPanel6.add((Component)this.up2PeerConnectionsTF, gridBagConstraints);
        JPanel jPanel7 = new JPanel(new GridBagLayout());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 0, 0, 0);
        gridBagConstraints.weightx = 1.0;
        jPanel4.add((Component)jPanel7, gridBagConstraints);
        this.allowToBeLeafChkbx = new JCheckBox(Localizer.getString("AllowToBecomeLeaf"), ServiceManager.sCfg.allowToBecomeLeaf);
        this.allowToBeLeafChkbx.setToolTipText(Localizer.getString("TTTAllowToBecomeLeaf"));
        this.allowToBeLeafChkbx.addActionListener(new CheckboxActionListener());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = new Insets(0, 0, 0, 0);
        jPanel7.add((Component)this.allowToBeLeafChkbx, gridBagConstraints);
        this.forceUPConnectionsChkbx = new JCheckBox(Localizer.getString("AcceptOnlyUltrapeers"), ServiceManager.sCfg.forceUPConnections);
        this.forceUPConnectionsChkbx.setToolTipText(Localizer.getString("TTTAcceptOnlyUltrapeers"));
        this.forceUPConnectionsChkbx.addActionListener(new CheckboxActionListener());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = new Insets(0, 15, 0, 0);
        gridBagConstraints.weightx = 1.0;
        jPanel7.add((Component)this.forceUPConnectionsChkbx, gridBagConstraints);
        JPanel jPanel8 = new JPanel(new GridBagLayout());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 3, 12, 0);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        jPanel4.add((Component)jPanel8, gridBagConstraints);
        this.connectionAsLeafLabel = new JLabel(Localizer.getString("ConnectionsAsLeaf") + ": ");
        this.connectionAsLeafLabel.setToolTipText(Localizer.getString("TTTConnectionsAsLeaf"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = new Insets(0, 0, 0, 3);
        jPanel8.add((Component)this.connectionAsLeafLabel, gridBagConstraints);
        this.leaf2upConnectionsLabel = new JLabel(Localizer.getString("ToUltrapeers") + ": ");
        this.leaf2upConnectionsLabel.setToolTipText(Localizer.getString("TTTToUltrapeers"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = new Insets(0, 0, 0, 0);
        jPanel8.add((Component)this.leaf2upConnectionsLabel, gridBagConstraints);
        this.leaf2upConnectionsTF = new IntegerTextField(String.valueOf(ServiceManager.sCfg.leaf2upConnections), 2, 2);
        this.leaf2upConnectionsTF.setToolTipText(Localizer.getString("TTTToUltrapeers"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = new Insets(0, 0, 0, 5);
        jPanel8.add((Component)this.leaf2upConnectionsTF, gridBagConstraints);
        this.leaf2PeerConnectionsLabel = new JLabel(Localizer.getString("ToPeers") + ": ");
        this.leaf2PeerConnectionsLabel.setToolTipText(Localizer.getString("TTTToPeers"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = new Insets(0, 0, 0, 0);
        jPanel8.add((Component)this.leaf2PeerConnectionsLabel, gridBagConstraints);
        this.leaf2PeerConnectionsTF = new IntegerTextField(String.valueOf(ServiceManager.sCfg.leaf2peerConnections), 2, 2);
        this.leaf2PeerConnectionsTF.setToolTipText(Localizer.getString("TTTToPeers"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = new Insets(0, 0, 0, 5);
        gridBagConstraints.weightx = 1.0;
        jPanel8.add((Component)this.leaf2PeerConnectionsTF, gridBagConstraints);
        JPanel jPanel9 = new JPanel(new GridBagLayout());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 3, 0, 0);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        jPanel4.add((Component)jPanel9, gridBagConstraints);
        jLabel = new JLabel(Localizer.getString("ConnectionsAsPeer") + ": ");
        jLabel.setToolTipText(Localizer.getString("TTTConnectionsAsPeer"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = new Insets(0, 0, 0, 3);
        jPanel9.add((Component)jLabel, gridBagConstraints);
        jLabel = new JLabel(Localizer.getString("ToPeers") + ": ");
        jLabel.setToolTipText(Localizer.getString("TTTToPeers"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = new Insets(0, 0, 0, 0);
        jPanel9.add((Component)jLabel, gridBagConstraints);
        this.peerConnectionsTF = new IntegerTextField(String.valueOf(ServiceManager.sCfg.peerConnections), 2, 2);
        this.peerConnectionsTF.setToolTipText(Localizer.getString("TTTToPeers"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = new Insets(0, 0, 0, 5);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        jPanel9.add((Component)this.peerConnectionsTF, gridBagConstraints);
        this.refreshEnableState();
    }

    public void checkInput(HashMap hashMap) {
        Integer n;
        String string;
        try {
            string = this.listeningPortTF.getText();
            n = new Integer(string);
            hashMap.put(LISTENING_PORT_KEY, n);
        }
        catch (NumberFormatException numberFormatException) {
            hashMap.put("NumberFormatError", this.listeningPortTF);
            this.setInputValid(hashMap, false);
            return;
        }
        try {
            string = this.connectionTimeoutTF.getText();
            n = new Integer(string);
            hashMap.put(CONNECTION_TIMEOUT_KEY, n);
        }
        catch (NumberFormatException numberFormatException) {
            hashMap.put("NumberFormatError", this.connectionTimeoutTF);
            this.setInputValid(hashMap, false);
            return;
        }
        try {
            string = this.errorDisplayTimeTF.getText();
            n = new Integer(string);
            hashMap.put(ERROR_DISPLAY_TIME_KEY, n);
        }
        catch (NumberFormatException numberFormatException) {
            hashMap.put("NumberFormatError", this.errorDisplayTimeTF);
            this.setInputValid(hashMap, false);
            return;
        }
        try {
            string = this.up2upConnectionsTF.getText();
            n = new Integer(string);
            hashMap.put(UP_2_UP_CONNECTIONS_KEY, n);
        }
        catch (NumberFormatException numberFormatException) {
            hashMap.put("NumberFormatError", this.up2upConnectionsTF);
            this.setInputValid(hashMap, false);
            return;
        }
        try {
            string = this.up2LeafConnectionsTF.getText();
            n = new Integer(string);
            hashMap.put(UP_2_LEAF_CONNECTIONS_KEY, n);
        }
        catch (NumberFormatException numberFormatException) {
            hashMap.put("NumberFormatError", this.up2LeafConnectionsTF);
            this.setInputValid(hashMap, false);
            return;
        }
        try {
            string = this.up2PeerConnectionsTF.getText();
            n = new Integer(string);
            hashMap.put(UP_2_PEER_CONNECTIONS_KEY, n);
        }
        catch (NumberFormatException numberFormatException) {
            hashMap.put("NumberFormatError", this.up2PeerConnectionsTF);
            this.setInputValid(hashMap, false);
            return;
        }
        try {
            string = this.leaf2upConnectionsTF.getText();
            n = new Integer(string);
            hashMap.put(LEAF_2_UP_CONNECTIONS_KEY, n);
        }
        catch (NumberFormatException numberFormatException) {
            hashMap.put("NumberFormatError", this.leaf2upConnectionsTF);
            this.setInputValid(hashMap, false);
            return;
        }
        try {
            string = this.leaf2PeerConnectionsTF.getText();
            n = new Integer(string);
            hashMap.put(LEAF_2_PEER_CONNECTIONS_KEY, n);
        }
        catch (NumberFormatException numberFormatException) {
            hashMap.put("NumberFormatError", this.leaf2PeerConnectionsTF);
            this.setInputValid(hashMap, false);
            return;
        }
        try {
            string = this.peerConnectionsTF.getText();
            n = new Integer(string);
            hashMap.put(PEER_CONNECTIONS_KEY, n);
        }
        catch (NumberFormatException numberFormatException) {
            hashMap.put("NumberFormatError", this.peerConnectionsTF);
            this.setInputValid(hashMap, false);
            return;
        }
        this.setInputValid(hashMap, true);
    }

    public void displayErrorMessage(HashMap hashMap) {
        if (hashMap.containsKey("NumberFormatError")) {
            this.displayNumberFormatError(hashMap);
        }
    }

    public void saveAndApplyChanges(HashMap hashMap) {
        Integer n;
        int n2;
        Integer n3;
        int n4;
        Integer n5;
        int n6;
        Integer n7;
        int n8;
        Integer n9;
        int n10;
        Integer n11;
        int n12;
        boolean bl;
        boolean bl2;
        boolean bl3;
        boolean bl4;
        boolean bl5;
        boolean bl6;
        Integer n13;
        int n14;
        int n15;
        Object object;
        Integer n16 = (Integer)hashMap.get(LISTENING_PORT_KEY);
        int n17 = n16;
        if (ServiceManager.sCfg.mListeningPort != n17) {
            ServiceManager.sCfg.mListeningPort = n17;
            OptionsSettingsPane.triggerConfigSave(hashMap);
            object = NetworkManager.getInstance().getIncomingListener();
            try {
                ((IncomingListener)object).restart();
            }
            catch (Exception exception) {
                GUIUtils.showErrorMessage(Localizer.getString("FailedToListenOnNewPort"), Localizer.getString("ListenerError"));
            }
        }
        if (ServiceManager.sCfg.mNetConnectionTimeout != (n15 = (Integer)(object = (Integer)hashMap.get(CONNECTION_TIMEOUT_KEY)) * 1000)) {
            ServiceManager.sCfg.mNetConnectionTimeout = n15;
            OptionsSettingsPane.triggerConfigSave(hashMap);
        }
        if (ServiceManager.sCfg.hostErrorDisplayTime != (n14 = (n13 = (Integer)hashMap.get(ERROR_DISPLAY_TIME_KEY)) * 1000)) {
            ServiceManager.sCfg.hostErrorDisplayTime = n14;
            OptionsSettingsPane.triggerConfigSave(hashMap);
        }
        if (ServiceManager.sCfg.mAutoConnect != (bl6 = this.autoConnectChkbx.isSelected())) {
            ServiceManager.sCfg.mAutoConnect = bl6;
            OptionsSettingsPane.triggerConfigSave(hashMap);
        }
        if (ServiceManager.sCfg.connectedToLAN != (bl5 = this.connectedToLANChkbx.isSelected())) {
            ServiceManager.sCfg.connectedToLAN = bl5;
            OptionsSettingsPane.triggerConfigSave(hashMap);
        }
        if (ServiceManager.sCfg.allowToBecomeLeaf != (bl4 = this.allowToBeLeafChkbx.isSelected())) {
            ServiceManager.sCfg.allowToBecomeLeaf = bl4;
            OptionsSettingsPane.triggerConfigSave(hashMap);
        }
        if (ServiceManager.sCfg.forceUPConnections != (bl3 = this.forceUPConnectionsChkbx.isSelected())) {
            ServiceManager.sCfg.forceUPConnections = bl3;
            OptionsSettingsPane.triggerConfigSave(hashMap);
        }
        if (ServiceManager.sCfg.allowToBecomeUP != (bl2 = this.allowToBeUPChkbx.isSelected())) {
            ServiceManager.sCfg.allowToBecomeUP = bl2;
            OptionsSettingsPane.triggerConfigSave(hashMap);
        }
        if (ServiceManager.sCfg.forceToBeUltrapeer != (bl = this.forceToBeUPChkbx.isSelected())) {
            ServiceManager.sCfg.forceToBeUltrapeer = bl;
            OptionsSettingsPane.triggerConfigSave(hashMap);
        }
        if (ServiceManager.sCfg.up2upConnections != (n12 = (n11 = (Integer)hashMap.get(UP_2_UP_CONNECTIONS_KEY)).intValue())) {
            ServiceManager.sCfg.up2upConnections = n12;
            OptionsSettingsPane.triggerConfigSave(hashMap);
        }
        if (ServiceManager.sCfg.up2leafConnections != (n10 = (n9 = (Integer)hashMap.get(UP_2_LEAF_CONNECTIONS_KEY)).intValue())) {
            ServiceManager.sCfg.up2leafConnections = n10;
            OptionsSettingsPane.triggerConfigSave(hashMap);
        }
        if (ServiceManager.sCfg.up2peerConnections != (n8 = (n7 = (Integer)hashMap.get(UP_2_PEER_CONNECTIONS_KEY)).intValue())) {
            ServiceManager.sCfg.up2peerConnections = n8;
            OptionsSettingsPane.triggerConfigSave(hashMap);
        }
        if (ServiceManager.sCfg.leaf2upConnections != (n6 = (n5 = (Integer)hashMap.get(LEAF_2_UP_CONNECTIONS_KEY)).intValue())) {
            ServiceManager.sCfg.leaf2upConnections = n6;
            OptionsSettingsPane.triggerConfigSave(hashMap);
        }
        if (ServiceManager.sCfg.leaf2peerConnections != (n4 = (n3 = (Integer)hashMap.get(LEAF_2_PEER_CONNECTIONS_KEY)).intValue())) {
            ServiceManager.sCfg.leaf2peerConnections = n4;
            OptionsSettingsPane.triggerConfigSave(hashMap);
        }
        if (ServiceManager.sCfg.peerConnections != (n2 = (n = (Integer)hashMap.get(PEER_CONNECTIONS_KEY)).intValue())) {
            ServiceManager.sCfg.peerConnections = n2;
            OptionsSettingsPane.triggerConfigSave(hashMap);
        }
    }

    private void refreshEnableState() {
        this.connectionAsUPLabel.setEnabled(this.allowToBeUPChkbx.isSelected());
        this.up2LeafConnectionsLabel.setEnabled(this.allowToBeUPChkbx.isSelected());
        this.up2LeafConnectionsTF.setEnabled(this.allowToBeUPChkbx.isSelected());
        this.up2PeerConnectionsLabel.setEnabled(this.allowToBeUPChkbx.isSelected());
        this.up2PeerConnectionsTF.setEnabled(this.allowToBeUPChkbx.isSelected());
        this.up2upConnectionsLabel.setEnabled(this.allowToBeUPChkbx.isSelected());
        this.up2upConnectionsTF.setEnabled(this.allowToBeUPChkbx.isSelected());
        this.forceToBeUPChkbx.setEnabled(this.allowToBeUPChkbx.isSelected());
        this.connectionAsLeafLabel.setEnabled(this.allowToBeLeafChkbx.isSelected());
        this.forceUPConnectionsChkbx.setEnabled(this.allowToBeLeafChkbx.isSelected());
        this.leaf2PeerConnectionsLabel.setEnabled(this.allowToBeLeafChkbx.isSelected());
        this.leaf2PeerConnectionsTF.setEnabled(this.allowToBeLeafChkbx.isSelected());
        this.leaf2upConnectionsLabel.setEnabled(this.allowToBeLeafChkbx.isSelected());
        this.leaf2upConnectionsTF.setEnabled(this.allowToBeLeafChkbx.isSelected());
    }

    class CheckboxActionListener
    implements ActionListener {
        CheckboxActionListener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            Object object = actionEvent.getSource();
            if (object == NetworkPane.this.forceToBeUPChkbx) {
                NetworkPane.this.forceUPConnectionsChkbx.setSelected(false);
            } else if (object == NetworkPane.this.forceUPConnectionsChkbx) {
                NetworkPane.this.forceToBeUPChkbx.setSelected(false);
            } else {
                NetworkPane.this.refreshEnableState();
            }
        }
    }
}

