/*
 * Decompiled with CFR 0.152.
 */
package phex.gui.models;

import java.util.Comparator;
import javax.swing.ListSelectionModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TableModelEvent;
import phex.download.swarming.SWDownloadCandidate;
import phex.download.swarming.SWDownloadFile;
import phex.download.swarming.SWDownloadInfo;
import phex.download.swarming.SWDownloadSegment;
import phex.download.swarming.SwarmingManager;
import phex.event.DownloadCandidatesChangeListener;
import phex.gui.common.FWTable;
import phex.gui.common.GUIRegistry;
import phex.gui.common.LazyEventQueue;
import phex.gui.comparator.TransferRateComparator;
import phex.gui.comparator.TransferSizeComparator;
import phex.gui.models.FWTableModel;
import phex.utils.Localizer;

public class SWCandidateTableModel
extends FWTableModel {
    public static final int HOST_COLUMN_ID = 1001;
    public static final int VENDOR_COLUMN_ID = 1002;
    public static final int PROGRESS_COLUMN_ID = 1003;
    public static final int SIZE_COLUMN_ID = 1004;
    public static final int RATE_COLUMN_ID = 1005;
    public static final int STATUS_COLUMN_ID = 1006;
    public static final int HOST_RATING_COLUMN_ID = 1007;
    public static final int HOST_MODEL_INDEX = 0;
    public static final int VENDOR_MODEL_INDEX = 1;
    public static final int PROGRESS_MODEL_INDEX = 2;
    public static final int SIZE_MODEL_INDEX = 3;
    public static final int RATE_MODEL_INDEX = 4;
    public static final int HOST_RATING_MODEL_INDEX = 5;
    public static final int STATUS_MODEL_INDEX = 6;
    private static String[] tableColumns = new String[]{Localizer.getString("SharingHost"), Localizer.getString("Vendor"), Localizer.getString("PercentSign"), Localizer.getString("Size"), Localizer.getString("Rate"), Localizer.getString("Rating"), Localizer.getString("Status")};
    private static Class[] tableClasses = new Class[]{class$phex$gui$renderer$IPCellRenderer == null ? (class$phex$gui$renderer$IPCellRenderer = SWCandidateTableModel.class$("phex.gui.renderer.IPCellRenderer")) : class$phex$gui$renderer$IPCellRenderer, class$java$lang$String == null ? (class$java$lang$String = SWCandidateTableModel.class$("java.lang.String")) : class$java$lang$String, class$phex$gui$renderer$ProgressCellRenderer == null ? (class$phex$gui$renderer$ProgressCellRenderer = SWCandidateTableModel.class$("phex.gui.renderer.ProgressCellRenderer")) : class$phex$gui$renderer$ProgressCellRenderer, class$phex$gui$renderer$TransferSizeCellRenderer == null ? (class$phex$gui$renderer$TransferSizeCellRenderer = SWCandidateTableModel.class$("phex.gui.renderer.TransferSizeCellRenderer")) : class$phex$gui$renderer$TransferSizeCellRenderer, class$phex$gui$renderer$TransferRateCellRenderer == null ? (class$phex$gui$renderer$TransferRateCellRenderer = SWCandidateTableModel.class$("phex.gui.renderer.TransferRateCellRenderer")) : class$phex$gui$renderer$TransferRateCellRenderer, class$java$lang$Short == null ? (class$java$lang$Short = SWCandidateTableModel.class$("java.lang.Short")) : class$java$lang$Short, class$java$lang$String == null ? (class$java$lang$String = SWCandidateTableModel.class$("java.lang.String")) : class$java$lang$String};
    private SwarmingManager swarmingMgr = SwarmingManager.getInstance();
    private SWDownloadFile downloadFile;
    private FWTable downloadTable;
    private DownloadCandidatesListener changeListener;
    static /* synthetic */ Class class$phex$gui$renderer$IPCellRenderer;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$phex$gui$renderer$ProgressCellRenderer;
    static /* synthetic */ Class class$phex$gui$renderer$TransferSizeCellRenderer;
    static /* synthetic */ Class class$phex$gui$renderer$TransferRateCellRenderer;
    static /* synthetic */ Class class$java$lang$Short;

    public SWCandidateTableModel(FWTable fWTable) {
        super(tableColumns, tableClasses);
        this.downloadTable = fWTable;
        this.downloadTable.getSelectionModel().addListSelectionListener(new DownloadSelectionChangeHandler());
        this.changeListener = new DownloadCandidatesListener();
    }

    public SWDownloadFile getDownloadFile() {
        return this.downloadFile;
    }

    public int getRowCount() {
        if (this.downloadFile == null) {
            return 0;
        }
        return this.downloadFile.getCandidateCount();
    }

    public Object getValueAt(int n, int n2) {
        SWDownloadCandidate sWDownloadCandidate = this.downloadFile.getCandidate(n);
        if (sWDownloadCandidate == null) {
            this.fireTableRowsDeleted(n, n);
            return "";
        }
        switch (n2) {
            case 0: {
                return sWDownloadCandidate.getHostAddress().getFullHostName();
            }
            case 1: {
                return sWDownloadCandidate.getVendor();
            }
            case 2: {
                SWDownloadSegment sWDownloadSegment = sWDownloadCandidate.getDownloadSegment();
                if (sWDownloadSegment == null) {
                    return null;
                }
                return sWDownloadSegment.getProgress();
            }
            case 3: 
            case 4: {
                return sWDownloadCandidate.getDownloadSegment();
            }
            case 5: {
                return sWDownloadCandidate.getHostRatingObject();
            }
            case 6: {
                return SWDownloadInfo.getDownloadCandidateStatusString(sWDownloadCandidate);
            }
        }
        return "";
    }

    public Comparator getColumnComparator(int n) {
        switch (n) {
            case 3: {
                return new TransferSizeComparator();
            }
            case 4: {
                return new TransferRateComparator();
            }
        }
        return null;
    }

    public int mapColumnIDToModelIndex(int n) {
        switch (n) {
            case 1001: {
                return 0;
            }
            case 1002: {
                return 1;
            }
            case 1003: {
                return 2;
            }
            case 1004: {
                return 3;
            }
            case 1005: {
                return 4;
            }
            case 1007: {
                return 5;
            }
            case 1006: {
                return 6;
            }
        }
        return -1;
    }

    public boolean isColumnHideable(int n) {
        return n != 1001;
    }

    public static int[] getColumnIdArray() {
        int[] nArray = new int[]{1001, 1002, 1003, 1004, 1005, 1007, 1006};
        return nArray;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private class DownloadCandidatesListener
    implements DownloadCandidatesChangeListener {
        private LazyEventQueue lazyEventQueue = GUIRegistry.getInstance().getLazyEventQueue();

        public void downloadCandidateChanged(int n) {
            this.lazyEventQueue.addTableModelEvent(new TableModelEvent(SWCandidateTableModel.this, n, n, -1, 0));
        }

        public void downloadCandidateAdded(int n) {
            SWCandidateTableModel.this.fireTableChanged(new TableModelEvent(SWCandidateTableModel.this, n, n, -1, 1));
        }

        public void downloadCandidateRemoved(int n) {
            SWCandidateTableModel.this.fireTableChanged(new TableModelEvent(SWCandidateTableModel.this, n, n, -1, -1));
        }
    }

    private class DownloadSelectionChangeHandler
    implements ListSelectionListener {
        private DownloadSelectionChangeHandler() {
        }

        public void valueChanged(ListSelectionEvent listSelectionEvent) {
            if (!listSelectionEvent.getValueIsAdjusting()) {
                ListSelectionModel listSelectionModel = (ListSelectionModel)listSelectionEvent.getSource();
                int n = listSelectionModel.getLeadSelectionIndex();
                int n2 = SWCandidateTableModel.this.downloadTable.convertRowIndexToModel(n);
                SWDownloadFile sWDownloadFile = SWCandidateTableModel.this.swarmingMgr.getDownloadFile(n2);
                if (sWDownloadFile != SWCandidateTableModel.this.downloadFile) {
                    if (SWCandidateTableModel.this.downloadFile != null) {
                        SWCandidateTableModel.this.downloadFile.removeDownloadCandidatesChangeListener(SWCandidateTableModel.this.changeListener);
                    }
                    SWCandidateTableModel.this.downloadFile = sWDownloadFile;
                    if (SWCandidateTableModel.this.downloadFile != null) {
                        SWCandidateTableModel.this.downloadFile.addDownloadCandidatesChangeListener(SWCandidateTableModel.this.changeListener);
                    }
                    SWCandidateTableModel.this.fireTableDataChanged();
                }
            }
        }
    }
}

