/*
 * Decompiled with CFR 0.152.
 */
package phex.gui.tabs;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Toolkit;
import java.awt.datatransfer.StringSelection;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.File;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.table.TableModel;
import javax.xml.bind.JAXBException;
import phex.common.ServiceManager;
import phex.download.RemoteFile;
import phex.download.swarming.SwarmingManager;
import phex.event.QueryHistoryChangeListener;
import phex.gui.common.FWTable;
import phex.gui.common.GUIRegistry;
import phex.gui.common.GUIUtils;
import phex.gui.common.IntegerTextField;
import phex.gui.common.MainFrame;
import phex.gui.models.FWSortedTableModel;
import phex.gui.models.FWTableColumnModel;
import phex.gui.models.PassiveSearchTableModel;
import phex.gui.models.QueryHistoryMonitorTableModel;
import phex.gui.tabs.FWTab;
import phex.host.MalformedHostAddressException;
import phex.interfaces.IMonitorSearch;
import phex.msg.MsgManager;
import phex.query.QueryHistoryMonitor;
import phex.query.QueryManager;
import phex.utils.IPUtils;
import phex.utils.Localizer;
import phex.utils.StrUtil;
import phex.utils.URLUtil;
import phex.xml.ObjectFactory;
import phex.xml.XJBGUISettings;
import phex.xml.XJBGUITable;
import phex.xml.XJBGUITableColumnList;

public class MonitorTab
extends FWTab
implements IMonitorSearch {
    private static final String PASSIVE_SEARCH_TABLE_IDENTIFIER = "PassiveSearchTable";
    private MainFrame mainFrame;
    private MsgManager mMsgManager;
    private QueryHistoryMonitor queryHistory;
    private JTable mMonitorTable;
    private JScrollPane monitorTableScrollPane;
    private QueryHistoryMonitorTableModel queryHistoryModel;
    private FWTable passiveSearchTable;
    private JScrollPane passiveSearchTableScrollPane;
    private PassiveSearchTableModel passiveSearchModel;
    private FWTableColumnModel passiveSearchColumnModel;
    private JTextField mPassiveSearch;
    private JButton mPassiveButton;
    private JLabel mPassiveStatus;
    private JCheckBox enableMonitorCheckbox;
    private JTextField numberOfMonitorRows;

    public MonitorTab(MainFrame mainFrame) {
        super(1002, Localizer.getString("MonitorSearch"), GUIRegistry.getInstance().getIconFactory().getIcon("Monitor"), Localizer.getString("TTTMonitorSearch"), Localizer.getChar("MonitorSearchMnemonic"), KeyStroke.getKeyStroke(Localizer.getString("MonitorSearchAccelerator")), 2);
        this.mainFrame = mainFrame;
        this.mMsgManager = MsgManager.getInstance();
        this.queryHistory = QueryManager.getInstance().getQueryHistoryMonitor();
        this.mMsgManager.setMonitorSearchListener(this);
    }

    public void initComponent(XJBGUISettings xJBGUISettings) {
        this.setLayout(new BorderLayout());
        JPanel jPanel = new JPanel(new GridBagLayout());
        this.enableMonitorCheckbox = new JCheckBox(Localizer.getString("enable"));
        this.enableMonitorCheckbox.setSelected(this.queryHistory.isHistoryMonitored());
        this.enableMonitorCheckbox.addActionListener(new EnableMonitorActionListener());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.anchor = 12;
        jPanel.add((Component)this.enableMonitorCheckbox, gridBagConstraints);
        this.queryHistoryModel = new QueryHistoryMonitorTableModel();
        this.mMonitorTable = new JTable(this.queryHistoryModel);
        this.queryHistory.setQueryHistoryChangeListener(new QueryHistoryChangeListener(){

            public void queryHistoryChanged() {
                GUIUtils.fireTableChanged(MonitorTab.this.mMonitorTable, MonitorTab.this.queryHistoryModel);
            }
        });
        JPanel jPanel2 = new JPanel(new GridBagLayout());
        JLabel jLabel = new JLabel(Localizer.getString("Show"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.anchor = 14;
        jPanel2.add((Component)jLabel, gridBagConstraints);
        this.numberOfMonitorRows = new IntegerTextField(String.valueOf(this.queryHistory.getMaxHistorySize()), 3, 3);
        this.numberOfMonitorRows.getDocument().addDocumentListener(new MonitorRowsDocumentListener());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.anchor = 14;
        jPanel2.add((Component)this.numberOfMonitorRows, gridBagConstraints);
        jLabel = new JLabel(Localizer.getString("Rows"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 14;
        jPanel2.add((Component)jLabel, gridBagConstraints);
        JPanel jPanel3 = new JPanel(new BorderLayout());
        jPanel3.add("North", jPanel);
        this.monitorTableScrollPane = FWTable.createFWTableScrollPane(this.mMonitorTable);
        jPanel3.add("Center", this.monitorTableScrollPane);
        jPanel3.add("South", jPanel2);
        jPanel3.setBorder(BorderFactory.createTitledBorder(BorderFactory.createLineBorder(this.getBackground().darker()), Localizer.getString("SearchMonitor")));
        JPanel jPanel4 = new JPanel(new BorderLayout());
        this.passiveSearchModel = new PassiveSearchTableModel();
        XJBGUITable xJBGUITable = GUIUtils.getXJBGUITableByIdentifier(xJBGUISettings, PASSIVE_SEARCH_TABLE_IDENTIFIER);
        this.buildPassiveSearchTableColumnModel(xJBGUITable);
        this.passiveSearchTable = new FWTable((TableModel)new FWSortedTableModel(this.passiveSearchModel), this.passiveSearchColumnModel);
        this.passiveSearchTable.activateAllHeaderActions();
        this.passiveSearchTable.setAutoResizeMode(0);
        this.passiveSearchTable.addMouseListener(new MouseHandler());
        JPanel jPanel5 = new JPanel(new BorderLayout());
        jPanel5.setBorder(BorderFactory.createEmptyBorder(8, 0, 0, 0));
        this.mPassiveSearch = new JTextField("", 20);
        this.mPassiveSearch.setToolTipText(Localizer.getString("TTTPassiveSearch"));
        this.mPassiveButton = new JButton(Localizer.getString("StartPassiveSearch"));
        this.mPassiveButton.setToolTipText(Localizer.getString("TTTStartPassiveSearch"));
        this.mPassiveStatus = new JLabel(Localizer.getString("PassiveSearchResult"));
        this.mPassiveButton.addActionListener(new PassiveSearchHandler());
        jPanel5.add("West", new JLabel(Localizer.getString("MonitorFilter") + Localizer.getChar("ColonSign")));
        jPanel5.add("Center", this.mPassiveSearch);
        jPanel5.add("East", this.mPassiveButton);
        jPanel5.add("South", this.mPassiveStatus);
        JPanel jPanel6 = new JPanel(new FlowLayout());
        JButton jButton = new JButton(Localizer.getString("Download"));
        JButton jButton2 = new JButton(Localizer.getString("Clear"));
        jButton.addActionListener(new PassiveDownloadHandler());
        jButton2.addActionListener(new PassiveClearHandler());
        jPanel6.add(jButton);
        jPanel6.add(jButton2);
        jPanel4.add("North", jPanel5);
        this.passiveSearchTableScrollPane = FWTable.createFWTableScrollPane(this.passiveSearchTable);
        jPanel4.add("Center", this.passiveSearchTableScrollPane);
        jPanel4.add("South", jPanel6);
        jPanel4.setBorder(BorderFactory.createTitledBorder(BorderFactory.createLineBorder(this.getBackground().darker()), Localizer.getString("PassiveSearch")));
        jPanel3.setPreferredSize(new Dimension(780, 200));
        jPanel4.setPreferredSize(new Dimension(780, 230));
        JSplitPane jSplitPane = new JSplitPane(0);
        jSplitPane.setBorder(BorderFactory.createEmptyBorder(4, 4, 2, 4));
        jSplitPane.setDividerSize(6);
        jSplitPane.setOneTouchExpandable(true);
        jSplitPane.setTopComponent(jPanel3);
        jSplitPane.setBottomComponent(jPanel4);
        this.add("Center", jSplitPane);
    }

    public void updateUI() {
        super.updateUI();
        if (this.passiveSearchTableScrollPane != null) {
            FWTable.updateFWTableScrollPane(this.passiveSearchTableScrollPane);
        }
        if (this.monitorTableScrollPane != null) {
            FWTable.updateFWTableScrollPane(this.monitorTableScrollPane);
        }
    }

    public RemoteFile getSelectedRemoteFile() {
        int n = this.passiveSearchTable.getSelectedRow();
        if (n < 0) {
            return null;
        }
        int n2 = this.passiveSearchTable.convertRowIndexToModel(n);
        Vector vector = this.mMsgManager.getPassiveResults();
        RemoteFile remoteFile = (RemoteFile)vector.elementAt(n2);
        return remoteFile;
    }

    public void passiveSearch() {
        if (this.mMsgManager.getPassiveSearching() == null) {
            String string = this.mPassiveSearch.getText().trim();
            this.mMsgManager.setPassiveSearching(string);
            this.mPassiveButton.setText(Localizer.getString("StopPassiveSearch"));
            this.mPassiveStatus.setText(Localizer.getString("PassiveSearchResultMonitoring"));
        } else {
            this.mMsgManager.setPassiveSearching(null);
            this.mPassiveButton.setText(Localizer.getString("StartPassiveSearch"));
            this.mPassiveStatus.setText(Localizer.getString("PassiveSearchResult"));
        }
    }

    public void passiveDownload() {
        int[] nArray = this.passiveSearchTable.getSelectedRows();
        if (nArray.length == 0) {
            return;
        }
        int[] nArray2 = this.passiveSearchTable.convertRowIndicesToModel(nArray);
        Vector vector = this.mMsgManager.getPassiveResults();
        int n = 0;
        while (n < nArray2.length) {
            int n2 = nArray2[n];
            RemoteFile remoteFile = (RemoteFile)vector.elementAt(n2);
            RemoteFile remoteFile2 = new RemoteFile(remoteFile);
            String string = StrUtil.createNaturalSearchTerm(remoteFile2.getFilename());
            SwarmingManager.getInstance().addFileToDownload(remoteFile2, ServiceManager.sCfg.mDownloadDir + File.separator + remoteFile2.getFilename(), string);
            ++n;
        }
        this.mainFrame.setSelectedTab(1003);
    }

    public void passiveCopyURL() {
        RemoteFile remoteFile = this.getSelectedRemoteFile();
        String string = URLUtil.buildFileURL(remoteFile);
        Toolkit.getDefaultToolkit().getSystemClipboard().setContents(new StringSelection(string), null);
    }

    public void filterPassiveDownloadHost() {
        int[] nArray = this.passiveSearchTable.getSelectedRows();
        if (nArray.length == 0) {
            return;
        }
        int[] nArray2 = this.passiveSearchTable.convertRowIndicesToModel(nArray);
        Vector vector = this.mMsgManager.getPassiveResults();
        int n = 0;
        while (n < nArray2.length) {
            int n2 = nArray2[n];
            RemoteFile remoteFile = (RemoteFile)vector.elementAt(n2);
            try {
                ServiceManager.sCfg.mFilteredSearchHosts.addElement(IPUtils.splitIP2Parts(remoteFile.getHostAddress().getHostName()));
            }
            catch (MalformedHostAddressException malformedHostAddressException) {
                // empty catch block
            }
            ++n;
        }
        ServiceManager.sCfg.save();
    }

    public boolean isPassiveResultSelected() {
        return this.passiveSearchTable.getSelectedRowCount() > 0;
    }

    private void passiveClearResult() {
        this.mMsgManager.resetPassiveResults();
    }

    public void passiveResultArrived() {
        GUIUtils.fireTableChanged(this.passiveSearchTable, this.passiveSearchModel);
    }

    private void buildPassiveSearchTableColumnModel(XJBGUITable xJBGUITable) {
        int[] nArray = PassiveSearchTableModel.getColumnIdArray();
        XJBGUITableColumnList xJBGUITableColumnList = null;
        if (xJBGUITable != null) {
            xJBGUITableColumnList = xJBGUITable.getTableColumnList();
        }
        this.passiveSearchColumnModel = new FWTableColumnModel(this.passiveSearchModel, nArray, xJBGUITableColumnList);
    }

    public void appendXJBGUISettings(XJBGUISettings xJBGUISettings) throws JAXBException {
        super.appendXJBGUISettings(xJBGUISettings);
        XJBGUITableColumnList xJBGUITableColumnList = this.passiveSearchColumnModel.createXJBGUITableColumnList();
        XJBGUITable xJBGUITable = ObjectFactory.createXJBGUITable();
        xJBGUITable.setTableColumnList(xJBGUITableColumnList);
        xJBGUITable.setTableIdentifier(PASSIVE_SEARCH_TABLE_IDENTIFIER);
        xJBGUISettings.getTableList().getTableList().add(xJBGUITable);
    }

    private class MonitorRowsDocumentListener
    implements DocumentListener {
        private MonitorRowsDocumentListener() {
        }

        public void insertUpdate(DocumentEvent documentEvent) {
            this.updateMonitorRows();
        }

        public void removeUpdate(DocumentEvent documentEvent) {
            this.updateMonitorRows();
        }

        public void changedUpdate(DocumentEvent documentEvent) {
        }

        private void updateMonitorRows() {
            String string = MonitorTab.this.numberOfMonitorRows.getText();
            try {
                int n = Integer.parseInt(string);
                MonitorTab.this.queryHistory.setMaxHistroySize(n);
            }
            catch (NumberFormatException numberFormatException) {}
        }
    }

    private class EnableMonitorActionListener
    implements ActionListener {
        private EnableMonitorActionListener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            MonitorTab.this.queryHistory.setHistoryMonitored(MonitorTab.this.enableMonitorCheckbox.isSelected());
        }
    }

    private class PassiveSearchHandler
    implements ActionListener {
        private PassiveSearchHandler() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            MonitorTab.this.passiveSearch();
        }
    }

    private class MouseHandler
    extends MouseAdapter
    implements MouseListener {
        private MouseHandler() {
        }

        public void mouseClicked(MouseEvent mouseEvent) {
            if (mouseEvent.getClickCount() == 2 && mouseEvent.getSource() == MonitorTab.this.passiveSearchTable) {
                MonitorTab.this.passiveDownload();
            }
        }

        public void mouseReleased(MouseEvent mouseEvent) {
            if (mouseEvent.isPopupTrigger()) {
                this.popupMenu((Component)mouseEvent.getSource(), mouseEvent.getX(), mouseEvent.getY());
            }
        }

        public void mousePressed(MouseEvent mouseEvent) {
            if (mouseEvent.isPopupTrigger()) {
                this.popupMenu((Component)mouseEvent.getSource(), mouseEvent.getX(), mouseEvent.getY());
            }
        }

        private void popupMenu(Component component, int n, int n2) {
            if (component == MonitorTab.this.passiveSearchTable) {
                // empty if block
            }
        }
    }

    private class PassiveDownloadHandler
    implements ActionListener {
        private PassiveDownloadHandler() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            MonitorTab.this.passiveDownload();
        }
    }

    private class PassiveClearHandler
    implements ActionListener {
        private PassiveClearHandler() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            MonitorTab.this.passiveClearResult();
        }
    }
}

