/*
 * Decompiled with CFR 0.152.
 */
package phex.http;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import phex.common.Environment;
import phex.http.HTTPHeader;

public class HTTPHeaders {
    public static final HTTPHeader[] EMPTY_HTTPHEADER_ARRAY = new HTTPHeader[0];
    public static final HTTPHeaders EMPTY_HTTPHEADERS = new EmptyHTTPHeaders();
    public static final String COLON_SEPARATOR = ": ";
    public static final String HEADER_ACCEPT = "Accept";
    public static final String HEADER_HOST = "Host";
    public static final String HEADER_RANGE = "Range";
    public static final String HEADER_USER_AGENT = "User-Agent";
    public static final String HEADER_SERVER = "Server";
    public static final String HEADER_CONNECTION = "Connection";
    public static final String HEADER_CONTENT_LENGTH = "Content-Length";
    public static final String HEADER_CONTENT_RANGE = "Content-Range";
    public static final String HEADER_CONTENT_TYPE = "Content-Type";
    public static final String HEADER_LISTEN_IP = "Listen-IP";
    public static final String HEADER_X_MY_ADDRESS = "X-My-Address";
    public static final String HEADER_REMOTE_IP = "Remote-IP";
    public static final String HEADER_ALT_LOC = "Alt-Location";
    public static final String HEADER_X_ALT_LOC = "X-Gnutella-Alternate-Location";
    public static final String HEADER_X_AVAILABLE_RANGES = "X-Available-Ranges";
    public static final String HEADER_X_GNUTELLA_CONTENT_URN = "X-Gnutella-Content-URN";
    public static final String HEADER_X_QUEUE = "X-Queue";
    public static final String HEADER_CHAT = "Chat";
    public static final String HEADER_X_ULTRAPEER = "X-Ultrapeer";
    public static final String HEADER_X_ULTRAPEER_NEEDED = "X-Ultrapeer-Needed";
    public static final String HEADER_X_QUERY_ROUTING = "X-Query-Routing";
    public static final String HEADER_X_UP_QUERY_ROUTING = "X-Ultrapeer-Query-Routing";
    public static final String HEADER_GGEP = "GGEP";
    public static final String HEADER_X_TRY = "X-Try";
    public static final String HEADER_X_TRY_ULTRAPEERS = "X-Try-Ultrapeers";
    public static final HTTPHeaders COMMON_HANDSHAKE_HEADERS = new HTTPHeaders(false);
    public static final HTTPHeaders ACCEPT_HANDSHAKE_HEADERS;
    private Map headerFields;
    private boolean lenient;

    public HTTPHeaders(boolean bl) {
        this.lenient = bl;
        this.headerFields = new HashMap();
    }

    public HTTPHeaders(HTTPHeaders hTTPHeaders) {
        this.headerFields = new HashMap(hTTPHeaders.headerFields);
        this.lenient = hTTPHeaders.lenient;
    }

    public HTTPHeaders(int n, boolean bl) {
        this.lenient = bl;
        this.headerFields = new HashMap(n);
    }

    public void addHeader(HTTPHeader hTTPHeader) {
        String string = this.lenient ? hTTPHeader.getName().toLowerCase() : hTTPHeader.getName();
        ArrayList<HTTPHeader> arrayList = (ArrayList<HTTPHeader>)this.headerFields.get(string);
        if (arrayList == null) {
            arrayList = new ArrayList<HTTPHeader>();
            this.headerFields.put(string, arrayList);
        }
        arrayList.add(hTTPHeader);
    }

    public void addHeaders(HTTPHeader[] hTTPHeaderArray) {
        int n = 0;
        while (n < hTTPHeaderArray.length) {
            String string = this.lenient ? hTTPHeaderArray[n].getName().toLowerCase() : hTTPHeaderArray[n].getName();
            ArrayList<HTTPHeader> arrayList = (ArrayList<HTTPHeader>)this.headerFields.get(string);
            if (arrayList == null) {
                arrayList = new ArrayList<HTTPHeader>();
                this.headerFields.put(string, arrayList);
            }
            arrayList.add(hTTPHeaderArray[n]);
            ++n;
        }
    }

    public void replaceHeaders(HTTPHeaders hTTPHeaders) {
        if (this.lenient == hTTPHeaders.lenient) {
            this.headerFields.putAll(hTTPHeaders.headerFields);
        } else {
            Iterator iterator = hTTPHeaders.headerFields.keySet().iterator();
            while (iterator.hasNext()) {
                String string = (String)iterator.next();
                ArrayList arrayList = (ArrayList)this.headerFields.get(string);
                String string2 = ((HTTPHeader)arrayList.get(0)).getName();
                if (this.lenient) {
                    string2 = string2.toLowerCase();
                }
                this.headerFields.put(string2, arrayList);
            }
        }
    }

    public HTTPHeader getHeader(String string) {
        if (this.lenient) {
            string = string.toLowerCase();
        }
        ArrayList arrayList = null;
        arrayList = (ArrayList)this.headerFields.get(string);
        if (arrayList != null) {
            return (HTTPHeader)arrayList.get(0);
        }
        return null;
    }

    public HTTPHeader[] getHeaders(String string) {
        if (this.lenient) {
            string = string.toLowerCase();
        }
        ArrayList arrayList = null;
        arrayList = (ArrayList)this.headerFields.get(string);
        if (arrayList == null) {
            return EMPTY_HTTPHEADER_ARRAY;
        }
        HTTPHeader[] hTTPHeaderArray = new HTTPHeader[arrayList.size()];
        return arrayList.toArray(hTTPHeaderArray);
    }

    public String buildHTTPHeaderString() {
        StringBuffer stringBuffer = new StringBuffer(30 * this.headerFields.size());
        Iterator iterator = this.headerFields.keySet().iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            ArrayList arrayList = (ArrayList)this.headerFields.get(string);
            Iterator iterator2 = arrayList.iterator();
            while (iterator2.hasNext()) {
                HTTPHeader hTTPHeader = (HTTPHeader)iterator2.next();
                stringBuffer.append(hTTPHeader.getName());
                stringBuffer.append(COLON_SEPARATOR);
                stringBuffer.append(hTTPHeader.getValue());
                stringBuffer.append("\r\n");
            }
        }
        return stringBuffer.toString();
    }

    public static HTTPHeaders createDefaultRequestHeaders() {
        HTTPHeaders hTTPHeaders = new HTTPHeaders(false);
        hTTPHeaders.addHeader(new HTTPHeader(HEADER_USER_AGENT, Environment.getPhexVendor()));
        return hTTPHeaders;
    }

    public static HTTPHeaders createDefaultResponseHeaders() {
        HTTPHeaders hTTPHeaders = new HTTPHeaders(false);
        hTTPHeaders.addHeader(new HTTPHeader(HEADER_SERVER, Environment.getPhexVendor()));
        return hTTPHeaders;
    }

    static {
        COMMON_HANDSHAKE_HEADERS.addHeader(new HTTPHeader(HEADER_USER_AGENT, Environment.getPhexVendor()));
        ACCEPT_HANDSHAKE_HEADERS = new HTTPHeaders(COMMON_HANDSHAKE_HEADERS);
        ACCEPT_HANDSHAKE_HEADERS.addHeader(new HTTPHeader(HEADER_GGEP, "0.5"));
    }

    private static class EmptyHTTPHeaders
    extends HTTPHeaders {
        EmptyHTTPHeaders() {
            super(0, false);
        }

        public void addHeader(HTTPHeader hTTPHeader) {
            throw new UnsupportedOperationException("Modification of empty http headers not allowed");
        }

        public void addHeaders(HTTPHeader[] hTTPHeaderArray) {
            throw new UnsupportedOperationException("Modification of empty http headers not allowed");
        }

        public HTTPHeader getHeader(String string) {
            return null;
        }

        public HTTPHeader[] getHeaders(String string) {
            return EMPTY_HTTPHEADER_ARRAY;
        }

        public String buildHTTPHeaderString() {
            return "";
        }
    }
}

