/*
 * Decompiled with CFR 0.152.
 */
package phex.msg;

import java.io.IOException;
import phex.msg.GUID;
import phex.msg.InvalidMessageException;
import phex.msg.Message;
import phex.msg.MsgHeader;
import phex.msg.MsgPing;
import phex.msg.MsgPong;
import phex.msg.MsgPushRequest;
import phex.msg.MsgQuery;
import phex.msg.MsgQueryResponse;
import phex.msg.RouteTableUpdateMsg;
import phex.utils.GnutellaInputStream;
import phex.utils.IOUtil;

public class MessageProcessor {
    public static Message parseMessage(GnutellaInputStream gnutellaInputStream) throws IOException, InvalidMessageException {
        MsgHeader msgHeader = MessageProcessor.parseMessageHeader(gnutellaInputStream, new byte[23]);
        if (msgHeader == null) {
            throw new IOException("Connection closed by remote host");
        }
        return MessageProcessor.parseMessage(msgHeader, gnutellaInputStream);
    }

    public static Message parseMessage(MsgHeader msgHeader, GnutellaInputStream gnutellaInputStream) throws IOException, InvalidMessageException {
        byte[] byArray = MessageProcessor.readMessageBody(gnutellaInputStream, msgHeader.getDataLen());
        Message message = MessageProcessor.createMessageFromBody(msgHeader, byArray);
        return message;
    }

    public static Message createMessageFromBody(MsgHeader msgHeader, byte[] byArray) throws InvalidMessageException {
        switch (msgHeader.getPayload()) {
            case 0: {
                return new MsgPing(msgHeader, byArray);
            }
            case 1: {
                return new MsgPong(msgHeader, byArray);
            }
            case 64: {
                return new MsgPushRequest(msgHeader, byArray);
            }
            case -127: {
                return new MsgQueryResponse(msgHeader, byArray);
            }
            case -128: {
                return new MsgQuery(msgHeader, byArray);
            }
            case 48: {
                return RouteTableUpdateMsg.parseMessage(msgHeader, byArray);
            }
        }
        return null;
    }

    public static byte[] readMessageBody(GnutellaInputStream gnutellaInputStream, int n) throws IOException {
        byte[] byArray = new byte[n];
        int n2 = 0;
        while (n2 < n) {
            int n3 = Math.min(n - n2, 1024);
            int n4 = gnutellaInputStream.read(byArray, n2, n3);
            if (n4 == -1) {
                throw new IOException("Connection closed by remote host");
            }
            n2 += n4;
        }
        return byArray;
    }

    public static MsgHeader parseMessageHeader(GnutellaInputStream gnutellaInputStream, byte[] byArray) throws IOException {
        int n = 0;
        while (n < 23) {
            int n2 = gnutellaInputStream.read(byArray, n, 23 - n);
            if (n2 == -1) {
                return null;
            }
            n += n2;
        }
        byte[] byArray2 = new byte[16];
        System.arraycopy(byArray, 0, byArray2, 0, 16);
        byte by = byArray[16];
        byte by2 = byArray[17];
        byte by3 = byArray[18];
        int n3 = IOUtil.deserializeIntLE(byArray, 19);
        MsgHeader msgHeader = new MsgHeader(new GUID(byArray2), by, by2, by3, n3);
        return msgHeader;
    }
}

