/*
 * Decompiled with CFR 0.152.
 */
package phex.msg;

import java.io.IOException;
import phex.common.ServiceManager;
import phex.host.Host;
import phex.msg.GUID;
import phex.utils.IOUtil;

public class MsgHeader {
    public static final int DATA_LENGTH = 23;
    public static final byte PING_PAYLOAD = 0;
    public static final byte PONG_PAYLOAD = 1;
    public static final byte ROUTE_TABLE_UPDATE_PAYLOAD = 48;
    public static final byte PUSH_PAYLOAD = 64;
    public static final byte QUERY_PAYLOAD = -128;
    public static final byte QUERY_HIT_PAYLOAD = -127;
    public static final byte sUnknown = -1;
    private GUID msgID;
    private byte payload;
    private byte ttl;
    private byte hopsTaken;
    private int mDataLen;
    private long mArrivalTime;
    private Host mFromHost = null;

    public MsgHeader() {
        this(new GUID());
    }

    public MsgHeader(GUID gUID) {
        this.msgID = gUID;
        this.payload = (byte)-1;
        this.ttl = (byte)ServiceManager.sCfg.ttl;
        this.hopsTaken = 0;
        this.mDataLen = 0;
    }

    public MsgHeader(GUID gUID, byte by, byte by2, byte by3, int n) {
        this.msgID = gUID;
        this.payload = by;
        this.ttl = by2;
        this.hopsTaken = by3;
        this.mDataLen = n;
    }

    public GUID getMsgID() {
        return this.msgID;
    }

    public void setMsgID(GUID gUID) {
        this.msgID = gUID;
    }

    public byte getPayload() {
        return this.payload;
    }

    public void setPayloadType(byte by) {
        this.payload = by;
    }

    private String getPayloadName() {
        switch (this.payload) {
            case 0: {
                return "Ping";
            }
            case 1: {
                return "Pong";
            }
            case 48: {
                return "RouteTableUpdate";
            }
            case 64: {
                return "Push";
            }
            case -128: {
                return "Query";
            }
            case -127: {
                return "QueryHit";
            }
        }
        return "Unknown";
    }

    public byte getTTL() {
        return this.ttl;
    }

    public void setTTL(byte by) {
        this.ttl = by;
    }

    public byte getHopsTaken() {
        return this.hopsTaken;
    }

    public void setHopsTaken(byte by) {
        this.hopsTaken = by;
    }

    public void countHop() {
        if (this.ttl > 0) {
            this.ttl = (byte)(this.ttl - 1);
        }
        this.hopsTaken = (byte)(this.hopsTaken + 1);
    }

    public int getDataLen() {
        return this.mDataLen;
    }

    public void setDataLen(int n) {
        this.mDataLen = n;
    }

    public long getArrivalTime() {
        return this.mArrivalTime;
    }

    public void setArrivalTime(long l) {
        this.mArrivalTime = l;
    }

    public Host getFromHost() {
        return this.mFromHost;
    }

    public void setFromHost(Host host) {
        this.mFromHost = host;
    }

    public int getSize() {
        return 23;
    }

    public void copy(MsgHeader msgHeader) {
        this.msgID = msgHeader.msgID;
        this.payload = msgHeader.payload;
        this.ttl = msgHeader.ttl;
        this.hopsTaken = msgHeader.hopsTaken;
        this.mDataLen = msgHeader.mDataLen;
    }

    public int serialize(byte[] byArray, int n) {
        n = this.msgID.serialize(byArray, n);
        byArray[n++] = this.payload;
        byArray[n++] = this.ttl;
        byArray[n++] = this.hopsTaken;
        n = IOUtil.serializeIntLE(this.mDataLen, byArray, n);
        return n;
    }

    public int deserialize(byte[] byArray, int n) throws IOException {
        n = this.msgID.deserialize(byArray, n);
        this.payload = byArray[n++];
        this.ttl = byArray[n++];
        this.hopsTaken = byArray[n++];
        this.mDataLen = IOUtil.deserializeIntLE(byArray, n);
        return n += 4;
    }

    public String getDebugString() {
        return "Header[ MsgID=" + this.msgID + ", Function=" + this.payload + "-" + this.getPayloadName() + ", TTL=" + this.ttl + ", HopsTaken=" + this.hopsTaken + ", DataLen=" + this.mDataLen + " ]";
    }
}

