/*
 * Decompiled with CFR 0.152.
 */
package phex.msg;

import java.io.IOException;
import java.net.NoRouteToHostException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.StringTokenizer;
import java.util.TimerTask;
import java.util.Vector;
import phex.common.Environment;
import phex.common.Manager;
import phex.common.QueryRoutingTable;
import phex.common.ServiceManager;
import phex.common.URN;
import phex.connection.NetworkManager;
import phex.download.PushRequestSleeper;
import phex.download.RemoteFile;
import phex.download.swarming.SWDownloadFile;
import phex.download.swarming.SwarmingManager;
import phex.host.Host;
import phex.host.HostAddress;
import phex.host.HostManager;
import phex.host.NetworkHostsContainer;
import phex.interfaces.IMonitorSearch;
import phex.msg.GUID;
import phex.msg.MsgPing;
import phex.msg.MsgPushRequest;
import phex.msg.MsgQuery;
import phex.msg.MsgQueryResponse;
import phex.msg.MsgResRecord;
import phex.msg.RouteTableUpdateMsg;
import phex.query.QueryHitHost;
import phex.query.QueryManager;
import phex.query.Search;
import phex.utils.GUIDRoutingTable;
import phex.utils.Logger;
import phex.utils.SearchEngine;

public final class MsgManager
implements Manager {
    private HostManager hostMgr;
    private NetworkHostsContainer hostsContainer;
    private QueryManager queryMgr;
    private Vector mPassiveResults = new Vector();
    private IMonitorSearch mMonitorSearchListener;
    private String mPassiveSearching = null;
    private ArrayList passiveSearchList;
    private SearchEngine passiveSearchEngine;
    private GUIDRoutingTable pingRoutingTable = new GUIDRoutingTable(120000L);
    private GUIDRoutingTable queryRoutingTable = new GUIDRoutingTable(300000L);
    private GUIDRoutingTable pushRoutingTable = new GUIDRoutingTable(420000L);
    private static MsgManager instance;

    private MsgManager() {
        this.passiveSearchList = new ArrayList(3);
    }

    public static MsgManager getInstance() {
        if (instance == null) {
            instance = new MsgManager();
        }
        return instance;
    }

    public boolean initialize() {
        return true;
    }

    public boolean onPostInitialization() {
        this.hostMgr = HostManager.getInstance();
        this.hostsContainer = this.hostMgr.getNetworkHostsContainer();
        this.queryMgr = QueryManager.getInstance();
        Environment.getInstance().scheduleTimerTask(new QRPUpdateTimer(), 10000L, 10000L);
        return true;
    }

    public void shutdown() {
    }

    public void setMonitorSearchListener(IMonitorSearch iMonitorSearch) {
        this.mMonitorSearchListener = iMonitorSearch;
    }

    public synchronized boolean checkAndAddToPingRoutingTable(GUID gUID, Host host) {
        boolean bl = this.pingRoutingTable.checkAndAddRouting(gUID, host);
        return bl;
    }

    public synchronized boolean checkAndAddToQueryRoutingTable(GUID gUID, Host host) {
        boolean bl = this.queryRoutingTable.checkAndAddRouting(gUID, host);
        return bl;
    }

    public synchronized void addToPushRoutingTable(GUID gUID, Host host) {
        this.pushRoutingTable.addRouting(gUID, host);
    }

    public synchronized void removeHost(Host host) {
        this.pingRoutingTable.removeHost(host);
        this.queryRoutingTable.removeHost(host);
        this.pushRoutingTable.removeHost(host);
    }

    public synchronized Host getPushRouting(GUID gUID) {
        return this.pushRoutingTable.findRouting(gUID);
    }

    public synchronized Host getPingRouting(GUID gUID) {
        return this.pingRoutingTable.findRouting(gUID);
    }

    public synchronized Host getQueryRouting(GUID gUID) {
        return this.queryRoutingTable.findRouting(gUID);
    }

    public synchronized void processQueryResponse(Host host, MsgQueryResponse msgQueryResponse) {
        this.queryMgr.getSearchContainer().processQueryResponse(msgQueryResponse);
        this.queryMgr.getBackgroundSearchContainer().processQueryResponse(msgQueryResponse);
        this.passiveMonitorResult(msgQueryResponse);
        this.snoopMonitorResult(msgQueryResponse);
    }

    public String getPassiveSearching() {
        return this.mPassiveSearching;
    }

    public void setPassiveSearching(String string) {
        this.mPassiveSearching = string;
        this.passiveSearchList.clear();
        if (this.mPassiveSearching != null && this.mPassiveSearching.length() > 0) {
            if (this.passiveSearchEngine == null) {
                this.passiveSearchEngine = new SearchEngine();
            }
            this.mPassiveSearching = this.mPassiveSearching.toLowerCase();
            StringTokenizer stringTokenizer = new StringTokenizer(this.mPassiveSearching, " ");
            this.passiveSearchList.ensureCapacity(stringTokenizer.countTokens());
            while (stringTokenizer.hasMoreTokens()) {
                this.passiveSearchList.add(stringTokenizer.nextToken());
            }
        }
    }

    public Vector getPassiveResults() {
        return this.mPassiveResults;
    }

    public void snoopMonitorResult(MsgQueryResponse msgQueryResponse) {
        if (!ServiceManager.sCfg.enableHitSnooping) {
            return;
        }
        SwarmingManager swarmingManager = SwarmingManager.getInstance();
        int n = 0;
        while (n < swarmingManager.getDownloadFileCount()) {
            SWDownloadFile sWDownloadFile = swarmingManager.getDownloadFile(n);
            if (sWDownloadFile != null) {
                Object object;
                SearchEngine searchEngine = new SearchEngine();
                ArrayList<Object> arrayList = new ArrayList<Object>();
                StringTokenizer stringTokenizer = new StringTokenizer(sWDownloadFile.getResearchSetting().getSearchTerm().toLowerCase(), " _,()");
                while (stringTokenizer.hasMoreTokens()) {
                    object = stringTokenizer.nextToken();
                    if (((String)object).length() < 3 || ((String)object).length() > 25) continue;
                    arrayList.add(object);
                }
                object = sWDownloadFile.getFileURN();
                int n2 = 0;
                while (n2 < msgQueryResponse.getRecordCount()) {
                    block9: {
                        MsgResRecord msgResRecord = msgQueryResponse.getMsgRecord(n2);
                        if (sWDownloadFile.getTransferDataSize() == (long)msgResRecord.getFileSize()) {
                            URN uRN = msgResRecord.getURN();
                            if (object == null || uRN == null || ((URN)object).equals(uRN)) {
                                searchEngine.setText(msgResRecord.getFilename().toLowerCase(), true);
                                Object object2 = arrayList.iterator();
                                while (object2.hasNext()) {
                                    searchEngine.setPattern((String)object2.next(), true);
                                    if (searchEngine.match()) {
                                        continue;
                                    }
                                    break block9;
                                }
                                object2 = new QueryHitHost(msgQueryResponse.getRemoteClientID(), msgQueryResponse.getHostAddress(), msgQueryResponse.getRemoteHostSpeed());
                                ((QueryHitHost)object2).setQHDFlags(msgQueryResponse.getPushNeededFlag(), msgQueryResponse.getServerBusyFlag(), msgQueryResponse.getHasUploadedFlag(), msgQueryResponse.getUploadSpeedFlag());
                                ((QueryHitHost)object2).setVendorCode(msgQueryResponse.getVendorCode());
                                ((QueryHitHost)object2).setChatSupported(msgQueryResponse.isChatSupported());
                                RemoteFile remoteFile = new RemoteFile((QueryHitHost)object2, msgResRecord.getFileIndex(), msgResRecord.getFilename(), msgResRecord.getFileSize(), msgResRecord.getURN(), msgResRecord.getMetaData(), -1);
                                sWDownloadFile.addDownloadCandidate(remoteFile);
                            }
                        }
                    }
                    ++n2;
                }
            }
            ++n;
        }
    }

    public void passiveMonitorResult(MsgQueryResponse msgQueryResponse) {
        if (this.mPassiveSearching == null) {
            return;
        }
        HostAddress hostAddress = msgQueryResponse.getHostAddress();
        int n = msgQueryResponse.getRemoteHostSpeed();
        GUID gUID = msgQueryResponse.getRemoteClientID();
        QueryHitHost queryHitHost = new QueryHitHost(gUID, hostAddress, n);
        queryHitHost.setQHDFlags(msgQueryResponse.getPushNeededFlag(), msgQueryResponse.getServerBusyFlag(), msgQueryResponse.getHasUploadedFlag(), msgQueryResponse.getUploadSpeedFlag());
        queryHitHost.setVendorCode(msgQueryResponse.getVendorCode());
        queryHitHost.setChatSupported(msgQueryResponse.isChatSupported());
        int n2 = 0;
        while (n2 < msgQueryResponse.getRecordCount()) {
            MsgResRecord msgResRecord = msgQueryResponse.getMsgRecord(n2);
            if (this.mPassiveSearching.length() == 0) {
                RemoteFile remoteFile = new RemoteFile(queryHitHost, msgResRecord.getFileIndex(), msgResRecord.getFilename(), msgResRecord.getFileSize(), msgResRecord.getURN(), msgResRecord.getMetaData(), 100);
                if (!this.passiveResultExists(remoteFile)) {
                    this.mPassiveResults.addElement(remoteFile);
                    this.mMonitorSearchListener.passiveResultArrived();
                }
            } else {
                boolean bl = true;
                this.passiveSearchEngine.setText(msgResRecord.getFilename(), false);
                int n3 = 0;
                while (n3 < this.passiveSearchList.size()) {
                    this.passiveSearchEngine.setPattern((String)this.passiveSearchList.get(n3), true);
                    if (!this.passiveSearchEngine.match()) {
                        bl = false;
                        break;
                    }
                    ++n3;
                }
                if (bl) {
                    short s = Search.calculateSearchScore(this.mPassiveSearching, msgResRecord.getFilename());
                    RemoteFile remoteFile = new RemoteFile(queryHitHost, msgResRecord.getFileIndex(), msgResRecord.getFilename(), msgResRecord.getFileSize(), msgResRecord.getURN(), msgResRecord.getMetaData(), s);
                    if (!this.passiveResultExists(remoteFile)) {
                        this.mPassiveResults.addElement(remoteFile);
                        this.mMonitorSearchListener.passiveResultArrived();
                    }
                }
            }
            ++n2;
        }
    }

    private boolean passiveResultExists(RemoteFile remoteFile) {
        int n = 0;
        while (n < this.mPassiveResults.size()) {
            RemoteFile remoteFile2 = (RemoteFile)this.mPassiveResults.elementAt(n);
            if (remoteFile2.equals(remoteFile)) {
                return true;
            }
            ++n;
        }
        return false;
    }

    public void resetPassiveResults() {
        this.mPassiveResults.removeAllElements();
        this.mMonitorSearchListener.passiveResultArrived();
    }

    public void forwardQuery(MsgQuery msgQuery, Host host) {
        Host[] hostArray;
        boolean bl = this.hostMgr.isShieldedLeafNode();
        if (bl && host != null && host.isLeafUltrapeerConnection()) {
            return;
        }
        if (!bl) {
            if (msgQuery.getHeader().getTTL() > 0) {
                hostArray = this.hostsContainer.getUltrapeerConnections();
                this.forwardQueryToUltrapeers(msgQuery, host, hostArray);
            }
            hostArray = this.hostsContainer.getLeafConnections();
            this.forwardQuery(msgQuery, host, hostArray);
        }
        if (msgQuery.getHeader().getTTL() > 0) {
            hostArray = this.hostsContainer.getPeerConnections();
            this.forwardQuery(msgQuery, host, hostArray);
        }
    }

    private void forwardQuery(MsgQuery msgQuery, Host host, Host[] hostArray) {
        int n = 0;
        while (n < hostArray.length) {
            QueryRoutingTable queryRoutingTable;
            if (hostArray[n] != host && ((queryRoutingTable = hostArray[n].getLastReceivedRoutingTable()) == null || queryRoutingTable.containsQuery(msgQuery))) {
                hostArray[n].queueMessageToSend(msgQuery);
            }
            ++n;
        }
    }

    private void forwardQueryToUltrapeers(MsgQuery msgQuery, Host host, Host[] hostArray) {
        boolean bl = msgQuery.getHeader().getTTL() == 1;
        int n = 0;
        while (n < hostArray.length) {
            QueryRoutingTable queryRoutingTable;
            if (!(hostArray[n] == host || bl && hostArray[n].isUPQueryRoutingSupported() && (queryRoutingTable = hostArray[n].getLastReceivedRoutingTable()) != null && !queryRoutingTable.containsQuery(msgQuery))) {
                hostArray[n].queueMessageToSend(msgQuery);
            }
            ++n;
        }
    }

    public void forwardPing(MsgPing msgPing, Host host) {
        Host[] hostArray;
        boolean bl = this.hostMgr.isShieldedLeafNode();
        if (bl && host != null && host.isLeafUltrapeerConnection()) {
            return;
        }
        if (!bl) {
            hostArray = this.hostsContainer.getUltrapeerConnections();
            this.forwardPing(msgPing, host, hostArray);
            hostArray = this.hostsContainer.getLeafConnections();
            this.forwardPing(msgPing, host, hostArray);
        }
        hostArray = this.hostsContainer.getPeerConnections();
        this.forwardPing(msgPing, host, hostArray);
    }

    private void forwardPing(MsgPing msgPing, Host host, Host[] hostArray) {
        int n = 0;
        while (n < hostArray.length) {
            if (hostArray[n] != host) {
                hostArray[n].queueMessageToSend(msgPing);
            }
            ++n;
        }
    }

    public void pingHost(Host host) {
        MsgPing msgPing = new MsgPing();
        msgPing.getHeader().setTTL((byte)1);
        this.checkAndAddToPingRoutingTable(msgPing.getHeader().getMsgID(), Host.LOCAL_HOST);
        host.queueMessageToSend(msgPing);
    }

    public void sendPushRequest(PushRequestSleeper pushRequestSleeper) throws IOException {
        GUID gUID = pushRequestSleeper.getGUID();
        long l = pushRequestSleeper.getFileIndex();
        HostAddress hostAddress = NetworkManager.getInstance().getLocalAddress();
        MsgPushRequest msgPushRequest = new MsgPushRequest(gUID, l, hostAddress);
        Host host = this.getPushRouting(gUID);
        Logger.logMessage(Logger.FINER, (short)2, "Push route for " + gUID + " is " + host);
        if (host == null) {
            throw new NoRouteToHostException("Routing table has no info to route back to sharing host.");
        }
        host.queueMessageToSend(msgPushRequest);
    }

    private class QRPUpdateTimer
    extends TimerTask {
        private static final long TIMER_PERIOD = 10000L;

        private QRPUpdateTimer() {
        }

        public void run() {
            this.sendQueryRoutingTable();
        }

        private void sendQueryRoutingTable() {
            boolean bl = MsgManager.this.hostMgr.isUltrapeer();
            if (!MsgManager.this.hostMgr.isShieldedLeafNode() && !bl) {
                return;
            }
            Host[] hostArray = MsgManager.this.hostsContainer.getUltrapeerConnections();
            QueryRoutingTable queryRoutingTable = null;
            int n = 0;
            while (n < hostArray.length) {
                if (!(!bl ? !hostArray[n].isQueryRoutingSupported() : !hostArray[n].isUPQueryRoutingSupported()) && hostArray[n].isQRTableUpdateRequired()) {
                    Logger.logMessage(Logger.FINER, (short)16, "Updating QRTable for: " + hostArray[n]);
                    if (queryRoutingTable == null) {
                        queryRoutingTable = QueryRoutingTable.createLocalQueryRoutingTable();
                    }
                    QueryRoutingTable queryRoutingTable2 = hostArray[n].getLastSentRoutingTable();
                    Iterator iterator = QueryRoutingTable.buildRouteTableUpdateMsgIterator(queryRoutingTable, queryRoutingTable2);
                    while (iterator.hasNext()) {
                        RouteTableUpdateMsg routeTableUpdateMsg = (RouteTableUpdateMsg)iterator.next();
                        hostArray[n].queueMessageToSend(routeTableUpdateMsg);
                    }
                    hostArray[n].setLastSentRoutingTable(queryRoutingTable);
                }
                ++n;
            }
        }
    }
}

