/*
 * Decompiled with CFR 0.152.
 */
package phex.query;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.StringTokenizer;
import phex.common.ServiceManager;
import phex.common.URN;
import phex.download.RemoteFile;
import phex.event.AsynchronousDispatcher;
import phex.event.NetworkHostsChangeListener;
import phex.event.SearchChangeEvent;
import phex.event.SearchChangeListener;
import phex.host.Host;
import phex.host.HostAddress;
import phex.host.HostManager;
import phex.msg.GUID;
import phex.msg.MsgManager;
import phex.msg.MsgQuery;
import phex.msg.MsgQueryResponse;
import phex.msg.MsgResRecord;
import phex.query.QueryHitHost;
import phex.query.SearchFilter;
import phex.utils.Logger;
import phex.utils.SearchEngine;

public class Search {
    public static final long DEFAULT_SEARCH_TIMEOUT = 300000L;
    boolean isPhexCapableOfXmlResults = false;
    private String fixedDisplayStr;
    private String searchString;
    private URN searchURN;
    protected SearchFilter searchFilter;
    private MsgQuery queryMsg;
    protected ArrayList queryHitList;
    protected ArrayList filteredQueryHitList;
    private boolean isPermanentlyFiltered;
    protected boolean isSearching = false;
    private long startTime;
    private long searchTimeout;
    private NewConnectedHostListener newHostListener;
    private ArrayList listenerList = new ArrayList(2);

    public Search(String string) {
        this(string, null, 300000L);
    }

    public Search(String string, URN uRN, long l) {
        this.queryHitList = new ArrayList();
        this.filteredQueryHitList = new ArrayList();
        this.searchString = string;
        this.searchURN = uRN;
        this.searchTimeout = l;
        boolean bl = ServiceManager.sCfg.isBehindFirewall;
        this.queryMsg = new MsgQuery((byte)ServiceManager.sCfg.ttl, this.searchString, this.searchURN, this.isPhexCapableOfXmlResults, bl);
        this.fixedDisplayStr = '\'' + this.searchString + '\'';
        this.newHostListener = new NewConnectedHostListener();
        this.searchFilter = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateSearchFilter(SearchFilter searchFilter) {
        ArrayList arrayList = this.filteredQueryHitList;
        synchronized (arrayList) {
            this.searchFilter = searchFilter;
            this.searchFilter.setLastTimeUsed(System.currentTimeMillis());
            this.updateFilteredQueryList();
        }
    }

    public SearchFilter getSearchFilter() {
        return this.searchFilter;
    }

    public void setPermanentlyFilter(boolean bl) {
        this.isPermanentlyFiltered = bl;
    }

    public String getSearchString() {
        return this.searchString;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getQueryHitCount() {
        ArrayList arrayList = this.filteredQueryHitList;
        synchronized (arrayList) {
            return this.filteredQueryHitList.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RemoteFile getQueryHit(int n) {
        ArrayList arrayList = this.filteredQueryHitList;
        synchronized (arrayList) {
            return (RemoteFile)this.filteredQueryHitList.get(n);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RemoteFile[] getQueryHits(int[] nArray) {
        ArrayList arrayList = this.filteredQueryHitList;
        synchronized (arrayList) {
            RemoteFile[] remoteFileArray = new RemoteFile[nArray.length];
            int n = 0;
            while (n < nArray.length) {
                remoteFileArray[n] = (RemoteFile)this.filteredQueryHitList.get(nArray[n]);
                ++n;
            }
            return remoteFileArray;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getLocallyFilteredCount() {
        ArrayList arrayList = this.queryHitList;
        synchronized (arrayList) {
            ArrayList arrayList2 = this.filteredQueryHitList;
            synchronized (arrayList2) {
                return this.queryHitList.size() - this.filteredQueryHitList.size();
            }
        }
    }

    public boolean isSearching() {
        return this.isSearching;
    }

    public String getDisplayStr() {
        return this.fixedDisplayStr + " - (" + this.getQueryHitCount() + ')';
    }

    public void checkForSearchTimeout(long l) {
        if (l > this.startTime + this.searchTimeout) {
            this.stopSearching();
        }
    }

    public void startSearching() {
        AsynchronousDispatcher.invokeLater(new Runnable(){

            public void run() {
                HostManager.getInstance().addNetworkHostsChangeListener(Search.this.newHostListener);
                Search.this.startTime = System.currentTimeMillis();
                Search.this.queryMsg.setCreationTime(Search.this.startTime);
                Logger.logMessage(Logger.FINER, (short)8, "Sending Query " + Search.this.queryMsg);
                MsgManager msgManager = MsgManager.getInstance();
                msgManager.checkAndAddToQueryRoutingTable(Search.this.queryMsg.getHeader().getMsgID(), Host.LOCAL_HOST);
                msgManager.forwardQuery(Search.this.queryMsg, null);
                Search.this.isSearching = true;
                Search.this.fireSearchStarted();
            }
        });
    }

    public void stopSearching() {
        if (!this.isSearching) {
            return;
        }
        this.isSearching = false;
        HostManager.getInstance().removeNetworkHostsChangeListener(this.newHostListener);
        this.fireSearchStoped();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void processResponse(MsgQueryResponse msgQueryResponse) {
        if (!this.isSearching) {
            return;
        }
        if (!msgQueryResponse.getHeader().getMsgID().equals(this.queryMsg.getHeader().getMsgID())) {
            return;
        }
        int n = msgQueryResponse.getRemoteHostSpeed();
        GUID gUID = msgQueryResponse.getRemoteClientID();
        HostAddress hostAddress = msgQueryResponse.getHostAddress();
        QueryHitHost queryHitHost = new QueryHitHost(gUID, hostAddress, n);
        queryHitHost.setQHDFlags(msgQueryResponse.getPushNeededFlag(), msgQueryResponse.getServerBusyFlag(), msgQueryResponse.getHasUploadedFlag(), msgQueryResponse.getUploadSpeedFlag());
        queryHitHost.setVendorCode(msgQueryResponse.getVendorCode());
        queryHitHost.setChatSupported(msgQueryResponse.isChatSupported());
        queryHitHost.setBrowseHostSupported(msgQueryResponse.isBrowseHostSupported());
        short s = queryHitHost.getHostRating();
        int n2 = this.queryHitList.size();
        int n3 = 0;
        while (n3 < msgQueryResponse.getRecordCount()) {
            MsgResRecord msgResRecord = msgQueryResponse.getMsgRecord(n3);
            if (this.searchURN == null || msgResRecord.getURN() == null || this.searchURN.equals(msgResRecord.getURN())) {
                ArrayList arrayList = this.filteredQueryHitList;
                synchronized (arrayList) {
                    boolean bl = false;
                    if (this.searchFilter != null) {
                        bl = this.searchFilter.isFiltered(this.filteredQueryHitList.size(), msgResRecord.getFileSize(), msgResRecord.getFilename(), n, s);
                    }
                    if (bl && this.isPermanentlyFiltered) {
                    } else {
                        String string = msgResRecord.getFilename();
                        long l = msgResRecord.getFileSize();
                        URN uRN = msgResRecord.getURN();
                        int n4 = msgResRecord.getFileIndex();
                        RemoteFile remoteFile = this.findQueryHit(queryHitHost.getHostGUID(), uRN, string, l, n4);
                        if (remoteFile != null) {
                            remoteFile.setQueryHitHost(queryHitHost);
                            remoteFile.setMetaData(msgResRecord.getMetaData());
                        } else {
                            short s2 = Search.calculateSearchScore(this.searchString, string);
                            RemoteFile remoteFile2 = new RemoteFile(queryHitHost, n4, string, l, msgResRecord.getURN(), msgResRecord.getMetaData(), s2);
                            this.queryHitList.add(remoteFile2);
                            if (!bl) {
                                this.filteredQueryHitList.add(remoteFile2);
                            }
                        }
                    }
                }
            }
            ++n3;
        }
        int n5 = this.queryHitList.size();
        if (n5 > n2) {
            this.fireSearchHitsAdded(n2, n5);
        }
    }

    public static short calculateSearchScore(String string, String string2) {
        double d = 0.0;
        double d2 = 0.0;
        StringTokenizer stringTokenizer = new StringTokenizer(string);
        SearchEngine searchEngine = new SearchEngine();
        searchEngine.setText(string2, false);
        while (stringTokenizer.hasMoreTokens()) {
            String string3 = stringTokenizer.nextToken();
            d += 1.0;
            searchEngine.setPattern(string3, false);
            if (!searchEngine.match()) continue;
            d2 += 1.0;
        }
        double d3 = d2 / d * 100.0;
        return (short)d3;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private RemoteFile findQueryHit(GUID gUID, URN uRN, String string, long l, int n) {
        ArrayList arrayList = this.filteredQueryHitList;
        synchronized (arrayList) {
            int n2 = this.queryHitList.size();
            int n3 = 0;
            while (n3 < n2) {
                RemoteFile remoteFile = (RemoteFile)this.queryHitList.get(n3);
                if (remoteFile.getQueryHitHost().getHostGUID().equals(gUID)) {
                    if (uRN != null && remoteFile.getURN() != null) {
                        if (uRN.equals(remoteFile.getURN())) {
                            return remoteFile;
                        }
                    } else if (n == remoteFile.getFileIndex() && l == remoteFile.getFileSize() && string.equals(remoteFile.getFilename())) {
                        return remoteFile;
                    }
                }
                ++n3;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateFilteredQueryList() {
        ArrayList arrayList = this.filteredQueryHitList;
        synchronized (arrayList) {
            this.filteredQueryHitList.clear();
            Iterator iterator = this.queryHitList.iterator();
            while (iterator.hasNext()) {
                RemoteFile remoteFile = (RemoteFile)iterator.next();
                boolean bl = this.searchFilter.isFiltered(this.filteredQueryHitList.size(), remoteFile.getFileSize(), remoteFile.getFilename(), remoteFile.getSpeed(), remoteFile.getQueryHitHost().getHostRating());
                if (bl) continue;
                this.filteredQueryHitList.add(remoteFile);
            }
            this.fireSearchFiltered();
        }
    }

    public void addSearchChangeListener(SearchChangeListener searchChangeListener) {
        this.listenerList.add(searchChangeListener);
    }

    public void removeSearchChangeListener(SearchChangeListener searchChangeListener) {
        this.listenerList.remove(searchChangeListener);
    }

    protected void fireSearchStarted() {
        SearchChangeEvent searchChangeEvent = new SearchChangeEvent(this, 0);
        this.fireSearchChangeEvent(searchChangeEvent);
    }

    protected void fireSearchStoped() {
        SearchChangeEvent searchChangeEvent = new SearchChangeEvent(this, 3);
        this.fireSearchChangeEvent(searchChangeEvent);
    }

    protected void fireSearchFiltered() {
        SearchChangeEvent searchChangeEvent = new SearchChangeEvent(this, 2);
        this.fireSearchChangeEvent(searchChangeEvent);
    }

    protected void fireSearchHitsAdded(int n, int n2) {
        SearchChangeEvent searchChangeEvent = new SearchChangeEvent(this, 1, n, n2);
        this.fireSearchChangeEvent(searchChangeEvent);
    }

    private void fireSearchChangeEvent(final SearchChangeEvent searchChangeEvent) {
        AsynchronousDispatcher.invokeLater(new Runnable(){

            public void run() {
                Object[] objectArray = Search.this.listenerList.toArray();
                int n = objectArray.length - 1;
                while (n >= 0) {
                    SearchChangeListener searchChangeListener = (SearchChangeListener)objectArray[n];
                    searchChangeListener.searchChanged(searchChangeEvent);
                    --n;
                }
            }
        });
    }

    private class NewConnectedHostListener
    implements NetworkHostsChangeListener {
        private NewConnectedHostListener() {
        }

        public void networkHostChanged(int n) {
            if (!Search.this.isSearching) {
                return;
            }
            Host host = HostManager.getInstance().getNetworkHostsContainer().getNetworkHostAt(n);
            if (host == null || !host.isConnectionStable()) {
                return;
            }
            Logger.logMessage(Logger.FINER, (short)8, "Forwarding search: " + Search.this.getDisplayStr() + " to: " + host);
            Search.this.queryMsg.setCreationTime(System.currentTimeMillis());
            host.queueMessageToSend(Search.this.queryMsg);
        }

        public void networkHostAdded(int n) {
        }

        public void networkHostRemoved(int n) {
        }
    }
}

