/*
 * Decompiled with CFR 0.152.
 */
package phex.query;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;
import javax.xml.bind.JAXBException;
import phex.common.MediaType;
import phex.query.QueryManager;
import phex.xml.ObjectFactory;
import phex.xml.XJBSearchFilter;

public class SearchFilter {
    private String name;
    private List filterTokens;
    private String filterString;
    private int minSpeed;
    private short minRating;
    private MediaType mediaType;
    private int maxResults;
    private long minFileSize;
    private long maxFileSize;
    private long lastTimeUsed;

    public SearchFilter(String string) {
        this.name = string;
        this.filterTokens = new ArrayList();
        this.minSpeed = 0;
        this.mediaType = MediaType.getMediaTypeAny();
        this.maxResults = Integer.MAX_VALUE;
        this.minFileSize = 0L;
        this.maxFileSize = Long.MAX_VALUE;
    }

    public String getFilterString() {
        return this.filterString;
    }

    public List getFilterTokens() {
        return this.filterTokens;
    }

    public long getMaxFileSize() {
        return this.maxFileSize;
    }

    public int getMaxResults() {
        return this.maxResults;
    }

    public MediaType getMediaType() {
        return this.mediaType;
    }

    public long getMinFileSize() {
        return this.minFileSize;
    }

    public short getMinRating() {
        return this.minRating;
    }

    public int getMinSpeed() {
        return this.minSpeed;
    }

    public String getName() {
        return this.name;
    }

    public long getLastTimeUsed() {
        return this.lastTimeUsed;
    }

    public void setLastTimeUsed(long l) {
        this.lastTimeUsed = l;
        QueryManager.getInstance().getSearchFilterContainer().saveSearchFilters();
    }

    public String toString() {
        return this.name;
    }

    public void updateSearchFilter(String string, int n, short s, MediaType mediaType, int n2, long l) {
        this.setFilterString(string);
        this.minSpeed = n;
        this.minRating = s;
        this.mediaType = mediaType;
        this.maxResults = n2;
        this.minFileSize = l;
        QueryManager.getInstance().getSearchFilterContainer().saveSearchFilters();
    }

    public void updateSearchFilter(long l, long l2) {
        this.minFileSize = l;
        this.maxFileSize = l2;
    }

    public boolean isFiltered(int n, long l, String string, int n2, int n3) {
        if (n > this.maxResults) {
            return true;
        }
        if (l < this.minFileSize || l > this.maxFileSize) {
            return true;
        }
        if (!this.mediaType.isFilenameOf(string)) {
            return true;
        }
        if (this.minSpeed > n2) {
            return true;
        }
        if (this.minRating > n3) {
            return true;
        }
        return this.isFilenameFiltered(string);
    }

    public XJBSearchFilter createXJBSearchFilter() throws JAXBException {
        XJBSearchFilter xJBSearchFilter = ObjectFactory.createXJBSearchFilter();
        xJBSearchFilter.setName(this.name);
        xJBSearchFilter.setRefineText(this.filterString);
        xJBSearchFilter.setMinHostSpeed(this.minSpeed);
        xJBSearchFilter.setMinHostRating(this.minRating);
        xJBSearchFilter.setMinFileSize(this.minFileSize);
        xJBSearchFilter.setMaxSearchResults(this.maxResults);
        xJBSearchFilter.setLastTimeUsed(this.lastTimeUsed);
        xJBSearchFilter.setMediaType(MediaType.convertToXJBMediaType(this.mediaType));
        return xJBSearchFilter;
    }

    public static SearchFilter createFromxJBSearchFilter(XJBSearchFilter xJBSearchFilter) {
        SearchFilter searchFilter = new SearchFilter(xJBSearchFilter.getName());
        searchFilter.filterString = xJBSearchFilter.getRefineText();
        searchFilter.minSpeed = xJBSearchFilter.getMinHostSpeed();
        searchFilter.minRating = xJBSearchFilter.getMinHostRating();
        searchFilter.minFileSize = xJBSearchFilter.getMinFileSize();
        searchFilter.maxResults = xJBSearchFilter.getMaxSearchResults();
        searchFilter.lastTimeUsed = xJBSearchFilter.getLastTimeUsed();
        searchFilter.mediaType = MediaType.convertFromXJBMediaType(xJBSearchFilter.getMediaType());
        return searchFilter;
    }

    private void setFilterString(String string) {
        this.filterString = string;
        StringTokenizer stringTokenizer = new StringTokenizer(this.filterString, " ");
        this.filterTokens.clear();
        while (stringTokenizer.hasMoreTokens()) {
            this.filterTokens.add(stringTokenizer.nextToken().toLowerCase());
        }
    }

    private boolean isFilenameFiltered(String string) {
        if (this.filterTokens == null || this.filterTokens.size() == 0) {
            return false;
        }
        string = string.toLowerCase();
        Iterator iterator = this.filterTokens.iterator();
        while (iterator.hasNext()) {
            String string2 = (String)iterator.next();
            if (string.indexOf(string2) != -1) continue;
            return true;
        }
        return false;
    }
}

