/*
 * Decompiled with CFR 0.152.
 */
package phex.query;

import java.io.File;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.xml.bind.JAXBException;
import phex.common.Environment;
import phex.event.AsynchronousDispatcher;
import phex.event.SearchFilterListListener;
import phex.query.SearchFilter;
import phex.utils.Logger;
import phex.utils.VersionUtils;
import phex.xml.ObjectFactory;
import phex.xml.PhexElement;
import phex.xml.XJBPhex;
import phex.xml.XJBSearchFilter;
import phex.xml.XJBSearchFilters;
import phex.xml.XMLBuilder;

public class SearchFilterContainer {
    private ArrayList searchFilterList;
    private ArrayList listenerList = new ArrayList(2);

    public SearchFilterContainer() {
        this.searchFilterList = new ArrayList();
        this.loadSearchFilters();
    }

    public int getSearchFilterCount() {
        return this.searchFilterList.size();
    }

    public SearchFilter getSearchFilterAt(int n) {
        if (n < 0 || n >= this.searchFilterList.size()) {
            return null;
        }
        return (SearchFilter)this.searchFilterList.get(n);
    }

    public SearchFilter getSearchFilterWithName(String string) {
        string = string.trim();
        int n = this.searchFilterList.size() - 1;
        while (n >= 0) {
            SearchFilter searchFilter = (SearchFilter)this.searchFilterList.get(n);
            if (searchFilter.getName().equals(string)) {
                return searchFilter;
            }
            --n;
        }
        return null;
    }

    public void addSearchFilter(SearchFilter searchFilter) {
        this.searchFilterList.add(0, searchFilter);
        this.fireSearchFilterAdded(0);
    }

    public void removeSearchFilter(SearchFilter searchFilter) {
        int n = this.searchFilterList.indexOf(searchFilter);
        if (n > -1) {
            this.searchFilterList.remove(n);
            this.saveSearchFilters();
            this.fireSearchFilterRemoved(n);
        }
    }

    public void saveSearchFilters() {
        Logger.logMessage(Logger.CONFIG, (short)8, "Saving search filters...");
        try {
            PhexElement phexElement = ObjectFactory.createPhexElement();
            phexElement.setPhexVersion(VersionUtils.getProgramVersion());
            XJBSearchFilters xJBSearchFilters = ObjectFactory.createXJBSearchFilters();
            phexElement.setSearchFilters(xJBSearchFilters);
            List list = xJBSearchFilters.getSearchFilterList();
            int n = this.searchFilterList.size() - 1;
            while (n >= 0) {
                SearchFilter searchFilter = (SearchFilter)this.searchFilterList.get(n);
                XJBSearchFilter xJBSearchFilter = searchFilter.createXJBSearchFilter();
                list.add(xJBSearchFilter);
                --n;
            }
            File file = Environment.getInstance().getPhexConfigFile("filterlist.xml");
            XMLBuilder.saveToFile(file, phexElement);
        }
        catch (JAXBException jAXBException) {
            Logger.logError(jAXBException);
        }
    }

    public void loadSearchFilters() {
        XJBPhex xJBPhex;
        Logger.logMessage(Logger.CONFIG, (short)8, "Loading search filters...");
        File file = Environment.getInstance().getPhexConfigFile("filterlist.xml");
        try {
            xJBPhex = XMLBuilder.loadXJBPhexFromFile(file);
            if (xJBPhex == null) {
                return;
            }
        }
        catch (JAXBException jAXBException) {
            Logger.logError(jAXBException);
            return;
        }
        List list = xJBPhex.getSearchFilters().getSearchFilterList();
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            try {
                XJBSearchFilter xJBSearchFilter = (XJBSearchFilter)iterator.next();
                SearchFilter searchFilter = SearchFilter.createFromxJBSearchFilter(xJBSearchFilter);
                this.searchFilterList.add(searchFilter);
            }
            catch (Exception exception) {
                Logger.logError(exception, "Error loading a search filter from XML.");
            }
        }
    }

    public void addSearchFilterListListener(SearchFilterListListener searchFilterListListener) {
        this.listenerList.add(searchFilterListListener);
    }

    public void removeSearchListChangeListener(SearchFilterListListener searchFilterListListener) {
        this.listenerList.remove(searchFilterListListener);
    }

    protected void fireSearchFilterChanged(final int n) {
        AsynchronousDispatcher.invokeLater(new Runnable(){

            public void run() {
                Object[] objectArray = SearchFilterContainer.this.listenerList.toArray();
                int n2 = objectArray.length - 1;
                while (n2 >= 0) {
                    SearchFilterListListener searchFilterListListener = (SearchFilterListListener)objectArray[n2];
                    searchFilterListListener.searchFilterChanged(n);
                    --n2;
                }
            }
        });
    }

    protected void fireSearchFilterAdded(final int n) {
        AsynchronousDispatcher.invokeLater(new Runnable(){

            public void run() {
                Object[] objectArray = SearchFilterContainer.this.listenerList.toArray();
                int n2 = objectArray.length - 1;
                while (n2 >= 0) {
                    SearchFilterListListener searchFilterListListener = (SearchFilterListListener)objectArray[n2];
                    searchFilterListListener.searchFilterAdded(n);
                    --n2;
                }
            }
        });
    }

    protected void fireSearchFilterRemoved(final int n) {
        AsynchronousDispatcher.invokeLater(new Runnable(){

            public void run() {
                Object[] objectArray = SearchFilterContainer.this.listenerList.toArray();
                int n2 = objectArray.length - 1;
                while (n2 >= 0) {
                    SearchFilterListListener searchFilterListListener = (SearchFilterListListener)objectArray[n2];
                    searchFilterListListener.searchFilterRemoved(n);
                    --n2;
                }
            }
        });
    }

    protected void fireSearchFilterChanged(SearchFilter searchFilter) {
        int n = this.searchFilterList.indexOf(searchFilter);
        if (n >= 0) {
            this.fireSearchFilterChanged(n);
        }
    }
}

