/*
 * Decompiled with CFR 0.152.
 */
package phex.share;

import com.bitzi.bitprint.Base32;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.net.URL;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Iterator;
import java.util.List;
import javax.xml.bind.JAXBException;
import phex.common.AlternateLocation;
import phex.common.AlternateLocationContainer;
import phex.common.Environment;
import phex.common.URN;
import phex.http.HTTPRangeSet;
import phex.share.FileAdministration;
import phex.share.ShareManager;
import phex.utils.Logger;
import phex.xml.ObjectFactory;
import phex.xml.XJBAlternateLocation;
import phex.xml.XJBSharedFile;

public class ShareFile {
    private static final String PHEX_FILE_NAME = Environment.getPhexVendor();
    private FileAdministration shareFileAdmin;
    private File file;
    private int fileIndex;
    private String fileName;
    private Long fileSize;
    private URN urn;
    private char[] searchCompareTerm;
    private Integer searchCount;
    private Integer uploadCount;
    private AlternateLocationContainer alternateLocations;

    public ShareFile(File file) {
        this.file = file;
        if (this.file == null) {
            this.fileIndex = -1;
            this.fileName = PHEX_FILE_NAME;
            this.fileSize = new Long(0L);
        } else {
            this.shareFileAdmin = ShareManager.getInstance().getFileAdministration();
            this.searchCount = new Integer(0);
            this.uploadCount = new Integer(0);
            this.fileName = this.file.getName();
            this.searchCompareTerm = this.file.getAbsolutePath().toLowerCase().toCharArray();
            this.fileSize = new Long(this.file.length());
        }
    }

    protected ShareFile(long l) {
        this.fileSize = new Long(l);
    }

    public URN getURN() {
        return this.urn;
    }

    public String getSHA1() {
        if (this.urn == null || !this.urn.isSha1Nid()) {
            return "";
        }
        return this.urn.getNamespaceSpecificString();
    }

    public File getFile() {
        return this.file;
    }

    public String getFileName() {
        return this.fileName;
    }

    public int getFileIndex() {
        return this.fileIndex;
    }

    public void setFileIndex(int n) {
        this.fileIndex = n;
    }

    public Long getFileSizeObject() {
        return this.fileSize;
    }

    public long getFileSize() {
        return this.fileSize;
    }

    public short getRangeAvailableStatus(HTTPRangeSet.Range range) {
        long l = this.fileSize;
        long l2 = range.getStartOffset(l);
        if (l2 < 0L || l2 >= l) {
            return 2;
        }
        return 0;
    }

    public AlternateLocationContainer getAltLocContainer() {
        if (this.alternateLocations == null) {
            this.alternateLocations = new AlternateLocationContainer(this.urn);
        }
        return this.alternateLocations;
    }

    public Integer getSearchCountObject() {
        return this.searchCount;
    }

    public int getSearchCount() {
        return this.searchCount;
    }

    public void incSearchCount() {
        this.searchCount = new Integer(this.searchCount + 1);
        this.shareFileAdmin.fireSharedFileChanged(this);
    }

    public Integer getUploadCountObject() {
        return this.uploadCount;
    }

    public int getUploadCount() {
        return this.uploadCount;
    }

    public void incUploadCount() {
        this.uploadCount = new Integer(this.uploadCount + 1);
        this.shareFileAdmin.fireSharedFileChanged(this);
    }

    public char[] getSearchCompareTerm() {
        return this.searchCompareTerm;
    }

    public void updateFromCache(XJBSharedFile xJBSharedFile) {
        this.searchCount = new Integer(xJBSharedFile.getHitCount());
        this.uploadCount = new Integer(xJBSharedFile.getUploadCount());
        this.urn = new URN("urn:sha1:" + xJBSharedFile.getSHA1());
        List list = xJBSharedFile.getAltLoc();
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            try {
                XJBAlternateLocation xJBAlternateLocation = (XJBAlternateLocation)iterator.next();
                String string = xJBAlternateLocation.getURL();
                String string2 = xJBAlternateLocation.getURN();
                long l = xJBAlternateLocation.getTimestamp();
                if (string2 == null) continue;
                AlternateLocation alternateLocation = new AlternateLocation(new URL(string), new URN(string2), l);
                this.getAltLocContainer().addAlternateLocation(alternateLocation);
            }
            catch (Exception exception) {
                Logger.logError(exception, "AlternateLocation skipped due to error.");
            }
        }
    }

    public void calculateURN() {
        try {
            int n;
            FileInputStream fileInputStream = new FileInputStream(this.file);
            MessageDigest messageDigest = MessageDigest.getInstance("SHA");
            byte[] byArray = new byte[65536];
            long l = System.currentTimeMillis();
            while ((n = fileInputStream.read(byArray)) != -1) {
                long l2 = System.currentTimeMillis();
                messageDigest.update(byArray, 0, n);
                long l3 = System.currentTimeMillis();
                try {
                    Thread.sleep((l3 - l2) * 2L);
                }
                catch (InterruptedException interruptedException) {
                    Thread.currentThread().interrupt();
                    return;
                }
            }
            fileInputStream.close();
            byte[] byArray2 = messageDigest.digest();
            long l4 = System.currentTimeMillis();
            this.urn = new URN("urn:sha1:" + Base32.encode(byArray2));
            Logger.logMessage(Logger.FINEST, (short)4, "SHA1 time: " + (l4 - l) + " size: " + this.file.length());
        }
        catch (IOException iOException) {
            Logger.logMessage(Logger.FINE, (short)4, iOException);
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            Logger.logMessage(Logger.FINE, (short)4, noSuchAlgorithmException);
        }
    }

    public XJBSharedFile createXJBSharedFile() throws JAXBException {
        XJBSharedFile xJBSharedFile = ObjectFactory.createXJBSharedFile();
        xJBSharedFile.setFileName(this.file.getAbsolutePath());
        xJBSharedFile.setSHA1(this.getSHA1());
        xJBSharedFile.setLastModified(this.file.lastModified());
        xJBSharedFile.setHitCount(this.searchCount);
        xJBSharedFile.setUploadCount(this.uploadCount);
        if (this.alternateLocations != null) {
            this.alternateLocations.createXJBAlternateLocationList(xJBSharedFile.getAltLoc());
        }
        return xJBSharedFile;
    }

    public String toString() {
        return super.toString() + " " + this.fileName + "  " + this.fileIndex;
    }
}

