/*
 * Decompiled with CFR 0.152.
 */
package phex.upload;

import java.io.File;
import phex.common.TransferDataProvider;
import phex.common.URN;
import phex.host.HostAddress;
import phex.statistic.CompletedUploadCountStatistic;
import phex.upload.UploadConstants;
import phex.upload.UploadEngine;
import phex.upload.UploadManager;
import phex.utils.Logger;

public class UploadState
implements TransferDataProvider,
UploadConstants {
    private UploadManager uploadManager = UploadManager.getInstance();
    private long transferredDataSize = 0L;
    private Integer currentProgress = new Integer(0);
    private short status;
    private HostAddress hostAddress;
    private String vendor;
    private String fileName;
    private URN fileURN;
    private File uploadFile;
    private UploadEngine uploadEngine;
    private long transferRateTimestamp;
    private long transferLength;
    private int transferRateBytes;
    private int transferRate;
    private long startTime;
    private long stopTime;

    public UploadState(HostAddress hostAddress, String string) {
        this(hostAddress, string, null, null, null, -1L);
    }

    public UploadState(HostAddress hostAddress, String string, String string2, URN uRN, File file, long l) {
        this.hostAddress = hostAddress;
        this.vendor = string;
        this.fileName = string2;
        this.fileURN = uRN;
        this.uploadFile = file;
        this.transferLength = l;
        this.status = 0;
    }

    public void update(HostAddress hostAddress, String string) {
        this.hostAddress = hostAddress;
        this.vendor = string;
    }

    public void update(HostAddress hostAddress, String string, String string2, URN uRN, File file, long l) {
        this.hostAddress = hostAddress;
        this.vendor = string;
        this.fileName = string2;
        this.fileURN = uRN;
        this.uploadFile = file;
        this.transferLength = l;
    }

    public File getUploadFile() {
        return this.uploadFile;
    }

    public String getVendor() {
        return this.vendor;
    }

    public String getFileName() {
        return this.fileName;
    }

    public URN getFileURN() {
        return this.fileURN;
    }

    public HostAddress getHostAddress() {
        return this.hostAddress;
    }

    public short getStatus() {
        return this.status;
    }

    public void setStatus(short s) {
        if (this.status == s) {
            return;
        }
        Logger.logMessage(Logger.FINE, (short)4, "UploadState Status " + s);
        switch (s) {
            case 3: {
                CompletedUploadCountStatistic.getInstance().increment(1);
            }
            case 4: {
                this.uploadStopNotify();
                break;
            }
            case 2: {
                this.uploadStartNotify();
            }
        }
        this.status = s;
        this.uploadManager.fireUploadFileChanged(this);
    }

    private void uploadStartNotify() {
        this.transferRateTimestamp = this.startTime = System.currentTimeMillis();
        this.stopTime = 0L;
    }

    private void uploadStopNotify() {
        if (this.stopTime == 0L) {
            this.stopTime = System.currentTimeMillis();
        }
    }

    public boolean isUploadRunning() {
        return this.status == 2;
    }

    public void setUploadEngine(UploadEngine uploadEngine) {
        this.uploadEngine = uploadEngine;
    }

    public void setTransferredDataSize(long l) {
        long l2 = l - this.transferredDataSize;
        this.transferRateBytes = (int)((long)this.transferRateBytes + l2);
        this.transferredDataSize = l;
        this.uploadManager.fireUploadFileChanged(this);
    }

    public Integer getProgress() {
        int n;
        if (this.status == 3) {
            n = 100;
        } else {
            long l = this.getTransferDataSize();
            n = (int)(this.getTransferredDataSize() * 100L / (l == 0L ? 1L : l));
        }
        if (this.currentProgress != n) {
            this.currentProgress = new Integer(n);
        }
        return this.currentProgress;
    }

    public void stopUpload() {
        if (this.uploadEngine != null) {
            this.uploadEngine.stopUpload();
        }
        this.setStatus((short)4);
    }

    public long getTransferDataSize() {
        return this.transferLength;
    }

    public long getTransferredDataSize() {
        return this.transferredDataSize;
    }

    public long getTotalDataSize() {
        return this.getTransferDataSize();
    }

    public void setTransferRateTimestamp(long l) {
        this.transferRateTimestamp = l;
        this.transferRateBytes = 0;
    }

    public int getShortTermTransferRate() {
        if (this.transferRateTimestamp != 0L) {
            double d = (double)(System.currentTimeMillis() - this.transferRateTimestamp) / 1000.0;
            if ((this.transferRateBytes > 0 || d > 1.0) && d != 0.0) {
                this.transferRate = (int)((double)this.transferRateBytes / d);
            }
        }
        return this.transferRate;
    }

    public int getLongTermTransferRate() {
        long l = this.stopTime != 0L ? (this.stopTime - this.startTime) / 1000L : (System.currentTimeMillis() - this.startTime) / 1000L;
        return (int)(this.getTransferredDataSize() / (l + 1L));
    }

    public short getDataTransferStatus() {
        switch (this.status) {
            case 2: {
                return 10;
            }
            case 4: {
                return 13;
            }
            case 3: {
                return 12;
            }
        }
        return 11;
    }
}

