/*
 * Decompiled with CFR 0.152.
 */
package phex.utils;

import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.NoSuchElementException;

public class CircularQueue {
    private int size;
    private Object[] elements;
    private int headIdx;
    private int tailIdx;

    public CircularQueue(int n) {
        this(Math.min(10, n), n);
    }

    public CircularQueue(int n, int n2) {
        if (n2 < 1) {
            throw new RuntimeException("Min size of the CircularQueue is 1");
        }
        this.size = n2 + 1;
        this.elements = new Object[n + 1];
        this.tailIdx = 0;
        this.headIdx = 0;
    }

    public Object addToTail(Object object) {
        Object object2 = null;
        if (this.isFull()) {
            object2 = this.removeFromHead();
        }
        this.ensureCapacity();
        this.elements[this.tailIdx] = object;
        this.tailIdx = this.nextIndex(this.tailIdx);
        return object2;
    }

    public Object addToHead(Object object) {
        Object object2 = null;
        if (this.isFull()) {
            object2 = this.removeFromTail();
        }
        this.ensureCapacity();
        this.headIdx = this.prevIndex(this.headIdx);
        this.elements[this.headIdx] = object;
        return object2;
    }

    public void clear() {
        this.headIdx = 0;
        this.tailIdx = 0;
    }

    public Object getFirst() throws NoSuchElementException {
        if (this.isEmpty()) {
            throw new NoSuchElementException();
        }
        return this.elements[this.headIdx];
    }

    public Object getLast() throws NoSuchElementException {
        if (this.isEmpty()) {
            throw new NoSuchElementException();
        }
        int n = this.prevIndex(this.tailIdx);
        return this.elements[n];
    }

    public Object get(int n) throws IndexOutOfBoundsException {
        int n2 = this.mapIndex(n);
        return this.elements[n2];
    }

    public int getSize() {
        if (this.headIdx <= this.tailIdx) {
            return this.tailIdx - this.headIdx;
        }
        return this.elements.length - this.headIdx + this.tailIdx;
    }

    public int getCapacity() {
        return this.size - 1;
    }

    public boolean isEmpty() {
        return this.headIdx == this.tailIdx;
    }

    public boolean isFull() {
        if (this.elements.length == this.size) {
            return this.nextIndex(this.tailIdx) == this.headIdx;
        }
        return false;
    }

    public Object removeFromHead() throws NoSuchElementException {
        if (this.isEmpty()) {
            throw new NoSuchElementException();
        }
        Object object = this.elements[this.headIdx];
        this.headIdx = this.nextIndex(this.headIdx);
        return object;
    }

    public Object removeFromTail() throws NoSuchElementException {
        if (this.isEmpty()) {
            throw new NoSuchElementException();
        }
        this.tailIdx = this.prevIndex(this.tailIdx);
        Object object = this.elements[this.tailIdx];
        return object;
    }

    public Iterator iterator() {
        return new CircularQueueIterator();
    }

    private void ensureCapacity() {
        if (this.elements.length == this.size) {
            return;
        }
        if (this.nextIndex(this.tailIdx) != this.headIdx) {
            return;
        }
        int n = Math.min(this.elements.length * 2, this.size);
        Object[] objectArray = new Object[n];
        if (this.headIdx <= this.tailIdx) {
            System.arraycopy(this.elements, this.headIdx, objectArray, this.headIdx, this.tailIdx - this.headIdx);
        } else {
            int n2 = n - (this.elements.length - this.headIdx);
            if (this.tailIdx > 0) {
                System.arraycopy(this.elements, 0, objectArray, 0, this.tailIdx - 1);
            }
            System.arraycopy(this.elements, this.headIdx, objectArray, n2, this.elements.length - this.headIdx);
            this.headIdx = n2;
        }
        this.elements = objectArray;
    }

    private int mapIndex(int n) throws IndexOutOfBoundsException {
        if (n >= this.elements.length || n < 0) {
            throw new IndexOutOfBoundsException("Index: " + n + ", Size: " + this.elements.length);
        }
        return (n + this.headIdx) % this.elements.length;
    }

    private int nextIndex(int n) {
        if (n == this.elements.length - 1) {
            return 0;
        }
        return n + 1;
    }

    private int prevIndex(int n) {
        if (n == 0) {
            return this.elements.length - 1;
        }
        return n - 1;
    }

    private class CircularQueueIterator
    implements Iterator {
        int originalHead;
        int originalTail;
        int nextElement;

        public CircularQueueIterator() {
            this.nextElement = CircularQueue.this.headIdx;
            this.originalHead = CircularQueue.this.headIdx;
            this.originalTail = CircularQueue.this.tailIdx;
        }

        public boolean hasNext() {
            this.checkForComodification();
            return this.nextElement != CircularQueue.this.tailIdx;
        }

        public Object next() throws NoSuchElementException {
            this.checkForComodification();
            if (this.nextElement == CircularQueue.this.tailIdx) {
                throw new NoSuchElementException();
            }
            Object object = CircularQueue.this.elements[this.nextElement];
            this.nextElement = CircularQueue.this.nextIndex(this.nextElement);
            return object;
        }

        public void remove() {
            throw new UnsupportedOperationException();
        }

        private void checkForComodification() {
            if (this.originalHead != CircularQueue.this.headIdx || this.originalTail != CircularQueue.this.tailIdx) {
                throw new ConcurrentModificationException();
            }
        }
    }
}

