/*
 * Decompiled with CFR 0.152.
 */
package redlight.client;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.io.File;
import java.io.IOException;
import java.util.Vector;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import redlight.client.BookmarkMenuItem;
import redlight.client.BookmarkTableCellRenderer;
import redlight.client.BookmarkTableModel;
import redlight.client.Child;
import redlight.client.ConnectInterface;
import redlight.client.ConnectionInterface;
import redlight.client.Machine;
import redlight.client.Main;
import redlight.client.Options;
import redlight.client.Parent;
import redlight.client.ServerStatusChecker;
import redlight.hotline.HLBookmarkFile;

public class BookmarkInterface
implements Child,
KeyListener,
ActionListener,
WindowListener,
MouseListener,
Runnable {
    Machine rlm;
    Parent parent;
    Options rlo;
    Container contentPane;
    JTextField server;
    JTextField port;
    JTextField login;
    JTextField password;
    JButton connect;
    JButton reload;
    JFrame f;
    JTable list;
    JPopupMenu popupMenu;
    JScrollPane scrollPane;
    JMenuItem connectToBookmarks;
    JMenuItem deleteBookmarks;
    JMenuItem editBookmarks;
    Thread getter;
    BookmarkTableModel bookmarkTableModel;
    ServerStatusChecker serverChecker;
    Vector bookmarks;
    short[] statuses;
    static JMenuItem empty = new JMenuItem("No bookmarks.");
    static /* synthetic */ Class class$java$lang$Number;

    public BookmarkInterface(Parent p, Options options) {
        this.parent = p;
        this.rlo = options;
        this.serverChecker = null;
        Font guiFont = (Font)Main.rlo.getProperty("Font.gui");
        this.f = new JFrame("Bookmarks");
        this.contentPane = this.f.getContentPane();
        GridBagLayout gbl = new GridBagLayout();
        GridBagConstraints gbc = new GridBagConstraints();
        this.reload = new JButton("", new ImageIcon(Main.rlo.getImageSet("FunctionIcons")[9]));
        this.bookmarkTableModel = new BookmarkTableModel(this);
        this.list = new JTable(this.bookmarkTableModel);
        this.scrollPane = new JScrollPane(this.list);
        this.popupMenu = new JPopupMenu();
        this.connectToBookmarks = new JMenuItem("Connect to selected bookmarks");
        this.deleteBookmarks = new JMenuItem("Delete selected bookmarks");
        this.editBookmarks = new JMenuItem("Edit selected bookmarks");
        this.contentPane.setLayout(gbl);
        this.reload.setFont(guiFont);
        this.reload.setActionCommand("Reload");
        this.reload.setMnemonic('R');
        this.reload.setToolTipText("Reload the list of bookmarks.");
        this.connectToBookmarks.setFont(guiFont);
        this.deleteBookmarks.setFont(guiFont);
        this.editBookmarks.setFont(guiFont);
        this.list.getColumnModel().getColumn(0).setPreferredWidth(1000);
        this.list.setShowVerticalLines(false);
        this.list.addMouseListener(this);
        this.list.setDefaultRenderer(class$java$lang$Number == null ? (class$java$lang$Number = BookmarkInterface.class$("java.lang.Number")) : class$java$lang$Number, new BookmarkTableCellRenderer());
        this.list.setFont((Font)Main.rlo.getProperty("Font.list"));
        this.list.registerKeyboardAction(this, "Activate", KeyStroke.getKeyStroke(32, 0), 2);
        this.reload.addActionListener(this);
        this.f.addWindowListener(this);
        this.connectToBookmarks.addActionListener(this);
        this.editBookmarks.addActionListener(this);
        this.deleteBookmarks.addActionListener(this);
        gbc.weightx = 1.0;
        gbc.insets = new Insets(4, 4, 4, 4);
        gbc.fill = 0;
        gbc.anchor = 17;
        this.contentPane.add((Component)this.reload, gbc);
        gbc.gridx = 0;
        gbc.gridy = 1;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        gbc.fill = 1;
        this.contentPane.add((Component)this.scrollPane, gbc);
        this.popupMenu.add(this.connectToBookmarks);
        this.popupMenu.add(this.editBookmarks);
        this.popupMenu.addSeparator();
        this.popupMenu.add(this.deleteBookmarks);
        this.f.pack();
        this.f.setLocation((Point)Main.rlo.getProperty("WindowLocation.Bookmarks"));
        this.f.setSize((Dimension)Main.rlo.getProperty("WindowDimension.Bookmarks"));
        this.show();
        this.bookmarks = new Vector();
        SwingUtilities.invokeLater(this);
    }

    public void run() {
        this.reload.setEnabled(false);
        this.list.removeAll();
        this.bookmarks.removeAllElements();
        File dir = (File)Main.rlo.getProperty("Path.Bookmarks");
        if (dir.exists()) {
            String[] files = dir.list();
            int i = 0;
            while (i < files.length) {
                HLBookmarkFile bmf = null;
                File f = new File(dir, files[i]);
                if (f.exists()) {
                    bmf = new HLBookmarkFile(f);
                    try {
                        bmf.load();
                        this.bookmarks.addElement(bmf);
                    }
                    catch (IOException e) {
                        // empty catch block
                    }
                }
                ++i;
            }
        }
        this.bookmarkTableModel.fireTableDataChanged();
        this.reload.setEnabled(true);
        this.statuses = new short[this.bookmarks.size()];
        this.serverChecker = new ServerStatusChecker(this.bookmarks, this.statuses, this);
        this.list.repaint();
        this.parent.displayPropertyChanged("bookmarkentries", "reload");
    }

    public int getColumnCount() {
        return 1;
    }

    public int getRowCount() {
        if (this.bookmarks != null) {
            return this.bookmarks.size();
        }
        return 1;
    }

    public Object getValueAt(int row, int col) {
        return ((HLBookmarkFile)this.bookmarks.elementAt(row)).getFile().getName();
    }

    public void show() {
        this.f.show();
        if (this.list.getSelectionModel().isSelectionEmpty() && this.list.getRowCount() > 0) {
            this.list.getSelectionModel().setSelectionInterval(0, 0);
        }
        this.list.requestFocus();
    }

    void itemActivated(int i) {
        HLBookmarkFile bmf = (HLBookmarkFile)this.bookmarks.elementAt(i);
        String address = bmf.get("address");
        int port = 5500;
        if (address.indexOf(":") != -1) {
            port = new Integer(address.substring(address.indexOf(":") + 1));
            address = address.substring(0, address.indexOf(":"));
        }
        new ConnectionInterface(address, port, bmf.get("login"), bmf.get("password"), bmf.getFile().getName());
    }

    void itemEdit(int i) {
        HLBookmarkFile bmf = (HLBookmarkFile)this.bookmarks.elementAt(i);
        String address = bmf.get("address");
        int port = 5500;
        if (address.indexOf(":") != -1) {
            port = new Integer(address.substring(address.indexOf(":") + 1));
            address = address.substring(0, address.indexOf(":"));
        }
        new ConnectInterface(this.parent, address, new Integer(port).toString(), bmf.get("login"), bmf.get("password"), bmf.getFile().getName(), true);
    }

    public static void populateContainerWithBookmarks(Container container, ActionListener l) {
        int oldCount = container.getComponentCount();
        File dir = (File)Main.rlo.getProperty("Path.Bookmarks");
        if (dir.exists()) {
            String[] files = dir.list();
            int i = 0;
            while (i < files.length) {
                HLBookmarkFile bmf = null;
                File f = new File(dir, files[i]);
                if (f.exists()) {
                    bmf = new HLBookmarkFile(f);
                    try {
                        bmf.load();
                        BookmarkMenuItem bookmark = new BookmarkMenuItem(bmf);
                        bookmark.setActionCommand("ActivateBookmark");
                        bookmark.addActionListener(l);
                        container.add(bookmark);
                    }
                    catch (IOException e) {
                        // empty catch block
                    }
                }
                ++i;
            }
        }
        if (container.getComponentCount() == oldCount) {
            empty.setEnabled(false);
            container.add(empty);
        }
    }

    public void actionPerformed(ActionEvent e) {
        int selected;
        if (e.getActionCommand().equals("Reload")) {
            SwingUtilities.invokeLater(this);
        } else if (e.getSource() == this.deleteBookmarks) {
            int[] indices = this.list.getSelectedRows();
            int i = 0;
            while (i < indices.length) {
                HLBookmarkFile bmf = (HLBookmarkFile)this.bookmarks.elementAt(indices[i]);
                File file = new File((File)Main.rlo.getProperty("Path.Bookmarks"), bmf.getFile().getName());
                file.delete();
                ++i;
            }
            this.list.setRowSelectionInterval(0, 0);
            this.parent.displayPropertyChanged("bookmarkentries", "");
            SwingUtilities.invokeLater(this);
        } else if (e.getSource() == this.editBookmarks) {
            int[] indices = this.list.getSelectedRows();
            int i = 0;
            while (i < indices.length) {
                this.itemEdit(indices[i]);
                ++i;
            }
        } else if (e.getSource() == this.connectToBookmarks) {
            int[] indices = this.list.getSelectedRows();
            int i = 0;
            while (i < indices.length) {
                this.itemActivated(indices[i]);
                ++i;
            }
        } else if (e.getActionCommand().equals("Activate") && (selected = this.list.getSelectedRow()) != -1) {
            this.itemActivated(selected);
        }
    }

    public void close() {
        Main.rlo.setProperty("WindowLocation.Bookmarks", this.f.getLocation());
        Main.rlo.setProperty("WindowDimension.Bookmarks", this.f.getSize());
        this.f.setVisible(false);
    }

    public void displayPropertyChanged(String what, Object property) {
        if (what.equals("listfont")) {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    BookmarkInterface.this.list.setFont((Font)Main.rlo.getProperty("Font.list"));
                    BookmarkInterface.this.list.repaint();
                }
            });
        } else if (what.equals("bookmarkstatus")) {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    BookmarkInterface.this.list.repaint();
                }
            });
        } else if (what.equals("bookmarkentries") && !property.toString().equals("reload")) {
            SwingUtilities.invokeLater(this);
        }
    }

    public void keyPressed(KeyEvent e) {
    }

    public void keyReleased(KeyEvent e) {
    }

    public void keyTyped(KeyEvent e) {
        boolean changed = true;
        if ('\n' == e.getKeyChar()) {
            // empty if block
        }
    }

    public void windowActivated(WindowEvent e) {
    }

    public void windowDeactivated(WindowEvent e) {
    }

    public void windowClosed(WindowEvent e) {
    }

    public void windowClosing(WindowEvent e) {
        this.close();
    }

    public void windowIconified(WindowEvent e) {
    }

    public void windowDeiconified(WindowEvent e) {
    }

    public void windowOpened(WindowEvent e) {
    }

    public void mouseClicked(MouseEvent e) {
        if (e.getClickCount() == 2 && (e.getModifiers() & 0x10) == 16 && this.list.getSelectedRow() != -1) {
            this.itemActivated(this.list.getSelectedRow());
        }
    }

    public void mouseEntered(MouseEvent e) {
    }

    public void mouseExited(MouseEvent e) {
    }

    public void mousePressed(MouseEvent e) {
        this.mouseReleased(e);
    }

    public void mouseReleased(MouseEvent e) {
        if (e.isPopupTrigger()) {
            this.deleteBookmarks.setEnabled(this.list.getSelectedRows().length != 0);
            this.editBookmarks.setEnabled(this.list.getSelectedRows().length != 0);
            this.popupMenu.show(this.list, e.getX(), e.getY());
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

