/*
 * Decompiled with CFR 0.152.
 */
package redlight.client;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.IOException;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JTabbedPane;
import javax.swing.SwingUtilities;
import redlight.client.AutoPanel;
import redlight.client.ButtonPanel;
import redlight.client.ButtonedPanel;
import redlight.client.HelpTextPanel;
import redlight.client.Main;
import redlight.client.NickIconPanel;
import redlight.client.Options;
import redlight.client.OptionsPanel;
import redlight.client.Parent;
import redlight.client.PathsPanel;

public class OptionsInterface
implements ActionListener {
    Options rlo;
    Parent parent;
    Container contentPane;
    static JFrame f;
    JButton confirm;
    JButton cancel;
    NickIconPanel nickIconPanel = new NickIconPanel();
    OptionsPanel optionsPanel = new OptionsPanel();
    PathsPanel pathsPanel = new PathsPanel();
    AutoPanel autoPanel = new AutoPanel();

    public OptionsInterface(Parent parent, Options options) {
        this.parent = parent;
        this.rlo = options;
        HelpTextPanel nickIconHelpPanel = new HelpTextPanel("Nick&icon", "Your nickname and icon.", this.nickIconPanel);
        HelpTextPanel optionsHelpPanel = new HelpTextPanel("Options", "Font settings, transfer method, switches.", this.optionsPanel);
        HelpTextPanel pathsHelpPanel = new HelpTextPanel("Paths", "Where files live on your disk.", this.pathsPanel);
        HelpTextPanel autoHelpPanel = new HelpTextPanel("Auto", "Timeouts, retries.", this.autoPanel);
        Font guiFont = (Font)Main.rlo.getProperty("Font.gui");
        f = new JFrame("Red Light Options");
        this.contentPane = f.getContentPane();
        GridBagConstraints gbc = new GridBagConstraints();
        JTabbedPane tabbedPane = new JTabbedPane();
        this.cancel = new JButton("Cancel");
        this.confirm = new JButton("Save");
        this.contentPane.setLayout(new GridBagLayout());
        this.cancel.setMnemonic('C');
        this.confirm.setDefaultCapable(true);
        this.confirm.setMnemonic('S');
        tabbedPane.addTab("Nick & icon", new ImageIcon(Main.rlo.getImageSet("FunctionIcons")[14]), nickIconHelpPanel, "Set your nick & icon");
        tabbedPane.addTab("Options", new ImageIcon(Main.rlo.getImageSet("FunctionIcons")[14]), optionsHelpPanel, "Options");
        tabbedPane.addTab("Paths", new ImageIcon(Main.rlo.getImageSet("FunctionIcons")[14]), pathsHelpPanel, "Where files live");
        tabbedPane.addTab("Auto", new ImageIcon(Main.rlo.getImageSet("FunctionIcons")[14]), autoHelpPanel, "Control automatic behaviour");
        JButton[] buttons = new JButton[]{this.cancel, this.confirm};
        ButtonPanel buttonPanel = new ButtonPanel(null, buttons);
        ButtonedPanel buttonedPanel = new ButtonedPanel(tabbedPane, buttonPanel);
        this.contentPane.setLayout(new BorderLayout());
        this.contentPane.add((Component)buttonedPanel, "Center");
        SwingUtilities.getRootPane(f).setDefaultButton(this.confirm);
        this.cancel.addActionListener(this);
        this.confirm.addActionListener(this);
        f.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent e) {
                f.setVisible(false);
            }
        });
        f.pack();
        Dimension d = Toolkit.getDefaultToolkit().getScreenSize();
        Dimension w = f.getSize();
        f.setLocation(d.width / 2 - w.width / 2, d.height / 2 - w.height / 3);
        f.show();
    }

    public void actionPerformed(ActionEvent e) {
        if (e.getActionCommand().equals("Save")) {
            this.nickIconPanel.actionPerformed(e);
            this.optionsPanel.actionPerformed(e);
            this.pathsPanel.actionPerformed(e);
            this.autoPanel.actionPerformed(e);
            try {
                Main.rlo.store(Main.CONFIGURATION_FILE);
            }
            catch (IOException ex) {
                System.out.println("Exception writing " + Main.CONFIGURATION_FILE + ": " + ex);
            }
            this.parent.displayPropertyChanged("textfont", (Font)Main.rlo.getProperty("Font.text"));
            this.parent.displayPropertyChanged("listfont", (Font)Main.rlo.getProperty("Font.list"));
            f.setVisible(false);
        } else if (e.getActionCommand().equals("Cancel")) {
            f.setVisible(false);
        }
    }

    public void show() {
        if (!f.isVisible()) {
            this.nickIconPanel.setup(Main.rlo);
            this.optionsPanel.setup(Main.rlo);
            this.pathsPanel.setup(Main.rlo);
            this.autoPanel.setup(Main.rlo);
        }
        f.show();
    }
}

